import xml.etree.ElementTree as ET


class CommentedTreeBuilder(ET.TreeBuilder):
    def __init__(self, *args, **kwargs):
        super(CommentedTreeBuilder, self).__init__(*args, **kwargs)
        self.first_xml_comment = ""

    def comment(self, data):
        if len(self.first_xml_comment) == 0:
            # this is the first comment inside the document being parsed
            self.first_xml_comment = data

    def get_first_xml_comment(self):
        return self.first_xml_comment
