#
# This is the file which is included by any Makefiles that wants to
# build a binary. Be sure to include this file at the end
# of your makefile.
#
# The calling Makefile must define:
#     EXENAME
#         This must be defined to the actual name of the executable,
#         excluding the path.
#     EXTRA_DEPS
#         Extra dependencies for the application main target; default to empty
#     << All variables supported by Internal-commonvars.mk -- see that file for detailed list >>
#
# Unit testing:
#     HAS_UNIT_TESTS
#         If 2 then the "test" target and the "test_valgrind" target are not defined at all; 
#         the caller makefile must define them if needed.
#         If 1 (default) when "test" target is called, and the "UnitTests" folder is present, the makefile will recursively
#         enter that folder. 
#         NOTE: value 0 is deprecated and not allowed anymore. If the calling makefile is not exposing any unit test, just
#         accept the default value "1" and make sure there is no "UnitTests" subfolder
#     IS_UNIT_TEST
#         If 1 then the caller is declaring that this "application" is a unit test of some libraries;
#         in such case the "test" target will invoke the application itself.
#
# Installation support:
#     HAS_INSTALL_SUPPORT
#         If 1 (default) then the "install" target will be implemented.
#         If 0 then no "install" target will be defined.
#     HAS_REMOTE_INSTALL_SUPPORT
#         If 1 (default) then the "remote_install_root" target will be implemented.
#         If 0 then no "remote_install_root" target will be defined.
#     INSTALL_DIRNAME
#         Name of the directory where the binary must be installed; this directory will be created under $(DESTDIR)
#         that is passed to the "install" target
#     INSTALL_CONFIG_FILES
#         Auxiliary configuration files that must be installed under $DESTDIR/etc
#     INSTALL_STATIC_CONFIG_FILES
#         Auxiliary configuration files that must be installed under $DESTDIR/static-etc.
#         In a k8s env, these configs files should be statically written inside the docker image and not overwritten at
#         installation time
#
# Config file regeneration:
#     HAS_CONFIG_FILES
#         If 0 (default) then the "config_files" target will be implemented as no-op
#         If 2 then the "config_files" target will be implemented as target that converts files listed in $(CONFIG_MASTER_XML_FILES)
#         to YAML format.
#
# Specially-handled sub-directories:
# This makefile will treat in a special way a few sub-folders if present:
#     UnitTests
#         The "all", "clean" and "test" targets of this makefile will enter recursively the "UnitTests" folder
#     Packaging, TestBundle, HelmChart
#         The "packaging" target of this makefile will enter recursively these folders
#
# For more variables that can be defined please see:
#   - Common-defines.mk
#   - CppBuild-targets.mk


# ------------------------------------------------------------------------------------------
# check calling Makefile parameters:
# ------------------------------------------------------------------------------------------

ifndef EXENAME
$(error EXENAME must be defined)
endif

ifndef BUILDDIR
$(error BUILDDIR must be defined)
endif

ifeq ($(EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR),)
$(error Please define EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR before including this snippet)
endif

ifndef OUTDIR
OUTDIR := ./Bin/$(BUILDID)
RM_OUTDIR=1
else
RM_OUTDIR=0
endif

ifdef OUTEXE
$(error Cannot override OUTEXE with value $(OUTEXE))
endif

ifndef HAS_UNIT_TESTS
# default value
HAS_UNIT_TESTS=1
endif

ifeq ($(HAS_UNIT_TESTS),0)
$(error HAS_UNIT_TESTS=0 is not supported anymore. Please switch to HAS_UNIT_TESTS=1)
endif

ifndef IS_UNIT_TEST
# default value
IS_UNIT_TEST=0
endif

ifeq ($(IS_UNIT_TEST),1)
HAS_INSTALL_SUPPORT=0
HAS_UNIT_TESTS=0
UNIT_TESTS_JUNIT=$(EXENAME)-UnitTests.xml
UNIT_TESTS_LOG=$(EXENAME)-UnitTests.log
endif

ifndef HAS_INSTALL_SUPPORT
# default value
HAS_INSTALL_SUPPORT=1
endif

ifndef HAS_REMOTE_INSTALL_SUPPORT
# default value
HAS_REMOTE_INSTALL_SUPPORT=1
endif

ifndef SUPPORTS_HELP
# default value
SUPPORTS_HELP=1
endif

ifndef REMOTE_DESTDIR
# default value
REMOTE_DESTDIR=/home/hammer
REMOTE_DESTDIR_DEBUG=/usr/lib/debug/$(REMOTE_DESTDIR)
endif

ifndef INSTALL_DIRNAME
# default value: get rid of debug tag _D if exists, and convert to lowercase
INSTALL_DIRNAME := $(shell echo $(subst _D,,$(EXENAME)) | tr A-Z a-z)
endif

ifndef SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS
# default value
SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS=1
endif

ifndef DOCKER_NETWORK
# default value
DOCKER_NETWORK=host
endif

# ------------------------------------------------------------------------------------------
# inclusion checks
# ------------------------------------------------------------------------------------------

INCLUDED_APPLICATION_TARGETS:=1

# blacklist other makefiles that for some reason are incompatible 
# (reason could be as simple as 'the combination has never been tested' or 'does not make much sense')
ifeq ($(INCLUDED_RECURSIVE_TARGETS),1) 
$(error Application-targets.mk is incompatible with Recursive-targets.mk. Don't include both.)
endif


# ------------------------------------------------------------------------------------------
# create aux make vars:
# ------------------------------------------------------------------------------------------

OUTEXE := $(OUTDIR)/$(EXENAME)
OUTEXE_DEBUGINFO := $(OUTDIR)/$(EXENAME).debug

# enable just for debugging the makefiles, but do not put this in production, too verbose:
#$(info enabling \
	$(if $(findstring norecursive,$(TARGS_OPTS)),simple,recursive) \
	building of binary $(OUTEXE))

# include the logic that collects source files:
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Internal-commonvars.mk



# ------------------------------------------------------------------------------------------
# Targets
# IMPORTANT #1: the targets ending with double colons can be _extended_ by the caller makefile;
# 
# ABOUT THE conandata.yml DEPENDENCY
# The depedency of the binary on the "conandata.yml" allows GNU make to spot
# changes in the versioning of upstream repositories and force the re-linking of
# the application so that it will point to the new version of shared libraries
# contained in the upstream repository.
#
# Example of problem without the conandata.yml dependency:
#  Assume your repo is linking against shared libraries produced by the upstream repo A, 
#  versioned using the MAJOR.MINOR combination of repo A. 
#  Assume you have already build artifacts (e.g. ELF or shared libs) of your repo linked
#  against version X of an upstream repo A.
#  Assume you now change in the conandata.yml the version of the upstream repo A to be version Y,
#  having different MAJOR.MINOR combination. 
#  Now run an incremental build of your repo: you will not be able to start binaries since some of them
#  are asking for version X of upstream repo A, but only see version Y.
# Solution:
#  By making it explicit the dependency on the conandata.yml, we will force GNU make to relink
#  the application binaries of your repo with all their DT_NEEDED entries pointing to version Y. 
# ------------------------------------------------------------------------------------------

.PHONY: all md5sum clean install test test_valgrind run valgrind

all:: $(OUTEXE)_md5sum
	@echo "READY [$(CFG)] $(OUTEXE)"
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	@# if present, assume we should recursively build also the UnitTests folder (we assume it contains its own Makefile!)
	$(MAKE) all -C UnitTests
endif
endif

symlinks::
	@echo "Nothing to symlink for binary $(OUTEXE)"

# IMPORTANT: please note that very often TestBundles contain Helm charts, so it's important
#            to package HelmChart folder BEFORE the TestBundle folder
packaging::
ifeq ($(INSIDE_BUILDER_IMAGE),)
	@echo "The 'packaging' target can be launched only from inside the builder docker."
	@echo "Please use the 'docker_packaging' target instead."
	@exit 99
endif
	@# All folders with 'Packaging' prefix are special and trigger a recursion inside them
	@$(foreach dir, $(wildcard Packaging*), $(MAKE) packaging -C $(dir) MAKEFLAGS=;)

ifneq ($(wildcard HelmChart/*),)
	$(MAKE) packaging -C HelmChart MAKEFLAGS=
endif
	@# TestBundle folder is special and triggers a recursion inside it
ifneq ($(wildcard TestBundle/*),)
	$(MAKE) packaging -C TestBundle MAKEFLAGS=
endif
	@echo
	@echo "COMPLETED PACKAGING APP [$(OUTEXE)]"
	@echo

ifeq ($(INSIDE_BUILDER_IMAGE),)
$(OUTEXE):: 
	@echo "The binary file '$(OUTEXE)' can be built only from inside the builder docker."
	@echo "Please use the 'docker_all' target instead."
	@exit 99
else
ifeq ($(ARCH), tile)

$(OUTEXE):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) $(EXTRA_LIBS) $(EXTRA_DEPS)
	$(TILERA_MDE)/bin/tile-gcc -static $(TILERA_CFLAGS) $(TILERA_LINKER_FLAGS) -o $@ \
		 $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) \
		 $(TILERA_EXTRA_LIBS) $(TILERA_USR_LIBS)

else
ifeq ($(ARCH), independent)

$(OUTDIR)/$(OUTEXE)::
	@echo "Please use Maven (for Java) or Buildout (for Python) to compile the binaries of this folder."

else # ARCH=x86_64/docker

# NOTE1: use of objcopy+strip utilities to extract debug information produces debug information that for
#        some reason is not usable by 'perf' tool, see AP-7716. eu-strip utility instead makes both gdb and perf happy!
# NOTE2: use of a tool like "dwz" to compress separate .debug files has been found to provide only a small
#       gain (e.g. from 28MB to 24MB, a 15% reduction) and then would also require fixing the CRC inside 
#       the .debug file (see /usr/lib/rpm/sepdebugcrcfix)
$(OUTEXE):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) $(EXTRA_LIBS) $(EXTRA_LIBS_WHOLE_ARCHIVE) $(TARGS_FORMATCHECKS) $(TARGS_CPPCHECKS) $(TOPDIR)/conandata.yml $(EXTRA_DEPS)
ifeq ($(V),0)
	$(call print_green,LINKING APP [$(CFG)] $@)
	@$(LINKER) $(LINKER_FLAGS) \
		$(TARGS_OBJS) $(EXTRA_TARGS_OBJS) \
		$(EXTRA_LIBS_LINKER_LINE) \
		$(USR_LIBS_LINKER_LINE) \
		-o $(OUTEXE)
ifeq ($(CFG), release)
ifeq ($(SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS), 1)
	@eu-strip -g -f $(OUTEXE_DEBUGINFO) $(OUTEXE) 
endif # SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS

endif # CFG=release
else # V=0/1
	$(LINKER) $(LINKER_FLAGS) \
		$(TARGS_OBJS) $(EXTRA_TARGS_OBJS) \
		$(EXTRA_LIBS_LINKER_LINE) \
		$(USR_LIBS_LINKER_LINE) \
		-o $(OUTEXE)
ifeq ($(CFG), release)
ifeq ($(SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS), 1)
	@eu-strip -g -f $(OUTEXE_DEBUGINFO) $(OUTEXE)
endif # SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS
endif # CFG=release
endif # V=1

endif # ARCH=x86_64
endif # ARCH=tile
endif # INSIDE_BUILDER_IMAGE

strip::
	strip $(OUTEXE)
	
$(OUTEXE)_md5sum:: $(OUTEXE)
	@md5sum $(abspath $^) > MD5SUMS
	@sed 's@$(ABSPATH_TOPDIR)/@@' MD5SUMS >> ${TOPDIR}/MD5SUMS
	@rm -f MD5SUMS

# add cleaning of debug infos:
clean::
ifeq ($(CFG), release)
	-rm -f $(OUTEXE_DEBUGINFO)
endif
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	@# if present, assume we should recursively clean also the UnitTests folder (we assume it contains its own Makefile!)
	$(MAKE) clean -C UnitTests
endif
endif


# ------------------------------------------------------------------------------------------
# Run Support
# ------------------------------------------------------------------------------------------

# IMPORTANT:
#     DEPENDENCIES_RPATHS contains the list of paths to store in the ELF dynamic section of shared libs / binaries generated by GNU make
#     UNIT_TESTS_LDLIBRARY_PATHS contains the list of paths to use, just when running unit tests, to test locally-built binaries
#     EXTRA_LD_LIBRARY_PATH should not be used in general, just for local-injection of paths for advanced debugging
# NOTE: The syntax
#   subst $() $()
# is a trick to have GNU make replacing spaces inside a string...
DEPENDENCIES_RPATHS_FOR_LDLIBRARY:=$(subst $() $(),:,$(foreach path, $(DEPENDENCIES_RPATHS),$(strip $(path))))
UNIT_TESTS_LDLIBRARY_PATHS_SANITIZED:=$(subst $() $(),:,$(foreach path, $(UNIT_TESTS_LDLIBRARY_PATHS),$(strip $(path))))
RUN_RPATHS:=$(UNIT_TESTS_LDLIBRARY_PATHS_SANITIZED):$(DEPENDENCIES_RPATHS_FOR_LDLIBRARY):$(EXTRA_LD_LIBRARY_PATH)

VALGRIND_LOGFILE_POSTFIX:=${EXENAME}-$(shell date +%F-%H%M%S)
VALGRIND_SUPP:=valgrind.supp
VALGRIND_COMMON_OPTS:=--gen-suppressions=all --suppressions=$(VALGRIND_SUPP) --time-stamp=yes --error-limit=no

# NOTE: --track-origins=yes makes Valgrind VERY slow but without it Valgrind will report false memory leaks
MEMCHECK_COMMON_OPTS:=--tool=memcheck $(VALGRIND_COMMON_OPTS) --track-origins=yes --malloc-fill=AF --free-fill=BF --leak-check=full
HELGRIND_COMMON_OPTS:=--tool=helgrind $(VALGRIND_COMMON_OPTS)

ERROR_VALGRIND_WITH_TCMALLOC:=Error: $(OUTEXE) is linking against tcmalloc. This makes hard/impossible for Valgrind to spot memory leaks. Please disable tcmalloc linking or use option CFG=debug and retry.

ifeq ($(IS_UNIT_TEST),1)
RUN_ENV_VARS:=\
	UNITTEST_LOGFILE=$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_LOGS)/$(UNIT_TESTS_LOG)
endif

$(OUTEXE)_pre_run_target:: $(OUTEXE)
	@# this is here so that it can be extended if needed... by default we just touch ourselves to allow for incremental builds
	touch $(OUTEXE)_pre_run_target

run:: $(OUTEXE) $(OUTEXE)_pre_run_target
	@echo "##################################################################################"
	@echo "Starting $(OUTEXE) with adjusted LD_LIBRARY_PATH environment var"
	@echo "   LD_LIBRARY_PATH=$(RUN_RPATHS) $(RUN_ENV_VARS) $(OUTEXE) $(ARGS)"
	@echo ""
	@LD_LIBRARY_PATH=$(RUN_RPATHS) $(RUN_ENV_VARS) $(OUTEXE) $(ARGS)

debug:: $(OUTEXE) $(OUTEXE)_pre_run_target
	@echo "##################################################################################"
	@echo "Debugging $(OUTEXE) with adjusted LD_LIBRARY_PATH environment var"
	@echo "   LD_LIBRARY_PATH=$(RUN_RPATHS) $(GDB) -args $(OUTEXE) $(ARGS)"
	@echo ""
	@LD_LIBRARY_PATH=$(RUN_RPATHS) $(GDB) -args $(OUTEXE) $(ARGS)

valgrind:: $(OUTEXE) $(OUTEXE)_pre_run_target
	@echo "##################################################################################"
	@echo "Running valgrind on $(OUTEXE) with adjusted LD_LIBRARY_PATH environment var"
	@echo "   LD_LIBRARY_PATH=$(RUN_RPATHS) $(VALGRIND) $(MEMCHECK_COMMON_OPTS) --log-file=valgrind-$(VALGRIND_LOGFILE_POSTFIX).log $(OUTEXE) $(ARGS)"
	@echo ""
	@[ -z "`ldd $(OUTEXE) | grep tcmalloc`" ] || ( echo "$(ERROR_VALGRIND_WITH_TCMALLOC)" ; exit 11 )
	LD_LIBRARY_PATH=$(RUN_RPATHS) $(VALGRIND) $(MEMCHECK_COMMON_OPTS) --log-file=valgrind-$(VALGRIND_LOGFILE_POSTFIX).log $(OUTEXE) $(ARGS)


# ------------------------------------------------------------------------------------------
# Docker Support
# ------------------------------------------------------------------------------------------

DOCKER_TO_RUN:=$(REMOTE_REPO_NEXUS_DOCKER_FOR_PULL)/$(DOCKER_GROUP)/$(DOCKER_IMAGE_NAME):$(DOCKER_VERSION)$(DEBUG_TAG)

$(OUTEXE)_pre_docker_run_target::
	@# this is here so that it can be extended if needed... by default we just touch ourselves to allow for incremental builds
	touch $(OUTEXE)_pre_docker_run_target

docker_run: $(OUTEXE)_pre_docker_run_target
ifndef DOCKER_IMAGE_NAME
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_NAME"
	@exit 1
endif
	docker run --privileged -it --rm  --cap-add sys_ptrace --ulimit core=-1 --network $(DOCKER_NETWORK) \
		$(DOCKER_RUN_ADDITIONAL_PARAMS) \
		$(DOCKER_TO_RUN) $(ARGS)

docker_debug: $(OUTEXE)_pre_docker_run_target
ifndef DOCKER_IMAGE_NAME
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_NAME"
	@exit 1
endif
ifndef DOCKER_IMAGE_BINARY
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_BINARY"
	@exit 1
endif
	@touch $(HOME)/.gdbinit
	@touch $(HOME)/.gdbearlyinit
	docker run --privileged -it --rm  --cap-add sys_ptrace --ulimit core=-1 --network $(DOCKER_NETWORK) \
		--volume $(HOME)/.gdbinit:/root/.gdbinit \
		--volume $(HOME)/.gdbearlyinit:/root/.gdbearlyinit \
		--volume $(shell readlink -f $(TOPDIR)):/source \
		--entrypoint /usr/bin/gdb.minimal \
		$(DOCKER_RUN_ADDITIONAL_PARAMS) \
		$(DOCKER_TO_RUN) \
		$(DOCKER_IMAGE_BINARY) $(ARGS)

DEBUG_PORT:=1234

#
# FIXME FIXME FIXME: this target is experimental. The idea is to launch the docker of the binary, then start the GDB server
#                    inside and attach to the running binary, exposing the debugging interface on a specific port, to allow
#                    remote debugging sessions (e.g. from a GDB client driven by an IDE). Unfortunately it looks like you  
#                    will need to have the GDB client with the same filesystem layout present inside the docker image (???)
#
docker_gdb_server:
ifndef DOCKER_IMAGE_NAME
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_NAME"
	@exit 1
endif
ifndef DOCKER_IMAGE_BINARY
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_BINARY"
	@exit 1
endif
	-docker stop $(EXENAME)_gdb_server 2>/dev/null
	docker run --privileged --detach --rm  --cap-add sys_ptrace --ulimit core=-1 --name $(DOCKER_IMAGE_NAME)_gdb_server \
		$(DOCKER_RUN_ADDITIONAL_PARAMS) \
		$(DOCKER_TO_RUN)
	docker exec -d --privileged $(DOCKER_IMAGE_NAME)_gdb_server /usr/bin/gdbserver --attach localhost:$(DEBUG_PORT) 1
	$(eval CONTAINER_IP_ADDRESS := $(shell docker inspect -f '{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' $(DOCKER_IMAGE_NAME)_gdb_server))
	@echo "Please attach your GDB client to $(CONTAINER_IP_ADDRESS):$(DEBUG_PORT)"


VALGRIND_COMMON_OPTS:=--gen-suppressions=all --suppressions=/source/$(shell realpath --relative-to=$(TOPDIR) .)/$(VALGRIND_SUPP) --time-stamp=yes --error-limit=no
MEMCHECK_COMMON_OPTS:=--tool=memcheck $(VALGRIND_COMMON_OPTS) --track-origins=yes --malloc-fill=AF --free-fill=BF --leak-check=full

docker_valgrind: $(OUTEXE)_pre_docker_run_target
ifndef DOCKER_IMAGE_NAME
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_NAME"
	@exit 1
endif
ifndef DOCKER_IMAGE_BINARY
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_BINARY"
	@exit 1
endif
	docker run --privileged -it --rm  --cap-add sys_ptrace --ulimit core=-1 --network $(DOCKER_NETWORK) \
		--volume $(shell readlink -f $(TOPDIR)):/source \
		--entrypoint /usr/bin/valgrind \
		$(DOCKER_RUN_ADDITIONAL_PARAMS) \
		$(DOCKER_TO_RUN) \
		$(MEMCHECK_COMMON_OPTS) --log-file=/source/valgrind-$(VALGRIND_LOGFILE_POSTFIX).log \
		$(DOCKER_IMAGE_BINARY) \
		$(ARGS)
		
docker_bash: $(OUTEXE)_pre_docker_run_target
ifndef DOCKER_IMAGE_NAME
	@echo "*** ERROR: please have the caller makefile define DOCKER_IMAGE_NAME"
	@exit 1
endif
	docker run --privileged -it --rm  --cap-add sys_ptrace --ulimit core=-1 --network $(DOCKER_NETWORK) \
		--volume $(shell readlink -f $(TOPDIR)):/source \
		--entrypoint /bin/bash \
		$(DOCKER_RUN_ADDITIONAL_PARAMS) \
		$(DOCKER_TO_RUN)



# ------------------------------------------------------------------------------------------
# Installation Support
# ------------------------------------------------------------------------------------------

# NOTE: the check about DESTDIR being an absolute path is useful to avoid wasting your time debugging strange
#       effects caused by code like:
#            cd /root/dummytest/dummysubdir
#            $(MAKE) -C .. install DESTDIR=../../installtest
#       EXPECTED: /root/dummytest/Makefile installs files into /root/installtest
#       ACTUAL:   /root/dummytest/Makefile installs files into /installtest
#                 (because DESTDIR relative path is relative to the Makefile path, not to the caller's path)
ifeq ($(HAS_INSTALL_SUPPORT),1)
install::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing $(EXENAME) binary program into $(DESTDIR)/bin"
else
	@echo "INSTALL APP $(EXENAME) -> $(DESTDIR)/bin"
endif
	@#@rm -rf                           $(DESTDIR)/    # do not take the freedom to remove the folder, it may be used also by other targets
	@mkdir --parents                    $(DESTDIR)/bin
	@cp $(CP_OPTS) $(OUTEXE)            $(DESTDIR)/bin/
	@chmod a+x                          $(DESTDIR)/bin/$(EXENAME)
ifeq ($(CFG),release)
ifneq ($(DESTDIR_DEBUG),)
	@mkdir --parents                    $(DESTDIR_DEBUG)/bin
	@cp $(CP_OPTS) $(OUTEXE_DEBUGINFO)  $(DESTDIR_DEBUG)/bin/$(EXENAME).debug
endif
else # CFG!=release
	@# we're installing a CFG=debug, CFG=debug-gcov etc, build: create a symlink to the actual binary with the debug tag:
	@cd $(DESTDIR)/bin && ln $(LN_OPTS) $(EXENAME) $(subst $(DEBUG_TAG),,$(EXENAME))
endif
endif # HAS_INSTALL_SUPPORT=1


ifeq ($(HAS_INSTALL_SUPPORT),1)
install_config_only::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing configuration files for $(EXENAME) into $(DESTDIR)/etc"
else
	@echo "INSTALL CONFIGS $(EXENAME) -> $(DESTDIR)/etc"
endif
	@#@rm -rf                           $(DESTDIR)/    # do not take the freedom to remove the folder, it may be used also by other targets
	@mkdir --parents                    $(DESTDIR)
ifdef INSTALL_CONFIG_FILES
	@mkdir --parents                    $(DESTDIR)/etc
	@cp $(CP_OPTS) $(sort $(INSTALL_CONFIG_FILES) $(INSTALL_CONFIG_FILES:yaml=yaml.schema.json)) $(DESTDIR)/etc
endif

endif # HAS_INSTALL_SUPPORT=1

ifeq ($(HAS_INSTALL_SUPPORT),1)
install_static_config_only::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing static configuration files for $(EXENAME) into $(DESTDIR)/static-etc"
else
	@echo "INSTALL STATIC CONFIGS $(EXENAME) -> $(DESTDIR)/static-etc"
endif
	@#@rm -rf                            $(DESTDIR)/    # do not take the freedom to remove the folder, it may be used also by other targets
	@mkdir --parents                     $(DESTDIR)
ifdef INSTALL_STATIC_CONFIG_FILES
	@mkdir --parents                     $(DESTDIR)/static-etc
	@cp $(CP_OPTS) $(INSTALL_STATIC_CONFIG_FILES)   $(DESTDIR)/static-etc
endif
endif # HAS_INSTALL_SUPPORT=1





# ------------------------------------------------------------------------------------------
# Unit Testing Support
#
# NOTE: if this Makefile is building a unit test binary (typically a small app just calling GTest entrypoint)
#       then the "test" and "test_valgrind" targets are implemented as targets that do start this application;
#       if this Makefile is not building a unit test binary but rather an application binary that has its own
#       UnitTests subfolder, then the "test" and "test_valgrind" targets are implemented as recursive targets
# ------------------------------------------------------------------------------------------

REALTOP=$(shell readlink -f $(TOPDIR))

ifeq ($(IS_UNIT_TEST),1)

UNITTEST_LOGFILE_PATH = $(TOPDIR)/$(shell realpath --relative-to=$(TOPDIR) .)/$(EXENAME).log

test:: $(OUTEXE) $(OUTEXE)_pre_run_target
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testStarted name='UnitTests of $(OUTEXE) built as $(BUILDID)' captureStandardOutput='true']" || true
	@echo ""
	@echo "##################################################################################"
	@echo "Starting $(OUTEXE) to run unit tests:"
	@echo "   LD_LIBRARY_PATH=$(RUN_RPATHS) \\"
	@echo "     EMPIRIX_ROOT=/tmp EMPIRIX_ROOT_STORAGE=/tmp \\"
	@echo "     GTEST_OUTPUT=xml:$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_JUNIT)/$(UNIT_TESTS_JUNIT) \\"
	@echo "     ASAN_OPTIONS=$(ASAN_OPTIONS) \\"
	@echo "     UNITTEST_LOGFILE=$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_LOGS)/$(UNIT_TESTS_LOG) \\"
	@echo "     $(OUTEXE) $(ARGS)"
	@echo ""
	@LD_LIBRARY_PATH=$(RUN_RPATHS) \
		EMPIRIX_ROOT=/tmp \
		EMPIRIX_ROOT_STORAGE=/tmp \
		GTEST_OUTPUT="xml:$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_JUNIT)/$(UNIT_TESTS_JUNIT)" \
		ASAN_OPTIONS=$(ASAN_OPTIONS) \
		UNITTEST_LOGFILE=$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_LOGS)/$(UNIT_TESTS_LOG) \
		$(OUTEXE) $(ARGS) || ( echo "Unit testing failed!" ;  \
			echo "##teamcity[blockOpened name='Logfile for unit tests']" ; \
			cat $(UNITTEST_LOGFILE_PATH) ; \
			echo "##teamcity[blockClosed name='Logfile for unit tests']" ; \
			echo "End of $(EXENAME) log file" ; \
			echo "##################################################################################" ; \
			[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testFinished name='UnitTests of $(OUTEXE) built as $(BUILDID)']" || true ; \
			false )
	@echo "##################################################################################"
	@echo ""
	@echo "Unit test binary $(OUTEXE) completed all unit tests successfully!"
	@echo ""
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testFinished name='UnitTests of $(OUTEXE) built as $(BUILDID)']" || true

MEMCHECK_UNITTEST_LOGFILE=valgrind-memcheck-unittests-$(VALGRIND_LOGFILE_POSTFIX).log

test_valgrind:: $(OUTEXE) $(OUTEXE)_pre_run_target
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testStarted name='Valgrind UnitTests of $(OUTEXE) built as $(BUILDID)' captureStandardOutput='true']" || true
	@echo ""
	@echo "##################################################################################"
	@echo "Running valgrind on $(OUTEXE) with adjusted LD_LIBRARY_PATH environment var"
	@echo "   LD_LIBRARY_PATH=$(RUN_RPATHS)  \\"
	@echo "     EMPIRIX_ROOT=/tmp EMPIRIX_ROOT_STORAGE=/tmp \\"
	@echo "     $(VALGRIND) $(MEMCHECK_COMMON_OPTS) \\"
	@echo "       --log-file=$(MEMCHECK_UNITTEST_LOGFILE) --error-exitcode=128 $(OUTEXE) --run-unit-tests $(ARGS)"
	@echo ""
	@[ -z "`ldd $(OUTEXE) | grep tcmalloc`" ] || ( echo "$(ERROR_VALGRIND_WITH_TCMALLOC)" ; exit 11 )
	@# IMPORTANT: instruct valgrind to exit with code 128 if it detects any programming mistake in memory usage:
	@LD_LIBRARY_PATH=$(RUN_RPATHS) \
		EMPIRIX_ROOT=/tmp \
		EMPIRIX_ROOT_STORAGE=/tmp \
		GTEST_OUTPUT="xml:$(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_JUNIT)/$(UNIT_TESTS_JUNIT)" \
		$(VALGRIND) $(MEMCHECK_COMMON_OPTS) --log-file=$(MEMCHECK_UNITTEST_LOGFILE) --error-exitcode=128 $(OUTEXE) --run-unit-tests $(ARGS) || ( \
			echo "Unit testing failed! Valgrind log file for $(EXENAME) after running unit tests:" ; \
			echo "" ;\
			echo "##teamcity[blockOpened name='Logfile for failed test']" ; \
			cat $(MEMCHECK_UNITTEST_LOGFILE) ;\
			echo "##teamcity[blockClosed name='Logfile for failed test']" ; \
			echo "" ;\
			echo "End of $(EXENAME) log file" ; \
			echo "##################################################################################" ; \
			[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testFinished name='Valgrind UnitTests of $(OUTEXE) built as $(BUILDID)']" || true ; \
			false )
	@echo "Valgrind unit testing successful! Log file $(MEMCHECK_UNITTEST_LOGFILE) will be available as a Teamcity artifacts in directory $(TEAMCITY_ARTIFACTS_DIR_MAIN)"
	@mkdir -p $(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_LOGS)
	@mv $(MEMCHECK_UNITTEST_LOGFILE) $(TEAMCITY_ARTIFACTS_DIR_UNITTESTS_LOGS)/
	@echo "End of $(EXENAME) log file"
	@echo "##################################################################################"
	@echo ""
	@echo "Valgrind unit testing of $(OUTEXE) successful!"
	@echo ""
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[testFinished name='Valgrind UnitTests of $(OUTEXE) built as $(BUILDID)']" || true
	@touch $(OUTEXE)_unittests_valgrind

else # IS_UNIT_TEST
ifeq ($(HAS_UNIT_TESTS),1)

test::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test -C UnitTests
endif

test_valgrind::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test_valgrind -C UnitTests
endif

endif # HAS_UNIT_TESTS
endif # IS_UNIT_TEST

##
## Documentation Support
##

# this target is empty... up to the caller Makefile to append commands inside it, if needed:
documentation::


# ------------------------------------------------------------------------------------------
# Config Files Support
# ------------------------------------------------------------------------------------------

include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Version-defines.mk
ifeq ($(HAS_CONFIG_FILES),2)
# note that the 'generate_*_from_*' targets are defined into CppBuild-targets.mk
config_files:: generate_yaml_file_from_xml
endif
ifeq ($(HAS_CONFIG_FILES),0)
config_files::
	@echo ""
	@echo "No config files to regenerate for $(EXENAME)"
	@echo ""
endif


# ------------------------------------------------------------------------------------------
# Help target
# NOTE1: descriptions must be all aligned at column 54 as standard (including the initial TAB)
# NOTE2: only most useful targets are documented; internal/obscure targets must NOT be listed
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_HELP),1)
help::
	@echo
	@echo "Application-level targets (to run INSIDE the builder docker only):"
	@echo "    all                                   builds this binary application"
	@echo "    run                                   runs this application"
	@echo "    debug                                 runs gdb on this application"
	@echo "    valgrind                              runs valgrind on this application"
ifeq ($(IS_UNIT_TEST),1)             
	@echo "    test                                  runs this application (which is declared to be a unit testing application)"
	@echo "    test_valgrind                         runs valgrind on this application (which is declared to be a unit testing application)"
endif             
ifeq ($(HAS_UNIT_TESTS),1)             
	@echo "    test                                  recursively enter the UnitTests subfolder and execute this target there"
	@echo "    test_valgrind                         recursively enter the UnitTests subfolder and execute this target there"
endif
	@echo
ifeq ($(HAS_INSTALL_SUPPORT),1)
	@echo "    install"
	@echo "    install_config_only"
endif
ifeq ($(HAS_REMOTE_INSTALL_SUPPORT),1)
	@echo "    remote_install_root"
endif
	@echo "    config_files                          convert XML configuration descriptors to YAML config files"
	@echo
	@echo "APPLICATION docker targets (do not confuse with builder docker):"
	@echo "    docker_run                            runs this application docker"
	@echo "    docker_debug                          runs this application docker using GDB.MINIMAL as entrypoint"
	@echo "    docker_valgrind                       runs this application docker using VALGRIND as entrypoint"
	@echo "    docker_bash                           runs this application docker using BASH as entrypoint"
endif # SUPPORTS_HELP

include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/CppBuild-targets.mk
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/BuilderDocker-targets.mk

# include all GCC automatically-generated dependency files to allow for smart incremental builds
-include $(TARGS_OBJS:%.o=%.d)
