#
# This is the file which is included by 
#   - Deploy-defines.mk
# and is a registry of all repository-related URLs

# ------------------------------------------------------------------------------------------
# repository constants for Nexus
#
# General naming scheme is:   REMOTE_REPO_<repoInstance>_<artifactType>_FOR_<operation>
#  where
#     repoInstance can be NEXUS,ARTIFACTORY
#     artifactType can be DOCKER,HELM,RPM,CONAN,PYTHON,JAVA
#     operation can be PUSH,PULL
#
# Within the project https://infovista.atlassian.net/browse/DE-1564, the Infovista
# repositories have been organized to work (simplifying a bit) as:
#   
#   ┌─────────────┐
#   │             │
#   │ JFrog       │
#   │ Artifactory ◄─────────────────────────────┐
#   │ cloud       │                             │
#   │ instance    │    ┌─────────────┐          │
#   │ (helm,etc)  │    │             │          │
#   └─────────┬───┘    │ Amazon ECR  │          │
#             │        │ cloud       ◄──────┐   │
#             │        │ instance    │      │   │
#             │        │ (dockers)   │      │   │
#       cache │        └────┬────────┘      │   │
#             │             │cache          │   │
#           ┌─▼─────────────▼─┐             │   │
#           │ nexus-${LAB}    │             │   │
#           │ registry-${LAB} │             │   │
#           │                 │             │   │
#           └──┬───────────┬──┘             │   │
#              │           │                │   │
#              │           │                │   │
#      ┌───────▼────┐   ┌──▼────────┐ push  │   │
#      │  developer │   │ build     ├───────┘   │
#      │  machine   │   │  agent    │           │
#      │            │   │           ├───────────┘
#      └────────────┘   └───────────┘ upload
#
# So the Nexus/JFrogRegistry constants defined here are for the CACHE layer depicted above.
# There is a number of REMOTE_REPO_NEXUS_..._PUSH variables still defined for legacy reasons but now
# all "push/publish" operation should be pushing artifacts into the cloud instances.
# See Deploy-defines.mk where most of the REPO_TYPE_FOR_DEPLOY variables default to "artifactory" now.
# The Nexus/JFrogRegistry CACHE repositories are expected to contain only repositories of type
# "group" or "proxy", not "hosted" anymore.
#
# Also please note that the "REMOTE_REPO_NEXUS_*" variables contain the word "NEXUS" but
# in practice they are used to refer both to the 
#   nexus-${LAB}
#   registry-${LAB}
# instances of "proxy" or "cache" repos of the picture above. Using NEXUS in the name is 
# not entirely correct because helm+dockers are actually proxies by registry-${LAB} service
# which is actually a JFrog Artifactory instance. So that could be confusing. 
# ------------------------------------------------------------------------------------------

ifeq ($(LAB), massy)
# docker: from registry-${LAB}
REMOTE_REPO_NEXUS_DOCKER_FOR_PULL:=registry-massy.dev.infovista.com

# helm: from registry-${LAB}
REMOTE_REPO_NEXUS_HELM_ROOT_FOR_PULL:=https://registry-massy.dev.infovista.com/repository

# rpm: from nexus-${LAB}
REMOTE_REPO_NEXUS_RPM_FOR_PULL:=http://nexus-massy.dev.infovista.com/repository/centos-7-yum/
REMOTE_REPO_NEXUS_RHEL8_RPM_FOR_PULL:=http://nexus-massy.dev.infovista.com/repository/rhel-8-yum/
REMOTE_REPO_NEXUS_OL9_RPM_FOR_PULL:=http://nexus-massy.dev.infovista.com/repository/rhel-9-yum/

# python: from nexus-${LAB}
REMOTE_REPO_NEXUS_PYTHON_FOR_PULL:=http://nexus-massy.dev.infovista.com/repository/pypi/
REMOTE_REPO_NEXUS_PYTHON_HOST_FOR_PULL:=nexus-massy.dev.infovista.com

# pcap: from nexus-${LAB}
# FIXME: right now nexus-massy has an "hosted" repository for PCAPs that is not in sync with the one in repo-billerica,
#        where new PCAPs get added. This is due to missing tunnel between Massy and Billerica data centers.
#        DevOps team has an epic to address this, see DE-2256
#        For the time being, use repo-billerica:
# REMOTE_REPO_NEXUS_PCAP_FOR_PULL:=http://nexus-massy.dev.infovista.com/repository/pcap/automated-tests/
REMOTE_REPO_NEXUS_PCAP_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/pcap/automated-tests/

else
ifeq ($(LAB), modena)

# docker: from registry-${LAB}
REMOTE_REPO_NEXUS_DOCKER_FOR_PULL:=registry-modena.dev.infovista.com

# helm: from registry-${LAB}
REMOTE_REPO_NEXUS_HELM_ROOT_FOR_PULL:=https://registry-modena.dev.infovista.com/repository

# rpm: from nexus-${LAB}
REMOTE_REPO_NEXUS_RPM_FOR_PULL:=http://nexus-modena.dev.infovista.com/repository/centos-7-yum/
REMOTE_REPO_NEXUS_RHEL8_RPM_FOR_PULL:=http://nexus-modena.dev.infovista.com/repository/rhel-8-yum/
REMOTE_REPO_NEXUS_OL9_RPM_FOR_PULL:=http://nexus-modena.dev.infovista.com/repository/rhel-9-yum/

# python: from nexus-${LAB}
REMOTE_REPO_NEXUS_PYTHON_FOR_PULL:=http://nexus-modena.dev.infovista.com/repository/pypi/
REMOTE_REPO_NEXUS_PYTHON_HOST_FOR_PULL:=nexus-modena.dev.infovista.com

# pcap: from nexus-${LAB}
REMOTE_REPO_NEXUS_PCAP_FOR_PULL:=https://nexus-modena.dev.infovista.com/repository/pcap/automated-tests/

else

# docker
REMOTE_REPO_NEXUS_DOCKER_FOR_PULL:=repo-billerica.perform.empirix.com:5000

# helm
REMOTE_REPO_NEXUS_HELM_ROOT_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository

# rpm
REMOTE_REPO_NEXUS_RPM_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/ecc-eva-yum/
REMOTE_REPO_NEXUS_RHEL8_RPM_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/rhel-8-yum/
REMOTE_REPO_NEXUS_OL9_RPM_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/rhel-9-yum/

# python
REMOTE_REPO_NEXUS_PYTHON_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/pypi/
REMOTE_REPO_NEXUS_PYTHON_HOST_FOR_PULL:=repo-billerica.perform.empirix.com

# pcap
REMOTE_REPO_NEXUS_PCAP_FOR_PULL:=https://repo-billerica.perform.empirix.com/repository/pcap/automated-tests/
endif
endif

# DEPRECATED PUSH CONSTANTS
# NOTE: these constants are not LAB-dependent because in nexus-modena and nexus-massy, the "hosted" repositories
#       are completely missing. We have these PUSH constants just as temporary flexibility in case for whatever
#       reason we might need to push in repo-billerica which still has the "hosted" repos available but generally
#       speaking with DE-1564 the policy is to push always in the JFrog cloud artifactory instance (see section below)
# RPM repositories
REMOTE_REPO_NEXUS_RPM_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/ecc-eva-billerica-yum/
REMOTE_REPO_NEXUS_RHEL8_RPM_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/rhel-8-ecc-eva-yum/
REMOTE_REPO_NEXUS_OL9_RPM_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/rhel-9-ecc-eva-yum/
# HELM repositories
REMOTE_REPO_NEXUS_HELM_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/helm-local/
# Maven repositories
REMOTE_REPO_NEXUS_JAVA_RELEASE_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/maven-releases/
REMOTE_REPO_NEXUS_JAVA_SNAPSHOT_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/maven-snapshots/
# PYPI repositories
REMOTE_REPO_NEXUS_PYTHON_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/pypi-local/
# RAW repositories
REMOTE_REPO_NEXUS_TESTRESULTS_FOR_PUSH:=https://repo-billerica.perform.empirix.com/repository/ecc-eva-test-results/

ifeq ($(NEXUS_USER),)
# Empirix Nexus is not protected by authentication but still the "docker login" command and other
# authentication methods for other artifacts want to have some kind of password.
# The user "developer" has no special access permissions but it exists just to make such commands happy.
NEXUS_USER=developer
endif
ifeq ($(NEXUS_PW),)
# Empirix Nexus is not protected by authentication but still the "docker login" command and other
# authentication methods for other artifacts want to have some kind of password.
# The user "developer" has no special access permissions but it exists just to make such commands happy.
NEXUS_PW=hammer
endif


# ------------------------------------------------------------------------------------------
# repository constants for the cloud JFrog Artifactory instance
#
# General naming scheme is:   REMOTE_REPO_[NEXUS|ARTIFACTORY]_<artifactType>_FOR_[PUSH|PULL]
#  where
#     artifactType can be DOCKER,HELM,RPM,CONAN,PYTHON,JAVA
#
# ------------------------------------------------------------------------------------------

# RPM repositories
REMOTE_REPO_ARTIFACTORY_RPM_FOR_PUSH:=https://empirixartifactory.jfrog.io/empirixartifactory/rpm-local/
REMOTE_REPO_ARTIFACTORY_RHEL8_RPM_FOR_PUSH:=https://empirixartifactory.jfrog.io/empirixartifactory/rpm-rhel-8-local/
REMOTE_REPO_ARTIFACTORY_OL9_RPM_FOR_PUSH:=https://empirixartifactory.jfrog.io/empirixartifactory/rpm-rhel-9-local/

# HELM repositories
REMOTE_REPO_ARTIFACTORY_HELM_FOR_PUSH:=https://empirixartifactory.jfrog.io/empirixartifactory/helm-local/

# Conan repositories
REMOTE_REPO_ARTIFACTORY_CLOUD_CONAN_FOR_PUSH:=https://empirixartifactory.jfrog.io/artifactory/api/conan/conan-local
REMOTE_REPO_ARTIFACTORY_CLOUD_CONAN_FOR_PULL:=https://empirixartifactory.jfrog.io/artifactory/conan-local
REMOTE_REPO_ARTIFACTORY_CLOUD_CONAN_NICKNAME:=artifactory_cloud

# PYPI repositories
REMOTE_REPO_ARTIFACTORY_PYTHON_FOR_PUSH:=https://empirixartifactory.jfrog.io/artifactory/api/pypi/pypi-local

# Maven repositories
REMOTE_REPO_ARTIFACTORY_JAVA_RELEASE_FOR_PUSH:=https://empirixartifactory.jfrog.io/artifactory/libs-release/
REMOTE_REPO_ARTIFACTORY_JAVA_SNAPSHOT_FOR_PUSH:=https://empirixartifactory.jfrog.io/artifactory/libs-snapshot/


# ------------------------------------------------------------------------------------------
# repository constants for the on-prem Artifactory instance dedicated to Conan only
# FIXME: this is the only repo that is used for PULLING artifacts that is not redundant 
#        across different LABs (it's just in Billerica)
#
# General naming scheme is:   REMOTE_REPO_[NEXUS|ARTIFACTORY]_<artifactType>_FOR_[PUSH|PULL]
#  where
#     artifactType can be DOCKER,HELM,RPM,CONAN,PYTHON,JAVA
#
# ------------------------------------------------------------------------------------------

REMOTE_REPO_ARTIFACTORY_BILLERICA_CONAN_FOR_PUSH:=http://repo-billerica.perform.empirix.com:8082/artifactory/api/conan/conan-local
REMOTE_REPO_ARTIFACTORY_BILLERICA_CONAN_FOR_PULL:=http://repo-billerica.perform.empirix.com:8082/artifactory/conan-local
REMOTE_REPO_ARTIFACTORY_BILLERICA_CONAN_NICKNAME:=artifactory_billerica

# ------------------------------------------------------------------------------------------
# repository constants for Amazon ECR
# 
# NOTE: Amazon ECR is used only for docker images artifacts
#
# ------------------------------------------------------------------------------------------
ifeq ($(ECR_REGISTRY),)
REMOTE_REPO_ECR_DOCKER_FOR_PUSH:=255142282392.dkr.ecr.us-east-1.amazonaws.com
else
# allow if needed to override the default above from e.g. Teamcity pipelines
REMOTE_REPO_ECR_DOCKER_FOR_PUSH:=$(ECR_REGISTRY)
endif
