#
# This is the file which is included by any Makefiles that wants to 
# build a library. Be sure to include this file at the end
# of the makefile.
#
# The calling Makefile must define:
#     LIBNAME
#         This must be defined to the actual name of the library, excluding
#         the path.
#     EXTRA_DEPS
#         Extra dependencies for the application main target; default to empty
#     << All variables supported by Internal-commonvars.mk -- see that file for detailed list >>
#
# Installation support:
#     INSTALL_DIRNAME
#         Name of the directory where the binary must be installed; this directory will be created under $(DESTDIR)
#         that is passed to the "install" target. If $(DESTDIR_DEBUG) is provided, then debug symbols are installed there.
#     HDR_INSTALL_DIRNAME
#         Name of the directory where the headers must be installed; this directory will be created under $(DESTDIR)
#         that is passed to the "install_headers" target.
#
# Unit testing:
#     HAS_UNIT_TESTS
#         If 2 then the "test" target and the "test_valgrind" target are not defined at all; 
#         the caller makefile must define them if needed.
#         If 1 (default) when "test" target is called, and the "UnitTests" folder is present, the makefile will recursively
#         enter that folder. 
#         NOTE: value 0 is deprecated and not allowed anymore. If the calling makefile is not exposing any unit test, just
#         accept the default value "1" and make sure there is no "UnitTests" subfolder
#
# Specially-handled sub-directories:
# This makefile will treat in a special way a few sub-folders if present:
#     UnitTests
#         The "all", "clean" and "test" targets of this makefile will enter recursively the "UnitTests" folder
#     Packaging, TestBundle, HelmChart
#         The "packaging" target of this makefile will enter recursively these folders
#
# For more variables that can be defined please see:
#   - Common-defines.mk
#   - CppBuild-targets.mk
#


# ---------------------------------------------
# check calling Makefile parameters:
# ---------------------------------------------

ifndef LIBNAME
$(error LIBNAME must be defined)
endif

ifndef BUILDDIR
$(error BUILDDIR must be defined)
endif

ifeq ($(EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR),)
$(error Please define EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR before including this snippet)
endif

ifndef OUTDIR
	OUTDIR := ./Lib/$(BUILDID)
	RM_OUTDIR=1
else
	RM_OUTDIR=0
endif

ifdef OUTLIB
$(error Cannot override OUTLIB with value $(OUTLIB))
endif

ifndef HAS_INSTALL_SUPPORT
# default value
HAS_INSTALL_SUPPORT=1
endif

ifndef SUPPORTS_HELP
# default value
SUPPORTS_HELP=1
endif

ifndef HDR_INSTALL_DIRNAME
ifdef INSTALL_DIRNAME
# default value
HDR_INSTALL_DIRNAME=$(INSTALL_DIRNAME)/include
endif
endif

ifdef LIBTARGS_OPTS
TARGS_OPTS:=$(LIBTARGS_OPTS)
endif

ifndef HAS_UNIT_TESTS
# default value
HAS_UNIT_TESTS=1
endif

ifeq ($(HAS_UNIT_TESTS),0)
$(error HAS_UNIT_TESTS=0 is not supported anymore. Please switch to HAS_UNIT_TESTS=1)
endif

ifeq ($(IS_UNIT_TEST),1)
$(error IS_UNIT_TEST=1 makes no sense for a shared library target. Please remove that setting)
endif

# ------------------------------------------------------------------------------------------
# inclusion checks
# ------------------------------------------------------------------------------------------

INCLUDED_STATICLIBRARY_TARGETS:=1

# blacklist other makefiles that for some reason are incompatible 
# (reason could be as simple as 'the combination has never been tested' or 'does not make much sense')
ifeq ($(INCLUDED_RECURSIVE_TARGETS),1) 
$(error StaticLibrary-targets.mk is incompatible with Recursive-targets.mk. Don't include both.)
endif

# ---------------------------------------------
# create aux make vars:
# ---------------------------------------------

OUTLIB := $(OUTDIR)/$(LIBNAME)

#$(info Enabling \
#	$(if $(findstring norecursive,$(TARGS_OPTS)),simple,recursive) \
#	building of static library $(OUTLIB))

# include the logic that collects source files:
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Internal-commonvars.mk


# ---------------------------------------------
# Targets
# IMPORTANT: the targets ending with double colons can be _extended_ by the caller makefile; this is a nice way to extend "all" and "clean"
#            to do additional stuff beside building the static library
# ---------------------------------------------

.PHONY: all md5sum clean install test

all:: $(OUTLIB)
	@echo "READY [$(CFG)] $(OUTLIB)"
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	@# if present, assume we should recursively build also the UnitTests folder (we assume it contains its own Makefile!)
	$(MAKE) all -C UnitTests
endif
endif

symlinks::
	@echo "Nothing to symlink for static library $(OUTLIB)"

packaging::
	@echo "Nothing to package for static library $(OUTLIB)"
	
ifeq ($(ARCH), tile)

$(OUTLIB):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) 
	$(TILERA_MDE)/bin/tile-ar crus $(OUTLIB) $(TARGS_OBJS)

else

$(OUTLIB):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) $(TARGS_FORMATCHECKS) $(TARGS_CPPCHECKS) $(EXTRA_DEPS)
	@rm -rf $(OUTLIB)     # this is required when building as non-root user and the OUTLIB is already there, without write permissions
ifeq ($(V),0)
	$(call print_green,STATIC LIBRARY CREATION [$(CFG)] $@)
	@$(AR) crus $(OUTLIB) $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) 
else
	$(AR) crus $(OUTLIB) $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) 
endif

endif

strip::
	strip --strip-debug $(OUTLIB)
	ranlib $(OUTLIB)   # after stripping it's important to run ranlib to make sure the static library is usable and linkable

run:
	@echo "Nothing to run for static library targets."

debug:
	@echo "Nothing to debug for static library targets."

valgrind:
	@echo "Nothing to valgrind for static library targets."

docker_run::
	@echo "No docker image is generated for static library targets."

docker_debug::
	@echo "No docker image is generated for static library targets."

docker_valgrind::
	@echo "No docker image is generated for shared library targets."

docker_bash::
	@echo "No docker image is generated for static library targets."

clean::
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	$(MAKE) clean -C UnitTests
endif
endif

##
## Install Support
##

ifeq ($(HAS_INSTALL_SUPPORT),1)
install::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing $(OUTLIB) shared libraries into $(DESTDIR)/$(INSTALL_DIRNAME)"
else
	@echo "INSTALL STATICLIB $(OUTLIB) -> $(DESTDIR)/$(INSTALL_DIRNAME)"
endif
	@mkdir --parents                      $(DESTDIR)/$(INSTALL_DIRNAME)
	@cp $(CP_OPTS) $(OUTLIB)              $(DESTDIR)/$(INSTALL_DIRNAME)/
ifeq ($(CFG),debug)
	@cd $(DESTDIR)/$(INSTALL_DIRNAME) && $(LN) $(LIBNAME) $(subst _D,,$(LIBNAME))
endif

#
# Note that the --parents option is used for cp to implement correctly the copy of header files
# living in subdirectories... e.g. consider TARGS_HDRS can contain "subFolder/a.h" which needs to
# be copied in $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/subFolder/a.h
#
install_headers::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing static library's header files into $(DESTDIR)/$(HDR_INSTALL_DIRNAME)"
else
	@echo "INSTALL HEADERS $(LIBNAME) -> $(DESTDIR)/$(HDR_INSTALL_DIRNAME)"
endif
	@mkdir --parents                               $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/
	@cp $(CP_OPTS) --parents $(TARGS_HDRS)         $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/
	
endif


##
## Unit Testing Support
##

ifeq ($(HAS_UNIT_TESTS),1)
test::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test -C UnitTests
endif

test_valgrind::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test_valgrind -C UnitTests
endif
	
docker_test::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) docker_test -C UnitTests
endif

docker_test_valgrind::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) docker_test_valgrind -C UnitTests
endif
endif

##
## Documentation Support
##

# this target is empty... up to the caller Makefile to append commands inside it, if needed:
documentation::

# ------------------------------------------------------------------------------------------
# Help target
# NOTE1: descriptions must be all aligned at column 54 as standard (including the initial TAB)
# NOTE2: only most useful targets are documented; internal/obscure targets must NOT be listed
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_HELP),1)
help::
	@echo "Static library targets (to run INSIDE the builder docker):"
	@echo "    all"
	@echo "    run"
	@echo "    debug"
	@echo "    valgrind"
ifeq ($(HAS_INSTALL_SUPPORT),1)
	@echo "    install"
endif
	@echo "    test"
	@echo "    test_valgrind"
endif
	
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/CppBuild-targets.mk
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/BuilderDocker-targets.mk

# include all GCC automatically-generated dependency files to allow for smart incremental builds
-include $(TARGS_OBJS:%.o=%.d)
