#
# Cleanup script for Artifactory Conan repository.
# The idea is that EVERYTHING that was published under the "empirix/unstable" Conan channel is OK to remove.
# This might cause issues for pipelines currently linked to unstable artifacts - but the idea is that the
# cache effect of the Nexus repository proxying Artifactory should shield those pipelines, at least for 30days.
#
# Author: fmontorsi
# Created: Nov 2020
#
#
#  FIXME FIXME FIXME: 
#   it seems not possible to query, via conan client, the LAST-DOWNLOADED date of a Conan pkg;
#   and so this script is always erasing all the UNSTABLE Conan packages... 
#   what we should do is to copy/extend the clean-docker-helm-artifacts.py script and interface directly
#   with JFrog APIs, bypassing the Conan client. The same logic used for Dockers/Helms can be probably reused
#   with Conan packages with small changes


function delete_whole_conan_pkg()
{
    local PKG="$1"

    # directly delete the entire package:
    echo "Removing from remote repo [$CONAN_REPO] the package [$PKG]"
    conan remove --remote $CONAN_REPO "$PKG" --force
}

function delete_conan_pkg_binaries()
{
    local PKG="$1"

    conan search --remote $CONAN_REPO --json conan-search-results.json "$PKG"
    if [ $? -ne 0 ]; then
        echo "Query failed. Aborting"
        exit 2
    fi

    # FIXME FIXME Nov2020: the "conan remove -p" step (with empty list of package IDs)
    # does not work due to a bug server-side
    #     https://www.jfrog.com/jira/browse/RTFACT-16410
    # we workaround that by removing each package ID one by one
    CONAN_PKG_IDS="$(jq -r '.results[].items[].packages[].id' conan-search-results.json)"
    for id in $CONAN_PKG_IDS; do
        echo "Removing $pkg / $id"
        conan remove --remote $CONAN_REPO "$pkg" --force --packages "$id"
    done
}

function run_cleanup()
{
    echo
    echo "Trying to login with right credentials on remote repository $CONAN_REPO"
    echo

    # reason for switching credentials is that typically build agents are logged in with a user that cannot DELETE packages
    conan user $ARTIFACTORY_CLEANER_USER -p $ARTIFACTORY_CLEANER_PWD -r $CONAN_REPO
    if [ $? -ne 0 ]; then echo "Failed authentication against $CONAN_REPO" ; exit 100 ; fi

    echo
    echo "Querying the remote repository for UNSTABLE Conan packages"
    echo

    CONAN_PKGS="$(conan search --raw --remote $CONAN_REPO "*/*@empirix/unstable")"
    NUM_CONAN_PKGS="$(echo "$CONAN_PKGS" | wc -l)"

    echo
    echo "Found $NUM_CONAN_PKGS Conan packages in the UNSTABLE channel. Looping on each unstable package and removing it. Take a break, this is going to take hours..."
    echo
    for pkg in $CONAN_PKGS; do

        # FIXME: we should improve by having the delete step done only on UNSTABLE artifacts
        #        older than X days
        delete_whole_conan_pkg "$pkg"
    done

    # go back to previous login
    conan user $ARTIFACTORY_ORIGINAL_USER -p $ARTIFACTORY_ORIGINAL_PWD -r $CONAN_REPO
}

# global config for this script
# NOTE: we assume this script runs in a pipeline that exports the ARTIFACTORY_USER/ARTIFACTORY_PW env vars
CONAN_REPO=artifactory_billerica
ARTIFACTORY_CLEANER_USER=$ARTIFACTORY_USER
ARTIFACTORY_CLEANER_PWD=$ARTIFACTORY_PW

ARTIFACTORY_ORIGINAL_USER=developer
ARTIFACTORY_ORIGINAL_PWD=Hammer123

run_cleanup


