#!/bin/bash
# liblinks.sh - generate symbolic links
# adapted from http://stackoverflow.com/questions/462100/bash-script-to-create-symbolic-links-to-shared-libraries
#
# Usage:
#    liblinks.sh shared_object_filepath1 [,shared_object_filepath2, etc]
#
# For each argument provided, (re)generates chained symbolic links to it;
# given myfolder/libx.so.0.0.0 this would generate, inside "myfolder":
#
#      libx.so     -> libx.so.0
#      libx.so.0   -> libx.so.0.0
#      libx.so.0.0 -> libx.so.0.0.0
#
# To fix all symlinks for shared objects inside a folder run:
#
#      ./liblinks.sh the_folder/lib*.so*
#

declare -u

# VERBOSE setting can be overriden using environment variables
V=${V:-false}

# normalize VERBOSE variable to just the values true/false
if [ "$V" = "1" ]; then
    V=true
else
    V=false
fi

NCREATED=0
NEXISTING=0
LIBFILES="$*"
for FILE in $LIBFILES; do
    if [[ -f "$FILE" ]]; then
        #echo Processing $FILE
        shortlib=$FILE
        
        dirname=$(dirname $FILE)
        basename=$(basename $FILE)
        extn=$(echo $shortlib | sed -n '/\.[0-9][0-9]*$/s/.*\(\.[0-9][0-9]*\)$/\1/p')
        
        current_path=$(pwd)
        cd $dirname
        while [ -n "$extn" ]; do
            #echo "Found extn=$extn"
            shortlib=$(basename $shortlib $extn)
            
            if [ ! -e "$shortlib" ]; then
            	if $V; then
	            	echo "In $dirname, creating link $basename -> $shortlib"
	            fi
	            ln -sf $basename $shortlib
	            (( NCREATED=NCREATED+1 ))
	        else
	        	# the link named "$shortlib" already exists
	        	(( NEXISTING=NEXISTING+1 ))
            fi
           
            basename=$shortlib
            extn=$(echo $shortlib | sed -n '/\.[0-9][0-9]*$/s/.*\(\.[0-9][0-9]*\)$/\1/p')
        done
        cd $current_path
    fi
done

if (( NCREATED+NEXISTING > 0 )); then
	if $V; then
		echo "Successfully created $NCREATED symlinks, $NEXISTING were already existing."
	fi
	exit 0
else
	echo "No versioned shared libraries found. No symlinks created." >&2
	exit 1
fi
