#!/bin/bash
dnf install -y python3-pip
pip3 install --no-cache-dir -r /source/UnitTests/requirements.txt

ROOT_DIR=$PWD

ALL_TEST_LIST=" \
    ConfigFileGenerator \
    YamlToJsonSchema \
    SystemHealthKpiGenerator \
    "

if [ -z "$TO_TEST_LIST" ]
then
    TO_TEST_LIST=$ALL_TEST_LIST
fi

for TO_TEST in $TO_TEST_LIST; do
    # This horrendous sed just convert pascal case to dash lower case:
    #   - "ThisTextVariable" becomes "this-text-variable" 
    TO_TEST_LOWERCASE_DASH=$(\
        sed --expression 's/\([A-Z]\)/-\L\1/g' \
            --expression 's/^-//'              \
            <<< "$TO_TEST"\
    )
    cd "$TO_TEST" || exit
    echo "Running test for '$TO_TEST'"
    pytest --junitxml="$ROOT_DIR"/TeamcityArtifacts/unit-tests-junit/"$TO_TEST_LOWERCASE_DASH".xml
    cd "$ROOT_DIR" || exit
done

if [ ! -z "$SKIP_STOP_TEST_DOCKER" ]
then
    echo
    echo "Skipping docker stop by sleeping for 1 day (just for developers). Press Ctrl+C to exit early."
    trap "exit 0" INT
    (
        trap '' INT
        sleep 86400
    ) &
    wait
fi
