# Infovista shared actions

Shared actions and workflows, aka the github edition of _v2-stable_.

#### Stable branch: `@main`
#### Stable branch for Centos7: `@legacy`

## Differences with gitlab

There are some _important_ differences between GL and GH:
- all GL jobs are dockerized, while GH jobs can be dockerized or not
- GH jobs are a composition of actions and scripts, while GL jobs are just scripts
- source code checkout in GH must be **explicitly** done at the beginning of a job
- GH workflows cannot be customized/extended as GL ones

## Documentation

WIP: move to wiki.

See [JOBS.md](_docs/JOBS.md) for the instructions on how to setup jobs.

See [ACTIONS.md](_docs/ACTIONS.md) for the list of the available actions.

## Developing

When you branch and before/after merge to stable, remember to change all the self-references to action versions.  
`./change-versions.sh bugfix-123` or `./change-versions.sh main`.

## TODO

- [ ] add documentation on actions in wiki
- [ ] add documentation on stages in wiki
- [ ] add extensibility to all workflows, detecting the presence of `$JOBNAME-before_script.sh`
- [ ] add CI version check to internal action references `grep -Hir 'infovista/actions/.*@main' --include '*.yml' .`
- [X] add version change to internal action references for branching

