# Available shared actions

Of course all the actions must be referenced with the version/branch tag, like `infovista/actions/checkout@v1`.

## Actions that can be used in any kind of job

### infovista/actions/checkout
Performs a source code checkout and registers a post-job workspace cleanup.

Also exports `$CI_COMMIT_REF` and `$CI_COMMIT_REF_SLUG` envvars. Slug is also available as action's `output.commit_ref_slug`.

### infovista/actions/setup-job
Sets up the job environment variables for local (nexus) resource access.
Input parameters:
- `variables`: a JSON string containing the job variables
- `secrets`: a JSON string containing the job secrets

Usage:
```yaml
- name: Setup job
  uses: infovista/actions/setup-job@main
  with:
    variables: ${{ toJSON(vars) }}
    secrets: ${{ toJSON(secrets) }}
```

## Actions that can be used only in Linux runners

### infovista/actions/devops-config-check
Checks the `devops-config.yaml` configuration file. The location of the file can be:
- in the root of the repo, `devops-config.yaml`
- in the root of the repo, `devops-config.yml` (note the different extension)
- in the `.infovista` folder, `.infovista/devops-config.yaml`

Input parameters:
- `systems`: (bool) set to `true` if the repo is a system (default: `false`)

## Actions that must be used in a docker job

### infovista/actions/dob
Performs a docker build via `dob`. Requires a job with `runs-on: [self-hosted, docker]` and `container: ghcr.io/infovista/dob:2`.

#### Input parameters:
- `docker-builder-config`: (string) path of the `docker-builder.config.yml` file (default: `docker-builder.config.yml`)
- `ecr-region`: (string) region of private ECR, set to `us-east-1`
- `ecr-access-key`: (string) ECR access key, set to `${{ secrets.ECR_ACCESS_KEY }}`
- `ecr-secret-key`: (string) ECR secret key, set to `${{ secrets.ECR_SECRET_KEY }}`
- `ecr-registry`: (string) ECR registry, set to `${{ vars.ECR_REGISTRY }}`

#### Outputs:
- `built-images`: (multiline string) list of built images
- `scan-images`: (multiline string) list of images to be scanned, for feeding trivy action

The job can be extended with a file called `.github/scripts/dob_before_script.sh` that will be executed before the build. The default shell is `sh` so add a shebang if you want to use another shell.

### infovista/actions/container-scan
Performs a container scan via `trivy`. Requires a job with `runs-on: [self-hosted, docker]` and `container: ghcr.io/infovista/docker-security-scan:2`.

#### Input parameters:
- `images-to-scan`: (multiline string) list of images to be scanned, must be set to the output of the job running `infovista/actions/dob`
- `ecr-region`: (string) region of private ECR, set to `us-east-1`
- `ecr-access-key`: (string) ECR access key, set to `${{ secrets.ECR_ACCESS_KEY }}`
- `ecr-secret-key`: (string) ECR secret key, set to `${{ secrets.ECR_SECRET_KEY }}`
- `ecr-registry`: (string) ECR registry, set to `${{ vars.ECR_REGISTRY }}`

Example:
```yaml
  with:
    images-to-scan: ${{ needs.dockerbuild.outputs.scan-images }}
```
