# jobs HOWTO

## Selecting a runner

#### :collision: Use `runs-on: [self-hosted, docker]` if you want to run a containerized job or something that needs docker
#### :balloon: Use `runs-on: [self-hosted, standard]` if you want to run a classic (bash+actions) job without docker

## Job setup

#### :warning: Always use `infovista/actions/checkout@main` for retrieving the source code.

A severe technical debt in the github code prevents the use of `actions/checkout` on self-hosted runners, so we have to use our own version that performs a post-job workspace cleanup.

#### :arrow_forward: use `infovista/actions/setup-job@main` for setting up envvars for local (nexus) resource access, this way:
```yaml
- name: Setup job
  uses: infovista/actions/setup-job@main
  with:
    variables: ${{ toJSON(vars) }}
    secrets: ${{ toJSON(secrets) }}
```
All the environment variables will be dynamically remapped depending on the datacenter the runner is. For example, `$NEXUS_MAVEN_MIRROR` will point to _nexus-billerica_, _nexus-massy_ or _nexus-modena_ depending on the runner location.

If you are **absolutely sure** that don't need access to corporate resources, you can skip this step.
