#!/bin/sh

# Check if parameters are provided
if [ "$#" -ne 1 ]; then
  echo "change all the self-references to action versions"
  echo "Usage: $0 <new-version>"
  echo "       $0 --git (uses git to get the current branch name)"
  exit 1
fi

kerneltype=$(uname -s)
if [ "$kerneltype" = "Darwin" ]; then
  SEDCOMMAND="gsed"
else
  SEDCOMMAND="sed"
fi

new_ver="$1"
if [ "$new_ver" = "--git" ]; then
  new_ver=$(git branch --show-current)
fi


regex='infovista/actions/(.*)@.*'
regex_new='infovista/actions/\1@'${new_ver}
echo "source regexp: $regex"
echo "dest regexp: $regex_new"

# Use find to search for all yaml files and pipe the results to a while loop
for file in `find . -type f -name '*.yml'`; do
  echo "processing $file"
  # Use sed to replace the matched strings
  $SEDCOMMAND -Ei "s|$regex|$regex_new|g" $file
done