#!/bin/bash

## converts revive.toml to golangci-lint configuration
## and modifies the existing .golangci.yml file with yq
## written by: chatgpt4

# Path to the input and output files
INPUT_FILE=".revive.toml"
OUTPUT_FILE="/tmp/golangci-new.yml"

echo "converting revive.toml to golangci-lint configuration"

# Start the YAML file with the required initial structure
echo "# Imported rules from revive.toml" > "$OUTPUT_FILE"
echo "rules:" >> "$OUTPUT_FILE"

# Read each line of the revive.toml
while IFS= read -r line
do
  if [[ "$line" =~ ^\[rule\.(.*)\] ]]; then
    # Extract the rule name
    RULENAME="${BASH_REMATCH[1]}"
    echo "  - name: $RULENAME" >> "$OUTPUT_FILE"
  elif [[ "$line" =~ Disabled\ =\ (.*) ]]; then
    # rule disabling
    ISDISABLED="${BASH_REMATCH[1]}"
    echo "    disabled: $ISDISABLED" >> "$OUTPUT_FILE"
  elif [[ "$line" =~ arguments\ =\ (.*) ]]; then
    # Extract the argument
    ARGUMENT="${BASH_REMATCH[1]}"
    # Check if the argument is a dictionary
    if [[ "$ARGUMENT" =~ ^\[\{(.*)\}\]$ ]]; then
      # Handle dictionary argument
      echo "    arguments:" >> "$OUTPUT_FILE"
      # Split the dictionary entries
      IFS=',' read -ra PAIRS <<< "${BASH_REMATCH[1]}"
      n=0
      for pair in "${PAIRS[@]}"; do
        # Split each entry into key and value
        IFS='=' read -r key value <<< "$pair"
        # Remove leading and trailing whitespace
        key=$(echo "$key" | xargs)
        value=$(echo "$value" | xargs)
        # Write key-value pairs to the output file
        if [ $n -gt 0 ]; then
            echo "      $key: $value" >> "$OUTPUT_FILE"
        else
            echo "    - $key: $value" >> "$OUTPUT_FILE"
        fi
        n=$((n+1))
      done
    else
      # Handle non-dictionary argument
      echo "    arguments: $ARGUMENT" >> "$OUTPUT_FILE"
    fi
  fi
done < "$INPUT_FILE"

# enable revive in golangci-lint
yq e '.linters-settings.revive = load("/tmp/golangci-new.yml")' -i .golangci.yml
yq e '.linters.enable += ["revive"] | .linters.enable |= unique' -i .golangci.yml
# remove temp file
rm $OUTPUT_FILE
