#!/bin/bash

source `dirname $(readlink -f $0)`/common.sh

start_section setup "Environment setup"
if detect_poetry; then
    echo Poetry package manager detected.
    echo Installing packages...
    poetry -v update
    # poetry add -D pylint_gitlab pylint@^2.14.5
    echo "installing pylint"
    poetry add -v -D "pylint@^2.14.5"
    poetry update -v pylint
    PYLINT_CMD="poetry run python -m pylint"
else
    # TODO more than one requirements in different envs for multiproject repos
    echo Poetry package manager not detected, using requirements.txt
    echo Installing packages...
    uv venv
    source .venv/bin/activate
    find . -type f -name requirements.txt  ! -path "./integration-tests/*" | xargs -r -n 1 -I {} uv pip install -r {}
    # pip install pylint_gitlab pylint~=2.14.5 -U
    echo "installing pylint"
    uv pip install pylint~=2.14.5 -U
    PYLINT_CMD="pylint"
fi
end_section setup

start_section "pylint" "Pylint checks"

JOBNAME=${GITHUB_JOB:-'pylint_test'}
PYLINT_THRESHOLD=${PYLINT_THRESHOLD:-7}
PYLINT_OUTPUT_DIR=${PYLINT_OUTPUT_DIR:-".pylint"}

mkdir -p ${PYLINT_OUTPUT_DIR}
mkdir -p ${PYLINT_OUTPUT_DIR}/badges
mkdir -p ${PYLINT_OUTPUT_DIR}/lint

PYFILES=$(find -type f -name "*.py" ! -path "**/.venv/**" ! -path "./usr/**")

echo Executing pylint...
SCORE="0.0"
${PYLINT_CMD} --exit-zero --output-format=text ${PYFILES} | tee ${PYLINT_OUTPUT_DIR}/lint/pylint.txt

SCORE=`sed -n 's/^Your code has been rated at \([-0-9.]*\)\/.*/\1/p' ${PYLINT_OUTPUT_DIR}/lint/pylint.txt`
end_section "pylint"

#start_section "pylintreports" "Pylint reports"

#echo Generating codeclimate data...
#${PYLINT_CMD} --exit-zero --output-format=pylint_gitlab.GitlabCodeClimateReporter ${PYFILES} > ${PYLINT_OUTPUT_DIR}/codeclimate.json

#echo Generating HTML report...
#${PYLINT_CMD} --exit-zero --output-format=pylint_gitlab.GitlabPagesHtmlReporter ${PYFILES} > ${PYLINT_OUTPUT_DIR}/lint/index.html

#echo Generating badge...
#anybadge --overwrite --label ${JOBNAME} --value=${SCORE} --file=${PYLINT_OUTPUT_DIR}/badges/${JOBNAME}.svg 4=red 6=orange 8=yellow 10=green

#end_section "pylintreports"

# threshold check
if awk "BEGIN {exit !($SCORE >= $PYLINT_THRESHOLD)}"; then
    echo "PyLint Passed :heavy_check_mark: | Score: \`${SCORE}\` | Threshold: \`${PYLINT_THRESHOLD}\`" | tee -a $GITHUB_STEP_SUMMARY
else
    echo "PyLint Failed :x: | Score: \`${SCORE}\` | Threshold: \`${PYLINT_THRESHOLD}\`" | tee -a $GITHUB_STEP_SUMMARY
    exit 1
fi
