#!/bin/bash

source `dirname $(readlink -f $0)`/common.sh

# TODO parse CLI parameters

PACKAGE_VERSION=$1
VERSION_MARKER_STRING=${2:-"VERSION"}

# substitute version in files (if they don't use disttools, and it happens always)
if [ ! -z ${PACKAGE_VERSION+x} ]; then
    # find marker string in all __init__.py files and setup.py
    for x in $(grep -lR --include 'setup.py' --include '*/__init__.py' "$VERSION_MARKER_STRING" .); do
        sed -i '' "s#^$VERSION_MARKER_STRING = .*#$VERSION_MARKER_STRING = \'$PACKAGE_VERSION\'#" $x
    done
fi

if detect_poetry; then
    poetry config repositories.target ${TARGET_PYPI_REPO_URL}
    poetry config http-basic.target ${TARGET_PYPI_USER} ${TARGET_PYPI_PASS}
    poetry version $PACKAGE_VERSION
    poetry publish -r target --build
    poetry config --unset repo.target
else
    python setup.py bdist_wheel
    python -m twine upload -u ${TARGET_PYPI_USER} -p ${TARGET_PYPI_PASS} --repository-url ${TARGET_PYPI_REPO_URL} dist/*
fi
