# CONFIG FILE GENERATOR

Translates a "master XML" file containing a description of all configuration options in:
* YAML or
* INI or
* CSV
file formats.
Moreover provides documentation for each parameter in Excel format.

KLERITY/Ativa products employ this utility in all EVA/ECC components to describe configuration parameters.

## Requirements
- Language: Python 3
- Libraries: python-xmltodict, python-lxml

## Example

- Config `INI` file generator

```bash
$ python3 config_file_generator.py \
                        --output_type INI \
                        --input Common/etc/data-config.xml \
                        --schema SMMCommonPropertiesMasterFiles.xsd \
                        --output config_file.ini
```

- Config `YAML` file generator:

```bash
$ python3  config_file_generator.py
                        --output_type YAML
                        --input Common/etc/data-config.xml
                        --schema SMMCommonPropertiesMasterFiles.xsd
                        --output config_file.yaml
```

- Config `CSV` file generator:

```bash
$ python3  config_file_generator.py
                        --output_type CSV
                        --input Common/etc/data-config.xml
                        --schema SMMCommonPropertiesMasterFiles.xsd
                        --output dictionary_file.csv
```

## Unit Test

```bash
$ python3 config_file_generator.py \
                        --output_type TEST
```

## Master XML file format

TODO: provide better documentation of the XML format. For now this example gather all supported attributes of
the XML 'field' node:

```xml
<config-file name="/fullpath/of/config/file" helm_chart="helm-charts-where-this-config-file-is-used" xmlns="http://www.empirix.com/master/xml/config" >
    <section name="foobar" tag="SomeTagJustForDocumentation">

        <!-- simple options that do not allow for min/max value specification: -->
        <option 
            name="option_name" 
            default_value="true" 
            type="string|boolean|enum|string_list|int_list|object" 
            short_desc="Short desc up to 50 chars" 
            long_desc="Longer description up to 5000 chars" 
            documentation="HIDDEN|VISIBLE"
        />

        <!-- simple options that do allow for min/max value specification: -->
        <option 
            name="option_name" 
            default_value="true" 
            min_value="0" 
            max_value="120"
            type="float|uint16|uint32|uint64|integer" 
            short_desc="Enable option" 
            long_desc="Enable option" 
        />

        <!-- complex configs having +1 hierarichal level: -->
        <option 
            name="object_list_with_one_item_two_children" 
            type="object_list" 
            short_desc="has two elements" 
            long_desc="long description">

            <!-- nested options -->
            <option 
                name="first_one" 
                default_value="123" 
                type="string" 
                short_desc="first child element" 
                long_desc="long description"/>
            <option 
                name="second_one" 
                default_value="name,test" 
                type="string_list" 
                short_desc="second child element" 
                long_desc="long description"/>
        </option>
    </section>
</config-file>
```