import os
import sys

import config_file_generator_constants


class AppLogger(object):
    def __init__(self, verbose: bool):
        self.verbose = verbose

    def log(self, msg):
        if self.verbose:
            print(config_file_generator_constants.SCRIPT_NAME + ": " + msg)


def listify(prop_or_list):
    return prop_or_list if isinstance(prop_or_list, list) else [prop_or_list]


def throw_error(message):
    print(message)
    raise Exception(message)


def throw_malformed_error(props, message=""):
    section = props.psection if hasattr(props, "psection") else "<psection not present>"
    name = props.name
    type = props.default_type
    # "MALFORMED OPTION WARNING: option name=%s type=%s in section %s... MISSING ATTRIBUTE.Abort."
    default_error_str = (
        f"with default={type}"
        if name and type
        else f"in section {section}...MISSING ATTRIBUTE. Abort."
    )
    throw_error(
        f"MALFORMED OPTION WARNING: option name={name} type={type} {default_error_str}. {message}"
    )


def xmlstr_to_pytype(input_str, input_type):
    # TODO key error if not into XML_TO_TYPE_MAP: unexpected type
    XML_TO_TYPE_MAP = {
        "integer": int,
        "uint32": int,
        "float": float,
        "boolean": bool,
        "enum": str,
        "string": str,
        "object_list": list,  # It should actually be an EMPTY list
        "string_list": list,
        "int_list": list,
    }
    XML_LIST_TO_TYPE_MAP = {
        "string_list": str,
        "int_list": int,
        "object_list": type(None),
    }
    end_type = XML_TO_TYPE_MAP[input_type]
    if end_type is list:
        # Corner case where someone forgot a split or we are using xml.etree
        if not isinstance(input_str, list):
            input_str = input_str.split(",")
        list_el_type = (
            XML_LIST_TO_TYPE_MAP[input_type]
            if isinstance(input_type, str)
            else type(input_str[0])
        )
        return [list_el_type(x) for x in input_str]
    elif end_type is bool:
        return {"true": True, "false": False}[input_str.lower()]
    elif not input_str:
        return input_str  # Keeps None and empty strings/lists unchanged
    else:
        return end_type(input_str)
