import sys
from lxml import etree

import common_helpers


class SchemaValidator(object):
    def __init__(self, logger):
        self.logger = logger

    def validate_xml(self, input_file, schema_file):
        try:
            # Document validation if schema is passed
            with open(input_file) as fd:
                with open(schema_file) as sd:
                    schema_data = etree.parse(sd)
                    xmlschema = etree.XMLSchema(schema_data)

                    xml_doc = etree.parse(fd)
                    xmlschema.assertValid(xml_doc)
        except etree.DocumentInvalid as err:
            print(
                f"Input XML document is not valid against schema '{schema_file}' provided: {err}"
            )
            sys.exit(128)
        except IOError as err:
            print(f"Error reading input XML file: {err}")
            sys.exit(128)

        self.logger.log(
            "The XML master configuration file '%s' validated correctly against XML schema '%s'"
            % (input_file, schema_file)
        )
