import os
import xmltodict
from lxml import etree
import pytest

import config_file_generator_constants
from test_constants import XML_EXAMPLE_TEXT, YAML_EXAMPLE_RESULT


class TestConfigFileGenerator:
    def test_xml_schema_validation(self):
        try:
            # with open(self.options.schema) as xsd:
            with open(
                "/source/ConfigFileGenerator/schema/MasterConfigFileSchema.xsd"
            ) as xsd:
                schema_data = etree.parse(xsd)
                xmlschema = etree.XMLSchema(schema_data)

                xml_doc = etree.fromstring(XML_EXAMPLE_TEXT.strip())
                xmlschema.assertValid(xml_doc)
        except etree.DocumentInvalid as err:
            print(
                "Input XML document is not valid against schema '%s' provided.. quitting."
            )

    def test_xml_namespace(self):
        valid_namespace = "http://www.empirix.com/master/xml/config"
        # xml_doc = etree.fromstring(self._xml_example_text)
        xml_data = xmltodict.parse(XML_EXAMPLE_TEXT.strip())
        assert xml_data.get("config-file").get("@xmlns") == valid_namespace

    def test_yaml_output(self):
        input_xml = XML_EXAMPLE_TEXT.strip()
        yaml_expected = YAML_EXAMPLE_RESULT.strip() + "\n"

        tmp_dir = "/tmp"
        script_absolute_path = (
            "/source/ConfigFileGenerator/" + config_file_generator_constants.SCRIPT_NAME
        )
        xml_input_filename = (
            tmp_dir + "/" + config_file_generator_constants.SCRIPT_NAME + ".test.xml"
        )

        xml_example_file = open(xml_input_filename, "w")
        xml_example_file.write(input_xml)
        xml_example_file.close()
        print("Created XML test input file: %s" % xml_input_filename)

        yaml_example_filename = (
            tmp_dir + "/" + config_file_generator_constants.SCRIPT_NAME + ".test.yaml"
        )

        conversion_command = (
            script_absolute_path
            + " --output_type YAML "
            + " --input "
            + xml_input_filename
            + " --output "
            + yaml_example_filename
            + " --schema "
            + "/source/ConfigFileGenerator/schema/MasterConfigFileSchema.xsd"
        )
        print("YamlConfigFileGenerator:Test command:\n%s" % conversion_command)
        stream = os.popen(conversion_command)
        command_output = stream.read()
        print("Command output:\n%s" % command_output)

        yaml_generated = ""
        with open(yaml_example_filename) as yaml_example_file:
            print("Created yaml test file: %s" % yaml_example_filename)
            yaml_generated = yaml_example_file.read().lstrip()

        if yaml_expected != yaml_generated:
            print("Yaml generated not as expected.. quitting.")
            print("--- Yaml generated ---\n" + yaml_generated)
            print("--- Yaml expected ---\n" + yaml_expected)
        else:
            print("Content of generated yaml file is as expected. Test success!")
            # os.remove(xml_input_filename)
            # os.remove(yaml_example_filename)

        assert yaml_expected == yaml_generated
