import pathlib
import hashlib
import os

import pytest
import config_file_generator_constants


class TestInvalidConfigGeneration:
    SCRIPT_LOCATION = pathlib.Path(__file__).parent.resolve()
    XML_LOCATION = os.path.join(SCRIPT_LOCATION, "input_files/")
    OUTPUT_FILES_LOCATION = os.path.join(SCRIPT_LOCATION, "output_files/")
    # EXPECTED_FILES_LOCATION = os.path.join(SCRIPT_LOCATION, "expected_files/")

    SCRIPT_ABSOLUTE_PATH = os.path.abspath(config_file_generator_constants.SCRIPT_NAME)

    def test_invalid_config_output(self):
        input_filename = "invalid-config"
        xml_input_filename = os.path.join(self.XML_LOCATION, f"{input_filename}.xml")

        if not os.path.isdir(self.OUTPUT_FILES_LOCATION):
            os.makedirs(self.OUTPUT_FILES_LOCATION)

        yaml_output_filename = os.path.join(
            self.OUTPUT_FILES_LOCATION, "{input_filename}.yaml"
        )

        conversion_command = f"{self.SCRIPT_ABSOLUTE_PATH} --input {xml_input_filename} --output {yaml_output_filename} --output_type YAML"
        print(f"Test command: {conversion_command}")

        stream = os.popen(conversion_command)
        command_output = stream.read()
        print(f"Command output: {command_output}")
        expected_exception = (
            "Either 'name' or 'pattern' attribute should be present in 'section'\n"
        )
        assert command_output == expected_exception
