#
# This makefile provides support to convert
#   master XML config files
#      -> YAML files
#      -> JSON schema files
#
# The calling Makefile must define:
#     CONFIG_MASTER_XML_FILES
#         List of master XML files to process
#     EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR
#         Pointer to the pipeline-framework makefile directory
#
# This makefile provides the following targets:
#  - generate_yaml_file_from_xml
#  - generate_json_schema_from_yaml


# ------------------------------------------------------------------------------------------
# Variables from caller makefile
# ------------------------------------------------------------------------------------------

ifndef HAS_CLEAN_SUPPORT
# default value
HAS_CLEAN_SUPPORT=1
endif


# ------------------------------------------------------------------------------------------
# Config files target
# ------------------------------------------------------------------------------------------

CONFIG_MASTER_XML_DIR=$(word 1, $(subst /,,$(dir $(CONFIG_MASTER_XML_FILES))))
CONFIG_YAML_FILES:=$(CONFIG_MASTER_XML_FILES:xml=yaml)
CONFIG_JSON_SCHEMA_FILES:=$(CONFIG_MASTER_XML_FILES:xml=schema.json)

# location of pipeline-framework-owned files
CONFIG_FILE_GENERATOR_DIR:=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../config-file-generator/
CONFIG_FILE_GENERATOR_SCRIPT:=$(CONFIG_FILE_GENERATOR_DIR)/config_file_generator.py
MASTER_CONFIG_FILE_XSD:=$(CONFIG_FILE_GENERATOR_DIR)/schema/MasterConfigFileSchema.xsd
YAML_TO_JSON_SCHEMA_DIR:=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../yaml-to-json-schema/
YAML_TO_JSON_SCHEMA_SCRIPT:=$(YAML_TO_JSON_SCHEMA_DIR)/yaml_to_json_schema.py

$(CONFIG_MASTER_XML_DIR)/%.schema.json: $(CONFIG_MASTER_XML_DIR)/%.xml
	@echo "CFGFILE $< -> $(@:schema.json=yaml)"
	@sed -i 's@\t@    @g' $<      # remove TABs, if any, from the master XML (attempt to enforce standard formatting)
ifeq ($(V),0)
	@python3 $(CONFIG_FILE_GENERATOR_SCRIPT) --schema $(MASTER_CONFIG_FILE_XSD) --output_type YAML --input $< --output $(@:schema.json=yaml)
else
	python3 $(CONFIG_FILE_GENERATOR_SCRIPT) --schema $(MASTER_CONFIG_FILE_XSD) --output_type YAML --input $< --output $(@:schema.json=yaml) --verbose
endif

%.schema.json: %.yaml
ifeq ($(V),0)
	@echo "CFGFILE $< -> $(@:schema.json=yaml)"
	@python3 $(YAML_TO_JSON_SCHEMA_SCRIPT) -i $< $(if $(JSON_SCHEMA_OUTPUT),-o $(JSON_SCHEMA_OUTPUT),)
else
	python3 $(YAML_TO_JSON_SCHEMA_SCRIPT) -i $< $(if $(JSON_SCHEMA_OUTPUT),-o $(JSON_SCHEMA_OUTPUT),)
endif

generate_yaml_file_from_xml: $(CONFIG_JSON_SCHEMA_FILES)

generate_json_schema_from_yaml: $(YAML_FILES:yaml=schema.json)
ifeq ($(YAML_FILES),)
	@echo "Please define YAML_FILES when invoking this target"
	@exit 34
endif

# ------------------------------------------------------------------------------------------
# Clean target
# ------------------------------------------------------------------------------------------

ifeq ($(HAS_CLEAN_SUPPORT), 1)

clean::
ifneq (,$(CONFIG_YAML_FILES))
	@echo "Removing automatically-generated YAML config files $(CONFIG_YAML_FILES)"
	@for cfgfile in $(CONFIG_YAML_FILES); do \
		$(RM) $$cfgfile; \
	done
endif

endif	# HAS_CLEAN_SUPPORT=1