# Provides support for processing .dsh (Dshell) files
#
# The calling Makefile must define:
#     EXTRA_INCS
#         Optionally defined to explicitly add directories to search
#         for header files.
#     EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR
#         Points to the pipeline-framework makefile directory
#
# This makefile provides the following targets:
#  - shell_cmds


# ------------------------------------------------------------------------------------------
# shell commands helper target
# ------------------------------------------------------------------------------------------

DSHELL_BIN=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../scripts/dshell/dshell
SEDEASY=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../scripts/dshell/sedeasy.sh

DSHELL_FILE := $(wildcard *.dsh)

shell_cmds:
ifneq ($$DSHELL_FILE,)
	@for DSHELL_FILE in $(wildcard *.dsh); do \
		echo "*** Now processing the DShell file $$DSHELL_FILE using the $(DSHELL_BIN) utility" ; \
		CMDS_HDR_FILE=$${DSHELL_FILE/.dsh/.h} ; \
		CMDS_SRC_FILE=$${DSHELL_FILE/.dsh/.cpp} ; \
		CMDS_SRCGEN_FILE=$${DSHELL_FILE/.dsh/.c} ; \
		$(DSHELL_BIN) $$DSHELL_FILE; \
		$(SEDEASY) "static int disp(int _cmd_, int _odesc_, int _flags_, int _args_[])" \
		        "static ShellCmdErr disp(int _cmd_, std::stringstream& _odesc_, int _flags_, void* _args_[])" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "                     (char*)_args_[" \
		        "               (const char*)_args_[" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "                            _args_[" \
		        "             (unsigned long)_args_[" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "shellCmd.h" \
		        "DShellCmd.h" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "int cmd_" \
		        "ShellCmdErr cmd_" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "char*" \
		        "const char*" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "            int" \
		        "            unsigned long" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "cmdTblReg" "ShellCmdTblReg" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "cmdTblUnreg" "ShellCmdTblUnreg" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "cmdTblReg" "ShellCmdTblReg" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "cmdTblUnreg" "ShellCmdTblUnreg" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "cmdEntry" "ShellCmdEntry" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "cmdTbl" "ShellCmdTbl" $$CMDS_SRCGEN_FILE  ; \
		$(SEDEASY) "int _odesc_" "std::stringstream& _odesc_" $$CMDS_HDR_FILE  ; \
		$(SEDEASY) "CMD_ERR_SYNTAX" "SHELL_CMD_ERR_SYNTAX" $$CMDS_SRCGEN_FILE  ; \
		mv $$CMDS_SRCGEN_FILE $$CMDS_SRC_FILE; \
		echo "Done generating $$CMDS_HDR_FILE and $$CMDS_SRC_FILE; now reformatting them using $(CLANG_FORMAT_BIN)"; \
		$(CLANG_FORMAT_BIN) --style=file -i $$CMDS_HDR_FILE ; \
		$(CLANG_FORMAT_BIN) --style=file -i $$CMDS_SRC_FILE ; \
		echo "Reformatting of $$CMDS_HDR_FILE and $$CMDS_SRC_FILE was done"; \
	done
else
	@echo "No shell table to regenerate"
endif

# old synonym
cmds: shell_cmds


# ------------------------------------------------------------------------------------------
# Help target
# NOTE1: descriptions must be all aligned at column 54 as standard (including the initial TAB)
# NOTE2: only most useful targets are documented; internal/obscure targets must NOT be listed
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_HELP),1)
help::
	@echo
	@echo "Misc targets (to run INSIDE the builder docker):"
	@echo "    shell_cmds:                           regen C++ source code from .DSH files"
endif
