#!/bin/bash

# Script to run commands in 'cache_credentials' and 'cache_credentials_clean' 
# targets and manage nohup

NOHUP_PID_FILE=/var/run/atf/credentials/nohup-pid
CACHED_CREDENTIAL_FILE=/var/run/atf/credentials/cache

function write_ciphered_file() 
{
    python3 $EMPIRIX_PIPELINE_FRAMEWORK_SCRIPT_SUPPORT_DIR/cache_nexus_credentials.py \
        $CACHED_CREDENTIAL_FILE $PCAP_REPO $NEXUS_PCAPBOT_USER $NEXUS_PCAPBOT_PW
    if [ $? -ne 0 ]; then
        echo "Failed to cache credentials. Aborting."
        exit $?
    fi

    if (( $TIMEOUT_SEC < 0 )); then
        echo "Invalid timeout provided ${TIMEOUT_SEC}. Use zero to specify infinite timeout."
        exit 100
    elif (( $TIMEOUT_SEC == 0 )); then
        echo "Cached credentials forever (no timeout). This is a security risk in case this machine can be used by other users."
    elif (( $TIMEOUT_SEC > 0 )); then
        # nohup allows to run a background process witch remove the 
        # credentials file after the timeout
        echo "Timing out credentials after ${TIMEOUT_SEC}secs"
        nohup bash -c "sleep $TIMEOUT_SEC && \
            rm -f $CACHED_CREDENTIAL_FILE $NOHUP_PID_FILE" >/dev/null 2>&1 &

        # save PID in a file
        echo $! > $NOHUP_PID_FILE
    fi
}

function cache_credentials_clean() {
    # if file with PID already exists, remove nohup PID
    if [ -f "$NOHUP_PID_FILE" ]; then
        kill -9 `cat $NOHUP_PID_FILE`
        rm -rf $NOHUP_PID_FILE
    fi 

    # remove credentials file
     if [ -f "$CACHED_CREDENTIAL_FILE" ]; then
        rm -rf $CACHED_CREDENTIAL_FILE
        echo "Credentials removed correctly"
    else
        echo "No credentials to clean"
    fi
}


# CLI arguments
FUNCTION_TO_INVOKE="$1"
EMPIRIX_PIPELINE_FRAMEWORK_SCRIPT_SUPPORT_DIR="$2"
PCAP_REPO="$3"
TIMEOUT_SEC="$4"
NEXUS_PCAPBOT_USER="${5:-null}"
NEXUS_PCAPBOT_PW="${6:-null}"
    
$FUNCTION_TO_INVOKE
