import os, sys, yaml


def check_name(kube_file: str, cluster_name_to_check: str) -> None:
    """Check Kubernetes cluster name from a kubeconfig file"""

    if not os.path.exists(kube_file):
        raise FileNotFoundError(f"File {kube_file} doesn't exist!")

    with open(kube_file, "r") as f:
        data = yaml.full_load(f)

    cluster_names = [cluster["name"] for cluster in data["clusters"]]
    if cluster_name_to_check not in cluster_names:
        print(
            f"ERROR: Cluster name '{cluster_name_to_check}' not found in {cluster_names} list from {kube_file} file!"
        )
        sys.exit(200)
    else:
        print(
            f"Cluster name '{cluster_name_to_check}' is in {kube_file} file. Proceeding..."
        )


if __name__ == "__main__":
    kube_file = sys.argv[1]
    cluster_name_to_check = sys.argv[2]
    check_name(kube_file, cluster_name_to_check)
