#
# Empirix Conan file to package C++ artifacts generated by this repository
# as a Conan package
#
# A few important points on how Conan is used here:
# 1) Conan is used only for the PACKAGING and does NOT drive the C++ build.
#    GNU make drives the C++ compilation, linking and installation steps.
# 2) Conan versioning is obtained from GNU make, through the use of the
#    "make get_conan_version" command... in this way the version declared by
#    GNU make will always be perfectly aligned to the one declared inside the
#    Conan package.
# 3) The installation of the artifacts into the Conan package is done through
#    "make install" command, instead of hardcoding here a long list of "copy"
#    commands.
from conans import ConanFile, AutoToolsBuildEnvironment
import yaml


def get_conan_requirements():
    with open(r"conandata.yml") as file:
        conandata = yaml.load(file, Loader=yaml.FullLoader)
        return conandata["conan_requirements"]


class EvaEccPipelineFrameworkConan(ConanFile):
    # metadata specific to this repo:
    name = "pipeline-framework"
    description = "GNU make code and scripts used to run all EVA/ECC pipelines"
    # metadata common to all Empirix C++ repos:
    generators = "make"
    author = "Empirix EVA/ECC team"
    settings = "os", "compiler", "build_type", "arch"
    license = "Empirix Commercial License"
    topics = None
    exports_sources = "*"
    build_policy = "missing"
    # The python_requires feature is a way to share files and code between different recipes
    python_requires = get_conan_requirements()
    # python_requires_extend is used to inform Conan about additional Python base classes.
    # The resulting inheritance is equivalent to declare our Pkg class as class Pkg(pyreq.MyBase, ConanFile)
    # To see more details go to https://docs.conan.io/en/latest/extending/python_requires.html
    python_requires_extend = "conan-base.EmpirixConanBase"

    def package_id(self):
        """
        This function is called by Conan to understand the type of package to create. In case there are no precompiled binaries,
        we must inform Conan that this is a so-called header-only package.
        Note that to correctly install header-only packages apparently on the download side you will need to always give the --build
        flag to the 'conan install' command.
        """
        self.info.header_only()

    def package(self):
        """
        This function is called by Conan in 2 cases:
        a) when building the package with the 'conan create' command; at that
        b) when installing a header-only package just-downloaded from a Conan repository, i.e. when using "conan install --build"

        In both cases this function executes inside the so-called "package folder" which has no git information (.git is missing)
        and thus we cannot use tools.Git() here. The package folder will contain all the sources of the original git repository
        matched by the "exports_sources" variable (by default everything except hidden folders like the .git one).

        Having no .git folder means having a smaller Conan package but also means that we cannot derive from git the value of 2
        env vars required by our makefiles: GIT_BRANCH_NAME and GIT_DESCRIBE.
        However typically Empirix makefiles will not use any version variable defined by Makefile.version
        so that we can actually provide some dummies for these git-based informations just to make GNU make and get the "install" done.

        In order to avoid hardcoding lots of "self.copy" commands, as done in several conanfile examples, we rely on the availability
        of a "make install" target.
        """
        self.output.info("Executing package() method")
        gnu_make_wrapper = AutoToolsBuildEnvironment(self)
        gnu_make_wrapper.install(
            vars={
                "DESTDIR": self.package_folder,
                "GIT_BRANCH_NAME": "dummy-branch",
                "GIT_DESCRIBE": "1.0.0-0-dummy",
            }
        )
