/* 
 * File:         HighSeeOutput.h
 * Description:  HighSeeOutput class
 *
 * (C) COPYRIGHT nTh s.r.l. 2015-2019. ALL RIGHTS RESERVED.
 * NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED REPRODUCED OR
 * TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR
 * WRITTEN CONSENT OF nTh s.r.l.
 */

#ifndef HIGHSEEOUTPUT_H
#define	HIGHSEEOUTPUT_H

#include <string>
#include <string.h>
#include "highsee_adaptor.h"
#include "IGenericObject.h"


class HighSeeOutput : public IGenericObject
{
    public:
        HighSeeOutput() { reset(); };
        virtual ~HighSeeOutput() {};
        virtual  eObjectType getType(void)             { return eHighSeeOutputType; }
        virtual  void reset(void)                      { resetOut(); }
        
        // Reading methods: used by 3rd Party
        uint32_t getSessionType(void)                  { return m_sessionType; }
        uint64_t getSessionId(void)                    { return m_sessionId; }
        highsee_timestamp_t& getTimestamp(void)        { return m_timestamp; }
        highsee_ip_address_t& getClientIp(void)        { return m_clientIp; }
        uint8_t getUpQfi(void)                         { return m_upQfi; }
        highsee_gtp_endpoint_t& getUlGtpEndpoint(void) { return m_ulGtpEndpoint; }
        highsee_gtp_endpoint_t& getDlGtpEndpoint(void) { return m_dlGtpEndpoint; }
        std::string& getSummaryInfo(void)              { return m_summaryInfo; }

        // Setting methods: used by HighSee
        void setClientIp(highsee_ip_address_t& ar_clientIp)    { setIpAddress(ar_clientIp, m_clientIp.len, m_clientIpBytes); }
        void setUlGtpEndpoint(highsee_gtp_endpoint_t &ar_gtpEndpoint) { m_ulGtpEndpoint.teid = ar_gtpEndpoint.teid; 
                                                                        setIpAddress(ar_gtpEndpoint.ip_addr, m_ulGtpEndpoint.ip_addr.len, m_ulGtpIpBytes); }
        void setDlGtpEndpoint(highsee_gtp_endpoint_t &ar_gtpEndpoint) { m_dlGtpEndpoint.teid = ar_gtpEndpoint.teid; 
                                                                        setIpAddress(ar_gtpEndpoint.ip_addr, m_dlGtpEndpoint.ip_addr.len, m_dlGtpIpBytes); }
        void setSessionType(uint32_t a_sessionType)          { m_sessionType = a_sessionType; }
        void setSessionId(uint64_t a_sessionId)              { m_sessionId = a_sessionId; }
        void setUpQfi(uint8_t a_upQfi)                       { m_upQfi = a_upQfi; }
        void setTimeStamp(highsee_timestamp_t &ar_timestamp) { m_timestamp = ar_timestamp; }            
        void setSummaryInfo(std::string& a_summaryInfo)      { m_summaryInfo = a_summaryInfo; }

    private:
        // Disabled copy constructor
        HighSeeOutput(const HighSeeOutput&);
        // Disabled assign operator
        HighSeeOutput& operator = (const HighSeeOutput&);

        inline void setIpAddress(highsee_ip_address_t& ar_ip_in, uint16_t& ar_ip_len, uint8_t* ap_ip_addr);
        inline void resetOut(void);
        
        uint32_t               m_sessionType;
        uint64_t               m_sessionId;
        highsee_timestamp_t    m_timestamp;
        highsee_ip_address_t   m_clientIp;
        uint8_t                m_upQfi;
        uint8_t                m_clientIpBytes[MAX_HS_ADDRESS_LENGTH];
        highsee_gtp_endpoint_t m_ulGtpEndpoint;
        uint8_t                m_ulGtpIpBytes[MAX_HS_ADDRESS_LENGTH];
        highsee_gtp_endpoint_t m_dlGtpEndpoint;
        uint8_t                m_dlGtpIpBytes[MAX_HS_ADDRESS_LENGTH];
        std::string	       m_summaryInfo;      
};

//------------------------------------------------------------------------------
inline void HighSeeOutput::resetOut()
{
    m_sessionType = SESSION_OUT_TYPE_NONE;
    m_sessionId = 0;
    m_timestamp.nsec = 0;
    m_timestamp.sec = 0;
    m_clientIp.len = 0;
    m_clientIp.p_data = m_clientIpBytes; // Always point to m_clientIpBytes
    m_clientIpBytes[0] = 0;
    m_upQfi = UP_QFI_NOT_VALID;
    m_ulGtpEndpoint.teid = 0;
    m_ulGtpEndpoint.ip_addr.len = 0;
    m_ulGtpEndpoint.ip_addr.p_data = m_ulGtpIpBytes; // Always point to m_ulGtpIpBytes
    m_ulGtpIpBytes[0] = 0;
    m_dlGtpEndpoint.teid = 0;
    m_dlGtpEndpoint.ip_addr.len = 0;
    m_dlGtpEndpoint.ip_addr.p_data = m_dlGtpIpBytes; // Always point to m_dlGtpIpBytes
    m_dlGtpIpBytes[0] = 0;
    m_summaryInfo.clear();
}

//------------------------------------------------------------------------------
inline void HighSeeOutput::setIpAddress(highsee_ip_address_t &ar_ip_in, uint16_t& ar_ip_len, uint8_t* ap_ip_addr)
{
    if ( ar_ip_in.len <= MAX_HS_ADDRESS_LENGTH)
    {
        ar_ip_len = ar_ip_in.len;
        memcpy(ap_ip_addr, ar_ip_in.p_data, ar_ip_in.len);
    }
    else
    {
        ar_ip_len = 0;
        ap_ip_addr[0] = 0;
    }
}

#endif	/* HIGHSEEOUTPUT_H */

