---
author: Carolyn King, Dianjin Wang 
title: Pulsar Summit Asia 2020 Schedule is Now Online
---

The Pulsar Summit is a global conference dedicated to sharing best practices, project updates, and insights across the Apache Pulsar community. Pulsar’s inaugural global summit, the [Pulsar Summit Virtual Conference 2020](https://pulsar-summit.org/en/event/virtual-conference-2020), took place in June 2020 and featured more than 30 sessions from top Pulsar experts, developers and thought-leaders from companies such as Salesforce, Verizon Media, and Splunk, and the conference attracted 600+ attendees. 

The rapid adoption of Apache Pulsar over the past few years has led to a high demand for Pulsar events. Today, StreamNative, a cloud-native event streaming company powered by Apache Pulsar, and also the host of [Pulsar Summit Asia 2020](https://pulsar-summit.org/en/event/asia-2020), announced more details on the upcoming event. Taking place on November 28th & 29th, the two-day event will feature more than 30 live sessions by tech leads, open-source developers, software engineers, and software architects from **Splunk, Yahoo! JAPAN, TIBCO, China Mobile, Tencent, Dada Group, KingSoft Cloud, Tuya Smart, and PingCAP**, and will include sessions on Pulsar use cases, its ecosystem, operations, and technology deep dives. 

See below for some of our featured sessions, which include both English and Mandarin tracks:
- [How Splunk is using Pulsar IO （English）](https://pulsar-summit.org/en/event/asia-2020/sessions/how-splunk-is-using-pulsar-io) - In this talk, Jerry Peng, Principal Software Engineer at Splunk will share insights on Splunk’s evaluation and decision to adopt the Pulsar IO framework, details on how Splunk's DSP product leverages the Pulsar IO framework, and insights on batch sources, a feature that was recently added to Pulsar IO.
- [Apache Pulsar at Yahoo! JAPAN - Adoption, Operational Insights and the Future（English）](https://pulsar-summit.org/en/event/asia-2020/sessions/apache–pulsar–at–yahoo–japan–adoption–operational–experiences–and–future) - In this talk, Nozomi Kurihara, Manager of the Messaging Platform team in Yahoo!Japan Corporation will share practical use cases of Apache Pulsar on production and insights on how to operate Apache Pulsar for large scale data streams.
- [Running Apache Pulsar on Tencent Cloud: New Challenges, Discussion, Practice (Mandarin)](https://pulsar-summit.org/en/event/asia-2020/sessions/running-apache-pulsar-on-tencent-cloud-new-challenges-discussion-practice) - In this talk, Lin Lin, senior engineer of Tencent Cloud will address how Pulsar helps solve challenges with message queues on Tencent Cloud, such as dynamic expansion and contraction, and large numbers of partitions.
- [How BIGO built a Real-Time Message System with Apache Pulsar and Flink (Mandarin) ](https://pulsar-summit.org/en/event/asia-2020/sessions/how-bigo-builds-real-time-message-system-with-apache-pulsar-and-flink) - In this talk, Hang Chen, Leader of the Messaging Platform team from BIGO will share how BIGO leveraged Apache Pulsar to build a real-time message system and how they tune Pulsar for production.
- [A Daredevil' Story: Apache Pulsar in Zhaopin.com (Mandarin)](https://pulsar-summit.org/en/event/asia-2020/sessions/a-daredevil-story-apache-pulsar-in-zhaopin-com) - In this talk, Shunli Gao, Senior Engineer at Zhaopin will share details on the development and future prospects of Apache Pulsar at Zhaopin.
- [Transactional Event Streaming with Apache Pulsar (Mandarin)](https://pulsar-summit.org/en/event/asia-2020/sessions/transactional-event-streaming-with-apache-pulsar) - In this talk, Bo Cong, software engineer at StreamNative will share how Pulsar transaction works and how it is supported by Pulsar Functions.
- [Benchmarking Pulsar vs. Kafka on AWS: Process & Results (Mandarin) ](https://pulsar-summit.org/en/event/asia-2020/sessions/benchmarking-pulsar-vs-kafka-on-aws-process-results) - In this talk, Penghui Li, the Apache Pulsar PMC member and software engineer at StreamNative will share the results of a benchmark test comparing Pulsar and Kafka that was run on AWS. The test ran Pulsar and Kafka under the same hardware environments on the write throughput, tailing read throughput, catchup read throughput, publish latency, and end-to-end latency of these two systems.

More featured talks coming soon!

The number and diversity of the sessions demonstrate the accelerated adoption of Pulsar in PoC and production environments, as well as the rapid development in functionalities and diverse ecosystems. To learn more about how companies leverage Pulsar for **messaging and event streaming, serverless computing, real-time analytics, event-driven applications, and mission-critical deployment management in production**, [RSVP](https://hopin.to/events/pulsar-summit-asia-2020) today!

We would like to say special thanks to the speakers for sharing their Pulsar expertise and experience with the community.


# About Apache Pulsar
[Apache Pulsar](https://pulsar.apache.org) is a cloud-native, distributed messaging and streaming platform that manages hundreds of billions of events per day. Pulsar was originally developed at Yahoo! as the unified messaging platform connecting critical Yahoo applications such as Yahoo Finance, Yahoo Mail, and Flickr to data. 

Today, Pulsar is used for real-time event streaming use cases, including data pipelines, microservices, and stream processing. Its cloud-native architecture and built-in multi-tenancy differentiate it from its predecessors and uniquely position it as an enterprise-ready, event streaming platform. Pulsar's multi-layer architecture enables stability, reliability, scalability, and high performance, simplifies management and reduces costs. Its built-in multi-tenancy and geo-replication ensure that companies are able to build applications with disaster recovery. 


# About StreamNative
[StreamNative](https://streamnative.io), founded by the original developers of Apache Pulsar and Apache BookKeeper, enables organizations to build the next generation of messaging and event streaming applications. Leveraging Apache Pulsar and BookKeeper, we optimize for scalability and resiliency while reducing the overhead management and complexity required by incumbent technologies. We do this by offering Pulsar and StreamNative’s ‘products as a service’. StreamNative is building a world-class team that is passionate about building amazing products and committed to customer success.
