---
author: Matteo Merli
title: Log4j2 Zero Day vulnerability (CVE-2021-44228)
---

Yesterday, a new serious vulnerability was reported regarding Log4j that can
allow remote execution for attackers.

The vulnerability issue is described and tracked under [CVE-2021-44228](https://nvd.nist.gov/vuln/detail/CVE-2021-44228).

Current releases of Apache Pulsar are bundling Log4j2 versions that are affected by this vulnerability.
Default configuration, combined with JVM version and other factors, can render it exploitable.
We strongly recommend to follow the advisory of the Apache Log4j community and patch your systems 
as soon as possible, as well as looking for unexpected behavior in your Pulsar logs.

There are 2 workarounds to patch a Pulsar deployments. You can set either of:

 1. Java property: `-Dlog4j2.formatMsgNoLookups=true`
 2. Environment variable: `LOG4J_FORMAT_MSG_NO_LOOKUPS=true`

Both approaches are effective in mitigating the vulnerability for Pulsar
services.

Additionally, when running Pulsar Functions with Kubernetes runtime, you should update
your Docker images, following the example described [here](https://github.com/lhotari/pulsar-docker-images-patch-CVE-2021-44228).

If you are using the Pulsar Helm Chart for deploying in Kubernetes, a [new
version of the chart](https://github.com/apache/pulsar-helm-chart/releases/tag/pulsar-2.7.6) is already available and it applies the above mentioned workaround.
If upgrading is not an option, you may also mitigate by adding `-Dlog4j2.formatMsgNoLookups=true` to the `PULSAR_EXTRA_OPTS` in the `configData` section for proxy, broker, bookkeeper, zookeeper, auto-recovery, and relative components in the helm values file.

We are already preparing new patch releases, 2.7.4, 2.8.2 and 2.9.1. These
releases will be ready in the next few days and will bundle the Log4j2 2.15.0,
which contains the vulnerability fix.
