---
id: version-2.7.0-helm-overview
title: Apache Pulsar Helm Chart
sidebar_label: Overview
original_id: helm-overview
---

This is the official supported Helm chart to install Apache Pulsar on a cloud-native environment. It was enhanced based on StreamNative's [Helm Chart](https://github.com/streamnative/charts).

## Introduction

The Apache Pulsar Helm chart is one of the most convenient ways to operate Pulsar on Kubernetes. This Pulsar Helm chart contains all the required components to get started and can scale to large deployments.

This chart includes all the components for a complete experience, but each part can be configured to be installed separately.

- Pulsar core components:
    - ZooKeeper
    - Bookies
    - Brokers
    - Function workers
    - Proxies
- Control Center:
    - Pulsar Manager
    - Prometheus
    - Grafana

It includes support for:

- Security
    - Automatically provisioned TLS certificates, using [Jetstack](https://www.jetstack.io/)'s [cert-manager](https://cert-manager.io/docs/)
        - self-signed
        - [Let's Encrypt](https://letsencrypt.org/)
    - TLS Encryption
        - Proxy
        - Broker
        - Toolset
        - Bookie
        - ZooKeeper
    - Authentication
        - JWT
    - Authorization
- Storage
    - Non-persistence storage
    - Persistence volume
    - Local persistent volumes
- Functions
    - Kubernetes Runtime
    - Process Runtime
    - Thread Runtime
- Operations
    - Independent image versions for all components, enabling controlled upgrades

## Pulsar Helm chart quick start

To get up and run with these charts as fast as possible, in a **non-production** use case, we provide a [quick start guide](getting-started-helm.md) for Proof of Concept (PoC) deployments.

This guide walks the user through deploying these charts with default values and features, but *does not* meet production ready requirements. To deploy these charts into production under sustained load, follow the complete [Installation Guide](helm-install.md).

## Troubleshooting

We have done our best to make these charts as seamless as possible. Occasionally, troubles do go outside of our control. We have collected tips and tricks for troubleshooting common issues. Please check them first before raising an [issue](https://github.com/apache/pulsar/issues/new/choose), and feel free to add to them by raising a [Pull Request](https://github.com/apache/pulsar/compare).

## Installation

The Apache Pulsar Helm chart contains all required dependencies.

If you deploy a PoC for testing, we strongly suggest you follow our [Quick Start Guide](getting-started-helm.md) for your first iteration.

1. [Preparation](helm-prepare.md)
2. [Deployment](helm-deploy.md)

## Upgrading

Once the Pulsar Helm chart is installed, use the `helm upgrade` to complete configuration changes and chart updates.

```bash
helm repo add apache https://pulsar.apache.org/charts
helm repo update
helm get values <pulsar-release-name> > pulsar.yaml
helm upgrade <pulsar-release-name> apache/pulsar -f pulsar.yaml
```

For more detailed information, see [Upgrading](helm-upgrade.md).

## Uninstallation

To uninstall the Pulsar Helm chart, run the following command:

```bash
helm delete <pulsar-release-name>
```

For the purposes of continuity, these charts have some Kubernetes objects that cannot be removed when performing `helm delete`.
It is recommended to *consciously* remove these items, as they affect re-deployment.

* PVCs for stateful data: *consciously* remove these items.
    - ZooKeeper: This is your metadata.
    - BookKeeper: This is your data.
    - Prometheus: This is your metrics data, which can be safely removed.
* Secrets: if the secrets are generated by the [prepare release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/prepare_helm_release.sh), they contain secret keys and tokens. You can use the [cleanup release script](https://github.com/apache/pulsar-helm-chart/blob/master/scripts/pulsar/cleanup_helm_release.sh) to remove these secrets and tokens as needed.
