###############################################################
# empirix-third-party-cpp-libs-runtime.spec
# RPM spec file for building the 3rd party rpm containing:
#  - static & shared libraries
#
# Author: Francesco Montorsi
# Date: Aug 19
#
###############################################################

# general info
#
Name: empirix-third-party-cpp-libs-runtime
Summary: Third Party libraries needed by DiagnostixCloud EvA/ECC
Group: Development
Version: %{RPM_VERSION}
Release: %{RPM_RELEASE}
License: Empirix
BuildRoot: %{THIRDPARTY_RPM_BUILDROOT}
Source: %{THIRDPARTY_RPM_BUILDROOT}
AutoReqProv: no   # RPM would detect some requirements like libc but would fail to understand they come from empirix-toolchain!

##########################################################################################################################################
%description
Third Party software needed by DiagnostixCloud EvA/ECC

##########################################################################################################################################
%install
mkdir -p                                               %{THIRDPARTY_RPM_BUILDROOT}/opt/empirix/third-party-cpp-libs/lib/x86_64-debug
mkdir -p                                               %{THIRDPARTY_RPM_BUILDROOT}/opt/empirix/third-party-cpp-libs/lib/x86_64-release

# install STATIC & DYNAMIC libraries for LINKING:
make -C %{THIRDPARTY_DIR} install_libs CFG=release    DESTDIR=%{THIRDPARTY_RPM_BUILDROOT}/opt/empirix/third-party-cpp-libs/lib/x86_64-release

# versioning is created by the -devel package only:
#    cp %{THIRDPARTY_DIR}/version                           %{THIRDPARTY_RPM_BUILDROOT}/opt/empirix/third-party-cpp-libs

##########################################################################################################################################
%post
# create a symlink that the user might be allowed to change for special debugging sessions
if [ ! -f /opt/empirix/third-party-cpp-libs/lib/x86_64 ]; then
	ln -sf /opt/empirix/third-party-cpp-libs/lib/x86_64-release     /opt/empirix/third-party-cpp-libs/lib/x86_64
fi

##########################################################################################################################################
%postun
if [ "$1" = "0" ] ; then
	#
	# UNINSTALLING
	#
	# get rid of the symlink
	rm -f /opt/empirix/third-party-cpp-libs/lib/x86_64
else
	#
	# UPGRADING
	#
	true			# NOP
fi


##########################################################################################################################################
%files
%defattr(-, root, root, 755)
/opt/empirix/*
