/* **************************************************************************
 * Copyright 2017-2018 Empirix, Inc.  All rights reserved.
 * -- Empirix Confidential
 *
 * @author: Ark M. Degtiarov (AMD) <adegtiarov@empirix.com>
 *
 * **************************************************************************/

#ifndef THIRD_PARTY_CPP_LIBS_FASTHASH_API_H_INCLUDED
#define THIRD_PARTY_CPP_LIBS_FASTHASH_API_H_INCLUDED

#include "fasthash.h"

namespace empirix
{
template <typename T> auto fasthash(const void* const buf, const size_t len) -> T
{
	T* crash = 0;
	// cppcheck-suppress nullPointer
	return *crash;
}

template <> inline auto fasthash<uint32_t>(const void* buf, size_t len) -> uint32_t
{
	return fasthash32(buf, len, 0xE9481AFCU);
}

template <> inline auto fasthash<uint64_t>(const void* buf, size_t len) -> uint64_t
{
	return fasthash64(buf, len, 0xA16231A7UL);
}
}

#endif /* THIRD_PARTY_CPP_LIBS_FASTHASH_API_H_INCLUDED */
