/* 
 * File:         IPacketInterface.h
 * Description:  IPacketInterface: interface  class for packet process
 *
 * (C) COPYRIGHT nTh s.r.l. 2015-2019. ALL RIGHTS RESERVED.
 * NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED REPRODUCED OR
 * TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR
 * WRITTEN CONSENT OF nTh s.r.l.
 */
#ifndef IPACKETINTERFACE_H
#define	IPACKETINTERFACE_H

#include <stddef.h>

#if __GNUC__ >= 4
    #define EXPORT_DLL_PUBLIC __attribute__ ((visibility ("default")))
    #define EXPORT_DLL_LOCAL  __attribute__ ((visibility ("hidden")))
#else
    #define EXPORT_DLL_PUBLIC
    #define EXPORT_DLL_LOCAL
#endif


class IPacketInterface
{
    
    public:
        IPacketInterface() { }
        virtual ~IPacketInterface() { }

        virtual bool initialize(int a_type, int a_param, char* a_arg, int a_index=0) = 0;

        virtual bool process(void* ap_packet, int a_type, void* ap_packout=NULL) = 0;
        
        virtual bool receive(void* ap_packet) = 0;
        
        virtual bool getStats(void* ap_stats) = 0;

        virtual bool release(void) = 0;

    private:
        IPacketInterface(const IPacketInterface&);              // Disabled copy constructor
        IPacketInterface& operator = (const IPacketInterface&); // Disabled assign operator  
        
};   

#endif	/* IPACKETINTERFACE_H */

