//
// h323_messages.h
//
// Code automatically generated by asnparser.
//

#ifndef __H323_MESSAGES_H
#define __H323_MESSAGES_H

#include <asn1.h>

#include "h235_security_messages.h"
#include "msc_t38faxprofile.h"


#include "hm_callidentifier.h"
#include "hm_transportaddress.h"
#include "hm_alternategk.h"
#include "hm_aliasaddress.h"
#include "hm_supportedprefix.h"
namespace H323_MESSAGES {

//
// StimulusControl
//

class StimulusControl : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    StimulusControl(const void* info) : Inherited(info) {}
  public:
    StimulusControl() : Inherited(&theInfo) {}
    StimulusControl(const StimulusControl & other) : Inherited(other)
    {}
    StimulusControl& operator = (const StimulusControl& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_isText,
      e_h248Message
    };

    class nonStandard {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class isText {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class isText
    isText::reference set_isText ();
    void omit_isText ();
    bool isText_isPresent () const;
    class h248Message {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h248Message
    h248Message::const_reference get_h248Message () const;
    h248Message::reference ref_h248Message ();
    h248Message::reference set_h248Message ();
    h248Message::reference set_h248Message (const std::vector<char>& value);
    void omit_h248Message ();
    bool h248Message_isPresent () const;
    void swap(StimulusControl& other);
    StimulusControl * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ScnConnectionType
//

class ScnConnectionType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ScnConnectionType(const void* info) : Inherited(info) {}
  public:
    ScnConnectionType() : Inherited(&theInfo) {}
    class unknown {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknown

    unknown::reference select_unknown (); 
    bool unknown_isSelected() const;

    class bChannel {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bChannel

    bChannel::reference select_bChannel (); 
    bool bChannel_isSelected() const;

    class hybrid2x64 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hybrid2x64

    hybrid2x64::reference select_hybrid2x64 (); 
    bool hybrid2x64_isSelected() const;

    class hybrid384 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hybrid384

    hybrid384::reference select_hybrid384 (); 
    bool hybrid384_isSelected() const;

    class hybrid1536 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hybrid1536

    hybrid1536::reference select_hybrid1536 (); 
    bool hybrid1536_isSelected() const;

    class hybrid1920 {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hybrid1920

    hybrid1920::reference select_hybrid1920 (); 
    bool hybrid1920_isSelected() const;

    class multirate {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multirate

    multirate::reference select_multirate (); 
    bool multirate_isSelected() const;

    ScnConnectionType(unknown::Id id, unknown::const_reference value);
    ScnConnectionType(bChannel::Id id, bChannel::const_reference value);
    ScnConnectionType(hybrid2x64::Id id, hybrid2x64::const_reference value);
    ScnConnectionType(hybrid384::Id id, hybrid384::const_reference value);
    ScnConnectionType(hybrid1536::Id id, hybrid1536::const_reference value);
    ScnConnectionType(hybrid1920::Id id, hybrid1920::const_reference value);
    ScnConnectionType(multirate::Id id, multirate::const_reference value);
    void swap(ScnConnectionType & other);
    ScnConnectionType(const ScnConnectionType & other)
    : Inherited(other) {} 

    ScnConnectionType & operator = (const ScnConnectionType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ScnConnectionType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[7];
#endif
};

//
// ScnConnectionAggregation
//

class ScnConnectionAggregation : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ScnConnectionAggregation(const void* info) : Inherited(info) {}
  public:
    ScnConnectionAggregation() : Inherited(&theInfo) {}
    class auto_ {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auto_

    auto_::reference select_auto (); 
    bool auto_isSelected() const;

    class none {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class none

    none::reference select_none (); 
    bool none_isSelected() const;

    class h221 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h221

    h221::reference select_h221 (); 
    bool h221_isSelected() const;

    class bonded_mode1 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bonded_mode1

    bonded_mode1::reference select_bonded_mode1 (); 
    bool bonded_mode1_isSelected() const;

    class bonded_mode2 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bonded_mode2

    bonded_mode2::reference select_bonded_mode2 (); 
    bool bonded_mode2_isSelected() const;

    class bonded_mode3 {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bonded_mode3

    bonded_mode3::reference select_bonded_mode3 (); 
    bool bonded_mode3_isSelected() const;

    ScnConnectionAggregation(auto_::Id id, auto_::const_reference value);
    ScnConnectionAggregation(none::Id id, none::const_reference value);
    ScnConnectionAggregation(h221::Id id, h221::const_reference value);
    ScnConnectionAggregation(bonded_mode1::Id id, bonded_mode1::const_reference value);
    ScnConnectionAggregation(bonded_mode2::Id id, bonded_mode2::const_reference value);
    ScnConnectionAggregation(bonded_mode3::Id id, bonded_mode3::const_reference value);
    void swap(ScnConnectionAggregation & other);
    ScnConnectionAggregation(const ScnConnectionAggregation & other)
    : Inherited(other) {} 

    ScnConnectionAggregation & operator = (const ScnConnectionAggregation & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ScnConnectionAggregation * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// PresentationIndicator
//

class PresentationIndicator : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    PresentationIndicator(const void* info) : Inherited(info) {}
  public:
    PresentationIndicator() : Inherited(&theInfo) {}
    class presentationAllowed {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationAllowed

    presentationAllowed::reference select_presentationAllowed (); 
    bool presentationAllowed_isSelected() const;

    class presentationRestricted {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationRestricted

    presentationRestricted::reference select_presentationRestricted (); 
    bool presentationRestricted_isSelected() const;

    class addressNotAvailable {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class addressNotAvailable

    addressNotAvailable::reference select_addressNotAvailable (); 
    bool addressNotAvailable_isSelected() const;

    PresentationIndicator(presentationAllowed::Id id, presentationAllowed::const_reference value);
    PresentationIndicator(presentationRestricted::Id id, presentationRestricted::const_reference value);
    PresentationIndicator(addressNotAvailable::Id id, addressNotAvailable::const_reference value);
    void swap(PresentationIndicator & other);
    PresentationIndicator(const PresentationIndicator & other)
    : Inherited(other) {} 

    PresentationIndicator & operator = (const PresentationIndicator & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    PresentationIndicator * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// ScreeningIndicator
//

class ScreeningIndicator : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    ScreeningIndicator(const void* info) : Inherited(info) {}
  public:
    ScreeningIndicator() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      userProvidedNotScreened,
      userProvidedVerifiedAndPassed,
      userProvidedVerifiedAndFailed,
      networkProvided
    };

    bool is_userProvidedNotScreened() const { return value == userProvidedNotScreened; }
    void set_userProvidedNotScreened() { value = userProvidedNotScreened; }

    bool is_userProvidedVerifiedAndPassed() const { return value == userProvidedVerifiedAndPassed; }
    void set_userProvidedVerifiedAndPassed() { value = userProvidedVerifiedAndPassed; }

    bool is_userProvidedVerifiedAndFailed() const { return value == userProvidedVerifiedAndFailed; }
    void set_userProvidedVerifiedAndFailed() { value = userProvidedVerifiedAndFailed; }

    bool is_networkProvided() const { return value == networkProvided; }
    void set_networkProvided() { value = networkProvided; }

    ScreeningIndicator(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    ScreeningIndicator & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (ScreeningIndicator & other)
    { ENUMERATED::swap(other); }
    ScreeningIndicator * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// FacilityReason
//

class FacilityReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FacilityReason(const void* info) : Inherited(info) {}
  public:
    FacilityReason() : Inherited(&theInfo) {}
    class routeCallToGatekeeper {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class routeCallToGatekeeper

    routeCallToGatekeeper::reference select_routeCallToGatekeeper (); 
    bool routeCallToGatekeeper_isSelected() const;

    class callForwarded {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callForwarded

    callForwarded::reference select_callForwarded (); 
    bool callForwarded_isSelected() const;

    class routeCallToMC {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class routeCallToMC

    routeCallToMC::reference select_routeCallToMC (); 
    bool routeCallToMC_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class conferenceListChoice {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceListChoice

    conferenceListChoice::reference select_conferenceListChoice (); 
    bool conferenceListChoice_isSelected() const;

    class startH245 {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class startH245

    startH245::reference select_startH245 (); 
    bool startH245_isSelected() const;

    class noH245 {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noH245

    noH245::reference select_noH245 (); 
    bool noH245_isSelected() const;

    class newTokens {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class newTokens

    newTokens::reference select_newTokens (); 
    bool newTokens_isSelected() const;

    class featureSetUpdate {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSetUpdate

    featureSetUpdate::reference select_featureSetUpdate (); 
    bool featureSetUpdate_isSelected() const;

    class forwardedElements {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardedElements

    forwardedElements::reference select_forwardedElements (); 
    bool forwardedElements_isSelected() const;

    class transportedInformation {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportedInformation

    transportedInformation::reference select_transportedInformation (); 
    bool transportedInformation_isSelected() const;

    FacilityReason(routeCallToGatekeeper::Id id, routeCallToGatekeeper::const_reference value);
    FacilityReason(callForwarded::Id id, callForwarded::const_reference value);
    FacilityReason(routeCallToMC::Id id, routeCallToMC::const_reference value);
    FacilityReason(undefinedReason::Id id, undefinedReason::const_reference value);
    FacilityReason(conferenceListChoice::Id id, conferenceListChoice::const_reference value);
    FacilityReason(startH245::Id id, startH245::const_reference value);
    FacilityReason(noH245::Id id, noH245::const_reference value);
    FacilityReason(newTokens::Id id, newTokens::const_reference value);
    FacilityReason(featureSetUpdate::Id id, featureSetUpdate::const_reference value);
    FacilityReason(forwardedElements::Id id, forwardedElements::const_reference value);
    FacilityReason(transportedInformation::Id id, transportedInformation::const_reference value);
    void swap(FacilityReason & other);
    FacilityReason(const FacilityReason & other)
    : Inherited(other) {} 

    FacilityReason & operator = (const FacilityReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FacilityReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[11];
#endif
};

//
// ExtendedAliasAddress
//

class ExtendedAliasAddress : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ExtendedAliasAddress(const void* info) : Inherited(info) {}
  public:
    ExtendedAliasAddress() : Inherited(&theInfo) {}
    ExtendedAliasAddress(const ExtendedAliasAddress & other) : Inherited(other)
    {}
    ExtendedAliasAddress& operator = (const ExtendedAliasAddress& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_presentationIndicator,
      e_screeningIndicator
    };

    class address {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class address
    address::const_reference get_address () const;
    address::reference ref_address ();
    address::reference set_address ();
    address::reference set_address (address::const_reference value);
    class presentationIndicator {
      public:
        typedef PresentationIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationIndicator
    presentationIndicator::const_reference get_presentationIndicator () const;
    presentationIndicator::reference ref_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator (presentationIndicator::const_reference value);
    void omit_presentationIndicator ();
    bool presentationIndicator_isPresent () const;
    class screeningIndicator {
      public:
        typedef ScreeningIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class screeningIndicator
    screeningIndicator::const_reference get_screeningIndicator () const;
    screeningIndicator::reference ref_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator (screeningIndicator::value_type::NamedNumber value);
    void omit_screeningIndicator ();
    bool screeningIndicator_isPresent () const;
    void swap(ExtendedAliasAddress& other);
    ExtendedAliasAddress * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// AlternateTransportAddresses
//

class AlternateTransportAddresses : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AlternateTransportAddresses(const void* info) : Inherited(info) {}
  public:
    AlternateTransportAddresses() : Inherited(&theInfo) {}
    AlternateTransportAddresses(const AlternateTransportAddresses & other) : Inherited(other)
    {}
    AlternateTransportAddresses& operator = (const AlternateTransportAddresses& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_annexE
    };

    class annexE {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class annexE
    annexE::const_reference get_annexE () const;
    annexE::reference ref_annexE ();
    annexE::reference set_annexE ();
    annexE::reference set_annexE (annexE::const_reference value);
    void omit_annexE ();
    bool annexE_isPresent () const;
    void swap(AlternateTransportAddresses& other);
    AlternateTransportAddresses * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// UseSpecifiedTransport
//

class UseSpecifiedTransport : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    UseSpecifiedTransport(const void* info) : Inherited(info) {}
  public:
    UseSpecifiedTransport() : Inherited(&theInfo) {}
    class tcp {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tcp

    tcp::reference select_tcp (); 
    bool tcp_isSelected() const;

    class annexE {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class annexE

    annexE::reference select_annexE (); 
    bool annexE_isSelected() const;

    UseSpecifiedTransport(tcp::Id id, tcp::const_reference value);
    UseSpecifiedTransport(annexE::Id id, annexE::const_reference value);
    void swap(UseSpecifiedTransport & other);
    UseSpecifiedTransport(const UseSpecifiedTransport & other)
    : Inherited(other) {} 

    UseSpecifiedTransport & operator = (const UseSpecifiedTransport & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    UseSpecifiedTransport * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// AltGKInfo
//

class AltGKInfo : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AltGKInfo(const void* info) : Inherited(info) {}
  public:
    AltGKInfo() : Inherited(&theInfo) {}
    AltGKInfo(const AltGKInfo & other) : Inherited(other)
    {}
    AltGKInfo& operator = (const AltGKInfo& other)
    { Inherited::operator = (other); return *this; } 
    class alternateGatekeeper {
      public:
        typedef ASN1::SEQUENCE_OF<AlternateGK>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateGatekeeper
    alternateGatekeeper::const_reference get_alternateGatekeeper () const;
    alternateGatekeeper::reference ref_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper (alternateGatekeeper::const_reference value);
    class altGKisPermanent {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKisPermanent
    altGKisPermanent::const_reference get_altGKisPermanent () const;
    altGKisPermanent::reference ref_altGKisPermanent ();
    altGKisPermanent::reference set_altGKisPermanent ();
    altGKisPermanent::reference set_altGKisPermanent (bool value);
    void swap(AltGKInfo& other);
    AltGKInfo * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// SecurityServiceMode
//

class SecurityServiceMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    SecurityServiceMode(const void* info) : Inherited(info) {}
  public:
    SecurityServiceMode() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class none {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class none

    none::reference select_none (); 
    bool none_isSelected() const;

    class default_ {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class default_

    default_::reference select_default (); 
    bool default_isSelected() const;

    SecurityServiceMode(nonStandard::Id id, nonStandard::const_reference value);
    SecurityServiceMode(none::Id id, none::const_reference value);
    SecurityServiceMode(default_::Id id, default_::const_reference value);
    void swap(SecurityServiceMode & other);
    SecurityServiceMode(const SecurityServiceMode & other)
    : Inherited(other) {} 

    SecurityServiceMode & operator = (const SecurityServiceMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    SecurityServiceMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// SecurityCapabilities
//

class SecurityCapabilities : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SecurityCapabilities(const void* info) : Inherited(info) {}
  public:
    SecurityCapabilities() : Inherited(&theInfo) {}
    SecurityCapabilities(const SecurityCapabilities & other) : Inherited(other)
    {}
    SecurityCapabilities& operator = (const SecurityCapabilities& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard
    };

    class nonStandard {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class encryption {
      public:
        typedef SecurityServiceMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryption
    encryption::const_reference get_encryption () const;
    encryption::reference ref_encryption ();
    encryption::reference set_encryption ();
    encryption::reference set_encryption (encryption::const_reference value);
    class authenticaton {
      public:
        typedef SecurityServiceMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class authenticaton
    authenticaton::const_reference get_authenticaton () const;
    authenticaton::reference ref_authenticaton ();
    authenticaton::reference set_authenticaton ();
    authenticaton::reference set_authenticaton (authenticaton::const_reference value);
    class integrity {
      public:
        typedef SecurityServiceMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrity
    integrity::const_reference get_integrity () const;
    integrity::reference ref_integrity ();
    integrity::reference set_integrity ();
    integrity::reference set_integrity (integrity::const_reference value);
    void swap(SecurityCapabilities& other);
    SecurityCapabilities * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// H245Security
//

class H245Security : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H245Security(const void* info) : Inherited(info) {}
  public:
    H245Security() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class noSecurity {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noSecurity

    noSecurity::reference select_noSecurity (); 
    bool noSecurity_isSelected() const;

    class tls {
      public:
        enum Id { id_ = 2 };
        typedef SecurityCapabilities value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tls

    tls::const_reference get_tls () const;
    tls::reference ref_tls (); 
    tls::reference select_tls (); 
    tls::reference select_tls (tls::const_reference value); 
    bool tls_isSelected() const;

    class ipsec {
      public:
        enum Id { id_ = 3 };
        typedef SecurityCapabilities value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ipsec

    ipsec::const_reference get_ipsec () const;
    ipsec::reference ref_ipsec (); 
    ipsec::reference select_ipsec (); 
    ipsec::reference select_ipsec (ipsec::const_reference value); 
    bool ipsec_isSelected() const;

    H245Security(nonStandard::Id id, nonStandard::const_reference value);
    H245Security(noSecurity::Id id, noSecurity::const_reference value);
    H245Security(tls::Id id, tls::const_reference value);
    H245Security(ipsec::Id id, ipsec::const_reference value);
    void swap(H245Security & other);
    H245Security(const H245Security & other)
    : Inherited(other) {} 

    H245Security & operator = (const H245Security & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H245Security * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// Q954Details
//

class Q954Details : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Q954Details(const void* info) : Inherited(info) {}
  public:
    Q954Details() : Inherited(&theInfo) {}
    Q954Details(const Q954Details & other) : Inherited(other)
    {}
    Q954Details& operator = (const Q954Details& other)
    { Inherited::operator = (other); return *this; } 
    class conferenceCalling {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceCalling
    conferenceCalling::const_reference get_conferenceCalling () const;
    conferenceCalling::reference ref_conferenceCalling ();
    conferenceCalling::reference set_conferenceCalling ();
    conferenceCalling::reference set_conferenceCalling (bool value);
    class threePartyService {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class threePartyService
    threePartyService::const_reference get_threePartyService () const;
    threePartyService::reference ref_threePartyService ();
    threePartyService::reference set_threePartyService ();
    threePartyService::reference set_threePartyService (bool value);
    void swap(Q954Details& other);
    Q954Details * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef GloballyUniqueID ConferenceIdentifier;
typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  RequestSeqNum;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  CallReferenceValue;

//
// EndpointIdentifier
//

class EndpointIdentifier : public ASN1::BMPString
{
    typedef ASN1::BMPString Inherited;
  protected:
    EndpointIdentifier(const void* info) : Inherited(info) {}
  public:
    EndpointIdentifier() : Inherited(&theInfo) { }
    EndpointIdentifier(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    EndpointIdentifier(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
    EndpointIdentifier(const EndpointIdentifier& other) : Inherited(other) {}
    EndpointIdentifier& operator = (std::wstring& other)
    { Inherited::operator=(other); return *this;}
    EndpointIdentifier& operator = (const wchar_t* other)
    { Inherited::operator=(other); return *this;}
    EndpointIdentifier * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::OBJECT_IDENTIFIER ProtocolIdentifier;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  TimeToLive;

typedef ASN1::OCTET_STRING H248PackagesDescriptor;

typedef ASN1::OCTET_STRING H248SignalsDescriptor;

//
// EncryptIntAlg
//

class EncryptIntAlg : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EncryptIntAlg(const void* info) : Inherited(info) {}
  public:
    EncryptIntAlg() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class isoAlgorithm {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class isoAlgorithm

    isoAlgorithm::const_reference get_isoAlgorithm () const;
    isoAlgorithm::reference ref_isoAlgorithm (); 
    isoAlgorithm::reference select_isoAlgorithm (); 
    isoAlgorithm::reference select_isoAlgorithm (isoAlgorithm::const_reference value); 
    bool isoAlgorithm_isSelected() const;

    EncryptIntAlg(nonStandard::Id id, nonStandard::const_reference value);
    EncryptIntAlg(isoAlgorithm::Id id, isoAlgorithm::const_reference value);
    void swap(EncryptIntAlg & other);
    EncryptIntAlg(const EncryptIntAlg & other)
    : Inherited(other) {} 

    EncryptIntAlg & operator = (const EncryptIntAlg & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EncryptIntAlg * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// NonIsoIntegrityMechanism
//

class NonIsoIntegrityMechanism : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NonIsoIntegrityMechanism(const void* info) : Inherited(info) {}
  public:
    NonIsoIntegrityMechanism() : Inherited(&theInfo) {}
    class hMAC_MD5 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hMAC_MD5

    hMAC_MD5::reference select_hMAC_MD5 (); 
    bool hMAC_MD5_isSelected() const;

    class hMAC_iso10118_2_s {
      public:
        enum Id { id_ = 1 };
        typedef EncryptIntAlg value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hMAC_iso10118_2_s

    hMAC_iso10118_2_s::const_reference get_hMAC_iso10118_2_s () const;
    hMAC_iso10118_2_s::reference ref_hMAC_iso10118_2_s (); 
    hMAC_iso10118_2_s::reference select_hMAC_iso10118_2_s (); 
    hMAC_iso10118_2_s::reference select_hMAC_iso10118_2_s (hMAC_iso10118_2_s::const_reference value); 
    bool hMAC_iso10118_2_s_isSelected() const;

    class hMAC_iso10118_2_l {
      public:
        enum Id { id_ = 2 };
        typedef EncryptIntAlg value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hMAC_iso10118_2_l

    hMAC_iso10118_2_l::const_reference get_hMAC_iso10118_2_l () const;
    hMAC_iso10118_2_l::reference ref_hMAC_iso10118_2_l (); 
    hMAC_iso10118_2_l::reference select_hMAC_iso10118_2_l (); 
    hMAC_iso10118_2_l::reference select_hMAC_iso10118_2_l (hMAC_iso10118_2_l::const_reference value); 
    bool hMAC_iso10118_2_l_isSelected() const;

    class hMAC_iso10118_3 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hMAC_iso10118_3

    hMAC_iso10118_3::const_reference get_hMAC_iso10118_3 () const;
    hMAC_iso10118_3::reference ref_hMAC_iso10118_3 (); 
    hMAC_iso10118_3::reference select_hMAC_iso10118_3 (); 
    hMAC_iso10118_3::reference select_hMAC_iso10118_3 (hMAC_iso10118_3::const_reference value); 
    bool hMAC_iso10118_3_isSelected() const;

    NonIsoIntegrityMechanism(hMAC_MD5::Id id, hMAC_MD5::const_reference value);
    NonIsoIntegrityMechanism(hMAC_iso10118_2_s::Id id, hMAC_iso10118_2_s::const_reference value);
    NonIsoIntegrityMechanism(hMAC_iso10118_2_l::Id id, hMAC_iso10118_2_l::const_reference value);
    NonIsoIntegrityMechanism(hMAC_iso10118_3::Id id, hMAC_iso10118_3::const_reference value);
    void swap(NonIsoIntegrityMechanism & other);
    NonIsoIntegrityMechanism(const NonIsoIntegrityMechanism & other)
    : Inherited(other) {} 

    NonIsoIntegrityMechanism & operator = (const NonIsoIntegrityMechanism & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NonIsoIntegrityMechanism * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// IntegrityMechanism
//

class IntegrityMechanism : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IntegrityMechanism(const void* info) : Inherited(info) {}
  public:
    IntegrityMechanism() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class digSig {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digSig

    digSig::reference select_digSig (); 
    bool digSig_isSelected() const;

    class iso9797 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class iso9797

    iso9797::const_reference get_iso9797 () const;
    iso9797::reference ref_iso9797 (); 
    iso9797::reference select_iso9797 (); 
    iso9797::reference select_iso9797 (iso9797::const_reference value); 
    bool iso9797_isSelected() const;

    class nonIsoIM {
      public:
        enum Id { id_ = 3 };
        typedef NonIsoIntegrityMechanism value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonIsoIM

    nonIsoIM::const_reference get_nonIsoIM () const;
    nonIsoIM::reference ref_nonIsoIM (); 
    nonIsoIM::reference select_nonIsoIM (); 
    nonIsoIM::reference select_nonIsoIM (nonIsoIM::const_reference value); 
    bool nonIsoIM_isSelected() const;

    IntegrityMechanism(nonStandard::Id id, nonStandard::const_reference value);
    IntegrityMechanism(digSig::Id id, digSig::const_reference value);
    IntegrityMechanism(iso9797::Id id, iso9797::const_reference value);
    IntegrityMechanism(nonIsoIM::Id id, nonIsoIM::const_reference value);
    void swap(IntegrityMechanism & other);
    IntegrityMechanism(const IntegrityMechanism & other)
    : Inherited(other) {} 

    IntegrityMechanism & operator = (const IntegrityMechanism & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IntegrityMechanism * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// ICV
//

class ICV : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ICV(const void* info) : Inherited(info) {}
  public:
    ICV() : Inherited(&theInfo) {}
    ICV(const ICV & other) : Inherited(other)
    {}
    ICV& operator = (const ICV& other)
    { Inherited::operator = (other); return *this; } 
    class algorithmOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOID
    algorithmOID::const_reference get_algorithmOID () const;
    algorithmOID::reference ref_algorithmOID ();
    algorithmOID::reference set_algorithmOID ();
    algorithmOID::reference set_algorithmOID (algorithmOID::const_reference value);
    class icv {
      public:
        typedef ASN1::BIT_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class icv
    icv::const_reference get_icv () const;
    icv::reference ref_icv ();
    icv::reference set_icv ();
    icv::reference set_icv (icv::const_reference value);
    void swap(ICV& other);
    ICV * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// FastStartToken
//

class FastStartToken : public H235_SECURITY_MESSAGES::ClearToken
{
    typedef H235_SECURITY_MESSAGES::ClearToken Inherited;
  protected:
    FastStartToken(const void* info) : Inherited(info) {}
  public:
    FastStartToken() : Inherited(&theInfo) {}
    FastStartToken(const FastStartToken& other) : Inherited(other) {}
    FastStartToken * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::Constrained_OpenData<FastStartToken>  EncodedFastStartToken;

//
// CallLinkage
//

class CallLinkage : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallLinkage(const void* info) : Inherited(info) {}
  public:
    CallLinkage() : Inherited(&theInfo) {}
    CallLinkage(const CallLinkage & other) : Inherited(other)
    {}
    CallLinkage& operator = (const CallLinkage& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_globalCallId,
      e_threadId
    };

    class globalCallId {
      public:
        typedef GloballyUniqueID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class globalCallId
    globalCallId::const_reference get_globalCallId () const;
    globalCallId::reference ref_globalCallId ();
    globalCallId::reference set_globalCallId ();
    globalCallId::reference set_globalCallId (globalCallId::const_reference value);
    void omit_globalCallId ();
    bool globalCallId_isPresent () const;
    class threadId {
      public:
        typedef GloballyUniqueID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class threadId
    threadId::const_reference get_threadId () const;
    threadId::reference ref_threadId ();
    threadId::reference set_threadId ();
    threadId::reference set_threadId (threadId::const_reference value);
    void omit_threadId ();
    bool threadId_isPresent () const;
    void swap(CallLinkage& other);
    CallLinkage * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CapacityReportingCapability
//

class CapacityReportingCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CapacityReportingCapability(const void* info) : Inherited(info) {}
  public:
    CapacityReportingCapability() : Inherited(&theInfo) {}
    CapacityReportingCapability(const CapacityReportingCapability & other) : Inherited(other)
    {}
    CapacityReportingCapability& operator = (const CapacityReportingCapability& other)
    { Inherited::operator = (other); return *this; } 
    class canReportCallCapacity {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canReportCallCapacity
    canReportCallCapacity::const_reference get_canReportCallCapacity () const;
    canReportCallCapacity::reference ref_canReportCallCapacity ();
    canReportCallCapacity::reference set_canReportCallCapacity ();
    canReportCallCapacity::reference set_canReportCallCapacity (bool value);
    void swap(CapacityReportingCapability& other);
    CapacityReportingCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CallsAvailable
//

class CallsAvailable : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallsAvailable(const void* info) : Inherited(info) {}
  public:
    CallsAvailable() : Inherited(&theInfo) {}
    CallsAvailable(const CallsAvailable & other) : Inherited(other)
    {}
    CallsAvailable& operator = (const CallsAvailable& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_group
    };

    class calls {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class calls
    calls::const_reference get_calls () const;
    calls::reference ref_calls ();
    calls::reference set_calls ();
    calls::reference set_calls (calls::value_type::int_type value);
    class group {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class group
    group::const_reference get_group () const;
    group::reference ref_group ();
    group::reference set_group ();
    group::reference set_group (const std::string& value);
    void omit_group ();
    bool group_isPresent () const;
    void swap(CallsAvailable& other);
    CallsAvailable * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RasUsageInfoTypes
//

class RasUsageInfoTypes : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RasUsageInfoTypes(const void* info) : Inherited(info) {}
  public:
    RasUsageInfoTypes() : Inherited(&theInfo) {}
    RasUsageInfoTypes(const RasUsageInfoTypes & other) : Inherited(other)
    {}
    RasUsageInfoTypes& operator = (const RasUsageInfoTypes& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_startTime,
      e_endTime,
      e_terminationCause
    };

    class nonStandardUsageTypes {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardUsageTypes
    nonStandardUsageTypes::const_reference get_nonStandardUsageTypes () const;
    nonStandardUsageTypes::reference ref_nonStandardUsageTypes ();
    nonStandardUsageTypes::reference set_nonStandardUsageTypes ();
    nonStandardUsageTypes::reference set_nonStandardUsageTypes (nonStandardUsageTypes::const_reference value);
    class startTime {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class startTime
    startTime::reference set_startTime ();
    void omit_startTime ();
    bool startTime_isPresent () const;
    class endTime {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endTime
    endTime::reference set_endTime ();
    void omit_endTime ();
    bool endTime_isPresent () const;
    class terminationCause {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationCause
    terminationCause::reference set_terminationCause ();
    void omit_terminationCause ();
    bool terminationCause_isPresent () const;
    void swap(RasUsageInfoTypes& other);
    RasUsageInfoTypes * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// RasUsageInformation
//

class RasUsageInformation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RasUsageInformation(const void* info) : Inherited(info) {}
  public:
    RasUsageInformation() : Inherited(&theInfo) {}
    RasUsageInformation(const RasUsageInformation & other) : Inherited(other)
    {}
    RasUsageInformation& operator = (const RasUsageInformation& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_alertingTime,
      e_connectTime,
      e_endTime
    };

    class nonStandardUsageFields {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardUsageFields
    nonStandardUsageFields::const_reference get_nonStandardUsageFields () const;
    nonStandardUsageFields::reference ref_nonStandardUsageFields ();
    nonStandardUsageFields::reference set_nonStandardUsageFields ();
    nonStandardUsageFields::reference set_nonStandardUsageFields (nonStandardUsageFields::const_reference value);
    class alertingTime {
      public:
        typedef H235_SECURITY_MESSAGES::TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alertingTime
    alertingTime::const_reference get_alertingTime () const;
    alertingTime::reference ref_alertingTime ();
    alertingTime::reference set_alertingTime ();
    alertingTime::reference set_alertingTime (alertingTime::const_reference value);
    void omit_alertingTime ();
    bool alertingTime_isPresent () const;
    class connectTime {
      public:
        typedef H235_SECURITY_MESSAGES::TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectTime
    connectTime::const_reference get_connectTime () const;
    connectTime::reference ref_connectTime ();
    connectTime::reference set_connectTime ();
    connectTime::reference set_connectTime (connectTime::const_reference value);
    void omit_connectTime ();
    bool connectTime_isPresent () const;
    class endTime {
      public:
        typedef H235_SECURITY_MESSAGES::TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endTime
    endTime::const_reference get_endTime () const;
    endTime::reference ref_endTime ();
    endTime::reference set_endTime ();
    endTime::reference set_endTime (endTime::const_reference value);
    void omit_endTime ();
    bool endTime_isPresent () const;
    void swap(RasUsageInformation& other);
    RasUsageInformation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// CallCreditCapability
//

class CallCreditCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallCreditCapability(const void* info) : Inherited(info) {}
  public:
    CallCreditCapability() : Inherited(&theInfo) {}
    CallCreditCapability(const CallCreditCapability & other) : Inherited(other)
    {}
    CallCreditCapability& operator = (const CallCreditCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_canDisplayAmountString,
      e_canEnforceDurationLimit
    };

    class canDisplayAmountString {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canDisplayAmountString
    canDisplayAmountString::const_reference get_canDisplayAmountString () const;
    canDisplayAmountString::reference ref_canDisplayAmountString ();
    canDisplayAmountString::reference set_canDisplayAmountString ();
    canDisplayAmountString::reference set_canDisplayAmountString (bool value);
    void omit_canDisplayAmountString ();
    bool canDisplayAmountString_isPresent () const;
    class canEnforceDurationLimit {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canEnforceDurationLimit
    canEnforceDurationLimit::const_reference get_canEnforceDurationLimit () const;
    canEnforceDurationLimit::reference ref_canEnforceDurationLimit ();
    canEnforceDurationLimit::reference set_canEnforceDurationLimit ();
    canEnforceDurationLimit::reference set_canEnforceDurationLimit (bool value);
    void omit_canEnforceDurationLimit ();
    bool canEnforceDurationLimit_isPresent () const;
    void swap(CallCreditCapability& other);
    CallCreditCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// GenericIdentifier
//

class GenericIdentifier : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    GenericIdentifier(const void* info) : Inherited(info) {}
  public:
    GenericIdentifier() : Inherited(&theInfo) {}
    class standard {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::ExtendableConstraint, 0, 16383>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class standard

    standard::const_reference get_standard () const;
    standard::reference ref_standard (); 
    standard::reference select_standard (); 
    standard::reference select_standard (standard::value_type::int_type value); 
    bool standard_isSelected() const;

    class oid {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class oid

    oid::const_reference get_oid () const;
    oid::reference ref_oid (); 
    oid::reference select_oid (); 
    oid::reference select_oid (oid::const_reference value); 
    bool oid_isSelected() const;

    class nonStandard {
      public:
        enum Id { id_ = 2 };
        typedef GloballyUniqueID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    GenericIdentifier(standard::Id id, standard::value_type::int_type value);
    GenericIdentifier(oid::Id id, oid::const_reference value);
    GenericIdentifier(nonStandard::Id id, nonStandard::const_reference value);
    void swap(GenericIdentifier & other);
    GenericIdentifier(const GenericIdentifier & other)
    : Inherited(other) {} 

    GenericIdentifier & operator = (const GenericIdentifier & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    GenericIdentifier * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// EnumeratedParameter
//

class Content;

class EnumeratedParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EnumeratedParameter(const void* info) : Inherited(info) {}
  public:
    EnumeratedParameter() : Inherited(&theInfo) {}
    EnumeratedParameter(const EnumeratedParameter & other) : Inherited(other)
    {}
    EnumeratedParameter& operator = (const EnumeratedParameter& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_content
    };

    class id {
      public:
        typedef GenericIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class id
    id::const_reference get_id () const;
    id::reference ref_id ();
    id::reference set_id ();
    id::reference set_id (id::const_reference value);
    class content {
      public:
        typedef Content value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class content
    content::const_reference get_content () const;
    content::reference ref_content ();
    content::reference set_content ();
    content::reference set_content (content::const_reference value);
    void omit_content ();
    bool content_isPresent () const;
    void swap(EnumeratedParameter& other);
    EnumeratedParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TransportChannelInfo
//

class TransportChannelInfo : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransportChannelInfo(const void* info) : Inherited(info) {}
  public:
    TransportChannelInfo() : Inherited(&theInfo) {}
    TransportChannelInfo(const TransportChannelInfo & other) : Inherited(other)
    {}
    TransportChannelInfo& operator = (const TransportChannelInfo& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_sendAddress,
      e_recvAddress
    };

    class sendAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendAddress
    sendAddress::const_reference get_sendAddress () const;
    sendAddress::reference ref_sendAddress ();
    sendAddress::reference set_sendAddress ();
    sendAddress::reference set_sendAddress (sendAddress::const_reference value);
    void omit_sendAddress ();
    bool sendAddress_isPresent () const;
    class recvAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class recvAddress
    recvAddress::const_reference get_recvAddress () const;
    recvAddress::reference ref_recvAddress ();
    recvAddress::reference set_recvAddress ();
    recvAddress::reference set_recvAddress (recvAddress::const_reference value);
    void omit_recvAddress ();
    bool recvAddress_isPresent () const;
    void swap(TransportChannelInfo& other);
    TransportChannelInfo * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// GatekeeperRejectReason
//

class GatekeeperRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    GatekeeperRejectReason(const void* info) : Inherited(info) {}
  public:
    GatekeeperRejectReason() : Inherited(&theInfo) {}
    class resourceUnavailable {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceUnavailable

    resourceUnavailable::reference select_resourceUnavailable (); 
    bool resourceUnavailable_isSelected() const;

    class terminalExcluded {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalExcluded

    terminalExcluded::reference select_terminalExcluded (); 
    bool terminalExcluded_isSelected() const;

    class invalidRevision {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidRevision

    invalidRevision::reference select_invalidRevision (); 
    bool invalidRevision_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class genericDataReason {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataReason

    genericDataReason::reference select_genericDataReason (); 
    bool genericDataReason_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    GatekeeperRejectReason(resourceUnavailable::Id id, resourceUnavailable::const_reference value);
    GatekeeperRejectReason(terminalExcluded::Id id, terminalExcluded::const_reference value);
    GatekeeperRejectReason(invalidRevision::Id id, invalidRevision::const_reference value);
    GatekeeperRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    GatekeeperRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    GatekeeperRejectReason(genericDataReason::Id id, genericDataReason::const_reference value);
    GatekeeperRejectReason(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    void swap(GatekeeperRejectReason & other);
    GatekeeperRejectReason(const GatekeeperRejectReason & other)
    : Inherited(other) {} 

    GatekeeperRejectReason & operator = (const GatekeeperRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    GatekeeperRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[7];
#endif
};

//
// UnregRequestReason
//

class UnregRequestReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    UnregRequestReason(const void* info) : Inherited(info) {}
  public:
    UnregRequestReason() : Inherited(&theInfo) {}
    class reregistrationRequired {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reregistrationRequired

    reregistrationRequired::reference select_reregistrationRequired (); 
    bool reregistrationRequired_isSelected() const;

    class ttlExpired {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ttlExpired

    ttlExpired::reference select_ttlExpired (); 
    bool ttlExpired_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class maintenance {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintenance

    maintenance::reference select_maintenance (); 
    bool maintenance_isSelected() const;

    UnregRequestReason(reregistrationRequired::Id id, reregistrationRequired::const_reference value);
    UnregRequestReason(ttlExpired::Id id, ttlExpired::const_reference value);
    UnregRequestReason(securityDenial::Id id, securityDenial::const_reference value);
    UnregRequestReason(undefinedReason::Id id, undefinedReason::const_reference value);
    UnregRequestReason(maintenance::Id id, maintenance::const_reference value);
    void swap(UnregRequestReason & other);
    UnregRequestReason(const UnregRequestReason & other)
    : Inherited(other) {} 

    UnregRequestReason & operator = (const UnregRequestReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    UnregRequestReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// UnregRejectReason
//

class UnregRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    UnregRejectReason(const void* info) : Inherited(info) {}
  public:
    UnregRejectReason() : Inherited(&theInfo) {}
    class notCurrentlyRegistered {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notCurrentlyRegistered

    notCurrentlyRegistered::reference select_notCurrentlyRegistered (); 
    bool notCurrentlyRegistered_isSelected() const;

    class callInProgress {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callInProgress

    callInProgress::reference select_callInProgress (); 
    bool callInProgress_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class permissionDenied {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class permissionDenied

    permissionDenied::reference select_permissionDenied (); 
    bool permissionDenied_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    UnregRejectReason(notCurrentlyRegistered::Id id, notCurrentlyRegistered::const_reference value);
    UnregRejectReason(callInProgress::Id id, callInProgress::const_reference value);
    UnregRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    UnregRejectReason(permissionDenied::Id id, permissionDenied::const_reference value);
    UnregRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    void swap(UnregRejectReason & other);
    UnregRejectReason(const UnregRejectReason & other)
    : Inherited(other) {} 

    UnregRejectReason & operator = (const UnregRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    UnregRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// CallType
//

class CallType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CallType(const void* info) : Inherited(info) {}
  public:
    CallType() : Inherited(&theInfo) {}
    class pointToPoint {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pointToPoint

    pointToPoint::reference select_pointToPoint (); 
    bool pointToPoint_isSelected() const;

    class oneToN {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class oneToN

    oneToN::reference select_oneToN (); 
    bool oneToN_isSelected() const;

    class nToOne {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nToOne

    nToOne::reference select_nToOne (); 
    bool nToOne_isSelected() const;

    class nToN {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nToN

    nToN::reference select_nToN (); 
    bool nToN_isSelected() const;

    CallType(pointToPoint::Id id, pointToPoint::const_reference value);
    CallType(oneToN::Id id, oneToN::const_reference value);
    CallType(nToOne::Id id, nToOne::const_reference value);
    CallType(nToN::Id id, nToN::const_reference value);
    void swap(CallType & other);
    CallType(const CallType & other)
    : Inherited(other) {} 

    CallType & operator = (const CallType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CallType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// CallModel
//

class CallModel : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CallModel(const void* info) : Inherited(info) {}
  public:
    CallModel() : Inherited(&theInfo) {}
    class direct {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class direct

    direct::reference select_direct (); 
    bool direct_isSelected() const;

    class gatekeeperRouted {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperRouted

    gatekeeperRouted::reference select_gatekeeperRouted (); 
    bool gatekeeperRouted_isSelected() const;

    CallModel(direct::Id id, direct::const_reference value);
    CallModel(gatekeeperRouted::Id id, gatekeeperRouted::const_reference value);
    void swap(CallModel & other);
    CallModel(const CallModel & other)
    : Inherited(other) {} 

    CallModel & operator = (const CallModel & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CallModel * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// TransportQOS
//

class TransportQOS : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    TransportQOS(const void* info) : Inherited(info) {}
  public:
    TransportQOS() : Inherited(&theInfo) {}
    class endpointControlled {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointControlled

    endpointControlled::reference select_endpointControlled (); 
    bool endpointControlled_isSelected() const;

    class gatekeeperControlled {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperControlled

    gatekeeperControlled::reference select_gatekeeperControlled (); 
    bool gatekeeperControlled_isSelected() const;

    class noControl {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noControl

    noControl::reference select_noControl (); 
    bool noControl_isSelected() const;

    TransportQOS(endpointControlled::Id id, endpointControlled::const_reference value);
    TransportQOS(gatekeeperControlled::Id id, gatekeeperControlled::const_reference value);
    TransportQOS(noControl::Id id, noControl::const_reference value);
    void swap(TransportQOS & other);
    TransportQOS(const TransportQOS & other)
    : Inherited(other) {} 

    TransportQOS & operator = (const TransportQOS & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    TransportQOS * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// UUIEsRequested
//

class UUIEsRequested : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UUIEsRequested(const void* info) : Inherited(info) {}
  public:
    UUIEsRequested() : Inherited(&theInfo) {}
    UUIEsRequested(const UUIEsRequested & other) : Inherited(other)
    {}
    UUIEsRequested& operator = (const UUIEsRequested& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_status,
      e_statusInquiry,
      e_setupAcknowledge,
      e_notify
    };

    class setup {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class setup
    setup::const_reference get_setup () const;
    setup::reference ref_setup ();
    setup::reference set_setup ();
    setup::reference set_setup (bool value);
    class callProceeding {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callProceeding
    callProceeding::const_reference get_callProceeding () const;
    callProceeding::reference ref_callProceeding ();
    callProceeding::reference set_callProceeding ();
    callProceeding::reference set_callProceeding (bool value);
    class connect {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connect
    connect::const_reference get_connect () const;
    connect::reference ref_connect ();
    connect::reference set_connect ();
    connect::reference set_connect (bool value);
    class alerting {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alerting
    alerting::const_reference get_alerting () const;
    alerting::reference ref_alerting ();
    alerting::reference set_alerting ();
    alerting::reference set_alerting (bool value);
    class information {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class information
    information::const_reference get_information () const;
    information::reference ref_information ();
    information::reference set_information ();
    information::reference set_information (bool value);
    class releaseComplete {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class releaseComplete
    releaseComplete::const_reference get_releaseComplete () const;
    releaseComplete::reference ref_releaseComplete ();
    releaseComplete::reference set_releaseComplete ();
    releaseComplete::reference set_releaseComplete (bool value);
    class facility {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class facility
    facility::const_reference get_facility () const;
    facility::reference ref_facility ();
    facility::reference set_facility ();
    facility::reference set_facility (bool value);
    class progress {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class progress
    progress::const_reference get_progress () const;
    progress::reference ref_progress ();
    progress::reference set_progress ();
    progress::reference set_progress (bool value);
    class empty {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class empty
    empty::const_reference get_empty () const;
    empty::reference ref_empty ();
    empty::reference set_empty ();
    empty::reference set_empty (bool value);
    class status {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class status
    status::const_reference get_status () const;
    status::reference ref_status ();
    status::reference set_status ();
    status::reference set_status (bool value);
    void omit_status ();
    bool status_isPresent () const;
    class statusInquiry {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statusInquiry
    statusInquiry::const_reference get_statusInquiry () const;
    statusInquiry::reference ref_statusInquiry ();
    statusInquiry::reference set_statusInquiry ();
    statusInquiry::reference set_statusInquiry (bool value);
    void omit_statusInquiry ();
    bool statusInquiry_isPresent () const;
    class setupAcknowledge {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class setupAcknowledge
    setupAcknowledge::const_reference get_setupAcknowledge () const;
    setupAcknowledge::reference ref_setupAcknowledge ();
    setupAcknowledge::reference set_setupAcknowledge ();
    setupAcknowledge::reference set_setupAcknowledge (bool value);
    void omit_setupAcknowledge ();
    bool setupAcknowledge_isPresent () const;
    class notify {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notify
    notify::const_reference get_notify () const;
    notify::reference ref_notify ();
    notify::reference set_notify ();
    notify::reference set_notify (bool value);
    void omit_notify ();
    bool notify_isPresent () const;
    void swap(UUIEsRequested& other);
    UUIEsRequested * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[13];
    static int fieldIds[13];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[13];
#endif
};

//
// AdmissionRejectReason
//

class AdmissionRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AdmissionRejectReason(const void* info) : Inherited(info) {}
  public:
    AdmissionRejectReason() : Inherited(&theInfo) {}
    class calledPartyNotRegistered {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class calledPartyNotRegistered

    calledPartyNotRegistered::reference select_calledPartyNotRegistered (); 
    bool calledPartyNotRegistered_isSelected() const;

    class invalidPermission {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidPermission

    invalidPermission::reference select_invalidPermission (); 
    bool invalidPermission_isSelected() const;

    class requestDenied {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestDenied

    requestDenied::reference select_requestDenied (); 
    bool requestDenied_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class callerNotRegistered {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callerNotRegistered

    callerNotRegistered::reference select_callerNotRegistered (); 
    bool callerNotRegistered_isSelected() const;

    class routeCallToGatekeeper {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class routeCallToGatekeeper

    routeCallToGatekeeper::reference select_routeCallToGatekeeper (); 
    bool routeCallToGatekeeper_isSelected() const;

    class invalidEndpointIdentifier {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidEndpointIdentifier

    invalidEndpointIdentifier::reference select_invalidEndpointIdentifier (); 
    bool invalidEndpointIdentifier_isSelected() const;

    class resourceUnavailable {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceUnavailable

    resourceUnavailable::reference select_resourceUnavailable (); 
    bool resourceUnavailable_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class qosControlNotSupported {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qosControlNotSupported

    qosControlNotSupported::reference select_qosControlNotSupported (); 
    bool qosControlNotSupported_isSelected() const;

    class incompleteAddress {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class incompleteAddress

    incompleteAddress::reference select_incompleteAddress (); 
    bool incompleteAddress_isSelected() const;

    class aliasesInconsistent {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aliasesInconsistent

    aliasesInconsistent::reference select_aliasesInconsistent (); 
    bool aliasesInconsistent_isSelected() const;

    class routeCallToSCN {
      public:
        enum Id { id_ = 12 };
        typedef ASN1::SEQUENCE_OF<PartyNumber>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class routeCallToSCN

    routeCallToSCN::const_reference get_routeCallToSCN () const;
    routeCallToSCN::reference ref_routeCallToSCN (); 
    routeCallToSCN::reference select_routeCallToSCN (); 
    routeCallToSCN::reference select_routeCallToSCN (routeCallToSCN::const_reference value); 
    bool routeCallToSCN_isSelected() const;

    class exceedsCallCapacity {
      public:
        enum Id { id_ = 13 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class exceedsCallCapacity

    exceedsCallCapacity::reference select_exceedsCallCapacity (); 
    bool exceedsCallCapacity_isSelected() const;

    class collectDestination {
      public:
        enum Id { id_ = 14 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class collectDestination

    collectDestination::reference select_collectDestination (); 
    bool collectDestination_isSelected() const;

    class collectPIN {
      public:
        enum Id { id_ = 15 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class collectPIN

    collectPIN::reference select_collectPIN (); 
    bool collectPIN_isSelected() const;

    class genericDataReason {
      public:
        enum Id { id_ = 16 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataReason

    genericDataReason::reference select_genericDataReason (); 
    bool genericDataReason_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 17 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    AdmissionRejectReason(calledPartyNotRegistered::Id id, calledPartyNotRegistered::const_reference value);
    AdmissionRejectReason(invalidPermission::Id id, invalidPermission::const_reference value);
    AdmissionRejectReason(requestDenied::Id id, requestDenied::const_reference value);
    AdmissionRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    AdmissionRejectReason(callerNotRegistered::Id id, callerNotRegistered::const_reference value);
    AdmissionRejectReason(routeCallToGatekeeper::Id id, routeCallToGatekeeper::const_reference value);
    AdmissionRejectReason(invalidEndpointIdentifier::Id id, invalidEndpointIdentifier::const_reference value);
    AdmissionRejectReason(resourceUnavailable::Id id, resourceUnavailable::const_reference value);
    AdmissionRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    AdmissionRejectReason(qosControlNotSupported::Id id, qosControlNotSupported::const_reference value);
    AdmissionRejectReason(incompleteAddress::Id id, incompleteAddress::const_reference value);
    AdmissionRejectReason(aliasesInconsistent::Id id, aliasesInconsistent::const_reference value);
    AdmissionRejectReason(routeCallToSCN::Id id, routeCallToSCN::const_reference value);
    AdmissionRejectReason(exceedsCallCapacity::Id id, exceedsCallCapacity::const_reference value);
    AdmissionRejectReason(collectDestination::Id id, collectDestination::const_reference value);
    AdmissionRejectReason(collectPIN::Id id, collectPIN::const_reference value);
    AdmissionRejectReason(genericDataReason::Id id, genericDataReason::const_reference value);
    AdmissionRejectReason(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    void swap(AdmissionRejectReason & other);
    AdmissionRejectReason(const AdmissionRejectReason & other)
    : Inherited(other) {} 

    AdmissionRejectReason & operator = (const AdmissionRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AdmissionRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[18];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[18];
#endif
};

//
// BandRejectReason
//

class BandRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    BandRejectReason(const void* info) : Inherited(info) {}
  public:
    BandRejectReason() : Inherited(&theInfo) {}
    class notBound {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notBound

    notBound::reference select_notBound (); 
    bool notBound_isSelected() const;

    class invalidConferenceID {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidConferenceID

    invalidConferenceID::reference select_invalidConferenceID (); 
    bool invalidConferenceID_isSelected() const;

    class invalidPermission {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidPermission

    invalidPermission::reference select_invalidPermission (); 
    bool invalidPermission_isSelected() const;

    class insufficientResources {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class insufficientResources

    insufficientResources::reference select_insufficientResources (); 
    bool insufficientResources_isSelected() const;

    class invalidRevision {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidRevision

    invalidRevision::reference select_invalidRevision (); 
    bool invalidRevision_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    BandRejectReason(notBound::Id id, notBound::const_reference value);
    BandRejectReason(invalidConferenceID::Id id, invalidConferenceID::const_reference value);
    BandRejectReason(invalidPermission::Id id, invalidPermission::const_reference value);
    BandRejectReason(insufficientResources::Id id, insufficientResources::const_reference value);
    BandRejectReason(invalidRevision::Id id, invalidRevision::const_reference value);
    BandRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    BandRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    void swap(BandRejectReason & other);
    BandRejectReason(const BandRejectReason & other)
    : Inherited(other) {} 

    BandRejectReason & operator = (const BandRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    BandRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[7];
#endif
};

//
// LocationRejectReason
//

class LocationRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    LocationRejectReason(const void* info) : Inherited(info) {}
  public:
    LocationRejectReason() : Inherited(&theInfo) {}
    class notRegistered {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notRegistered

    notRegistered::reference select_notRegistered (); 
    bool notRegistered_isSelected() const;

    class invalidPermission {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidPermission

    invalidPermission::reference select_invalidPermission (); 
    bool invalidPermission_isSelected() const;

    class requestDenied {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestDenied

    requestDenied::reference select_requestDenied (); 
    bool requestDenied_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class aliasesInconsistent {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aliasesInconsistent

    aliasesInconsistent::reference select_aliasesInconsistent (); 
    bool aliasesInconsistent_isSelected() const;

    class routeCalltoSCN {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::SEQUENCE_OF<PartyNumber>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class routeCalltoSCN

    routeCalltoSCN::const_reference get_routeCalltoSCN () const;
    routeCalltoSCN::reference ref_routeCalltoSCN (); 
    routeCalltoSCN::reference select_routeCalltoSCN (); 
    routeCalltoSCN::reference select_routeCalltoSCN (routeCalltoSCN::const_reference value); 
    bool routeCalltoSCN_isSelected() const;

    class resourceUnavailable {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceUnavailable

    resourceUnavailable::reference select_resourceUnavailable (); 
    bool resourceUnavailable_isSelected() const;

    class genericDataReason {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataReason

    genericDataReason::reference select_genericDataReason (); 
    bool genericDataReason_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    class hopCountExceeded {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hopCountExceeded

    hopCountExceeded::reference select_hopCountExceeded (); 
    bool hopCountExceeded_isSelected() const;

    class incompleteAddress {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class incompleteAddress

    incompleteAddress::reference select_incompleteAddress (); 
    bool incompleteAddress_isSelected() const;

    LocationRejectReason(notRegistered::Id id, notRegistered::const_reference value);
    LocationRejectReason(invalidPermission::Id id, invalidPermission::const_reference value);
    LocationRejectReason(requestDenied::Id id, requestDenied::const_reference value);
    LocationRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    LocationRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    LocationRejectReason(aliasesInconsistent::Id id, aliasesInconsistent::const_reference value);
    LocationRejectReason(routeCalltoSCN::Id id, routeCalltoSCN::const_reference value);
    LocationRejectReason(resourceUnavailable::Id id, resourceUnavailable::const_reference value);
    LocationRejectReason(genericDataReason::Id id, genericDataReason::const_reference value);
    LocationRejectReason(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    LocationRejectReason(hopCountExceeded::Id id, hopCountExceeded::const_reference value);
    LocationRejectReason(incompleteAddress::Id id, incompleteAddress::const_reference value);
    void swap(LocationRejectReason & other);
    LocationRejectReason(const LocationRejectReason & other)
    : Inherited(other) {} 

    LocationRejectReason & operator = (const LocationRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    LocationRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[12];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[12];
#endif
};

//
// DisengageReason
//

class DisengageReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DisengageReason(const void* info) : Inherited(info) {}
  public:
    DisengageReason() : Inherited(&theInfo) {}
    class forcedDrop {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forcedDrop

    forcedDrop::reference select_forcedDrop (); 
    bool forcedDrop_isSelected() const;

    class normalDrop {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class normalDrop

    normalDrop::reference select_normalDrop (); 
    bool normalDrop_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    DisengageReason(forcedDrop::Id id, forcedDrop::const_reference value);
    DisengageReason(normalDrop::Id id, normalDrop::const_reference value);
    DisengageReason(undefinedReason::Id id, undefinedReason::const_reference value);
    void swap(DisengageReason & other);
    DisengageReason(const DisengageReason & other)
    : Inherited(other) {} 

    DisengageReason & operator = (const DisengageReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DisengageReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// DisengageRejectReason
//

class DisengageRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DisengageRejectReason(const void* info) : Inherited(info) {}
  public:
    DisengageRejectReason() : Inherited(&theInfo) {}
    class notRegistered {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notRegistered

    notRegistered::reference select_notRegistered (); 
    bool notRegistered_isSelected() const;

    class requestToDropOther {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestToDropOther

    requestToDropOther::reference select_requestToDropOther (); 
    bool requestToDropOther_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    DisengageRejectReason(notRegistered::Id id, notRegistered::const_reference value);
    DisengageRejectReason(requestToDropOther::Id id, requestToDropOther::const_reference value);
    DisengageRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    void swap(DisengageRejectReason & other);
    DisengageRejectReason(const DisengageRejectReason & other)
    : Inherited(other) {} 

    DisengageRejectReason & operator = (const DisengageRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DisengageRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// InfoRequestResponseStatus
//

class InfoRequestResponseStatus : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    InfoRequestResponseStatus(const void* info) : Inherited(info) {}
  public:
    InfoRequestResponseStatus() : Inherited(&theInfo) {}
    class complete {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class complete

    complete::reference select_complete (); 
    bool complete_isSelected() const;

    class incomplete {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class incomplete

    incomplete::reference select_incomplete (); 
    bool incomplete_isSelected() const;

    class segment {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class segment

    segment::const_reference get_segment () const;
    segment::reference ref_segment (); 
    segment::reference select_segment (); 
    segment::reference select_segment (segment::value_type::int_type value); 
    bool segment_isSelected() const;

    class invalidCall {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidCall

    invalidCall::reference select_invalidCall (); 
    bool invalidCall_isSelected() const;

    InfoRequestResponseStatus(complete::Id id, complete::const_reference value);
    InfoRequestResponseStatus(incomplete::Id id, incomplete::const_reference value);
    InfoRequestResponseStatus(segment::Id id, segment::value_type::int_type value);
    InfoRequestResponseStatus(invalidCall::Id id, invalidCall::const_reference value);
    void swap(InfoRequestResponseStatus & other);
    InfoRequestResponseStatus(const InfoRequestResponseStatus & other)
    : Inherited(other) {} 

    InfoRequestResponseStatus & operator = (const InfoRequestResponseStatus & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    InfoRequestResponseStatus * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// InfoRequestNakReason
//

class InfoRequestNakReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    InfoRequestNakReason(const void* info) : Inherited(info) {}
  public:
    InfoRequestNakReason() : Inherited(&theInfo) {}
    class notRegistered {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notRegistered

    notRegistered::reference select_notRegistered (); 
    bool notRegistered_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    InfoRequestNakReason(notRegistered::Id id, notRegistered::const_reference value);
    InfoRequestNakReason(securityDenial::Id id, securityDenial::const_reference value);
    InfoRequestNakReason(undefinedReason::Id id, undefinedReason::const_reference value);
    void swap(InfoRequestNakReason & other);
    InfoRequestNakReason(const InfoRequestNakReason & other)
    : Inherited(other) {} 

    InfoRequestNakReason & operator = (const InfoRequestNakReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    InfoRequestNakReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H323_UserInformation_user_data
//

class H323_UserInformation_user_data : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H323_UserInformation_user_data(const void* info) : Inherited(info) {}
  public:
    H323_UserInformation_user_data() : Inherited(&theInfo) {}
    H323_UserInformation_user_data(const H323_UserInformation_user_data & other) : Inherited(other)
    {}
    H323_UserInformation_user_data& operator = (const H323_UserInformation_user_data& other)
    { Inherited::operator = (other); return *this; } 
    class protocol_discriminator {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocol_discriminator
    protocol_discriminator::const_reference get_protocol_discriminator () const;
    protocol_discriminator::reference ref_protocol_discriminator ();
    protocol_discriminator::reference set_protocol_discriminator ();
    protocol_discriminator::reference set_protocol_discriminator (protocol_discriminator::value_type::int_type value);
    class user_information {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 131> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class user_information
    user_information::const_reference get_user_information () const;
    user_information::reference ref_user_information ();
    user_information::reference set_user_information ();
    user_information::reference set_user_information (const std::vector<char>& value);
    void swap(H323_UserInformation_user_data& other);
    H323_UserInformation_user_data * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H323_UU_PDU_tunnelledSignallingMessage
//

class H323_UU_PDU_tunnelledSignallingMessage : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H323_UU_PDU_tunnelledSignallingMessage(const void* info) : Inherited(info) {}
  public:
    H323_UU_PDU_tunnelledSignallingMessage() : Inherited(&theInfo) {}
    H323_UU_PDU_tunnelledSignallingMessage(const H323_UU_PDU_tunnelledSignallingMessage & other) : Inherited(other)
    {}
    H323_UU_PDU_tunnelledSignallingMessage& operator = (const H323_UU_PDU_tunnelledSignallingMessage& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tunnellingRequired,
      e_nonStandardData
    };

    class tunnelledProtocolID {
      public:
        typedef TunnelledProtocol value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tunnelledProtocolID
    tunnelledProtocolID::const_reference get_tunnelledProtocolID () const;
    tunnelledProtocolID::reference ref_tunnelledProtocolID ();
    tunnelledProtocolID::reference set_tunnelledProtocolID ();
    tunnelledProtocolID::reference set_tunnelledProtocolID (tunnelledProtocolID::const_reference value);
    class messageContent {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class messageContent
    messageContent::const_reference get_messageContent () const;
    messageContent::reference ref_messageContent ();
    messageContent::reference set_messageContent ();
    messageContent::reference set_messageContent (messageContent::const_reference value);
    class tunnellingRequired {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tunnellingRequired
    tunnellingRequired::reference set_tunnellingRequired ();
    void omit_tunnellingRequired ();
    bool tunnellingRequired_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    void swap(H323_UU_PDU_tunnelledSignallingMessage& other);
    H323_UU_PDU_tunnelledSignallingMessage * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// Setup_UUIE_conferenceGoal
//

class Setup_UUIE_conferenceGoal : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Setup_UUIE_conferenceGoal(const void* info) : Inherited(info) {}
  public:
    Setup_UUIE_conferenceGoal() : Inherited(&theInfo) {}
    class create {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class create

    create::reference select_create (); 
    bool create_isSelected() const;

    class join {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class join

    join::reference select_join (); 
    bool join_isSelected() const;

    class invite {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invite

    invite::reference select_invite (); 
    bool invite_isSelected() const;

    class capability_negotiation {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capability_negotiation

    capability_negotiation::reference select_capability_negotiation (); 
    bool capability_negotiation_isSelected() const;

    class callIndependentSupplementaryService {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIndependentSupplementaryService

    callIndependentSupplementaryService::reference select_callIndependentSupplementaryService (); 
    bool callIndependentSupplementaryService_isSelected() const;

    Setup_UUIE_conferenceGoal(create::Id id, create::const_reference value);
    Setup_UUIE_conferenceGoal(join::Id id, join::const_reference value);
    Setup_UUIE_conferenceGoal(invite::Id id, invite::const_reference value);
    Setup_UUIE_conferenceGoal(capability_negotiation::Id id, capability_negotiation::const_reference value);
    Setup_UUIE_conferenceGoal(callIndependentSupplementaryService::Id id, callIndependentSupplementaryService::const_reference value);
    void swap(Setup_UUIE_conferenceGoal & other);
    Setup_UUIE_conferenceGoal(const Setup_UUIE_conferenceGoal & other)
    : Inherited(other) {} 

    Setup_UUIE_conferenceGoal & operator = (const Setup_UUIE_conferenceGoal & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Setup_UUIE_conferenceGoal * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// Setup_UUIE_connectionParameters
//

class Setup_UUIE_connectionParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Setup_UUIE_connectionParameters(const void* info) : Inherited(info) {}
  public:
    Setup_UUIE_connectionParameters() : Inherited(&theInfo) {}
    Setup_UUIE_connectionParameters(const Setup_UUIE_connectionParameters & other) : Inherited(other)
    {}
    Setup_UUIE_connectionParameters& operator = (const Setup_UUIE_connectionParameters& other)
    { Inherited::operator = (other); return *this; } 
    class connectionType {
      public:
        typedef ScnConnectionType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionType
    connectionType::const_reference get_connectionType () const;
    connectionType::reference ref_connectionType ();
    connectionType::reference set_connectionType ();
    connectionType::reference set_connectionType (connectionType::const_reference value);
    class numberOfScnConnections {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfScnConnections
    numberOfScnConnections::const_reference get_numberOfScnConnections () const;
    numberOfScnConnections::reference ref_numberOfScnConnections ();
    numberOfScnConnections::reference set_numberOfScnConnections ();
    numberOfScnConnections::reference set_numberOfScnConnections (numberOfScnConnections::value_type::int_type value);
    class connectionAggregation {
      public:
        typedef ScnConnectionAggregation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionAggregation
    connectionAggregation::const_reference get_connectionAggregation () const;
    connectionAggregation::reference ref_connectionAggregation ();
    connectionAggregation::reference set_connectionAggregation ();
    connectionAggregation::reference set_connectionAggregation (connectionAggregation::const_reference value);
    void swap(Setup_UUIE_connectionParameters& other);
    Setup_UUIE_connectionParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// AddressPattern_range
//

class AddressPattern_range : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AddressPattern_range(const void* info) : Inherited(info) {}
  public:
    AddressPattern_range() : Inherited(&theInfo) {}
    AddressPattern_range(const AddressPattern_range & other) : Inherited(other)
    {}
    AddressPattern_range& operator = (const AddressPattern_range& other)
    { Inherited::operator = (other); return *this; } 
    class startOfRange {
      public:
        typedef PartyNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class startOfRange
    startOfRange::const_reference get_startOfRange () const;
    startOfRange::reference ref_startOfRange ();
    startOfRange::reference set_startOfRange ();
    startOfRange::reference set_startOfRange (startOfRange::const_reference value);
    class endOfRange {
      public:
        typedef PartyNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endOfRange
    endOfRange::const_reference get_endOfRange () const;
    endOfRange::reference ref_endOfRange ();
    endOfRange::reference set_endOfRange ();
    endOfRange::reference set_endOfRange (endOfRange::const_reference value);
    void swap(AddressPattern_range& other);
    AddressPattern_range * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CryptoH323Token_cryptoEPPwdHash
//

class CryptoH323Token_cryptoEPPwdHash : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CryptoH323Token_cryptoEPPwdHash(const void* info) : Inherited(info) {}
  public:
    CryptoH323Token_cryptoEPPwdHash() : Inherited(&theInfo) {}
    CryptoH323Token_cryptoEPPwdHash(const CryptoH323Token_cryptoEPPwdHash & other) : Inherited(other)
    {}
    CryptoH323Token_cryptoEPPwdHash& operator = (const CryptoH323Token_cryptoEPPwdHash& other)
    { Inherited::operator = (other); return *this; } 
    class alias {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alias
    alias::const_reference get_alias () const;
    alias::reference ref_alias ();
    alias::reference set_alias ();
    alias::reference set_alias (alias::const_reference value);
    class timeStamp {
      public:
        typedef H235_SECURITY_MESSAGES::TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeStamp
    timeStamp::const_reference get_timeStamp () const;
    timeStamp::reference ref_timeStamp ();
    timeStamp::reference set_timeStamp ();
    timeStamp::reference set_timeStamp (timeStamp::const_reference value);
    class token {
      public:
        typedef H235_SECURITY_MESSAGES::HASHED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class token
    token::const_reference get_token () const;
    token::reference ref_token ();
    token::reference set_token ();
    token::reference set_token (token::const_reference value);
    void swap(CryptoH323Token_cryptoEPPwdHash& other);
    CryptoH323Token_cryptoEPPwdHash * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CryptoH323Token_cryptoGKPwdHash
//

class CryptoH323Token_cryptoGKPwdHash : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CryptoH323Token_cryptoGKPwdHash(const void* info) : Inherited(info) {}
  public:
    CryptoH323Token_cryptoGKPwdHash() : Inherited(&theInfo) {}
    CryptoH323Token_cryptoGKPwdHash(const CryptoH323Token_cryptoGKPwdHash & other) : Inherited(other)
    {}
    CryptoH323Token_cryptoGKPwdHash& operator = (const CryptoH323Token_cryptoGKPwdHash& other)
    { Inherited::operator = (other); return *this; } 
    class gatekeeperId {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperId
    gatekeeperId::const_reference get_gatekeeperId () const;
    gatekeeperId::reference ref_gatekeeperId ();
    gatekeeperId::reference set_gatekeeperId ();
    gatekeeperId::reference set_gatekeeperId (gatekeeperId::const_reference value);
    class timeStamp {
      public:
        typedef H235_SECURITY_MESSAGES::TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeStamp
    timeStamp::const_reference get_timeStamp () const;
    timeStamp::reference ref_timeStamp ();
    timeStamp::reference set_timeStamp ();
    timeStamp::reference set_timeStamp (timeStamp::const_reference value);
    class token {
      public:
        typedef H235_SECURITY_MESSAGES::HASHED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class token
    token::const_reference get_token () const;
    token::reference ref_token ();
    token::reference set_token ();
    token::reference set_token (token::const_reference value);
    void swap(CryptoH323Token_cryptoGKPwdHash& other);
    CryptoH323Token_cryptoGKPwdHash * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CapacityReportingSpecification_when
//

class CapacityReportingSpecification_when : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CapacityReportingSpecification_when(const void* info) : Inherited(info) {}
  public:
    CapacityReportingSpecification_when() : Inherited(&theInfo) {}
    CapacityReportingSpecification_when(const CapacityReportingSpecification_when & other) : Inherited(other)
    {}
    CapacityReportingSpecification_when& operator = (const CapacityReportingSpecification_when& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_callStart,
      e_callEnd
    };

    class callStart {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callStart
    callStart::reference set_callStart ();
    void omit_callStart ();
    bool callStart_isPresent () const;
    class callEnd {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callEnd
    callEnd::reference set_callEnd ();
    void omit_callEnd ();
    bool callEnd_isPresent () const;
    void swap(CapacityReportingSpecification_when& other);
    CapacityReportingSpecification_when * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 4> > >  CicInfo_cic;

typedef ASN1::SEQUENCE_OF<ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535> >  GroupID_member;

//
// ServiceControlSession_reason
//

class ServiceControlSession_reason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ServiceControlSession_reason(const void* info) : Inherited(info) {}
  public:
    ServiceControlSession_reason() : Inherited(&theInfo) {}
    class open {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class open

    open::reference select_open (); 
    bool open_isSelected() const;

    class refresh {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class refresh

    refresh::reference select_refresh (); 
    bool refresh_isSelected() const;

    class close {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class close

    close::reference select_close (); 
    bool close_isSelected() const;

    ServiceControlSession_reason(open::Id id, open::const_reference value);
    ServiceControlSession_reason(refresh::Id id, refresh::const_reference value);
    ServiceControlSession_reason(close::Id id, close::const_reference value);
    void swap(ServiceControlSession_reason & other);
    ServiceControlSession_reason(const ServiceControlSession_reason & other)
    : Inherited(other) {} 

    ServiceControlSession_reason & operator = (const ServiceControlSession_reason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ServiceControlSession_reason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// RasUsageSpecification_when
//

class RasUsageSpecification_when : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RasUsageSpecification_when(const void* info) : Inherited(info) {}
  public:
    RasUsageSpecification_when() : Inherited(&theInfo) {}
    RasUsageSpecification_when(const RasUsageSpecification_when & other) : Inherited(other)
    {}
    RasUsageSpecification_when& operator = (const RasUsageSpecification_when& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_start,
      e_end,
      e_inIrr
    };

    class start {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class start
    start::reference set_start ();
    void omit_start ();
    bool start_isPresent () const;
    class end {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class end
    end::reference set_end ();
    void omit_end ();
    bool end_isPresent () const;
    class inIrr {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class inIrr
    inIrr::reference set_inIrr ();
    void omit_inIrr ();
    bool inIrr_isPresent () const;
    void swap(RasUsageSpecification_when& other);
    RasUsageSpecification_when * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RasUsageSpecification_callStartingPoint
//

class RasUsageSpecification_callStartingPoint : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RasUsageSpecification_callStartingPoint(const void* info) : Inherited(info) {}
  public:
    RasUsageSpecification_callStartingPoint() : Inherited(&theInfo) {}
    RasUsageSpecification_callStartingPoint(const RasUsageSpecification_callStartingPoint & other) : Inherited(other)
    {}
    RasUsageSpecification_callStartingPoint& operator = (const RasUsageSpecification_callStartingPoint& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_alerting,
      e_connect
    };

    class alerting {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alerting
    alerting::reference set_alerting ();
    void omit_alerting ();
    bool alerting_isPresent () const;
    class connect {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connect
    connect::reference set_connect ();
    void omit_connect ();
    bool connect_isPresent () const;
    void swap(RasUsageSpecification_callStartingPoint& other);
    RasUsageSpecification_callStartingPoint * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CallCreditServiceControl_billingMode
//

class CallCreditServiceControl_billingMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CallCreditServiceControl_billingMode(const void* info) : Inherited(info) {}
  public:
    CallCreditServiceControl_billingMode() : Inherited(&theInfo) {}
    class credit {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class credit

    credit::reference select_credit (); 
    bool credit_isSelected() const;

    class debit {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class debit

    debit::reference select_debit (); 
    bool debit_isSelected() const;

    CallCreditServiceControl_billingMode(credit::Id id, credit::const_reference value);
    CallCreditServiceControl_billingMode(debit::Id id, debit::const_reference value);
    void swap(CallCreditServiceControl_billingMode & other);
    CallCreditServiceControl_billingMode(const CallCreditServiceControl_billingMode & other)
    : Inherited(other) {} 

    CallCreditServiceControl_billingMode & operator = (const CallCreditServiceControl_billingMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CallCreditServiceControl_billingMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CallCreditServiceControl_callStartingPoint
//

class CallCreditServiceControl_callStartingPoint : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CallCreditServiceControl_callStartingPoint(const void* info) : Inherited(info) {}
  public:
    CallCreditServiceControl_callStartingPoint() : Inherited(&theInfo) {}
    class alerting {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alerting

    alerting::reference select_alerting (); 
    bool alerting_isSelected() const;

    class connect {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connect

    connect::reference select_connect (); 
    bool connect_isSelected() const;

    CallCreditServiceControl_callStartingPoint(alerting::Id id, alerting::const_reference value);
    CallCreditServiceControl_callStartingPoint(connect::Id id, connect::const_reference value);
    void swap(CallCreditServiceControl_callStartingPoint & other);
    CallCreditServiceControl_callStartingPoint(const CallCreditServiceControl_callStartingPoint & other)
    : Inherited(other) {} 

    CallCreditServiceControl_callStartingPoint & operator = (const CallCreditServiceControl_callStartingPoint & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CallCreditServiceControl_callStartingPoint * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255> >  RTPSession_associatedSessionIds;

//
// RegistrationConfirm_preGrantedARQ
//

class RegistrationConfirm_preGrantedARQ : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RegistrationConfirm_preGrantedARQ(const void* info) : Inherited(info) {}
  public:
    RegistrationConfirm_preGrantedARQ() : Inherited(&theInfo) {}
    RegistrationConfirm_preGrantedARQ(const RegistrationConfirm_preGrantedARQ & other) : Inherited(other)
    {}
    RegistrationConfirm_preGrantedARQ& operator = (const RegistrationConfirm_preGrantedARQ& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_irrFrequencyInCall,
      e_totalBandwidthRestriction,
      e_alternateTransportAddresses,
      e_useSpecifiedTransport
    };

    class makeCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeCall
    makeCall::const_reference get_makeCall () const;
    makeCall::reference ref_makeCall ();
    makeCall::reference set_makeCall ();
    makeCall::reference set_makeCall (bool value);
    class useGKCallSignalAddressToMakeCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class useGKCallSignalAddressToMakeCall
    useGKCallSignalAddressToMakeCall::const_reference get_useGKCallSignalAddressToMakeCall () const;
    useGKCallSignalAddressToMakeCall::reference ref_useGKCallSignalAddressToMakeCall ();
    useGKCallSignalAddressToMakeCall::reference set_useGKCallSignalAddressToMakeCall ();
    useGKCallSignalAddressToMakeCall::reference set_useGKCallSignalAddressToMakeCall (bool value);
    class answerCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class answerCall
    answerCall::const_reference get_answerCall () const;
    answerCall::reference ref_answerCall ();
    answerCall::reference set_answerCall ();
    answerCall::reference set_answerCall (bool value);
    class useGKCallSignalAddressToAnswer {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class useGKCallSignalAddressToAnswer
    useGKCallSignalAddressToAnswer::const_reference get_useGKCallSignalAddressToAnswer () const;
    useGKCallSignalAddressToAnswer::reference ref_useGKCallSignalAddressToAnswer ();
    useGKCallSignalAddressToAnswer::reference set_useGKCallSignalAddressToAnswer ();
    useGKCallSignalAddressToAnswer::reference set_useGKCallSignalAddressToAnswer (bool value);
    class irrFrequencyInCall {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class irrFrequencyInCall
    irrFrequencyInCall::const_reference get_irrFrequencyInCall () const;
    irrFrequencyInCall::reference ref_irrFrequencyInCall ();
    irrFrequencyInCall::reference set_irrFrequencyInCall ();
    irrFrequencyInCall::reference set_irrFrequencyInCall (irrFrequencyInCall::value_type::int_type value);
    void omit_irrFrequencyInCall ();
    bool irrFrequencyInCall_isPresent () const;
    class totalBandwidthRestriction {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class totalBandwidthRestriction
    totalBandwidthRestriction::const_reference get_totalBandwidthRestriction () const;
    totalBandwidthRestriction::reference ref_totalBandwidthRestriction ();
    totalBandwidthRestriction::reference set_totalBandwidthRestriction ();
    totalBandwidthRestriction::reference set_totalBandwidthRestriction (totalBandwidthRestriction::const_reference value);
    void omit_totalBandwidthRestriction ();
    bool totalBandwidthRestriction_isPresent () const;
    class alternateTransportAddresses {
      public:
        typedef AlternateTransportAddresses value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateTransportAddresses
    alternateTransportAddresses::const_reference get_alternateTransportAddresses () const;
    alternateTransportAddresses::reference ref_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses (alternateTransportAddresses::const_reference value);
    void omit_alternateTransportAddresses ();
    bool alternateTransportAddresses_isPresent () const;
    class useSpecifiedTransport {
      public:
        typedef UseSpecifiedTransport value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class useSpecifiedTransport
    useSpecifiedTransport::const_reference get_useSpecifiedTransport () const;
    useSpecifiedTransport::reference ref_useSpecifiedTransport ();
    useSpecifiedTransport::reference set_useSpecifiedTransport ();
    useSpecifiedTransport::reference set_useSpecifiedTransport (useSpecifiedTransport::const_reference value);
    void omit_useSpecifiedTransport ();
    bool useSpecifiedTransport_isPresent () const;
    void swap(RegistrationConfirm_preGrantedARQ& other);
    RegistrationConfirm_preGrantedARQ * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// ServiceControlIndication_callSpecific
//

class ServiceControlIndication_callSpecific : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceControlIndication_callSpecific(const void* info) : Inherited(info) {}
  public:
    ServiceControlIndication_callSpecific() : Inherited(&theInfo) {}
    ServiceControlIndication_callSpecific(const ServiceControlIndication_callSpecific & other) : Inherited(other)
    {}
    ServiceControlIndication_callSpecific& operator = (const ServiceControlIndication_callSpecific& other)
    { Inherited::operator = (other); return *this; } 
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class answeredCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class answeredCall
    answeredCall::const_reference get_answeredCall () const;
    answeredCall::reference ref_answeredCall ();
    answeredCall::reference set_answeredCall ();
    answeredCall::reference set_answeredCall (bool value);
    void swap(ServiceControlIndication_callSpecific& other);
    ServiceControlIndication_callSpecific * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ServiceControlResponse_result
//

class ServiceControlResponse_result : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ServiceControlResponse_result(const void* info) : Inherited(info) {}
  public:
    ServiceControlResponse_result() : Inherited(&theInfo) {}
    class started {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class started

    started::reference select_started (); 
    bool started_isSelected() const;

    class failed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class failed

    failed::reference select_failed (); 
    bool failed_isSelected() const;

    class stopped {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class stopped

    stopped::reference select_stopped (); 
    bool stopped_isSelected() const;

    class notAvailable {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notAvailable

    notAvailable::reference select_notAvailable (); 
    bool notAvailable_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    ServiceControlResponse_result(started::Id id, started::const_reference value);
    ServiceControlResponse_result(failed::Id id, failed::const_reference value);
    ServiceControlResponse_result(stopped::Id id, stopped::const_reference value);
    ServiceControlResponse_result(notAvailable::Id id, notAvailable::const_reference value);
    ServiceControlResponse_result(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    void swap(ServiceControlResponse_result & other);
    ServiceControlResponse_result(const ServiceControlResponse_result & other)
    : Inherited(other) {} 

    ServiceControlResponse_result & operator = (const ServiceControlResponse_result & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ServiceControlResponse_result * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// Connect_UUIE_language_subtype
//

class Connect_UUIE_language_subtype : public ASN1::IA5String
{
    typedef ASN1::IA5String Inherited;
  protected:
    Connect_UUIE_language_subtype(const void* info) : Inherited(info) {}
  public:
    Connect_UUIE_language_subtype() : Inherited(&theInfo) { }
    Connect_UUIE_language_subtype(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    Connect_UUIE_language_subtype(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
    Connect_UUIE_language_subtype(const Connect_UUIE_language_subtype& other) : Inherited(other) {}
    Connect_UUIE_language_subtype& operator = (const std::string& other)
    { Inherited::operator=(other); return *this;}
    Connect_UUIE_language_subtype& operator = (const char* other)
    { Inherited::operator=(other); return *this;}
    Connect_UUIE_language_subtype * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// Setup_UUIE_language_subtype
//

class Setup_UUIE_language_subtype : public ASN1::IA5String
{
    typedef ASN1::IA5String Inherited;
  protected:
    Setup_UUIE_language_subtype(const void* info) : Inherited(info) {}
  public:
    Setup_UUIE_language_subtype() : Inherited(&theInfo) { }
    Setup_UUIE_language_subtype(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    Setup_UUIE_language_subtype(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
    Setup_UUIE_language_subtype(const Setup_UUIE_language_subtype& other) : Inherited(other) {}
    Setup_UUIE_language_subtype& operator = (const std::string& other)
    { Inherited::operator=(other); return *this;}
    Setup_UUIE_language_subtype& operator = (const char* other)
    { Inherited::operator=(other); return *this;}
    Setup_UUIE_language_subtype * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// AdmissionConfirm_language_subtype
//

class AdmissionConfirm_language_subtype : public ASN1::IA5String
{
    typedef ASN1::IA5String Inherited;
  protected:
    AdmissionConfirm_language_subtype(const void* info) : Inherited(info) {}
  public:
    AdmissionConfirm_language_subtype() : Inherited(&theInfo) { }
    AdmissionConfirm_language_subtype(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    AdmissionConfirm_language_subtype(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
    AdmissionConfirm_language_subtype(const AdmissionConfirm_language_subtype& other) : Inherited(other) {}
    AdmissionConfirm_language_subtype& operator = (const std::string& other)
    { Inherited::operator=(other); return *this;}
    AdmissionConfirm_language_subtype& operator = (const char* other)
    { Inherited::operator=(other); return *this;}
    AdmissionConfirm_language_subtype * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// ReleaseCompleteReason
//

class ReleaseCompleteReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ReleaseCompleteReason(const void* info) : Inherited(info) {}
  public:
    ReleaseCompleteReason() : Inherited(&theInfo) {}
    class noBandwidth {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noBandwidth

    noBandwidth::reference select_noBandwidth (); 
    bool noBandwidth_isSelected() const;

    class gatekeeperResources {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperResources

    gatekeeperResources::reference select_gatekeeperResources (); 
    bool gatekeeperResources_isSelected() const;

    class unreachableDestination {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unreachableDestination

    unreachableDestination::reference select_unreachableDestination (); 
    bool unreachableDestination_isSelected() const;

    class destinationRejection {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationRejection

    destinationRejection::reference select_destinationRejection (); 
    bool destinationRejection_isSelected() const;

    class invalidRevision {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidRevision

    invalidRevision::reference select_invalidRevision (); 
    bool invalidRevision_isSelected() const;

    class noPermission {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noPermission

    noPermission::reference select_noPermission (); 
    bool noPermission_isSelected() const;

    class unreachableGatekeeper {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unreachableGatekeeper

    unreachableGatekeeper::reference select_unreachableGatekeeper (); 
    bool unreachableGatekeeper_isSelected() const;

    class gatewayResources {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatewayResources

    gatewayResources::reference select_gatewayResources (); 
    bool gatewayResources_isSelected() const;

    class badFormatAddress {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class badFormatAddress

    badFormatAddress::reference select_badFormatAddress (); 
    bool badFormatAddress_isSelected() const;

    class adaptiveBusy {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class adaptiveBusy

    adaptiveBusy::reference select_adaptiveBusy (); 
    bool adaptiveBusy_isSelected() const;

    class inConf {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class inConf

    inConf::reference select_inConf (); 
    bool inConf_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class facilityCallDeflection {
      public:
        enum Id { id_ = 12 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class facilityCallDeflection

    facilityCallDeflection::reference select_facilityCallDeflection (); 
    bool facilityCallDeflection_isSelected() const;

    class securityDenied {
      public:
        enum Id { id_ = 13 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenied

    securityDenied::reference select_securityDenied (); 
    bool securityDenied_isSelected() const;

    class calledPartyNotRegistered {
      public:
        enum Id { id_ = 14 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class calledPartyNotRegistered

    calledPartyNotRegistered::reference select_calledPartyNotRegistered (); 
    bool calledPartyNotRegistered_isSelected() const;

    class callerNotRegistered {
      public:
        enum Id { id_ = 15 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callerNotRegistered

    callerNotRegistered::reference select_callerNotRegistered (); 
    bool callerNotRegistered_isSelected() const;

    class newConnectionNeeded {
      public:
        enum Id { id_ = 16 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class newConnectionNeeded

    newConnectionNeeded::reference select_newConnectionNeeded (); 
    bool newConnectionNeeded_isSelected() const;

    class nonStandardReason {
      public:
        enum Id { id_ = 17 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardReason

    nonStandardReason::const_reference get_nonStandardReason () const;
    nonStandardReason::reference ref_nonStandardReason (); 
    nonStandardReason::reference select_nonStandardReason (); 
    nonStandardReason::reference select_nonStandardReason (nonStandardReason::const_reference value); 
    bool nonStandardReason_isSelected() const;

    class replaceWithConferenceInvite {
      public:
        enum Id { id_ = 18 };
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replaceWithConferenceInvite

    replaceWithConferenceInvite::const_reference get_replaceWithConferenceInvite () const;
    replaceWithConferenceInvite::reference ref_replaceWithConferenceInvite (); 
    replaceWithConferenceInvite::reference select_replaceWithConferenceInvite (); 
    replaceWithConferenceInvite::reference select_replaceWithConferenceInvite (const std::vector<char>& value); 
    bool replaceWithConferenceInvite_isSelected() const;

    class genericDataReason {
      public:
        enum Id { id_ = 19 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataReason

    genericDataReason::reference select_genericDataReason (); 
    bool genericDataReason_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 20 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    class tunnelledSignallingRejected {
      public:
        enum Id { id_ = 21 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tunnelledSignallingRejected

    tunnelledSignallingRejected::reference select_tunnelledSignallingRejected (); 
    bool tunnelledSignallingRejected_isSelected() const;

    class invalidCID {
      public:
        enum Id { id_ = 22 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidCID

    invalidCID::reference select_invalidCID (); 
    bool invalidCID_isSelected() const;

    ReleaseCompleteReason(noBandwidth::Id id, noBandwidth::const_reference value);
    ReleaseCompleteReason(gatekeeperResources::Id id, gatekeeperResources::const_reference value);
    ReleaseCompleteReason(unreachableDestination::Id id, unreachableDestination::const_reference value);
    ReleaseCompleteReason(destinationRejection::Id id, destinationRejection::const_reference value);
    ReleaseCompleteReason(invalidRevision::Id id, invalidRevision::const_reference value);
    ReleaseCompleteReason(noPermission::Id id, noPermission::const_reference value);
    ReleaseCompleteReason(unreachableGatekeeper::Id id, unreachableGatekeeper::const_reference value);
    ReleaseCompleteReason(gatewayResources::Id id, gatewayResources::const_reference value);
    ReleaseCompleteReason(badFormatAddress::Id id, badFormatAddress::const_reference value);
    ReleaseCompleteReason(adaptiveBusy::Id id, adaptiveBusy::const_reference value);
    ReleaseCompleteReason(inConf::Id id, inConf::const_reference value);
    ReleaseCompleteReason(undefinedReason::Id id, undefinedReason::const_reference value);
    ReleaseCompleteReason(facilityCallDeflection::Id id, facilityCallDeflection::const_reference value);
    ReleaseCompleteReason(securityDenied::Id id, securityDenied::const_reference value);
    ReleaseCompleteReason(calledPartyNotRegistered::Id id, calledPartyNotRegistered::const_reference value);
    ReleaseCompleteReason(callerNotRegistered::Id id, callerNotRegistered::const_reference value);
    ReleaseCompleteReason(newConnectionNeeded::Id id, newConnectionNeeded::const_reference value);
    ReleaseCompleteReason(nonStandardReason::Id id, nonStandardReason::const_reference value);
    ReleaseCompleteReason(replaceWithConferenceInvite::Id id, const std::vector<char>& value);
    ReleaseCompleteReason(genericDataReason::Id id, genericDataReason::const_reference value);
    ReleaseCompleteReason(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    ReleaseCompleteReason(tunnelledSignallingRejected::Id id, tunnelledSignallingRejected::const_reference value);
    ReleaseCompleteReason(invalidCID::Id id, invalidCID::const_reference value);
    void swap(ReleaseCompleteReason & other);
    ReleaseCompleteReason(const ReleaseCompleteReason & other)
    : Inherited(other) {} 

    ReleaseCompleteReason & operator = (const ReleaseCompleteReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ReleaseCompleteReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[23];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[23];
#endif
};

//
// ConferenceList
//

class ConferenceList : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceList(const void* info) : Inherited(info) {}
  public:
    ConferenceList() : Inherited(&theInfo) {}
    ConferenceList(const ConferenceList & other) : Inherited(other)
    {}
    ConferenceList& operator = (const ConferenceList& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_conferenceID,
      e_conferenceAlias,
      e_nonStandardData
    };

    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    void omit_conferenceID ();
    bool conferenceID_isPresent () const;
    class conferenceAlias {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceAlias
    conferenceAlias::const_reference get_conferenceAlias () const;
    conferenceAlias::reference ref_conferenceAlias ();
    conferenceAlias::reference set_conferenceAlias ();
    conferenceAlias::reference set_conferenceAlias (conferenceAlias::const_reference value);
    void omit_conferenceAlias ();
    bool conferenceAlias_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    void swap(ConferenceList& other);
    ConferenceList * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// AddressPattern
//

class AddressPattern : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AddressPattern(const void* info) : Inherited(info) {}
  public:
    AddressPattern() : Inherited(&theInfo) {}
    class wildcard {
      public:
        enum Id { id_ = 0 };
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wildcard

    wildcard::const_reference get_wildcard () const;
    wildcard::reference ref_wildcard (); 
    wildcard::reference select_wildcard (); 
    wildcard::reference select_wildcard (wildcard::const_reference value); 
    bool wildcard_isSelected() const;

    class range {
      public:
        enum Id { id_ = 1 };
        typedef AddressPattern_range value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class range

    range::const_reference get_range () const;
    range::reference ref_range (); 
    range::reference select_range (); 
    range::reference select_range (range::const_reference value); 
    bool range_isSelected() const;

    AddressPattern(wildcard::Id id, wildcard::const_reference value);
    AddressPattern(range::Id id, range::const_reference value);
    void swap(AddressPattern & other);
    AddressPattern(const AddressPattern & other)
    : Inherited(other) {} 

    AddressPattern & operator = (const AddressPattern & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AddressPattern * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// QseriesOptions
//

class QseriesOptions : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    QseriesOptions(const void* info) : Inherited(info) {}
  public:
    QseriesOptions() : Inherited(&theInfo) {}
    QseriesOptions(const QseriesOptions & other) : Inherited(other)
    {}
    QseriesOptions& operator = (const QseriesOptions& other)
    { Inherited::operator = (other); return *this; } 
    class q932Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q932Full
    q932Full::const_reference get_q932Full () const;
    q932Full::reference ref_q932Full ();
    q932Full::reference set_q932Full ();
    q932Full::reference set_q932Full (bool value);
    class q951Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q951Full
    q951Full::const_reference get_q951Full () const;
    q951Full::reference ref_q951Full ();
    q951Full::reference set_q951Full ();
    q951Full::reference set_q951Full (bool value);
    class q952Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q952Full
    q952Full::const_reference get_q952Full () const;
    q952Full::reference ref_q952Full ();
    q952Full::reference set_q952Full ();
    q952Full::reference set_q952Full (bool value);
    class q953Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q953Full
    q953Full::const_reference get_q953Full () const;
    q953Full::reference ref_q953Full ();
    q953Full::reference set_q953Full ();
    q953Full::reference set_q953Full (bool value);
    class q955Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q955Full
    q955Full::const_reference get_q955Full () const;
    q955Full::reference ref_q955Full ();
    q955Full::reference set_q955Full ();
    q955Full::reference set_q955Full (bool value);
    class q956Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q956Full
    q956Full::const_reference get_q956Full () const;
    q956Full::reference ref_q956Full ();
    q956Full::reference set_q956Full ();
    q956Full::reference set_q956Full (bool value);
    class q957Full {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q957Full
    q957Full::const_reference get_q957Full () const;
    q957Full::reference ref_q957Full ();
    q957Full::reference set_q957Full ();
    q957Full::reference set_q957Full (bool value);
    class q954Info {
      public:
        typedef Q954Details value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q954Info
    q954Info::const_reference get_q954Info () const;
    q954Info::reference ref_q954Info ();
    q954Info::reference set_q954Info ();
    q954Info::reference set_q954Info (q954Info::const_reference value);
    void swap(QseriesOptions& other);
    QseriesOptions * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// CryptoH323Token
//

class CryptoH323Token : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CryptoH323Token(const void* info) : Inherited(info) {}
  public:
    CryptoH323Token() : Inherited(&theInfo) {}
    class cryptoEPPwdHash {
      public:
        enum Id { id_ = 0 };
        typedef CryptoH323Token_cryptoEPPwdHash value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoEPPwdHash

    cryptoEPPwdHash::const_reference get_cryptoEPPwdHash () const;
    cryptoEPPwdHash::reference ref_cryptoEPPwdHash (); 
    cryptoEPPwdHash::reference select_cryptoEPPwdHash (); 
    cryptoEPPwdHash::reference select_cryptoEPPwdHash (cryptoEPPwdHash::const_reference value); 
    bool cryptoEPPwdHash_isSelected() const;

    class cryptoGKPwdHash {
      public:
        enum Id { id_ = 1 };
        typedef CryptoH323Token_cryptoGKPwdHash value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoGKPwdHash

    cryptoGKPwdHash::const_reference get_cryptoGKPwdHash () const;
    cryptoGKPwdHash::reference ref_cryptoGKPwdHash (); 
    cryptoGKPwdHash::reference select_cryptoGKPwdHash (); 
    cryptoGKPwdHash::reference select_cryptoGKPwdHash (cryptoGKPwdHash::const_reference value); 
    bool cryptoGKPwdHash_isSelected() const;

    class cryptoEPPwdEncr {
      public:
        enum Id { id_ = 2 };
        typedef H235_SECURITY_MESSAGES::ENCRYPTED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoEPPwdEncr

    cryptoEPPwdEncr::const_reference get_cryptoEPPwdEncr () const;
    cryptoEPPwdEncr::reference ref_cryptoEPPwdEncr (); 
    cryptoEPPwdEncr::reference select_cryptoEPPwdEncr (); 
    cryptoEPPwdEncr::reference select_cryptoEPPwdEncr (cryptoEPPwdEncr::const_reference value); 
    bool cryptoEPPwdEncr_isSelected() const;

    class cryptoGKPwdEncr {
      public:
        enum Id { id_ = 3 };
        typedef H235_SECURITY_MESSAGES::ENCRYPTED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoGKPwdEncr

    cryptoGKPwdEncr::const_reference get_cryptoGKPwdEncr () const;
    cryptoGKPwdEncr::reference ref_cryptoGKPwdEncr (); 
    cryptoGKPwdEncr::reference select_cryptoGKPwdEncr (); 
    cryptoGKPwdEncr::reference select_cryptoGKPwdEncr (cryptoGKPwdEncr::const_reference value); 
    bool cryptoGKPwdEncr_isSelected() const;

    class cryptoEPCert {
      public:
        enum Id { id_ = 4 };
        typedef H235_SECURITY_MESSAGES::SIGNED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoEPCert

    cryptoEPCert::const_reference get_cryptoEPCert () const;
    cryptoEPCert::reference ref_cryptoEPCert (); 
    cryptoEPCert::reference select_cryptoEPCert (); 
    cryptoEPCert::reference select_cryptoEPCert (cryptoEPCert::const_reference value); 
    bool cryptoEPCert_isSelected() const;

    class cryptoGKCert {
      public:
        enum Id { id_ = 5 };
        typedef H235_SECURITY_MESSAGES::SIGNED<H235_SECURITY_MESSAGES::EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoGKCert

    cryptoGKCert::const_reference get_cryptoGKCert () const;
    cryptoGKCert::reference ref_cryptoGKCert (); 
    cryptoGKCert::reference select_cryptoGKCert (); 
    cryptoGKCert::reference select_cryptoGKCert (cryptoGKCert::const_reference value); 
    bool cryptoGKCert_isSelected() const;

    class cryptoFastStart {
      public:
        enum Id { id_ = 6 };
        typedef H235_SECURITY_MESSAGES::SIGNED<EncodedFastStartToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoFastStart

    cryptoFastStart::const_reference get_cryptoFastStart () const;
    cryptoFastStart::reference ref_cryptoFastStart (); 
    cryptoFastStart::reference select_cryptoFastStart (); 
    cryptoFastStart::reference select_cryptoFastStart (cryptoFastStart::const_reference value); 
    bool cryptoFastStart_isSelected() const;

    class nestedcryptoToken {
      public:
        enum Id { id_ = 7 };
        typedef H235_SECURITY_MESSAGES::CryptoToken value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nestedcryptoToken

    nestedcryptoToken::const_reference get_nestedcryptoToken () const;
    nestedcryptoToken::reference ref_nestedcryptoToken (); 
    nestedcryptoToken::reference select_nestedcryptoToken (); 
    nestedcryptoToken::reference select_nestedcryptoToken (nestedcryptoToken::const_reference value); 
    bool nestedcryptoToken_isSelected() const;

    CryptoH323Token(cryptoEPPwdHash::Id id, cryptoEPPwdHash::const_reference value);
    CryptoH323Token(cryptoGKPwdHash::Id id, cryptoGKPwdHash::const_reference value);
    CryptoH323Token(cryptoEPPwdEncr::Id id, cryptoEPPwdEncr::const_reference value);
    CryptoH323Token(cryptoGKPwdEncr::Id id, cryptoGKPwdEncr::const_reference value);
    CryptoH323Token(cryptoEPCert::Id id, cryptoEPCert::const_reference value);
    CryptoH323Token(cryptoGKCert::Id id, cryptoGKCert::const_reference value);
    CryptoH323Token(cryptoFastStart::Id id, cryptoFastStart::const_reference value);
    CryptoH323Token(nestedcryptoToken::Id id, nestedcryptoToken::const_reference value);
    void swap(CryptoH323Token & other);
    CryptoH323Token(const CryptoH323Token & other)
    : Inherited(other) {} 

    CryptoH323Token & operator = (const CryptoH323Token & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CryptoH323Token * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// CapacityReportingSpecification
//

class CapacityReportingSpecification : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CapacityReportingSpecification(const void* info) : Inherited(info) {}
  public:
    CapacityReportingSpecification() : Inherited(&theInfo) {}
    CapacityReportingSpecification(const CapacityReportingSpecification & other) : Inherited(other)
    {}
    CapacityReportingSpecification& operator = (const CapacityReportingSpecification& other)
    { Inherited::operator = (other); return *this; } 
    class when {
      public:
        typedef CapacityReportingSpecification_when value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class when
    when::const_reference get_when () const;
    when::reference ref_when ();
    when::reference set_when ();
    when::reference set_when (when::const_reference value);
    void swap(CapacityReportingSpecification& other);
    CapacityReportingSpecification * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CallCapacityInfo
//

class CallCapacityInfo : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallCapacityInfo(const void* info) : Inherited(info) {}
  public:
    CallCapacityInfo() : Inherited(&theInfo) {}
    CallCapacityInfo(const CallCapacityInfo & other) : Inherited(other)
    {}
    CallCapacityInfo& operator = (const CallCapacityInfo& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_voiceGwCallsAvailable,
      e_h310GwCallsAvailable,
      e_h320GwCallsAvailable,
      e_h321GwCallsAvailable,
      e_h322GwCallsAvailable,
      e_h323GwCallsAvailable,
      e_h324GwCallsAvailable,
      e_t120OnlyGwCallsAvailable,
      e_t38FaxAnnexbOnlyGwCallsAvailable,
      e_terminalCallsAvailable,
      e_mcuCallsAvailable
    };

    class voiceGwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class voiceGwCallsAvailable
    voiceGwCallsAvailable::const_reference get_voiceGwCallsAvailable () const;
    voiceGwCallsAvailable::reference ref_voiceGwCallsAvailable ();
    voiceGwCallsAvailable::reference set_voiceGwCallsAvailable ();
    voiceGwCallsAvailable::reference set_voiceGwCallsAvailable (voiceGwCallsAvailable::const_reference value);
    void omit_voiceGwCallsAvailable ();
    bool voiceGwCallsAvailable_isPresent () const;
    class h310GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h310GwCallsAvailable
    h310GwCallsAvailable::const_reference get_h310GwCallsAvailable () const;
    h310GwCallsAvailable::reference ref_h310GwCallsAvailable ();
    h310GwCallsAvailable::reference set_h310GwCallsAvailable ();
    h310GwCallsAvailable::reference set_h310GwCallsAvailable (h310GwCallsAvailable::const_reference value);
    void omit_h310GwCallsAvailable ();
    bool h310GwCallsAvailable_isPresent () const;
    class h320GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h320GwCallsAvailable
    h320GwCallsAvailable::const_reference get_h320GwCallsAvailable () const;
    h320GwCallsAvailable::reference ref_h320GwCallsAvailable ();
    h320GwCallsAvailable::reference set_h320GwCallsAvailable ();
    h320GwCallsAvailable::reference set_h320GwCallsAvailable (h320GwCallsAvailable::const_reference value);
    void omit_h320GwCallsAvailable ();
    bool h320GwCallsAvailable_isPresent () const;
    class h321GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h321GwCallsAvailable
    h321GwCallsAvailable::const_reference get_h321GwCallsAvailable () const;
    h321GwCallsAvailable::reference ref_h321GwCallsAvailable ();
    h321GwCallsAvailable::reference set_h321GwCallsAvailable ();
    h321GwCallsAvailable::reference set_h321GwCallsAvailable (h321GwCallsAvailable::const_reference value);
    void omit_h321GwCallsAvailable ();
    bool h321GwCallsAvailable_isPresent () const;
    class h322GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h322GwCallsAvailable
    h322GwCallsAvailable::const_reference get_h322GwCallsAvailable () const;
    h322GwCallsAvailable::reference ref_h322GwCallsAvailable ();
    h322GwCallsAvailable::reference set_h322GwCallsAvailable ();
    h322GwCallsAvailable::reference set_h322GwCallsAvailable (h322GwCallsAvailable::const_reference value);
    void omit_h322GwCallsAvailable ();
    bool h322GwCallsAvailable_isPresent () const;
    class h323GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h323GwCallsAvailable
    h323GwCallsAvailable::const_reference get_h323GwCallsAvailable () const;
    h323GwCallsAvailable::reference ref_h323GwCallsAvailable ();
    h323GwCallsAvailable::reference set_h323GwCallsAvailable ();
    h323GwCallsAvailable::reference set_h323GwCallsAvailable (h323GwCallsAvailable::const_reference value);
    void omit_h323GwCallsAvailable ();
    bool h323GwCallsAvailable_isPresent () const;
    class h324GwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h324GwCallsAvailable
    h324GwCallsAvailable::const_reference get_h324GwCallsAvailable () const;
    h324GwCallsAvailable::reference ref_h324GwCallsAvailable ();
    h324GwCallsAvailable::reference set_h324GwCallsAvailable ();
    h324GwCallsAvailable::reference set_h324GwCallsAvailable (h324GwCallsAvailable::const_reference value);
    void omit_h324GwCallsAvailable ();
    bool h324GwCallsAvailable_isPresent () const;
    class t120OnlyGwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t120OnlyGwCallsAvailable
    t120OnlyGwCallsAvailable::const_reference get_t120OnlyGwCallsAvailable () const;
    t120OnlyGwCallsAvailable::reference ref_t120OnlyGwCallsAvailable ();
    t120OnlyGwCallsAvailable::reference set_t120OnlyGwCallsAvailable ();
    t120OnlyGwCallsAvailable::reference set_t120OnlyGwCallsAvailable (t120OnlyGwCallsAvailable::const_reference value);
    void omit_t120OnlyGwCallsAvailable ();
    bool t120OnlyGwCallsAvailable_isPresent () const;
    class t38FaxAnnexbOnlyGwCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t38FaxAnnexbOnlyGwCallsAvailable
    t38FaxAnnexbOnlyGwCallsAvailable::const_reference get_t38FaxAnnexbOnlyGwCallsAvailable () const;
    t38FaxAnnexbOnlyGwCallsAvailable::reference ref_t38FaxAnnexbOnlyGwCallsAvailable ();
    t38FaxAnnexbOnlyGwCallsAvailable::reference set_t38FaxAnnexbOnlyGwCallsAvailable ();
    t38FaxAnnexbOnlyGwCallsAvailable::reference set_t38FaxAnnexbOnlyGwCallsAvailable (t38FaxAnnexbOnlyGwCallsAvailable::const_reference value);
    void omit_t38FaxAnnexbOnlyGwCallsAvailable ();
    bool t38FaxAnnexbOnlyGwCallsAvailable_isPresent () const;
    class terminalCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCallsAvailable
    terminalCallsAvailable::const_reference get_terminalCallsAvailable () const;
    terminalCallsAvailable::reference ref_terminalCallsAvailable ();
    terminalCallsAvailable::reference set_terminalCallsAvailable ();
    terminalCallsAvailable::reference set_terminalCallsAvailable (terminalCallsAvailable::const_reference value);
    void omit_terminalCallsAvailable ();
    bool terminalCallsAvailable_isPresent () const;
    class mcuCallsAvailable {
      public:
        typedef ASN1::SEQUENCE_OF<CallsAvailable>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mcuCallsAvailable
    mcuCallsAvailable::const_reference get_mcuCallsAvailable () const;
    mcuCallsAvailable::reference ref_mcuCallsAvailable ();
    mcuCallsAvailable::reference set_mcuCallsAvailable ();
    mcuCallsAvailable::reference set_mcuCallsAvailable (mcuCallsAvailable::const_reference value);
    void omit_mcuCallsAvailable ();
    bool mcuCallsAvailable_isPresent () const;
    void swap(CallCapacityInfo& other);
    CallCapacityInfo * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// CicInfo
//

class CicInfo : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CicInfo(const void* info) : Inherited(info) {}
  public:
    CicInfo() : Inherited(&theInfo) {}
    CicInfo(const CicInfo & other) : Inherited(other)
    {}
    CicInfo& operator = (const CicInfo& other)
    { Inherited::operator = (other); return *this; } 
    class cic {
      public:
        typedef CicInfo_cic value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cic
    cic::const_reference get_cic () const;
    cic::reference ref_cic ();
    cic::reference set_cic ();
    cic::reference set_cic (cic::const_reference value);
    class pointCode {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 5> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pointCode
    pointCode::const_reference get_pointCode () const;
    pointCode::reference ref_pointCode ();
    pointCode::reference set_pointCode ();
    pointCode::reference set_pointCode (const std::vector<char>& value);
    void swap(CicInfo& other);
    CicInfo * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// GroupID
//

class GroupID : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    GroupID(const void* info) : Inherited(info) {}
  public:
    GroupID() : Inherited(&theInfo) {}
    GroupID(const GroupID & other) : Inherited(other)
    {}
    GroupID& operator = (const GroupID& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_member
    };

    class member {
      public:
        typedef GroupID_member value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class member
    member::const_reference get_member () const;
    member::reference ref_member ();
    member::reference set_member ();
    member::reference set_member (member::const_reference value);
    void omit_member ();
    bool member_isPresent () const;
    class group {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class group
    group::const_reference get_group () const;
    group::reference ref_group ();
    group::reference set_group ();
    group::reference set_group (const std::string& value);
    void swap(GroupID& other);
    GroupID * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RasUsageSpecification
//

class RasUsageSpecification : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RasUsageSpecification(const void* info) : Inherited(info) {}
  public:
    RasUsageSpecification() : Inherited(&theInfo) {}
    RasUsageSpecification(const RasUsageSpecification & other) : Inherited(other)
    {}
    RasUsageSpecification& operator = (const RasUsageSpecification& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_callStartingPoint
    };

    class when {
      public:
        typedef RasUsageSpecification_when value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class when
    when::const_reference get_when () const;
    when::reference ref_when ();
    when::reference set_when ();
    when::reference set_when (when::const_reference value);
    class callStartingPoint {
      public:
        typedef RasUsageSpecification_callStartingPoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callStartingPoint
    callStartingPoint::const_reference get_callStartingPoint () const;
    callStartingPoint::reference ref_callStartingPoint ();
    callStartingPoint::reference set_callStartingPoint ();
    callStartingPoint::reference set_callStartingPoint (callStartingPoint::const_reference value);
    void omit_callStartingPoint ();
    bool callStartingPoint_isPresent () const;
    class required {
      public:
        typedef RasUsageInfoTypes value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class required
    required::const_reference get_required () const;
    required::reference ref_required ();
    required::reference set_required ();
    required::reference set_required (required::const_reference value);
    void swap(RasUsageSpecification& other);
    RasUsageSpecification * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CallTerminationCause
//

class CallTerminationCause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CallTerminationCause(const void* info) : Inherited(info) {}
  public:
    CallTerminationCause() : Inherited(&theInfo) {}
    class releaseCompleteReason {
      public:
        enum Id { id_ = 0 };
        typedef ReleaseCompleteReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class releaseCompleteReason

    releaseCompleteReason::const_reference get_releaseCompleteReason () const;
    releaseCompleteReason::reference ref_releaseCompleteReason (); 
    releaseCompleteReason::reference select_releaseCompleteReason (); 
    releaseCompleteReason::reference select_releaseCompleteReason (releaseCompleteReason::const_reference value); 
    bool releaseCompleteReason_isSelected() const;

    class releaseCompleteCauseIE {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 32> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class releaseCompleteCauseIE

    releaseCompleteCauseIE::const_reference get_releaseCompleteCauseIE () const;
    releaseCompleteCauseIE::reference ref_releaseCompleteCauseIE (); 
    releaseCompleteCauseIE::reference select_releaseCompleteCauseIE (); 
    releaseCompleteCauseIE::reference select_releaseCompleteCauseIE (const std::vector<char>& value); 
    bool releaseCompleteCauseIE_isSelected() const;

    CallTerminationCause(releaseCompleteReason::Id id, releaseCompleteReason::const_reference value);
    CallTerminationCause(releaseCompleteCauseIE::Id id, const std::vector<char>& value);
    void swap(CallTerminationCause & other);
    CallTerminationCause(const CallTerminationCause & other)
    : Inherited(other) {} 

    CallTerminationCause & operator = (const CallTerminationCause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CallTerminationCause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// BandwidthDetails
//

class BandwidthDetails : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    BandwidthDetails(const void* info) : Inherited(info) {}
  public:
    BandwidthDetails() : Inherited(&theInfo) {}
    BandwidthDetails(const BandwidthDetails & other) : Inherited(other)
    {}
    BandwidthDetails& operator = (const BandwidthDetails& other)
    { Inherited::operator = (other); return *this; } 
    class sender {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sender
    sender::const_reference get_sender () const;
    sender::reference ref_sender ();
    sender::reference set_sender ();
    sender::reference set_sender (bool value);
    class multicast {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multicast
    multicast::const_reference get_multicast () const;
    multicast::reference ref_multicast ();
    multicast::reference set_multicast ();
    multicast::reference set_multicast (bool value);
    class bandwidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidth
    bandwidth::const_reference get_bandwidth () const;
    bandwidth::reference ref_bandwidth ();
    bandwidth::reference set_bandwidth ();
    bandwidth::reference set_bandwidth (bandwidth::const_reference value);
    class rtcpAddresses {
      public:
        typedef TransportChannelInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtcpAddresses
    rtcpAddresses::const_reference get_rtcpAddresses () const;
    rtcpAddresses::reference ref_rtcpAddresses ();
    rtcpAddresses::reference set_rtcpAddresses ();
    rtcpAddresses::reference set_rtcpAddresses (rtcpAddresses::const_reference value);
    void swap(BandwidthDetails& other);
    BandwidthDetails * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// CallCreditServiceControl
//

class CallCreditServiceControl : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallCreditServiceControl(const void* info) : Inherited(info) {}
  public:
    CallCreditServiceControl() : Inherited(&theInfo) {}
    CallCreditServiceControl(const CallCreditServiceControl & other) : Inherited(other)
    {}
    CallCreditServiceControl& operator = (const CallCreditServiceControl& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_amountString,
      e_billingMode,
      e_callDurationLimit,
      e_enforceCallDurationLimit,
      e_callStartingPoint
    };

    class amountString {
      public:
        class value_type : public ASN1::BMPString
        {
            typedef ASN1::BMPString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (std::wstring& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const wchar_t* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class amountString
    amountString::const_reference get_amountString () const;
    amountString::reference ref_amountString ();
    amountString::reference set_amountString ();
    amountString::reference set_amountString (const std::wstring& value);
    void omit_amountString ();
    bool amountString_isPresent () const;
    class billingMode {
      public:
        typedef CallCreditServiceControl_billingMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class billingMode
    billingMode::const_reference get_billingMode () const;
    billingMode::reference ref_billingMode ();
    billingMode::reference set_billingMode ();
    billingMode::reference set_billingMode (billingMode::const_reference value);
    void omit_billingMode ();
    bool billingMode_isPresent () const;
    class callDurationLimit {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callDurationLimit
    callDurationLimit::const_reference get_callDurationLimit () const;
    callDurationLimit::reference ref_callDurationLimit ();
    callDurationLimit::reference set_callDurationLimit ();
    callDurationLimit::reference set_callDurationLimit (callDurationLimit::value_type::int_type value);
    void omit_callDurationLimit ();
    bool callDurationLimit_isPresent () const;
    class enforceCallDurationLimit {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enforceCallDurationLimit
    enforceCallDurationLimit::const_reference get_enforceCallDurationLimit () const;
    enforceCallDurationLimit::reference ref_enforceCallDurationLimit ();
    enforceCallDurationLimit::reference set_enforceCallDurationLimit ();
    enforceCallDurationLimit::reference set_enforceCallDurationLimit (bool value);
    void omit_enforceCallDurationLimit ();
    bool enforceCallDurationLimit_isPresent () const;
    class callStartingPoint {
      public:
        typedef CallCreditServiceControl_callStartingPoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callStartingPoint
    callStartingPoint::const_reference get_callStartingPoint () const;
    callStartingPoint::reference ref_callStartingPoint ();
    callStartingPoint::reference set_callStartingPoint ();
    callStartingPoint::reference set_callStartingPoint (callStartingPoint::const_reference value);
    void omit_callStartingPoint ();
    bool callStartingPoint_isPresent () const;
    void swap(CallCreditServiceControl& other);
    CallCreditServiceControl * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// GenericData
//

class GenericData : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    GenericData(const void* info) : Inherited(info) {}
  public:
    GenericData() : Inherited(&theInfo) {}
    GenericData(const GenericData & other) : Inherited(other)
    {}
    GenericData& operator = (const GenericData& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_parameters
    };

    class id {
      public:
        typedef GenericIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class id
    id::const_reference get_id () const;
    id::reference ref_id ();
    id::reference set_id ();
    id::reference set_id (id::const_reference value);
    class parameters {
      public:
        typedef ASN1::SEQUENCE_OF<EnumeratedParameter,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 512> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class parameters
    parameters::const_reference get_parameters () const;
    parameters::reference ref_parameters ();
    parameters::reference set_parameters ();
    parameters::reference set_parameters (parameters::const_reference value);
    void omit_parameters ();
    bool parameters_isPresent () const;
    void swap(GenericData& other);
    GenericData * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// Content
//

class Content : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Content(const void* info) : Inherited(info) {}
  public:
    Content() : Inherited(&theInfo) {}
    class raw {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class raw

    raw::const_reference get_raw () const;
    raw::reference ref_raw (); 
    raw::reference select_raw (); 
    raw::reference select_raw (const std::vector<char>& value); 
    bool raw_isSelected() const;

    class text {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::IA5String value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class text

    text::const_reference get_text () const;
    text::reference ref_text (); 
    text::reference select_text (); 
    text::reference select_text (const std::string& value); 
    bool text_isSelected() const;

    class unicode {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::BMPString value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unicode

    unicode::const_reference get_unicode () const;
    unicode::reference ref_unicode (); 
    unicode::reference select_unicode (); 
    unicode::reference select_unicode (const std::wstring& value); 
    bool unicode_isSelected() const;

    class bool_ {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bool_

    bool_::const_reference get_bool () const;
    bool_::reference ref_bool (); 
    bool_::reference select_bool (); 
    bool_::reference select_bool (bool value); 
    bool bool_isSelected() const;

    class number8 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class number8

    number8::const_reference get_number8 () const;
    number8::reference ref_number8 (); 
    number8::reference select_number8 (); 
    number8::reference select_number8 (number8::value_type::int_type value); 
    bool number8_isSelected() const;

    class number16 {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class number16

    number16::const_reference get_number16 () const;
    number16::reference ref_number16 (); 
    number16::reference select_number16 (); 
    number16::reference select_number16 (number16::value_type::int_type value); 
    bool number16_isSelected() const;

    class number32 {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class number32

    number32::const_reference get_number32 () const;
    number32::reference ref_number32 (); 
    number32::reference select_number32 (); 
    number32::reference select_number32 (number32::value_type::int_type value); 
    bool number32_isSelected() const;

    class id {
      public:
        enum Id { id_ = 7 };
        typedef GenericIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class id

    id::const_reference get_id () const;
    id::reference ref_id (); 
    id::reference select_id (); 
    id::reference select_id (id::const_reference value); 
    bool id_isSelected() const;

    class alias {
      public:
        enum Id { id_ = 8 };
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alias

    alias::const_reference get_alias () const;
    alias::reference ref_alias (); 
    alias::reference select_alias (); 
    alias::reference select_alias (alias::const_reference value); 
    bool alias_isSelected() const;

    class transport {
      public:
        enum Id { id_ = 9 };
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transport

    transport::const_reference get_transport () const;
    transport::reference ref_transport (); 
    transport::reference select_transport (); 
    transport::reference select_transport (transport::const_reference value); 
    bool transport_isSelected() const;

    class compound {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::SEQUENCE_OF<EnumeratedParameter,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 512> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class compound

    compound::const_reference get_compound () const;
    compound::reference ref_compound (); 
    compound::reference select_compound (); 
    compound::reference select_compound (compound::const_reference value); 
    bool compound_isSelected() const;

    class nested {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::SEQUENCE_OF<GenericData,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 16> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nested

    nested::const_reference get_nested () const;
    nested::reference ref_nested (); 
    nested::reference select_nested (); 
    nested::reference select_nested (nested::const_reference value); 
    bool nested_isSelected() const;

    Content(raw::Id id, const std::vector<char>& value);
    Content(text::Id id, const std::string& value);
    Content(unicode::Id id, const std::wstring& value);
    Content(bool_::Id id, bool value);
    Content(number8::Id id, number8::value_type::int_type value);
    Content(number16::Id id, number16::value_type::int_type value);
    Content(number32::Id id, number32::value_type::int_type value);
    Content(id::Id id, id::const_reference value);
    Content(alias::Id id, alias::const_reference value);
    Content(transport::Id id, transport::const_reference value);
    Content(compound::Id id, compound::const_reference value);
    Content(nested::Id id, nested::const_reference value);
    void swap(Content & other);
    Content(const Content & other)
    : Inherited(other) {} 

    Content & operator = (const Content & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Content * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[12];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[12];
#endif
};

//
// RTPSession
//

class RTPSession : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RTPSession(const void* info) : Inherited(info) {}
  public:
    RTPSession() : Inherited(&theInfo) {}
    RTPSession(const RTPSession & other) : Inherited(other)
    {}
    RTPSession& operator = (const RTPSession& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_multicast,
      e_bandwidth
    };

    class rtpAddress {
      public:
        typedef TransportChannelInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpAddress
    rtpAddress::const_reference get_rtpAddress () const;
    rtpAddress::reference ref_rtpAddress ();
    rtpAddress::reference set_rtpAddress ();
    rtpAddress::reference set_rtpAddress (rtpAddress::const_reference value);
    class rtcpAddress {
      public:
        typedef TransportChannelInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtcpAddress
    rtcpAddress::const_reference get_rtcpAddress () const;
    rtcpAddress::reference ref_rtcpAddress ();
    rtcpAddress::reference set_rtcpAddress ();
    rtcpAddress::reference set_rtcpAddress (rtcpAddress::const_reference value);
    class cname {
      public:
        typedef ASN1::PrintableString value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cname
    cname::const_reference get_cname () const;
    cname::reference ref_cname ();
    cname::reference set_cname ();
    cname::reference set_cname (const std::string& value);
    class ssrc {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ssrc
    ssrc::const_reference get_ssrc () const;
    ssrc::reference ref_ssrc ();
    ssrc::reference set_ssrc ();
    ssrc::reference set_ssrc (ssrc::value_type::int_type value);
    class sessionId {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionId
    sessionId::const_reference get_sessionId () const;
    sessionId::reference ref_sessionId ();
    sessionId::reference set_sessionId ();
    sessionId::reference set_sessionId (sessionId::value_type::int_type value);
    class associatedSessionIds {
      public:
        typedef RTPSession_associatedSessionIds value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class associatedSessionIds
    associatedSessionIds::const_reference get_associatedSessionIds () const;
    associatedSessionIds::reference ref_associatedSessionIds ();
    associatedSessionIds::reference set_associatedSessionIds ();
    associatedSessionIds::reference set_associatedSessionIds (associatedSessionIds::const_reference value);
    class multicast {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multicast
    multicast::reference set_multicast ();
    void omit_multicast ();
    bool multicast_isPresent () const;
    class bandwidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidth
    bandwidth::const_reference get_bandwidth () const;
    bandwidth::reference ref_bandwidth ();
    bandwidth::reference set_bandwidth ();
    bandwidth::reference set_bandwidth (bandwidth::const_reference value);
    void omit_bandwidth ();
    bool bandwidth_isPresent () const;
    void swap(RTPSession& other);
    RTPSession * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// UnregistrationConfirm
//

class UnregistrationConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UnregistrationConfirm(const void* info) : Inherited(info) {}
  public:
    UnregistrationConfirm() : Inherited(&theInfo) {}
    UnregistrationConfirm(const UnregistrationConfirm & other) : Inherited(other)
    {}
    UnregistrationConfirm& operator = (const UnregistrationConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(UnregistrationConfirm& other);
    UnregistrationConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// UnregistrationReject
//

class UnregistrationReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UnregistrationReject(const void* info) : Inherited(info) {}
  public:
    UnregistrationReject() : Inherited(&theInfo) {}
    UnregistrationReject(const UnregistrationReject & other) : Inherited(other)
    {}
    UnregistrationReject& operator = (const UnregistrationReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class rejectReason {
      public:
        typedef UnregRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(UnregistrationReject& other);
    UnregistrationReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// BandwidthReject
//

class BandwidthReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    BandwidthReject(const void* info) : Inherited(info) {}
  public:
    BandwidthReject() : Inherited(&theInfo) {}
    BandwidthReject(const BandwidthReject & other) : Inherited(other)
    {}
    BandwidthReject& operator = (const BandwidthReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class rejectReason {
      public:
        typedef BandRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class allowedBandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class allowedBandWidth
    allowedBandWidth::const_reference get_allowedBandWidth () const;
    allowedBandWidth::reference ref_allowedBandWidth ();
    allowedBandWidth::reference set_allowedBandWidth ();
    allowedBandWidth::reference set_allowedBandWidth (allowedBandWidth::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(BandwidthReject& other);
    BandwidthReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[9];
    static int fieldIds[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[9];
#endif
};

//
// DisengageReject
//

class DisengageReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DisengageReject(const void* info) : Inherited(info) {}
  public:
    DisengageReject() : Inherited(&theInfo) {}
    DisengageReject(const DisengageReject & other) : Inherited(other)
    {}
    DisengageReject& operator = (const DisengageReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class rejectReason {
      public:
        typedef DisengageRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(DisengageReject& other);
    DisengageReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// InfoRequest
//

class InfoRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequest(const void* info) : Inherited(info) {}
  public:
    InfoRequest() : Inherited(&theInfo) {}
    InfoRequest(const InfoRequest & other) : Inherited(other)
    {}
    InfoRequest& operator = (const InfoRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_replyAddress,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_uuiesRequested,
      e_callLinkage,
      e_usageInfoRequested,
      e_segmentedResponseSupported,
      e_nextSegmentRequested,
      e_capacityInfoRequested,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class callReferenceValue {
      public:
        typedef CallReferenceValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callReferenceValue
    callReferenceValue::const_reference get_callReferenceValue () const;
    callReferenceValue::reference ref_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue (callReferenceValue::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class replyAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replyAddress
    replyAddress::const_reference get_replyAddress () const;
    replyAddress::reference ref_replyAddress ();
    replyAddress::reference set_replyAddress ();
    replyAddress::reference set_replyAddress (replyAddress::const_reference value);
    void omit_replyAddress ();
    bool replyAddress_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class uuiesRequested {
      public:
        typedef UUIEsRequested value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class uuiesRequested
    uuiesRequested::const_reference get_uuiesRequested () const;
    uuiesRequested::reference ref_uuiesRequested ();
    uuiesRequested::reference set_uuiesRequested ();
    uuiesRequested::reference set_uuiesRequested (uuiesRequested::const_reference value);
    void omit_uuiesRequested ();
    bool uuiesRequested_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class usageInfoRequested {
      public:
        typedef RasUsageInfoTypes value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageInfoRequested
    usageInfoRequested::const_reference get_usageInfoRequested () const;
    usageInfoRequested::reference ref_usageInfoRequested ();
    usageInfoRequested::reference set_usageInfoRequested ();
    usageInfoRequested::reference set_usageInfoRequested (usageInfoRequested::const_reference value);
    void omit_usageInfoRequested ();
    bool usageInfoRequested_isPresent () const;
    class segmentedResponseSupported {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class segmentedResponseSupported
    segmentedResponseSupported::reference set_segmentedResponseSupported ();
    void omit_segmentedResponseSupported ();
    bool segmentedResponseSupported_isPresent () const;
    class nextSegmentRequested {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nextSegmentRequested
    nextSegmentRequested::const_reference get_nextSegmentRequested () const;
    nextSegmentRequested::reference ref_nextSegmentRequested ();
    nextSegmentRequested::reference set_nextSegmentRequested ();
    nextSegmentRequested::reference set_nextSegmentRequested (nextSegmentRequested::value_type::int_type value);
    void omit_nextSegmentRequested ();
    bool nextSegmentRequested_isPresent () const;
    class capacityInfoRequested {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacityInfoRequested
    capacityInfoRequested::reference set_capacityInfoRequested ();
    void omit_capacityInfoRequested ();
    bool capacityInfoRequested_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(InfoRequest& other);
    InfoRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[15];
    static int fieldIds[15];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[15];
#endif
};

//
// InfoRequestAck
//

class InfoRequestAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequestAck(const void* info) : Inherited(info) {}
  public:
    InfoRequestAck() : Inherited(&theInfo) {}
    InfoRequestAck(const InfoRequestAck & other) : Inherited(other)
    {}
    InfoRequestAck& operator = (const InfoRequestAck& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    void swap(InfoRequestAck& other);
    InfoRequestAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// InfoRequestNak
//

class InfoRequestNak : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequestNak(const void* info) : Inherited(info) {}
  public:
    InfoRequestNak() : Inherited(&theInfo) {}
    InfoRequestNak(const InfoRequestNak & other) : Inherited(other)
    {}
    InfoRequestNak& operator = (const InfoRequestNak& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class nakReason {
      public:
        typedef InfoRequestNakReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nakReason
    nakReason::const_reference get_nakReason () const;
    nakReason::reference ref_nakReason ();
    nakReason::reference set_nakReason ();
    nakReason::reference set_nakReason (nakReason::const_reference value);
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    void swap(InfoRequestNak& other);
    InfoRequestNak * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// UnknownMessageResponse
//

class UnknownMessageResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UnknownMessageResponse(const void* info) : Inherited(info) {}
  public:
    UnknownMessageResponse() : Inherited(&theInfo) {}
    UnknownMessageResponse(const UnknownMessageResponse & other) : Inherited(other)
    {}
    UnknownMessageResponse& operator = (const UnknownMessageResponse& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_messageNotUnderstood
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class messageNotUnderstood {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class messageNotUnderstood
    messageNotUnderstood::const_reference get_messageNotUnderstood () const;
    messageNotUnderstood::reference ref_messageNotUnderstood ();
    messageNotUnderstood::reference set_messageNotUnderstood ();
    messageNotUnderstood::reference set_messageNotUnderstood (const std::vector<char>& value);
    void omit_messageNotUnderstood ();
    bool messageNotUnderstood_isPresent () const;
    void swap(UnknownMessageResponse& other);
    UnknownMessageResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// RequestInProgress
//

class RequestInProgress : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestInProgress(const void* info) : Inherited(info) {}
  public:
    RequestInProgress() : Inherited(&theInfo) {}
    RequestInProgress(const RequestInProgress & other) : Inherited(other)
    {}
    RequestInProgress& operator = (const RequestInProgress& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class delay {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class delay
    delay::const_reference get_delay () const;
    delay::reference ref_delay ();
    delay::reference set_delay ();
    delay::reference set_delay (delay::value_type::int_type value);
    void swap(RequestInProgress& other);
    RequestInProgress * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// ResourcesAvailableConfirm
//

class ResourcesAvailableConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ResourcesAvailableConfirm(const void* info) : Inherited(info) {}
  public:
    ResourcesAvailableConfirm() : Inherited(&theInfo) {}
    ResourcesAvailableConfirm(const ResourcesAvailableConfirm & other) : Inherited(other)
    {}
    ResourcesAvailableConfirm& operator = (const ResourcesAvailableConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(ResourcesAvailableConfirm& other);
    ResourcesAvailableConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

typedef ASN1::SEQUENCE_OF<Connect_UUIE_language_subtype>  Connect_UUIE_language;

typedef ASN1::SEQUENCE_OF<Setup_UUIE_language_subtype>  Setup_UUIE_language;

//
// RegistrationRejectReason_invalidTerminalAliases
//

class RegistrationRejectReason_invalidTerminalAliases : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RegistrationRejectReason_invalidTerminalAliases(const void* info) : Inherited(info) {}
  public:
    RegistrationRejectReason_invalidTerminalAliases() : Inherited(&theInfo) {}
    RegistrationRejectReason_invalidTerminalAliases(const RegistrationRejectReason_invalidTerminalAliases & other) : Inherited(other)
    {}
    RegistrationRejectReason_invalidTerminalAliases& operator = (const RegistrationRejectReason_invalidTerminalAliases& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_terminalAlias,
      e_terminalAliasPattern,
      e_supportedPrefixes
    };

    class terminalAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAlias
    terminalAlias::const_reference get_terminalAlias () const;
    terminalAlias::reference ref_terminalAlias ();
    terminalAlias::reference set_terminalAlias ();
    terminalAlias::reference set_terminalAlias (terminalAlias::const_reference value);
    void omit_terminalAlias ();
    bool terminalAlias_isPresent () const;
    class terminalAliasPattern {
      public:
        typedef ASN1::SEQUENCE_OF<AddressPattern>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAliasPattern
    terminalAliasPattern::const_reference get_terminalAliasPattern () const;
    terminalAliasPattern::reference ref_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern (terminalAliasPattern::const_reference value);
    void omit_terminalAliasPattern ();
    bool terminalAliasPattern_isPresent () const;
    class supportedPrefixes {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedPrefix>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedPrefixes
    supportedPrefixes::const_reference get_supportedPrefixes () const;
    supportedPrefixes::reference ref_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes (supportedPrefixes::const_reference value);
    void omit_supportedPrefixes ();
    bool supportedPrefixes_isPresent () const;
    void swap(RegistrationRejectReason_invalidTerminalAliases& other);
    RegistrationRejectReason_invalidTerminalAliases * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

typedef ASN1::SEQUENCE_OF<AdmissionConfirm_language_subtype>  AdmissionConfirm_language;

//
// Progress_UUIE
//

class Progress_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Progress_UUIE(const void* info) : Inherited(info) {}
  public:
    Progress_UUIE() : Inherited(&theInfo) {}
    Progress_UUIE(const Progress_UUIE & other) : Inherited(other)
    {}
    Progress_UUIE& operator = (const Progress_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h245Address,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class destinationInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class h245SecurityMode {
      public:
        typedef H245Security value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityMode
    h245SecurityMode::const_reference get_h245SecurityMode () const;
    h245SecurityMode::reference ref_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode (h245SecurityMode::const_reference value);
    void omit_h245SecurityMode ();
    bool h245SecurityMode_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    void swap(Progress_UUIE& other);
    Progress_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// Status_UUIE
//

class Status_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Status_UUIE(const void* info) : Inherited(info) {}
  public:
    Status_UUIE() : Inherited(&theInfo) {}
    Status_UUIE(const Status_UUIE & other) : Inherited(other)
    {}
    Status_UUIE& operator = (const Status_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    void swap(Status_UUIE& other);
    Status_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// StatusInquiry_UUIE
//

class StatusInquiry_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    StatusInquiry_UUIE(const void* info) : Inherited(info) {}
  public:
    StatusInquiry_UUIE() : Inherited(&theInfo) {}
    StatusInquiry_UUIE(const StatusInquiry_UUIE & other) : Inherited(other)
    {}
    StatusInquiry_UUIE& operator = (const StatusInquiry_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    void swap(StatusInquiry_UUIE& other);
    StatusInquiry_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// SetupAcknowledge_UUIE
//

class SetupAcknowledge_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SetupAcknowledge_UUIE(const void* info) : Inherited(info) {}
  public:
    SetupAcknowledge_UUIE() : Inherited(&theInfo) {}
    SetupAcknowledge_UUIE(const SetupAcknowledge_UUIE & other) : Inherited(other)
    {}
    SetupAcknowledge_UUIE& operator = (const SetupAcknowledge_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    void swap(SetupAcknowledge_UUIE& other);
    SetupAcknowledge_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// Notify_UUIE
//

class Notify_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Notify_UUIE(const void* info) : Inherited(info) {}
  public:
    Notify_UUIE() : Inherited(&theInfo) {}
    Notify_UUIE(const Notify_UUIE & other) : Inherited(other)
    {}
    Notify_UUIE& operator = (const Notify_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    void swap(Notify_UUIE& other);
    Notify_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// Endpoint
//

class Endpoint : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Endpoint(const void* info) : Inherited(info) {}
  public:
    Endpoint() : Inherited(&theInfo) {}
    Endpoint(const Endpoint & other) : Inherited(other)
    {}
    Endpoint& operator = (const Endpoint& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_aliasAddress,
      e_callSignalAddress,
      e_rasAddress,
      e_endpointType,
      e_tokens,
      e_cryptoTokens,
      e_priority,
      e_remoteExtensionAddress,
      e_destExtraCallInfo,
      e_alternateTransportAddresses
    };

    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class aliasAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aliasAddress
    aliasAddress::const_reference get_aliasAddress () const;
    aliasAddress::reference ref_aliasAddress ();
    aliasAddress::reference set_aliasAddress ();
    aliasAddress::reference set_aliasAddress (aliasAddress::const_reference value);
    void omit_aliasAddress ();
    bool aliasAddress_isPresent () const;
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    void omit_callSignalAddress ();
    bool callSignalAddress_isPresent () const;
    class rasAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    void omit_rasAddress ();
    bool rasAddress_isPresent () const;
    class endpointType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointType
    endpointType::const_reference get_endpointType () const;
    endpointType::reference ref_endpointType ();
    endpointType::reference set_endpointType ();
    endpointType::reference set_endpointType (endpointType::const_reference value);
    void omit_endpointType ();
    bool endpointType_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class priority {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class priority
    priority::const_reference get_priority () const;
    priority::reference ref_priority ();
    priority::reference set_priority ();
    priority::reference set_priority (priority::value_type::int_type value);
    void omit_priority ();
    bool priority_isPresent () const;
    class remoteExtensionAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteExtensionAddress
    remoteExtensionAddress::const_reference get_remoteExtensionAddress () const;
    remoteExtensionAddress::reference ref_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress (remoteExtensionAddress::const_reference value);
    void omit_remoteExtensionAddress ();
    bool remoteExtensionAddress_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class alternateTransportAddresses {
      public:
        typedef AlternateTransportAddresses value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateTransportAddresses
    alternateTransportAddresses::const_reference get_alternateTransportAddresses () const;
    alternateTransportAddresses::reference ref_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses (alternateTransportAddresses::const_reference value);
    void omit_alternateTransportAddresses ();
    bool alternateTransportAddresses_isPresent () const;
    void swap(Endpoint& other);
    Endpoint * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

typedef GenericData FeatureDescriptor;
//
// CallCapacity
//

class CallCapacity : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallCapacity(const void* info) : Inherited(info) {}
  public:
    CallCapacity() : Inherited(&theInfo) {}
    CallCapacity(const CallCapacity & other) : Inherited(other)
    {}
    CallCapacity& operator = (const CallCapacity& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_maximumCallCapacity,
      e_currentCallCapacity
    };

    class maximumCallCapacity {
      public:
        typedef CallCapacityInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumCallCapacity
    maximumCallCapacity::const_reference get_maximumCallCapacity () const;
    maximumCallCapacity::reference ref_maximumCallCapacity ();
    maximumCallCapacity::reference set_maximumCallCapacity ();
    maximumCallCapacity::reference set_maximumCallCapacity (maximumCallCapacity::const_reference value);
    void omit_maximumCallCapacity ();
    bool maximumCallCapacity_isPresent () const;
    class currentCallCapacity {
      public:
        typedef CallCapacityInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class currentCallCapacity
    currentCallCapacity::const_reference get_currentCallCapacity () const;
    currentCallCapacity::reference ref_currentCallCapacity ();
    currentCallCapacity::reference set_currentCallCapacity ();
    currentCallCapacity::reference set_currentCallCapacity (currentCallCapacity::const_reference value);
    void omit_currentCallCapacity ();
    bool currentCallCapacity_isPresent () const;
    void swap(CallCapacity& other);
    CallCapacity * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CircuitIdentifier
//

class CircuitIdentifier : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CircuitIdentifier(const void* info) : Inherited(info) {}
  public:
    CircuitIdentifier() : Inherited(&theInfo) {}
    CircuitIdentifier(const CircuitIdentifier & other) : Inherited(other)
    {}
    CircuitIdentifier& operator = (const CircuitIdentifier& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_cic,
      e_group
    };

    class cic {
      public:
        typedef CicInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cic
    cic::const_reference get_cic () const;
    cic::reference ref_cic ();
    cic::reference set_cic ();
    cic::reference set_cic (cic::const_reference value);
    void omit_cic ();
    bool cic_isPresent () const;
    class group {
      public:
        typedef GroupID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class group
    group::const_reference get_group () const;
    group::reference ref_group ();
    group::reference set_group ();
    group::reference set_group (group::const_reference value);
    void omit_group ();
    bool group_isPresent () const;
    void swap(CircuitIdentifier& other);
    CircuitIdentifier * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ServiceControlDescriptor
//

class ServiceControlDescriptor : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ServiceControlDescriptor(const void* info) : Inherited(info) {}
  public:
    ServiceControlDescriptor() : Inherited(&theInfo) {}
    class url {
      public:
        enum Id { id_ = 0 };
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class url

    url::const_reference get_url () const;
    url::reference ref_url (); 
    url::reference select_url (); 
    url::reference select_url (const std::string& value); 
    bool url_isSelected() const;

    class signal {
      public:
        enum Id { id_ = 1 };
        typedef H248SignalsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signal

    signal::const_reference get_signal () const;
    signal::reference ref_signal (); 
    signal::reference select_signal (); 
    signal::reference select_signal (const std::vector<char>& value); 
    bool signal_isSelected() const;

    class nonStandard {
      public:
        enum Id { id_ = 2 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class callCreditServiceControl {
      public:
        enum Id { id_ = 3 };
        typedef CallCreditServiceControl value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callCreditServiceControl

    callCreditServiceControl::const_reference get_callCreditServiceControl () const;
    callCreditServiceControl::reference ref_callCreditServiceControl (); 
    callCreditServiceControl::reference select_callCreditServiceControl (); 
    callCreditServiceControl::reference select_callCreditServiceControl (callCreditServiceControl::const_reference value); 
    bool callCreditServiceControl_isSelected() const;

    ServiceControlDescriptor(url::Id id, const std::string& value);
    ServiceControlDescriptor(signal::Id id, const std::vector<char>& value);
    ServiceControlDescriptor(nonStandard::Id id, nonStandard::const_reference value);
    ServiceControlDescriptor(callCreditServiceControl::Id id, callCreditServiceControl::const_reference value);
    void swap(ServiceControlDescriptor & other);
    ServiceControlDescriptor(const ServiceControlDescriptor & other)
    : Inherited(other) {} 

    ServiceControlDescriptor & operator = (const ServiceControlDescriptor & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ServiceControlDescriptor * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// ServiceControlSession
//

class ServiceControlSession : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceControlSession(const void* info) : Inherited(info) {}
  public:
    ServiceControlSession() : Inherited(&theInfo) {}
    ServiceControlSession(const ServiceControlSession & other) : Inherited(other)
    {}
    ServiceControlSession& operator = (const ServiceControlSession& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_contents
    };

    class sessionId {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionId
    sessionId::const_reference get_sessionId () const;
    sessionId::reference ref_sessionId ();
    sessionId::reference set_sessionId ();
    sessionId::reference set_sessionId (sessionId::value_type::int_type value);
    class contents {
      public:
        typedef ServiceControlDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contents
    contents::const_reference get_contents () const;
    contents::reference ref_contents ();
    contents::reference set_contents ();
    contents::reference set_contents (contents::const_reference value);
    void omit_contents ();
    bool contents_isPresent () const;
    class reason {
      public:
        typedef ServiceControlSession_reason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    void swap(ServiceControlSession& other);
    ServiceControlSession * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// FeatureSet
//

class FeatureSet : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    FeatureSet(const void* info) : Inherited(info) {}
  public:
    FeatureSet() : Inherited(&theInfo) {}
    FeatureSet(const FeatureSet & other) : Inherited(other)
    {}
    FeatureSet& operator = (const FeatureSet& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_neededFeatures,
      e_desiredFeatures,
      e_supportedFeatures
    };

    class replacementFeatureSet {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replacementFeatureSet
    replacementFeatureSet::const_reference get_replacementFeatureSet () const;
    replacementFeatureSet::reference ref_replacementFeatureSet ();
    replacementFeatureSet::reference set_replacementFeatureSet ();
    replacementFeatureSet::reference set_replacementFeatureSet (bool value);
    class neededFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatures
    neededFeatures::const_reference get_neededFeatures () const;
    neededFeatures::reference ref_neededFeatures ();
    neededFeatures::reference set_neededFeatures ();
    neededFeatures::reference set_neededFeatures (neededFeatures::const_reference value);
    void omit_neededFeatures ();
    bool neededFeatures_isPresent () const;
    class desiredFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredFeatures
    desiredFeatures::const_reference get_desiredFeatures () const;
    desiredFeatures::reference ref_desiredFeatures ();
    desiredFeatures::reference set_desiredFeatures ();
    desiredFeatures::reference set_desiredFeatures (desiredFeatures::const_reference value);
    void omit_desiredFeatures ();
    bool desiredFeatures_isPresent () const;
    class supportedFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedFeatures
    supportedFeatures::const_reference get_supportedFeatures () const;
    supportedFeatures::reference ref_supportedFeatures ();
    supportedFeatures::reference set_supportedFeatures ();
    supportedFeatures::reference set_supportedFeatures (supportedFeatures::const_reference value);
    void omit_supportedFeatures ();
    bool supportedFeatures_isPresent () const;
    void swap(FeatureSet& other);
    FeatureSet * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// GatekeeperRequest
//

class GatekeeperRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    GatekeeperRequest(const void* info) : Inherited(info) {}
  public:
    GatekeeperRequest() : Inherited(&theInfo) {}
    GatekeeperRequest(const GatekeeperRequest & other) : Inherited(other)
    {}
    GatekeeperRequest& operator = (const GatekeeperRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_callServices,
      e_endpointAlias,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_authenticationCapability,
      e_algorithmOIDs,
      e_integrity,
      e_integrityCheckValue,
      e_supportsAltGK,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class rasAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    class endpointType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointType
    endpointType::const_reference get_endpointType () const;
    endpointType::reference ref_endpointType ();
    endpointType::reference set_endpointType ();
    endpointType::reference set_endpointType (endpointType::const_reference value);
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class callServices {
      public:
        typedef QseriesOptions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callServices
    callServices::const_reference get_callServices () const;
    callServices::reference ref_callServices ();
    callServices::reference set_callServices ();
    callServices::reference set_callServices (callServices::const_reference value);
    void omit_callServices ();
    bool callServices_isPresent () const;
    class endpointAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointAlias
    endpointAlias::const_reference get_endpointAlias () const;
    endpointAlias::reference ref_endpointAlias ();
    endpointAlias::reference set_endpointAlias ();
    endpointAlias::reference set_endpointAlias (endpointAlias::const_reference value);
    void omit_endpointAlias ();
    bool endpointAlias_isPresent () const;
    class alternateEndpoints {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateEndpoints
    alternateEndpoints::const_reference get_alternateEndpoints () const;
    alternateEndpoints::reference ref_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints (alternateEndpoints::const_reference value);
    void omit_alternateEndpoints ();
    bool alternateEndpoints_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class authenticationCapability {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::AuthenticationMechanism>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class authenticationCapability
    authenticationCapability::const_reference get_authenticationCapability () const;
    authenticationCapability::reference ref_authenticationCapability ();
    authenticationCapability::reference set_authenticationCapability ();
    authenticationCapability::reference set_authenticationCapability (authenticationCapability::const_reference value);
    void omit_authenticationCapability ();
    bool authenticationCapability_isPresent () const;
    class algorithmOIDs {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OBJECT_IDENTIFIER>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOIDs
    algorithmOIDs::const_reference get_algorithmOIDs () const;
    algorithmOIDs::reference ref_algorithmOIDs ();
    algorithmOIDs::reference set_algorithmOIDs ();
    algorithmOIDs::reference set_algorithmOIDs (algorithmOIDs::const_reference value);
    void omit_algorithmOIDs ();
    bool algorithmOIDs_isPresent () const;
    class integrity {
      public:
        typedef ASN1::SEQUENCE_OF<IntegrityMechanism>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrity
    integrity::const_reference get_integrity () const;
    integrity::reference ref_integrity ();
    integrity::reference set_integrity ();
    integrity::reference set_integrity (integrity::const_reference value);
    void omit_integrity ();
    bool integrity_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class supportsAltGK {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportsAltGK
    supportsAltGK::reference set_supportsAltGK ();
    void omit_supportsAltGK ();
    bool supportsAltGK_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(GatekeeperRequest& other);
    GatekeeperRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[18];
    static int fieldIds[18];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[18];
#endif
};

//
// GatekeeperConfirm
//

class GatekeeperConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    GatekeeperConfirm(const void* info) : Inherited(info) {}
  public:
    GatekeeperConfirm() : Inherited(&theInfo) {}
    GatekeeperConfirm(const GatekeeperConfirm & other) : Inherited(other)
    {}
    GatekeeperConfirm& operator = (const GatekeeperConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_alternateGatekeeper,
      e_authenticationMode,
      e_tokens,
      e_cryptoTokens,
      e_algorithmOID,
      e_integrity,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class rasAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    class alternateGatekeeper {
      public:
        typedef ASN1::SEQUENCE_OF<AlternateGK>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateGatekeeper
    alternateGatekeeper::const_reference get_alternateGatekeeper () const;
    alternateGatekeeper::reference ref_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper (alternateGatekeeper::const_reference value);
    void omit_alternateGatekeeper ();
    bool alternateGatekeeper_isPresent () const;
    class authenticationMode {
      public:
        typedef H235_SECURITY_MESSAGES::AuthenticationMechanism value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class authenticationMode
    authenticationMode::const_reference get_authenticationMode () const;
    authenticationMode::reference ref_authenticationMode ();
    authenticationMode::reference set_authenticationMode ();
    authenticationMode::reference set_authenticationMode (authenticationMode::const_reference value);
    void omit_authenticationMode ();
    bool authenticationMode_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class algorithmOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOID
    algorithmOID::const_reference get_algorithmOID () const;
    algorithmOID::reference ref_algorithmOID ();
    algorithmOID::reference set_algorithmOID ();
    algorithmOID::reference set_algorithmOID (algorithmOID::const_reference value);
    void omit_algorithmOID ();
    bool algorithmOID_isPresent () const;
    class integrity {
      public:
        typedef ASN1::SEQUENCE_OF<IntegrityMechanism>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrity
    integrity::const_reference get_integrity () const;
    integrity::reference ref_integrity ();
    integrity::reference set_integrity ();
    integrity::reference set_integrity (integrity::const_reference value);
    void omit_integrity ();
    bool integrity_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(GatekeeperConfirm& other);
    GatekeeperConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[14];
    static int fieldIds[14];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[14];
#endif
};

//
// GatekeeperReject
//

class GatekeeperReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    GatekeeperReject(const void* info) : Inherited(info) {}
  public:
    GatekeeperReject() : Inherited(&theInfo) {}
    GatekeeperReject(const GatekeeperReject & other) : Inherited(other)
    {}
    GatekeeperReject& operator = (const GatekeeperReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class rejectReason {
      public:
        typedef GatekeeperRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(GatekeeperReject& other);
    GatekeeperReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// RegistrationRequest
//

class RegistrationRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RegistrationRequest(const void* info) : Inherited(info) {}
  public:
    RegistrationRequest() : Inherited(&theInfo) {}
    RegistrationRequest(const RegistrationRequest & other) : Inherited(other)
    {}
    RegistrationRequest& operator = (const RegistrationRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_terminalAlias,
      e_gatekeeperIdentifier,
      e_alternateEndpoints,
      e_timeToLive,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_keepAlive,
      e_endpointIdentifier,
      e_willSupplyUUIEs,
      e_maintainConnection,
      e_alternateTransportAddresses,
      e_additiveRegistration,
      e_terminalAliasPattern,
      e_supportsAltGK,
      e_usageReportingCapability,
      e_multipleCalls,
      e_supportedH248Packages,
      e_callCreditCapability,
      e_capacityReportingCapability,
      e_capacity,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class discoveryComplete {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class discoveryComplete
    discoveryComplete::const_reference get_discoveryComplete () const;
    discoveryComplete::reference ref_discoveryComplete ();
    discoveryComplete::reference set_discoveryComplete ();
    discoveryComplete::reference set_discoveryComplete (bool value);
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    class rasAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    class terminalType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalType
    terminalType::const_reference get_terminalType () const;
    terminalType::reference ref_terminalType ();
    terminalType::reference set_terminalType ();
    terminalType::reference set_terminalType (terminalType::const_reference value);
    class terminalAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAlias
    terminalAlias::const_reference get_terminalAlias () const;
    terminalAlias::reference ref_terminalAlias ();
    terminalAlias::reference set_terminalAlias ();
    terminalAlias::reference set_terminalAlias (terminalAlias::const_reference value);
    void omit_terminalAlias ();
    bool terminalAlias_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class endpointVendor {
      public:
        typedef VendorIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointVendor
    endpointVendor::const_reference get_endpointVendor () const;
    endpointVendor::reference ref_endpointVendor ();
    endpointVendor::reference set_endpointVendor ();
    endpointVendor::reference set_endpointVendor (endpointVendor::const_reference value);
    class alternateEndpoints {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateEndpoints
    alternateEndpoints::const_reference get_alternateEndpoints () const;
    alternateEndpoints::reference ref_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints (alternateEndpoints::const_reference value);
    void omit_alternateEndpoints ();
    bool alternateEndpoints_isPresent () const;
    class timeToLive {
      public:
        typedef TimeToLive value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeToLive
    timeToLive::const_reference get_timeToLive () const;
    timeToLive::reference ref_timeToLive ();
    timeToLive::reference set_timeToLive ();
    timeToLive::reference set_timeToLive (timeToLive::value_type::int_type value);
    void omit_timeToLive ();
    bool timeToLive_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class keepAlive {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keepAlive
    keepAlive::const_reference get_keepAlive () const;
    keepAlive::reference ref_keepAlive ();
    keepAlive::reference set_keepAlive ();
    keepAlive::reference set_keepAlive (bool value);
    void omit_keepAlive ();
    bool keepAlive_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    void omit_endpointIdentifier ();
    bool endpointIdentifier_isPresent () const;
    class willSupplyUUIEs {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willSupplyUUIEs
    willSupplyUUIEs::const_reference get_willSupplyUUIEs () const;
    willSupplyUUIEs::reference ref_willSupplyUUIEs ();
    willSupplyUUIEs::reference set_willSupplyUUIEs ();
    willSupplyUUIEs::reference set_willSupplyUUIEs (bool value);
    void omit_willSupplyUUIEs ();
    bool willSupplyUUIEs_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class alternateTransportAddresses {
      public:
        typedef AlternateTransportAddresses value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateTransportAddresses
    alternateTransportAddresses::const_reference get_alternateTransportAddresses () const;
    alternateTransportAddresses::reference ref_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses (alternateTransportAddresses::const_reference value);
    void omit_alternateTransportAddresses ();
    bool alternateTransportAddresses_isPresent () const;
    class additiveRegistration {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class additiveRegistration
    additiveRegistration::reference set_additiveRegistration ();
    void omit_additiveRegistration ();
    bool additiveRegistration_isPresent () const;
    class terminalAliasPattern {
      public:
        typedef ASN1::SEQUENCE_OF<AddressPattern>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAliasPattern
    terminalAliasPattern::const_reference get_terminalAliasPattern () const;
    terminalAliasPattern::reference ref_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern (terminalAliasPattern::const_reference value);
    void omit_terminalAliasPattern ();
    bool terminalAliasPattern_isPresent () const;
    class supportsAltGK {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportsAltGK
    supportsAltGK::reference set_supportsAltGK ();
    void omit_supportsAltGK ();
    bool supportsAltGK_isPresent () const;
    class usageReportingCapability {
      public:
        typedef RasUsageInfoTypes value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageReportingCapability
    usageReportingCapability::const_reference get_usageReportingCapability () const;
    usageReportingCapability::reference ref_usageReportingCapability ();
    usageReportingCapability::reference set_usageReportingCapability ();
    usageReportingCapability::reference set_usageReportingCapability (usageReportingCapability::const_reference value);
    void omit_usageReportingCapability ();
    bool usageReportingCapability_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class supportedH248Packages {
      public:
        typedef ASN1::SEQUENCE_OF<H248PackagesDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedH248Packages
    supportedH248Packages::const_reference get_supportedH248Packages () const;
    supportedH248Packages::reference ref_supportedH248Packages ();
    supportedH248Packages::reference set_supportedH248Packages ();
    supportedH248Packages::reference set_supportedH248Packages (supportedH248Packages::const_reference value);
    void omit_supportedH248Packages ();
    bool supportedH248Packages_isPresent () const;
    class callCreditCapability {
      public:
        typedef CallCreditCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callCreditCapability
    callCreditCapability::const_reference get_callCreditCapability () const;
    callCreditCapability::reference ref_callCreditCapability ();
    callCreditCapability::reference set_callCreditCapability ();
    callCreditCapability::reference set_callCreditCapability (callCreditCapability::const_reference value);
    void omit_callCreditCapability ();
    bool callCreditCapability_isPresent () const;
    class capacityReportingCapability {
      public:
        typedef CapacityReportingCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacityReportingCapability
    capacityReportingCapability::const_reference get_capacityReportingCapability () const;
    capacityReportingCapability::reference ref_capacityReportingCapability ();
    capacityReportingCapability::reference set_capacityReportingCapability ();
    capacityReportingCapability::reference set_capacityReportingCapability (capacityReportingCapability::const_reference value);
    void omit_capacityReportingCapability ();
    bool capacityReportingCapability_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(RegistrationRequest& other);
    RegistrationRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[31];
    static int fieldIds[31];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[31];
#endif
};

//
// RegistrationConfirm
//

class RegistrationConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RegistrationConfirm(const void* info) : Inherited(info) {}
  public:
    RegistrationConfirm() : Inherited(&theInfo) {}
    RegistrationConfirm(const RegistrationConfirm & other) : Inherited(other)
    {}
    RegistrationConfirm& operator = (const RegistrationConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_terminalAlias,
      e_gatekeeperIdentifier,
      e_alternateGatekeeper,
      e_timeToLive,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_willRespondToIRR,
      e_preGrantedARQ,
      e_maintainConnection,
      e_serviceControl,
      e_supportsAdditiveRegistration,
      e_terminalAliasPattern,
      e_supportedPrefixes,
      e_usageSpec,
      e_featureServerAlias,
      e_capacityReportingSpec,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    class terminalAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAlias
    terminalAlias::const_reference get_terminalAlias () const;
    terminalAlias::reference ref_terminalAlias ();
    terminalAlias::reference set_terminalAlias ();
    terminalAlias::reference set_terminalAlias (terminalAlias::const_reference value);
    void omit_terminalAlias ();
    bool terminalAlias_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class alternateGatekeeper {
      public:
        typedef ASN1::SEQUENCE_OF<AlternateGK>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateGatekeeper
    alternateGatekeeper::const_reference get_alternateGatekeeper () const;
    alternateGatekeeper::reference ref_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper (alternateGatekeeper::const_reference value);
    void omit_alternateGatekeeper ();
    bool alternateGatekeeper_isPresent () const;
    class timeToLive {
      public:
        typedef TimeToLive value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeToLive
    timeToLive::const_reference get_timeToLive () const;
    timeToLive::reference ref_timeToLive ();
    timeToLive::reference set_timeToLive ();
    timeToLive::reference set_timeToLive (timeToLive::value_type::int_type value);
    void omit_timeToLive ();
    bool timeToLive_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class willRespondToIRR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willRespondToIRR
    willRespondToIRR::const_reference get_willRespondToIRR () const;
    willRespondToIRR::reference ref_willRespondToIRR ();
    willRespondToIRR::reference set_willRespondToIRR ();
    willRespondToIRR::reference set_willRespondToIRR (bool value);
    void omit_willRespondToIRR ();
    bool willRespondToIRR_isPresent () const;
    class preGrantedARQ {
      public:
        typedef RegistrationConfirm_preGrantedARQ value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class preGrantedARQ
    preGrantedARQ::const_reference get_preGrantedARQ () const;
    preGrantedARQ::reference ref_preGrantedARQ ();
    preGrantedARQ::reference set_preGrantedARQ ();
    preGrantedARQ::reference set_preGrantedARQ (preGrantedARQ::const_reference value);
    void omit_preGrantedARQ ();
    bool preGrantedARQ_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class supportsAdditiveRegistration {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportsAdditiveRegistration
    supportsAdditiveRegistration::reference set_supportsAdditiveRegistration ();
    void omit_supportsAdditiveRegistration ();
    bool supportsAdditiveRegistration_isPresent () const;
    class terminalAliasPattern {
      public:
        typedef ASN1::SEQUENCE_OF<AddressPattern>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalAliasPattern
    terminalAliasPattern::const_reference get_terminalAliasPattern () const;
    terminalAliasPattern::reference ref_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern ();
    terminalAliasPattern::reference set_terminalAliasPattern (terminalAliasPattern::const_reference value);
    void omit_terminalAliasPattern ();
    bool terminalAliasPattern_isPresent () const;
    class supportedPrefixes {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedPrefix>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedPrefixes
    supportedPrefixes::const_reference get_supportedPrefixes () const;
    supportedPrefixes::reference ref_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes (supportedPrefixes::const_reference value);
    void omit_supportedPrefixes ();
    bool supportedPrefixes_isPresent () const;
    class usageSpec {
      public:
        typedef ASN1::SEQUENCE_OF<RasUsageSpecification>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageSpec
    usageSpec::const_reference get_usageSpec () const;
    usageSpec::reference ref_usageSpec ();
    usageSpec::reference set_usageSpec ();
    usageSpec::reference set_usageSpec (usageSpec::const_reference value);
    void omit_usageSpec ();
    bool usageSpec_isPresent () const;
    class featureServerAlias {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureServerAlias
    featureServerAlias::const_reference get_featureServerAlias () const;
    featureServerAlias::reference ref_featureServerAlias ();
    featureServerAlias::reference set_featureServerAlias ();
    featureServerAlias::reference set_featureServerAlias (featureServerAlias::const_reference value);
    void omit_featureServerAlias ();
    bool featureServerAlias_isPresent () const;
    class capacityReportingSpec {
      public:
        typedef CapacityReportingSpecification value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacityReportingSpec
    capacityReportingSpec::const_reference get_capacityReportingSpec () const;
    capacityReportingSpec::reference ref_capacityReportingSpec ();
    capacityReportingSpec::reference set_capacityReportingSpec ();
    capacityReportingSpec::reference set_capacityReportingSpec (capacityReportingSpec::const_reference value);
    void omit_capacityReportingSpec ();
    bool capacityReportingSpec_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(RegistrationConfirm& other);
    RegistrationConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[24];
    static int fieldIds[24];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[24];
#endif
};

//
// RegistrationRejectReason
//

class RegistrationRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RegistrationRejectReason(const void* info) : Inherited(info) {}
  public:
    RegistrationRejectReason() : Inherited(&theInfo) {}
    class discoveryRequired {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class discoveryRequired

    discoveryRequired::reference select_discoveryRequired (); 
    bool discoveryRequired_isSelected() const;

    class invalidRevision {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidRevision

    invalidRevision::reference select_invalidRevision (); 
    bool invalidRevision_isSelected() const;

    class invalidCallSignalAddress {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidCallSignalAddress

    invalidCallSignalAddress::reference select_invalidCallSignalAddress (); 
    bool invalidCallSignalAddress_isSelected() const;

    class invalidRASAddress {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidRASAddress

    invalidRASAddress::reference select_invalidRASAddress (); 
    bool invalidRASAddress_isSelected() const;

    class duplicateAlias {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class duplicateAlias

    duplicateAlias::const_reference get_duplicateAlias () const;
    duplicateAlias::reference ref_duplicateAlias (); 
    duplicateAlias::reference select_duplicateAlias (); 
    duplicateAlias::reference select_duplicateAlias (duplicateAlias::const_reference value); 
    bool duplicateAlias_isSelected() const;

    class invalidTerminalType {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidTerminalType

    invalidTerminalType::reference select_invalidTerminalType (); 
    bool invalidTerminalType_isSelected() const;

    class undefinedReason {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class transportNotSupported {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportNotSupported

    transportNotSupported::reference select_transportNotSupported (); 
    bool transportNotSupported_isSelected() const;

    class transportQOSNotSupported {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportQOSNotSupported

    transportQOSNotSupported::reference select_transportQOSNotSupported (); 
    bool transportQOSNotSupported_isSelected() const;

    class resourceUnavailable {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceUnavailable

    resourceUnavailable::reference select_resourceUnavailable (); 
    bool resourceUnavailable_isSelected() const;

    class invalidAlias {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidAlias

    invalidAlias::reference select_invalidAlias (); 
    bool invalidAlias_isSelected() const;

    class securityDenial {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class securityDenial

    securityDenial::reference select_securityDenial (); 
    bool securityDenial_isSelected() const;

    class fullRegistrationRequired {
      public:
        enum Id { id_ = 12 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fullRegistrationRequired

    fullRegistrationRequired::reference select_fullRegistrationRequired (); 
    bool fullRegistrationRequired_isSelected() const;

    class additiveRegistrationNotSupported {
      public:
        enum Id { id_ = 13 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class additiveRegistrationNotSupported

    additiveRegistrationNotSupported::reference select_additiveRegistrationNotSupported (); 
    bool additiveRegistrationNotSupported_isSelected() const;

    class invalidTerminalAliases {
      public:
        enum Id { id_ = 14 };
        typedef RegistrationRejectReason_invalidTerminalAliases value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidTerminalAliases

    invalidTerminalAliases::const_reference get_invalidTerminalAliases () const;
    invalidTerminalAliases::reference ref_invalidTerminalAliases (); 
    invalidTerminalAliases::reference select_invalidTerminalAliases (); 
    invalidTerminalAliases::reference select_invalidTerminalAliases (invalidTerminalAliases::const_reference value); 
    bool invalidTerminalAliases_isSelected() const;

    class genericDataReason {
      public:
        enum Id { id_ = 15 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataReason

    genericDataReason::reference select_genericDataReason (); 
    bool genericDataReason_isSelected() const;

    class neededFeatureNotSupported {
      public:
        enum Id { id_ = 16 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatureNotSupported

    neededFeatureNotSupported::reference select_neededFeatureNotSupported (); 
    bool neededFeatureNotSupported_isSelected() const;

    RegistrationRejectReason(discoveryRequired::Id id, discoveryRequired::const_reference value);
    RegistrationRejectReason(invalidRevision::Id id, invalidRevision::const_reference value);
    RegistrationRejectReason(invalidCallSignalAddress::Id id, invalidCallSignalAddress::const_reference value);
    RegistrationRejectReason(invalidRASAddress::Id id, invalidRASAddress::const_reference value);
    RegistrationRejectReason(duplicateAlias::Id id, duplicateAlias::const_reference value);
    RegistrationRejectReason(invalidTerminalType::Id id, invalidTerminalType::const_reference value);
    RegistrationRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    RegistrationRejectReason(transportNotSupported::Id id, transportNotSupported::const_reference value);
    RegistrationRejectReason(transportQOSNotSupported::Id id, transportQOSNotSupported::const_reference value);
    RegistrationRejectReason(resourceUnavailable::Id id, resourceUnavailable::const_reference value);
    RegistrationRejectReason(invalidAlias::Id id, invalidAlias::const_reference value);
    RegistrationRejectReason(securityDenial::Id id, securityDenial::const_reference value);
    RegistrationRejectReason(fullRegistrationRequired::Id id, fullRegistrationRequired::const_reference value);
    RegistrationRejectReason(additiveRegistrationNotSupported::Id id, additiveRegistrationNotSupported::const_reference value);
    RegistrationRejectReason(invalidTerminalAliases::Id id, invalidTerminalAliases::const_reference value);
    RegistrationRejectReason(genericDataReason::Id id, genericDataReason::const_reference value);
    RegistrationRejectReason(neededFeatureNotSupported::Id id, neededFeatureNotSupported::const_reference value);
    void swap(RegistrationRejectReason & other);
    RegistrationRejectReason(const RegistrationRejectReason & other)
    : Inherited(other) {} 

    RegistrationRejectReason & operator = (const RegistrationRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RegistrationRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[17];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[17];
#endif
};

//
// UnregistrationRequest
//

class UnregistrationRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UnregistrationRequest(const void* info) : Inherited(info) {}
  public:
    UnregistrationRequest() : Inherited(&theInfo) {}
    UnregistrationRequest(const UnregistrationRequest & other) : Inherited(other)
    {}
    UnregistrationRequest& operator = (const UnregistrationRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_endpointAlias,
      e_nonStandardData,
      e_endpointIdentifier,
      e_alternateEndpoints,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_reason,
      e_endpointAliasPattern,
      e_supportedPrefixes,
      e_alternateGatekeeper,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    class endpointAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointAlias
    endpointAlias::const_reference get_endpointAlias () const;
    endpointAlias::reference ref_endpointAlias ();
    endpointAlias::reference set_endpointAlias ();
    endpointAlias::reference set_endpointAlias (endpointAlias::const_reference value);
    void omit_endpointAlias ();
    bool endpointAlias_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    void omit_endpointIdentifier ();
    bool endpointIdentifier_isPresent () const;
    class alternateEndpoints {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateEndpoints
    alternateEndpoints::const_reference get_alternateEndpoints () const;
    alternateEndpoints::reference ref_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints (alternateEndpoints::const_reference value);
    void omit_alternateEndpoints ();
    bool alternateEndpoints_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class reason {
      public:
        typedef UnregRequestReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    void omit_reason ();
    bool reason_isPresent () const;
    class endpointAliasPattern {
      public:
        typedef ASN1::SEQUENCE_OF<AddressPattern>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointAliasPattern
    endpointAliasPattern::const_reference get_endpointAliasPattern () const;
    endpointAliasPattern::reference ref_endpointAliasPattern ();
    endpointAliasPattern::reference set_endpointAliasPattern ();
    endpointAliasPattern::reference set_endpointAliasPattern (endpointAliasPattern::const_reference value);
    void omit_endpointAliasPattern ();
    bool endpointAliasPattern_isPresent () const;
    class supportedPrefixes {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedPrefix>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedPrefixes
    supportedPrefixes::const_reference get_supportedPrefixes () const;
    supportedPrefixes::reference ref_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes ();
    supportedPrefixes::reference set_supportedPrefixes (supportedPrefixes::const_reference value);
    void omit_supportedPrefixes ();
    bool supportedPrefixes_isPresent () const;
    class alternateGatekeeper {
      public:
        typedef ASN1::SEQUENCE_OF<AlternateGK>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateGatekeeper
    alternateGatekeeper::const_reference get_alternateGatekeeper () const;
    alternateGatekeeper::reference ref_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper ();
    alternateGatekeeper::reference set_alternateGatekeeper (alternateGatekeeper::const_reference value);
    void omit_alternateGatekeeper ();
    bool alternateGatekeeper_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(UnregistrationRequest& other);
    UnregistrationRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[15];
    static int fieldIds[15];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[15];
#endif
};

//
// AdmissionReject
//

class AdmissionReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AdmissionReject(const void* info) : Inherited(info) {}
  public:
    AdmissionReject() : Inherited(&theInfo) {}
    AdmissionReject(const AdmissionReject & other) : Inherited(other)
    {}
    AdmissionReject& operator = (const AdmissionReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_callSignalAddress,
      e_integrityCheckValue,
      e_serviceControl,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class rejectReason {
      public:
        typedef AdmissionRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    void omit_callSignalAddress ();
    bool callSignalAddress_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(AdmissionReject& other);
    AdmissionReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// BandwidthRequest
//

class BandwidthRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    BandwidthRequest(const void* info) : Inherited(info) {}
  public:
    BandwidthRequest() : Inherited(&theInfo) {}
    BandwidthRequest(const BandwidthRequest & other) : Inherited(other)
    {}
    BandwidthRequest& operator = (const BandwidthRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_callType,
      e_nonStandardData,
      e_callIdentifier,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_answeredCall,
      e_callLinkage,
      e_capacity,
      e_usageInformation,
      e_bandwidthDetails,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class callReferenceValue {
      public:
        typedef CallReferenceValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callReferenceValue
    callReferenceValue::const_reference get_callReferenceValue () const;
    callReferenceValue::reference ref_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue (callReferenceValue::value_type::int_type value);
    class callType {
      public:
        typedef CallType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callType
    callType::const_reference get_callType () const;
    callType::reference ref_callType ();
    callType::reference set_callType ();
    callType::reference set_callType (callType::const_reference value);
    void omit_callType ();
    bool callType_isPresent () const;
    class bandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandWidth
    bandWidth::const_reference get_bandWidth () const;
    bandWidth::reference ref_bandWidth ();
    bandWidth::reference set_bandWidth ();
    bandWidth::reference set_bandWidth (bandWidth::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class answeredCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class answeredCall
    answeredCall::const_reference get_answeredCall () const;
    answeredCall::reference ref_answeredCall ();
    answeredCall::reference set_answeredCall ();
    answeredCall::reference set_answeredCall (bool value);
    void omit_answeredCall ();
    bool answeredCall_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class usageInformation {
      public:
        typedef RasUsageInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageInformation
    usageInformation::const_reference get_usageInformation () const;
    usageInformation::reference ref_usageInformation ();
    usageInformation::reference set_usageInformation ();
    usageInformation::reference set_usageInformation (usageInformation::const_reference value);
    void omit_usageInformation ();
    bool usageInformation_isPresent () const;
    class bandwidthDetails {
      public:
        typedef ASN1::SEQUENCE_OF<BandwidthDetails>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidthDetails
    bandwidthDetails::const_reference get_bandwidthDetails () const;
    bandwidthDetails::reference ref_bandwidthDetails ();
    bandwidthDetails::reference set_bandwidthDetails ();
    bandwidthDetails::reference set_bandwidthDetails (bandwidthDetails::const_reference value);
    void omit_bandwidthDetails ();
    bool bandwidthDetails_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(BandwidthRequest& other);
    BandwidthRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[18];
    static int fieldIds[18];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[18];
#endif
};

//
// BandwidthConfirm
//

class BandwidthConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    BandwidthConfirm(const void* info) : Inherited(info) {}
  public:
    BandwidthConfirm() : Inherited(&theInfo) {}
    BandwidthConfirm(const BandwidthConfirm & other) : Inherited(other)
    {}
    BandwidthConfirm& operator = (const BandwidthConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class bandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandWidth
    bandWidth::const_reference get_bandWidth () const;
    bandWidth::reference ref_bandWidth ();
    bandWidth::reference set_bandWidth ();
    bandWidth::reference set_bandWidth (bandWidth::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(BandwidthConfirm& other);
    BandwidthConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// LocationReject
//

class LocationReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LocationReject(const void* info) : Inherited(info) {}
  public:
    LocationReject() : Inherited(&theInfo) {}
    LocationReject(const LocationReject & other) : Inherited(other)
    {}
    LocationReject& operator = (const LocationReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData,
      e_serviceControl
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class rejectReason {
      public:
        typedef LocationRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    void swap(LocationReject& other);
    LocationReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[10];
    static int fieldIds[10];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[10];
#endif
};

//
// NonStandardMessage
//

class NonStandardMessage : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NonStandardMessage(const void* info) : Inherited(info) {}
  public:
    NonStandardMessage() : Inherited(&theInfo) {}
    NonStandardMessage(const NonStandardMessage & other) : Inherited(other)
    {}
    NonStandardMessage& operator = (const NonStandardMessage& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(NonStandardMessage& other);
    NonStandardMessage * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// ResourcesAvailableIndicate
//

class ResourcesAvailableIndicate : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ResourcesAvailableIndicate(const void* info) : Inherited(info) {}
  public:
    ResourcesAvailableIndicate() : Inherited(&theInfo) {}
    ResourcesAvailableIndicate(const ResourcesAvailableIndicate & other) : Inherited(other)
    {}
    ResourcesAvailableIndicate& operator = (const ResourcesAvailableIndicate& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class protocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocols
    protocols::const_reference get_protocols () const;
    protocols::reference ref_protocols ();
    protocols::reference set_protocols ();
    protocols::reference set_protocols (protocols::const_reference value);
    class almostOutOfResources {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class almostOutOfResources
    almostOutOfResources::const_reference get_almostOutOfResources () const;
    almostOutOfResources::reference ref_almostOutOfResources ();
    almostOutOfResources::reference set_almostOutOfResources ();
    almostOutOfResources::reference set_almostOutOfResources (bool value);
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(ResourcesAvailableIndicate& other);
    ResourcesAvailableIndicate * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// ServiceControlIndication
//

class ServiceControlIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceControlIndication(const void* info) : Inherited(info) {}
  public:
    ServiceControlIndication() : Inherited(&theInfo) {}
    ServiceControlIndication(const ServiceControlIndication & other) : Inherited(other)
    {}
    ServiceControlIndication& operator = (const ServiceControlIndication& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_endpointIdentifier,
      e_callSpecific,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    void omit_endpointIdentifier ();
    bool endpointIdentifier_isPresent () const;
    class callSpecific {
      public:
        typedef ServiceControlIndication_callSpecific value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSpecific
    callSpecific::const_reference get_callSpecific () const;
    callSpecific::reference ref_callSpecific ();
    callSpecific::reference set_callSpecific ();
    callSpecific::reference set_callSpecific (callSpecific::const_reference value);
    void omit_callSpecific ();
    bool callSpecific_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(ServiceControlIndication& other);
    ServiceControlIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[10];
    static int fieldIds[10];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[10];
#endif
};

//
// ServiceControlResponse
//

class ServiceControlResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceControlResponse(const void* info) : Inherited(info) {}
  public:
    ServiceControlResponse() : Inherited(&theInfo) {}
    ServiceControlResponse(const ServiceControlResponse & other) : Inherited(other)
    {}
    ServiceControlResponse& operator = (const ServiceControlResponse& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_result,
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class result {
      public:
        typedef ServiceControlResponse_result value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class result
    result::const_reference get_result () const;
    result::reference ref_result ();
    result::reference set_result ();
    result::reference set_result (result::const_reference value);
    void omit_result ();
    bool result_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(ServiceControlResponse& other);
    ServiceControlResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// Alerting_UUIE
//

class Alerting_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Alerting_UUIE(const void* info) : Inherited(info) {}
  public:
    Alerting_UUIE() : Inherited(&theInfo) {}
    Alerting_UUIE(const Alerting_UUIE & other) : Inherited(other)
    {}
    Alerting_UUIE& operator = (const Alerting_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_alertingAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_fastConnectRefused,
      e_serviceControl,
      e_capacity,
      e_featureSet
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class destinationInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class h245SecurityMode {
      public:
        typedef H245Security value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityMode
    h245SecurityMode::const_reference get_h245SecurityMode () const;
    h245SecurityMode::reference ref_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode (h245SecurityMode::const_reference value);
    void omit_h245SecurityMode ();
    bool h245SecurityMode_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class alertingAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alertingAddress
    alertingAddress::const_reference get_alertingAddress () const;
    alertingAddress::reference ref_alertingAddress ();
    alertingAddress::reference set_alertingAddress ();
    alertingAddress::reference set_alertingAddress (alertingAddress::const_reference value);
    void omit_alertingAddress ();
    bool alertingAddress_isPresent () const;
    class presentationIndicator {
      public:
        typedef PresentationIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationIndicator
    presentationIndicator::const_reference get_presentationIndicator () const;
    presentationIndicator::reference ref_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator (presentationIndicator::const_reference value);
    void omit_presentationIndicator ();
    bool presentationIndicator_isPresent () const;
    class screeningIndicator {
      public:
        typedef ScreeningIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class screeningIndicator
    screeningIndicator::const_reference get_screeningIndicator () const;
    screeningIndicator::reference ref_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator (screeningIndicator::value_type::NamedNumber value);
    void omit_screeningIndicator ();
    bool screeningIndicator_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    void swap(Alerting_UUIE& other);
    Alerting_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[17];
    static int fieldIds[17];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[17];
#endif
};

//
// CallProceeding_UUIE
//

class CallProceeding_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CallProceeding_UUIE(const void* info) : Inherited(info) {}
  public:
    CallProceeding_UUIE() : Inherited(&theInfo) {}
    CallProceeding_UUIE(const CallProceeding_UUIE & other) : Inherited(other)
    {}
    CallProceeding_UUIE& operator = (const CallProceeding_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused,
      e_featureSet
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class destinationInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class h245SecurityMode {
      public:
        typedef H245Security value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityMode
    h245SecurityMode::const_reference get_h245SecurityMode () const;
    h245SecurityMode::reference ref_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode (h245SecurityMode::const_reference value);
    void omit_h245SecurityMode ();
    bool h245SecurityMode_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    void swap(CallProceeding_UUIE& other);
    CallProceeding_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[12];
    static int fieldIds[12];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[12];
#endif
};

//
// Connect_UUIE
//

class Connect_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Connect_UUIE(const void* info) : Inherited(info) {}
  public:
    Connect_UUIE() : Inherited(&theInfo) {}
    Connect_UUIE(const Connect_UUIE & other) : Inherited(other)
    {}
    Connect_UUIE& operator = (const Connect_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h245Address,
      e_callIdentifier,
      e_h245SecurityMode,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_language,
      e_connectedAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_fastConnectRefused,
      e_serviceControl,
      e_capacity,
      e_featureSet
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class destinationInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class h245SecurityMode {
      public:
        typedef H245Security value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityMode
    h245SecurityMode::const_reference get_h245SecurityMode () const;
    h245SecurityMode::reference ref_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode (h245SecurityMode::const_reference value);
    void omit_h245SecurityMode ();
    bool h245SecurityMode_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class language {
      public:
        typedef Connect_UUIE_language value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class language
    language::const_reference get_language () const;
    language::reference ref_language ();
    language::reference set_language ();
    language::reference set_language (language::const_reference value);
    void omit_language ();
    bool language_isPresent () const;
    class connectedAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectedAddress
    connectedAddress::const_reference get_connectedAddress () const;
    connectedAddress::reference ref_connectedAddress ();
    connectedAddress::reference set_connectedAddress ();
    connectedAddress::reference set_connectedAddress (connectedAddress::const_reference value);
    void omit_connectedAddress ();
    bool connectedAddress_isPresent () const;
    class presentationIndicator {
      public:
        typedef PresentationIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationIndicator
    presentationIndicator::const_reference get_presentationIndicator () const;
    presentationIndicator::reference ref_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator (presentationIndicator::const_reference value);
    void omit_presentationIndicator ();
    bool presentationIndicator_isPresent () const;
    class screeningIndicator {
      public:
        typedef ScreeningIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class screeningIndicator
    screeningIndicator::const_reference get_screeningIndicator () const;
    screeningIndicator::reference ref_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator (screeningIndicator::value_type::NamedNumber value);
    void omit_screeningIndicator ();
    bool screeningIndicator_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    void swap(Connect_UUIE& other);
    Connect_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[19];
    static int fieldIds[19];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[19];
#endif
};

//
// ReleaseComplete_UUIE
//

class ReleaseComplete_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ReleaseComplete_UUIE(const void* info) : Inherited(info) {}
  public:
    ReleaseComplete_UUIE() : Inherited(&theInfo) {}
    ReleaseComplete_UUIE(const ReleaseComplete_UUIE & other) : Inherited(other)
    {}
    ReleaseComplete_UUIE& operator = (const ReleaseComplete_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_reason,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_busyAddress,
      e_presentationIndicator,
      e_screeningIndicator,
      e_capacity,
      e_serviceControl,
      e_featureSet
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class reason {
      public:
        typedef ReleaseCompleteReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    void omit_reason ();
    bool reason_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class busyAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class busyAddress
    busyAddress::const_reference get_busyAddress () const;
    busyAddress::reference ref_busyAddress ();
    busyAddress::reference set_busyAddress ();
    busyAddress::reference set_busyAddress (busyAddress::const_reference value);
    void omit_busyAddress ();
    bool busyAddress_isPresent () const;
    class presentationIndicator {
      public:
        typedef PresentationIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationIndicator
    presentationIndicator::const_reference get_presentationIndicator () const;
    presentationIndicator::reference ref_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator (presentationIndicator::const_reference value);
    void omit_presentationIndicator ();
    bool presentationIndicator_isPresent () const;
    class screeningIndicator {
      public:
        typedef ScreeningIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class screeningIndicator
    screeningIndicator::const_reference get_screeningIndicator () const;
    screeningIndicator::reference ref_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator (screeningIndicator::value_type::NamedNumber value);
    void omit_screeningIndicator ();
    bool screeningIndicator_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    void swap(ReleaseComplete_UUIE& other);
    ReleaseComplete_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// CircuitInfo
//

class CircuitInfo : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CircuitInfo(const void* info) : Inherited(info) {}
  public:
    CircuitInfo() : Inherited(&theInfo) {}
    CircuitInfo(const CircuitInfo & other) : Inherited(other)
    {}
    CircuitInfo& operator = (const CircuitInfo& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_sourceCircuitID,
      e_destinationCircuitID,
      e_genericData
    };

    class sourceCircuitID {
      public:
        typedef CircuitIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sourceCircuitID
    sourceCircuitID::const_reference get_sourceCircuitID () const;
    sourceCircuitID::reference ref_sourceCircuitID ();
    sourceCircuitID::reference set_sourceCircuitID ();
    sourceCircuitID::reference set_sourceCircuitID (sourceCircuitID::const_reference value);
    void omit_sourceCircuitID ();
    bool sourceCircuitID_isPresent () const;
    class destinationCircuitID {
      public:
        typedef CircuitIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationCircuitID
    destinationCircuitID::const_reference get_destinationCircuitID () const;
    destinationCircuitID::reference ref_destinationCircuitID ();
    destinationCircuitID::reference set_destinationCircuitID ();
    destinationCircuitID::reference set_destinationCircuitID (destinationCircuitID::const_reference value);
    void omit_destinationCircuitID ();
    bool destinationCircuitID_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(CircuitInfo& other);
    CircuitInfo * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RegistrationReject
//

class RegistrationReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RegistrationReject(const void* info) : Inherited(info) {}
  public:
    RegistrationReject() : Inherited(&theInfo) {}
    RegistrationReject(const RegistrationReject & other) : Inherited(other)
    {}
    RegistrationReject& operator = (const RegistrationReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_gatekeeperIdentifier,
      e_altGKInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class rejectReason {
      public:
        typedef RegistrationRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class altGKInfo {
      public:
        typedef AltGKInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class altGKInfo
    altGKInfo::const_reference get_altGKInfo () const;
    altGKInfo::reference ref_altGKInfo ();
    altGKInfo::reference set_altGKInfo ();
    altGKInfo::reference set_altGKInfo (altGKInfo::const_reference value);
    void omit_altGKInfo ();
    bool altGKInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(RegistrationReject& other);
    RegistrationReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// AdmissionRequest
//

class AdmissionRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AdmissionRequest(const void* info) : Inherited(info) {}
  public:
    AdmissionRequest() : Inherited(&theInfo) {}
    AdmissionRequest(const AdmissionRequest & other) : Inherited(other)
    {}
    AdmissionRequest& operator = (const AdmissionRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_callModel,
      e_destinationInfo,
      e_destCallSignalAddress,
      e_destExtraCallInfo,
      e_srcCallSignalAddress,
      e_nonStandardData,
      e_callServices,
      e_canMapAlias,
      e_callIdentifier,
      e_srcAlternatives,
      e_destAlternatives,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_transportQOS,
      e_willSupplyUUIEs,
      e_callLinkage,
      e_gatewayDataRate,
      e_capacity,
      e_circuitInfo,
      e_desiredProtocols,
      e_desiredTunnelledProtocol,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class callType {
      public:
        typedef CallType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callType
    callType::const_reference get_callType () const;
    callType::reference ref_callType ();
    callType::reference set_callType ();
    callType::reference set_callType (callType::const_reference value);
    class callModel {
      public:
        typedef CallModel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callModel
    callModel::const_reference get_callModel () const;
    callModel::reference ref_callModel ();
    callModel::reference set_callModel ();
    callModel::reference set_callModel (callModel::const_reference value);
    void omit_callModel ();
    bool callModel_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class destinationInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    void omit_destinationInfo ();
    bool destinationInfo_isPresent () const;
    class destCallSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destCallSignalAddress
    destCallSignalAddress::const_reference get_destCallSignalAddress () const;
    destCallSignalAddress::reference ref_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress (destCallSignalAddress::const_reference value);
    void omit_destCallSignalAddress ();
    bool destCallSignalAddress_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class srcInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class srcInfo
    srcInfo::const_reference get_srcInfo () const;
    srcInfo::reference ref_srcInfo ();
    srcInfo::reference set_srcInfo ();
    srcInfo::reference set_srcInfo (srcInfo::const_reference value);
    class srcCallSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class srcCallSignalAddress
    srcCallSignalAddress::const_reference get_srcCallSignalAddress () const;
    srcCallSignalAddress::reference ref_srcCallSignalAddress ();
    srcCallSignalAddress::reference set_srcCallSignalAddress ();
    srcCallSignalAddress::reference set_srcCallSignalAddress (srcCallSignalAddress::const_reference value);
    void omit_srcCallSignalAddress ();
    bool srcCallSignalAddress_isPresent () const;
    class bandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandWidth
    bandWidth::const_reference get_bandWidth () const;
    bandWidth::reference ref_bandWidth ();
    bandWidth::reference set_bandWidth ();
    bandWidth::reference set_bandWidth (bandWidth::const_reference value);
    class callReferenceValue {
      public:
        typedef CallReferenceValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callReferenceValue
    callReferenceValue::const_reference get_callReferenceValue () const;
    callReferenceValue::reference ref_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue (callReferenceValue::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class callServices {
      public:
        typedef QseriesOptions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callServices
    callServices::const_reference get_callServices () const;
    callServices::reference ref_callServices ();
    callServices::reference set_callServices ();
    callServices::reference set_callServices (callServices::const_reference value);
    void omit_callServices ();
    bool callServices_isPresent () const;
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class activeMC {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class activeMC
    activeMC::const_reference get_activeMC () const;
    activeMC::reference ref_activeMC ();
    activeMC::reference set_activeMC ();
    activeMC::reference set_activeMC (bool value);
    class answerCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class answerCall
    answerCall::const_reference get_answerCall () const;
    answerCall::reference ref_answerCall ();
    answerCall::reference set_answerCall ();
    answerCall::reference set_answerCall (bool value);
    class canMapAlias {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canMapAlias
    canMapAlias::const_reference get_canMapAlias () const;
    canMapAlias::reference ref_canMapAlias ();
    canMapAlias::reference set_canMapAlias ();
    canMapAlias::reference set_canMapAlias (bool value);
    void omit_canMapAlias ();
    bool canMapAlias_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class srcAlternatives {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class srcAlternatives
    srcAlternatives::const_reference get_srcAlternatives () const;
    srcAlternatives::reference ref_srcAlternatives ();
    srcAlternatives::reference set_srcAlternatives ();
    srcAlternatives::reference set_srcAlternatives (srcAlternatives::const_reference value);
    void omit_srcAlternatives ();
    bool srcAlternatives_isPresent () const;
    class destAlternatives {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destAlternatives
    destAlternatives::const_reference get_destAlternatives () const;
    destAlternatives::reference ref_destAlternatives ();
    destAlternatives::reference set_destAlternatives ();
    destAlternatives::reference set_destAlternatives (destAlternatives::const_reference value);
    void omit_destAlternatives ();
    bool destAlternatives_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class transportQOS {
      public:
        typedef TransportQOS value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportQOS
    transportQOS::const_reference get_transportQOS () const;
    transportQOS::reference ref_transportQOS ();
    transportQOS::reference set_transportQOS ();
    transportQOS::reference set_transportQOS (transportQOS::const_reference value);
    void omit_transportQOS ();
    bool transportQOS_isPresent () const;
    class willSupplyUUIEs {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willSupplyUUIEs
    willSupplyUUIEs::const_reference get_willSupplyUUIEs () const;
    willSupplyUUIEs::reference ref_willSupplyUUIEs ();
    willSupplyUUIEs::reference set_willSupplyUUIEs ();
    willSupplyUUIEs::reference set_willSupplyUUIEs (bool value);
    void omit_willSupplyUUIEs ();
    bool willSupplyUUIEs_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class gatewayDataRate {
      public:
        typedef DataRate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatewayDataRate
    gatewayDataRate::const_reference get_gatewayDataRate () const;
    gatewayDataRate::reference ref_gatewayDataRate ();
    gatewayDataRate::reference set_gatewayDataRate ();
    gatewayDataRate::reference set_gatewayDataRate (gatewayDataRate::const_reference value);
    void omit_gatewayDataRate ();
    bool gatewayDataRate_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class desiredProtocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredProtocols
    desiredProtocols::const_reference get_desiredProtocols () const;
    desiredProtocols::reference ref_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols (desiredProtocols::const_reference value);
    void omit_desiredProtocols ();
    bool desiredProtocols_isPresent () const;
    class desiredTunnelledProtocol {
      public:
        typedef TunnelledProtocol value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredTunnelledProtocol
    desiredTunnelledProtocol::const_reference get_desiredTunnelledProtocol () const;
    desiredTunnelledProtocol::reference ref_desiredTunnelledProtocol ();
    desiredTunnelledProtocol::reference set_desiredTunnelledProtocol ();
    desiredTunnelledProtocol::reference set_desiredTunnelledProtocol (desiredTunnelledProtocol::const_reference value);
    void omit_desiredTunnelledProtocol ();
    bool desiredTunnelledProtocol_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(AdmissionRequest& other);
    AdmissionRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[34];
    static int fieldIds[34];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[34];
#endif
};

//
// AdmissionConfirm
//

class AdmissionConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AdmissionConfirm(const void* info) : Inherited(info) {}
  public:
    AdmissionConfirm() : Inherited(&theInfo) {}
    AdmissionConfirm(const AdmissionConfirm & other) : Inherited(other)
    {}
    AdmissionConfirm& operator = (const AdmissionConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_irrFrequency,
      e_nonStandardData,
      e_destinationInfo,
      e_destExtraCallInfo,
      e_destinationType,
      e_remoteExtensionAddress,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_transportQOS,
      e_willRespondToIRR,
      e_uuiesRequested,
      e_language,
      e_alternateTransportAddresses,
      e_useSpecifiedTransport,
      e_circuitInfo,
      e_usageSpec,
      e_supportedProtocols,
      e_serviceControl,
      e_multipleCalls,
      e_featureSet,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class bandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandWidth
    bandWidth::const_reference get_bandWidth () const;
    bandWidth::reference ref_bandWidth ();
    bandWidth::reference set_bandWidth ();
    bandWidth::reference set_bandWidth (bandWidth::const_reference value);
    class callModel {
      public:
        typedef CallModel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callModel
    callModel::const_reference get_callModel () const;
    callModel::reference ref_callModel ();
    callModel::reference set_callModel ();
    callModel::reference set_callModel (callModel::const_reference value);
    class destCallSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destCallSignalAddress
    destCallSignalAddress::const_reference get_destCallSignalAddress () const;
    destCallSignalAddress::reference ref_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress (destCallSignalAddress::const_reference value);
    class irrFrequency {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class irrFrequency
    irrFrequency::const_reference get_irrFrequency () const;
    irrFrequency::reference ref_irrFrequency ();
    irrFrequency::reference set_irrFrequency ();
    irrFrequency::reference set_irrFrequency (irrFrequency::value_type::int_type value);
    void omit_irrFrequency ();
    bool irrFrequency_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class destinationInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    void omit_destinationInfo ();
    bool destinationInfo_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class destinationType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationType
    destinationType::const_reference get_destinationType () const;
    destinationType::reference ref_destinationType ();
    destinationType::reference set_destinationType ();
    destinationType::reference set_destinationType (destinationType::const_reference value);
    void omit_destinationType ();
    bool destinationType_isPresent () const;
    class remoteExtensionAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteExtensionAddress
    remoteExtensionAddress::const_reference get_remoteExtensionAddress () const;
    remoteExtensionAddress::reference ref_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress (remoteExtensionAddress::const_reference value);
    void omit_remoteExtensionAddress ();
    bool remoteExtensionAddress_isPresent () const;
    class alternateEndpoints {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateEndpoints
    alternateEndpoints::const_reference get_alternateEndpoints () const;
    alternateEndpoints::reference ref_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints (alternateEndpoints::const_reference value);
    void omit_alternateEndpoints ();
    bool alternateEndpoints_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class transportQOS {
      public:
        typedef TransportQOS value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportQOS
    transportQOS::const_reference get_transportQOS () const;
    transportQOS::reference ref_transportQOS ();
    transportQOS::reference set_transportQOS ();
    transportQOS::reference set_transportQOS (transportQOS::const_reference value);
    void omit_transportQOS ();
    bool transportQOS_isPresent () const;
    class willRespondToIRR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willRespondToIRR
    willRespondToIRR::const_reference get_willRespondToIRR () const;
    willRespondToIRR::reference ref_willRespondToIRR ();
    willRespondToIRR::reference set_willRespondToIRR ();
    willRespondToIRR::reference set_willRespondToIRR (bool value);
    void omit_willRespondToIRR ();
    bool willRespondToIRR_isPresent () const;
    class uuiesRequested {
      public:
        typedef UUIEsRequested value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class uuiesRequested
    uuiesRequested::const_reference get_uuiesRequested () const;
    uuiesRequested::reference ref_uuiesRequested ();
    uuiesRequested::reference set_uuiesRequested ();
    uuiesRequested::reference set_uuiesRequested (uuiesRequested::const_reference value);
    void omit_uuiesRequested ();
    bool uuiesRequested_isPresent () const;
    class language {
      public:
        typedef AdmissionConfirm_language value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class language
    language::const_reference get_language () const;
    language::reference ref_language ();
    language::reference set_language ();
    language::reference set_language (language::const_reference value);
    void omit_language ();
    bool language_isPresent () const;
    class alternateTransportAddresses {
      public:
        typedef AlternateTransportAddresses value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateTransportAddresses
    alternateTransportAddresses::const_reference get_alternateTransportAddresses () const;
    alternateTransportAddresses::reference ref_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses (alternateTransportAddresses::const_reference value);
    void omit_alternateTransportAddresses ();
    bool alternateTransportAddresses_isPresent () const;
    class useSpecifiedTransport {
      public:
        typedef UseSpecifiedTransport value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class useSpecifiedTransport
    useSpecifiedTransport::const_reference get_useSpecifiedTransport () const;
    useSpecifiedTransport::reference ref_useSpecifiedTransport ();
    useSpecifiedTransport::reference set_useSpecifiedTransport ();
    useSpecifiedTransport::reference set_useSpecifiedTransport (useSpecifiedTransport::const_reference value);
    void omit_useSpecifiedTransport ();
    bool useSpecifiedTransport_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class usageSpec {
      public:
        typedef ASN1::SEQUENCE_OF<RasUsageSpecification>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageSpec
    usageSpec::const_reference get_usageSpec () const;
    usageSpec::reference ref_usageSpec ();
    usageSpec::reference set_usageSpec ();
    usageSpec::reference set_usageSpec (usageSpec::const_reference value);
    void omit_usageSpec ();
    bool usageSpec_isPresent () const;
    class supportedProtocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedProtocols
    supportedProtocols::const_reference get_supportedProtocols () const;
    supportedProtocols::reference ref_supportedProtocols ();
    supportedProtocols::reference set_supportedProtocols ();
    supportedProtocols::reference set_supportedProtocols (supportedProtocols::const_reference value);
    void omit_supportedProtocols ();
    bool supportedProtocols_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(AdmissionConfirm& other);
    AdmissionConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[27];
    static int fieldIds[27];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[27];
#endif
};

//
// LocationRequest
//

class LocationRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LocationRequest(const void* info) : Inherited(info) {}
  public:
    LocationRequest() : Inherited(&theInfo) {}
    LocationRequest(const LocationRequest & other) : Inherited(other)
    {}
    LocationRequest& operator = (const LocationRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_endpointIdentifier,
      e_nonStandardData,
      e_sourceInfo,
      e_canMapAlias,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_desiredProtocols,
      e_desiredTunnelledProtocol,
      e_featureSet,
      e_genericData,
      e_hopCount,
      e_circuitInfo
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    void omit_endpointIdentifier ();
    bool endpointIdentifier_isPresent () const;
    class destinationInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class replyAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replyAddress
    replyAddress::const_reference get_replyAddress () const;
    replyAddress::reference ref_replyAddress ();
    replyAddress::reference set_replyAddress ();
    replyAddress::reference set_replyAddress (replyAddress::const_reference value);
    class sourceInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sourceInfo
    sourceInfo::const_reference get_sourceInfo () const;
    sourceInfo::reference ref_sourceInfo ();
    sourceInfo::reference set_sourceInfo ();
    sourceInfo::reference set_sourceInfo (sourceInfo::const_reference value);
    void omit_sourceInfo ();
    bool sourceInfo_isPresent () const;
    class canMapAlias {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canMapAlias
    canMapAlias::const_reference get_canMapAlias () const;
    canMapAlias::reference ref_canMapAlias ();
    canMapAlias::reference set_canMapAlias ();
    canMapAlias::reference set_canMapAlias (bool value);
    void omit_canMapAlias ();
    bool canMapAlias_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class desiredProtocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredProtocols
    desiredProtocols::const_reference get_desiredProtocols () const;
    desiredProtocols::reference ref_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols (desiredProtocols::const_reference value);
    void omit_desiredProtocols ();
    bool desiredProtocols_isPresent () const;
    class desiredTunnelledProtocol {
      public:
        typedef TunnelledProtocol value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredTunnelledProtocol
    desiredTunnelledProtocol::const_reference get_desiredTunnelledProtocol () const;
    desiredTunnelledProtocol::reference ref_desiredTunnelledProtocol ();
    desiredTunnelledProtocol::reference set_desiredTunnelledProtocol ();
    desiredTunnelledProtocol::reference set_desiredTunnelledProtocol (desiredTunnelledProtocol::const_reference value);
    void omit_desiredTunnelledProtocol ();
    bool desiredTunnelledProtocol_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    class hopCount {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hopCount
    hopCount::const_reference get_hopCount () const;
    hopCount::reference ref_hopCount ();
    hopCount::reference set_hopCount ();
    hopCount::reference set_hopCount (hopCount::value_type::int_type value);
    void omit_hopCount ();
    bool hopCount_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    void swap(LocationRequest& other);
    LocationRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[17];
    static int fieldIds[17];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[17];
#endif
};

//
// LocationConfirm
//

class LocationConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LocationConfirm(const void* info) : Inherited(info) {}
  public:
    LocationConfirm() : Inherited(&theInfo) {}
    LocationConfirm(const LocationConfirm & other) : Inherited(other)
    {}
    LocationConfirm& operator = (const LocationConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_destinationInfo,
      e_destExtraCallInfo,
      e_destinationType,
      e_remoteExtensionAddress,
      e_alternateEndpoints,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_alternateTransportAddresses,
      e_supportedProtocols,
      e_multipleCalls,
      e_featureSet,
      e_genericData,
      e_circuitInfo,
      e_serviceControl
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class callSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    class rasAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class destinationInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    void omit_destinationInfo ();
    bool destinationInfo_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class destinationType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationType
    destinationType::const_reference get_destinationType () const;
    destinationType::reference ref_destinationType ();
    destinationType::reference set_destinationType ();
    destinationType::reference set_destinationType (destinationType::const_reference value);
    void omit_destinationType ();
    bool destinationType_isPresent () const;
    class remoteExtensionAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteExtensionAddress
    remoteExtensionAddress::const_reference get_remoteExtensionAddress () const;
    remoteExtensionAddress::reference ref_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress (remoteExtensionAddress::const_reference value);
    void omit_remoteExtensionAddress ();
    bool remoteExtensionAddress_isPresent () const;
    class alternateEndpoints {
      public:
        typedef ASN1::SEQUENCE_OF<Endpoint>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateEndpoints
    alternateEndpoints::const_reference get_alternateEndpoints () const;
    alternateEndpoints::reference ref_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints ();
    alternateEndpoints::reference set_alternateEndpoints (alternateEndpoints::const_reference value);
    void omit_alternateEndpoints ();
    bool alternateEndpoints_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class alternateTransportAddresses {
      public:
        typedef AlternateTransportAddresses value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternateTransportAddresses
    alternateTransportAddresses::const_reference get_alternateTransportAddresses () const;
    alternateTransportAddresses::reference ref_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses ();
    alternateTransportAddresses::reference set_alternateTransportAddresses (alternateTransportAddresses::const_reference value);
    void omit_alternateTransportAddresses ();
    bool alternateTransportAddresses_isPresent () const;
    class supportedProtocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedProtocols
    supportedProtocols::const_reference get_supportedProtocols () const;
    supportedProtocols::reference ref_supportedProtocols ();
    supportedProtocols::reference set_supportedProtocols ();
    supportedProtocols::reference set_supportedProtocols (supportedProtocols::const_reference value);
    void omit_supportedProtocols ();
    bool supportedProtocols_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    void swap(LocationConfirm& other);
    LocationConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[19];
    static int fieldIds[19];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[19];
#endif
};

//
// DisengageRequest
//

class DisengageRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DisengageRequest(const void* info) : Inherited(info) {}
  public:
    DisengageRequest() : Inherited(&theInfo) {}
    DisengageRequest(const DisengageRequest & other) : Inherited(other)
    {}
    DisengageRequest& operator = (const DisengageRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_callIdentifier,
      e_gatekeeperIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_answeredCall,
      e_callLinkage,
      e_capacity,
      e_circuitInfo,
      e_usageInformation,
      e_terminationCause,
      e_serviceControl,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class callReferenceValue {
      public:
        typedef CallReferenceValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callReferenceValue
    callReferenceValue::const_reference get_callReferenceValue () const;
    callReferenceValue::reference ref_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue (callReferenceValue::value_type::int_type value);
    class disengageReason {
      public:
        typedef DisengageReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class disengageReason
    disengageReason::const_reference get_disengageReason () const;
    disengageReason::reference ref_disengageReason ();
    disengageReason::reference set_disengageReason ();
    disengageReason::reference set_disengageReason (disengageReason::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class gatekeeperIdentifier {
      public:
        typedef GatekeeperIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperIdentifier
    gatekeeperIdentifier::const_reference get_gatekeeperIdentifier () const;
    gatekeeperIdentifier::reference ref_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier ();
    gatekeeperIdentifier::reference set_gatekeeperIdentifier (gatekeeperIdentifier::const_reference value);
    void omit_gatekeeperIdentifier ();
    bool gatekeeperIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class answeredCall {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class answeredCall
    answeredCall::const_reference get_answeredCall () const;
    answeredCall::reference ref_answeredCall ();
    answeredCall::reference set_answeredCall ();
    answeredCall::reference set_answeredCall (bool value);
    void omit_answeredCall ();
    bool answeredCall_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class usageInformation {
      public:
        typedef RasUsageInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageInformation
    usageInformation::const_reference get_usageInformation () const;
    usageInformation::reference ref_usageInformation ();
    usageInformation::reference set_usageInformation ();
    usageInformation::reference set_usageInformation (usageInformation::const_reference value);
    void omit_usageInformation ();
    bool usageInformation_isPresent () const;
    class terminationCause {
      public:
        typedef CallTerminationCause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationCause
    terminationCause::const_reference get_terminationCause () const;
    terminationCause::reference ref_terminationCause ();
    terminationCause::reference set_terminationCause ();
    terminationCause::reference set_terminationCause (terminationCause::const_reference value);
    void omit_terminationCause ();
    bool terminationCause_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(DisengageRequest& other);
    DisengageRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[19];
    static int fieldIds[19];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[19];
#endif
};

//
// DisengageConfirm
//

class DisengageConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DisengageConfirm(const void* info) : Inherited(info) {}
  public:
    DisengageConfirm() : Inherited(&theInfo) {}
    DisengageConfirm(const DisengageConfirm & other) : Inherited(other)
    {}
    DisengageConfirm& operator = (const DisengageConfirm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_capacity,
      e_circuitInfo,
      e_usageInformation,
      e_genericData
    };

    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class usageInformation {
      public:
        typedef RasUsageInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageInformation
    usageInformation::const_reference get_usageInformation () const;
    usageInformation::reference ref_usageInformation ();
    usageInformation::reference set_usageInformation ();
    usageInformation::reference set_usageInformation (usageInformation::const_reference value);
    void omit_usageInformation ();
    bool usageInformation_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(DisengageConfirm& other);
    DisengageConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[9];
    static int fieldIds[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[9];
#endif
};

//
// Information_UUIE
//

class Information_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Information_UUIE(const void* info) : Inherited(info) {}
  public:
    Information_UUIE() : Inherited(&theInfo) {}
    Information_UUIE(const Information_UUIE & other) : Inherited(other)
    {}
    Information_UUIE& operator = (const Information_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_fastConnectRefused,
      e_circuitInfo
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    void swap(Information_UUIE& other);
    Information_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// Setup_UUIE
//

class Setup_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Setup_UUIE(const void* info) : Inherited(info) {}
  public:
    Setup_UUIE() : Inherited(&theInfo) {}
    Setup_UUIE(const Setup_UUIE & other) : Inherited(other)
    {}
    Setup_UUIE& operator = (const Setup_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h245Address,
      e_sourceAddress,
      e_destinationAddress,
      e_destCallSignalAddress,
      e_destExtraCallInfo,
      e_destExtraCRV,
      e_callServices,
      e_sourceCallSignalAddress,
      e_remoteExtensionAddress,
      e_callIdentifier,
      e_h245SecurityCapability,
      e_tokens,
      e_cryptoTokens,
      e_fastStart,
      e_mediaWaitForConnect,
      e_canOverlapSend,
      e_endpointIdentifier,
      e_multipleCalls,
      e_maintainConnection,
      e_connectionParameters,
      e_language,
      e_presentationIndicator,
      e_screeningIndicator,
      e_serviceControl,
      e_symmetricOperationRequired,
      e_capacity,
      e_circuitInfo,
      e_desiredProtocols,
      e_neededFeatures,
      e_desiredFeatures,
      e_supportedFeatures,
      e_parallelH245Control,
      e_additionalSourceAddresses
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class sourceAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sourceAddress
    sourceAddress::const_reference get_sourceAddress () const;
    sourceAddress::reference ref_sourceAddress ();
    sourceAddress::reference set_sourceAddress ();
    sourceAddress::reference set_sourceAddress (sourceAddress::const_reference value);
    void omit_sourceAddress ();
    bool sourceAddress_isPresent () const;
    class sourceInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sourceInfo
    sourceInfo::const_reference get_sourceInfo () const;
    sourceInfo::reference ref_sourceInfo ();
    sourceInfo::reference set_sourceInfo ();
    sourceInfo::reference set_sourceInfo (sourceInfo::const_reference value);
    class destinationAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationAddress
    destinationAddress::const_reference get_destinationAddress () const;
    destinationAddress::reference ref_destinationAddress ();
    destinationAddress::reference set_destinationAddress ();
    destinationAddress::reference set_destinationAddress (destinationAddress::const_reference value);
    void omit_destinationAddress ();
    bool destinationAddress_isPresent () const;
    class destCallSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destCallSignalAddress
    destCallSignalAddress::const_reference get_destCallSignalAddress () const;
    destCallSignalAddress::reference ref_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress ();
    destCallSignalAddress::reference set_destCallSignalAddress (destCallSignalAddress::const_reference value);
    void omit_destCallSignalAddress ();
    bool destCallSignalAddress_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class destExtraCRV {
      public:
        typedef ASN1::SEQUENCE_OF<CallReferenceValue>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCRV
    destExtraCRV::const_reference get_destExtraCRV () const;
    destExtraCRV::reference ref_destExtraCRV ();
    destExtraCRV::reference set_destExtraCRV ();
    destExtraCRV::reference set_destExtraCRV (destExtraCRV::const_reference value);
    void omit_destExtraCRV ();
    bool destExtraCRV_isPresent () const;
    class activeMC {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class activeMC
    activeMC::const_reference get_activeMC () const;
    activeMC::reference ref_activeMC ();
    activeMC::reference set_activeMC ();
    activeMC::reference set_activeMC (bool value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class conferenceGoal {
      public:
        typedef Setup_UUIE_conferenceGoal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceGoal
    conferenceGoal::const_reference get_conferenceGoal () const;
    conferenceGoal::reference ref_conferenceGoal ();
    conferenceGoal::reference set_conferenceGoal ();
    conferenceGoal::reference set_conferenceGoal (conferenceGoal::const_reference value);
    class callServices {
      public:
        typedef QseriesOptions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callServices
    callServices::const_reference get_callServices () const;
    callServices::reference ref_callServices ();
    callServices::reference set_callServices ();
    callServices::reference set_callServices (callServices::const_reference value);
    void omit_callServices ();
    bool callServices_isPresent () const;
    class callType {
      public:
        typedef CallType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callType
    callType::const_reference get_callType () const;
    callType::reference ref_callType ();
    callType::reference set_callType ();
    callType::reference set_callType (callType::const_reference value);
    class sourceCallSignalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sourceCallSignalAddress
    sourceCallSignalAddress::const_reference get_sourceCallSignalAddress () const;
    sourceCallSignalAddress::reference ref_sourceCallSignalAddress ();
    sourceCallSignalAddress::reference set_sourceCallSignalAddress ();
    sourceCallSignalAddress::reference set_sourceCallSignalAddress (sourceCallSignalAddress::const_reference value);
    void omit_sourceCallSignalAddress ();
    bool sourceCallSignalAddress_isPresent () const;
    class remoteExtensionAddress {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteExtensionAddress
    remoteExtensionAddress::const_reference get_remoteExtensionAddress () const;
    remoteExtensionAddress::reference ref_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress (remoteExtensionAddress::const_reference value);
    void omit_remoteExtensionAddress ();
    bool remoteExtensionAddress_isPresent () const;
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class h245SecurityCapability {
      public:
        typedef ASN1::SEQUENCE_OF<H245Security>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityCapability
    h245SecurityCapability::const_reference get_h245SecurityCapability () const;
    h245SecurityCapability::reference ref_h245SecurityCapability ();
    h245SecurityCapability::reference set_h245SecurityCapability ();
    h245SecurityCapability::reference set_h245SecurityCapability (h245SecurityCapability::const_reference value);
    void omit_h245SecurityCapability ();
    bool h245SecurityCapability_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class mediaWaitForConnect {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaWaitForConnect
    mediaWaitForConnect::const_reference get_mediaWaitForConnect () const;
    mediaWaitForConnect::reference ref_mediaWaitForConnect ();
    mediaWaitForConnect::reference set_mediaWaitForConnect ();
    mediaWaitForConnect::reference set_mediaWaitForConnect (bool value);
    void omit_mediaWaitForConnect ();
    bool mediaWaitForConnect_isPresent () const;
    class canOverlapSend {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canOverlapSend
    canOverlapSend::const_reference get_canOverlapSend () const;
    canOverlapSend::reference ref_canOverlapSend ();
    canOverlapSend::reference set_canOverlapSend ();
    canOverlapSend::reference set_canOverlapSend (bool value);
    void omit_canOverlapSend ();
    bool canOverlapSend_isPresent () const;
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    void omit_endpointIdentifier ();
    bool endpointIdentifier_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class connectionParameters {
      public:
        typedef Setup_UUIE_connectionParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionParameters
    connectionParameters::const_reference get_connectionParameters () const;
    connectionParameters::reference ref_connectionParameters ();
    connectionParameters::reference set_connectionParameters ();
    connectionParameters::reference set_connectionParameters (connectionParameters::const_reference value);
    void omit_connectionParameters ();
    bool connectionParameters_isPresent () const;
    class language {
      public:
        typedef Setup_UUIE_language value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class language
    language::const_reference get_language () const;
    language::reference ref_language ();
    language::reference set_language ();
    language::reference set_language (language::const_reference value);
    void omit_language ();
    bool language_isPresent () const;
    class presentationIndicator {
      public:
        typedef PresentationIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class presentationIndicator
    presentationIndicator::const_reference get_presentationIndicator () const;
    presentationIndicator::reference ref_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator ();
    presentationIndicator::reference set_presentationIndicator (presentationIndicator::const_reference value);
    void omit_presentationIndicator ();
    bool presentationIndicator_isPresent () const;
    class screeningIndicator {
      public:
        typedef ScreeningIndicator value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class screeningIndicator
    screeningIndicator::const_reference get_screeningIndicator () const;
    screeningIndicator::reference ref_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator ();
    screeningIndicator::reference set_screeningIndicator (screeningIndicator::value_type::NamedNumber value);
    void omit_screeningIndicator ();
    bool screeningIndicator_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class symmetricOperationRequired {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class symmetricOperationRequired
    symmetricOperationRequired::reference set_symmetricOperationRequired ();
    void omit_symmetricOperationRequired ();
    bool symmetricOperationRequired_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class desiredProtocols {
      public:
        typedef ASN1::SEQUENCE_OF<SupportedProtocols>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredProtocols
    desiredProtocols::const_reference get_desiredProtocols () const;
    desiredProtocols::reference ref_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols ();
    desiredProtocols::reference set_desiredProtocols (desiredProtocols::const_reference value);
    void omit_desiredProtocols ();
    bool desiredProtocols_isPresent () const;
    class neededFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class neededFeatures
    neededFeatures::const_reference get_neededFeatures () const;
    neededFeatures::reference ref_neededFeatures ();
    neededFeatures::reference set_neededFeatures ();
    neededFeatures::reference set_neededFeatures (neededFeatures::const_reference value);
    void omit_neededFeatures ();
    bool neededFeatures_isPresent () const;
    class desiredFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class desiredFeatures
    desiredFeatures::const_reference get_desiredFeatures () const;
    desiredFeatures::reference ref_desiredFeatures ();
    desiredFeatures::reference set_desiredFeatures ();
    desiredFeatures::reference set_desiredFeatures (desiredFeatures::const_reference value);
    void omit_desiredFeatures ();
    bool desiredFeatures_isPresent () const;
    class supportedFeatures {
      public:
        typedef ASN1::SEQUENCE_OF<FeatureDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class supportedFeatures
    supportedFeatures::const_reference get_supportedFeatures () const;
    supportedFeatures::reference ref_supportedFeatures ();
    supportedFeatures::reference set_supportedFeatures ();
    supportedFeatures::reference set_supportedFeatures (supportedFeatures::const_reference value);
    void omit_supportedFeatures ();
    bool supportedFeatures_isPresent () const;
    class parallelH245Control {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class parallelH245Control
    parallelH245Control::const_reference get_parallelH245Control () const;
    parallelH245Control::reference ref_parallelH245Control ();
    parallelH245Control::reference set_parallelH245Control ();
    parallelH245Control::reference set_parallelH245Control (parallelH245Control::const_reference value);
    void omit_parallelH245Control ();
    bool parallelH245Control_isPresent () const;
    class additionalSourceAddresses {
      public:
        typedef ASN1::SEQUENCE_OF<ExtendedAliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class additionalSourceAddresses
    additionalSourceAddresses::const_reference get_additionalSourceAddresses () const;
    additionalSourceAddresses::reference ref_additionalSourceAddresses ();
    additionalSourceAddresses::reference set_additionalSourceAddresses ();
    additionalSourceAddresses::reference set_additionalSourceAddresses (additionalSourceAddresses::const_reference value);
    void omit_additionalSourceAddresses ();
    bool additionalSourceAddresses_isPresent () const;
    void swap(Setup_UUIE& other);
    Setup_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[39];
    static int fieldIds[39];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[39];
#endif
};

//
// Facility_UUIE
//

class Facility_UUIE : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Facility_UUIE(const void* info) : Inherited(info) {}
  public:
    Facility_UUIE() : Inherited(&theInfo) {}
    Facility_UUIE(const Facility_UUIE & other) : Inherited(other)
    {}
    Facility_UUIE& operator = (const Facility_UUIE& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_alternativeAddress,
      e_alternativeAliasAddress,
      e_conferenceID,
      e_callIdentifier,
      e_destExtraCallInfo,
      e_remoteExtensionAddress,
      e_tokens,
      e_cryptoTokens,
      e_conferences,
      e_h245Address,
      e_fastStart,
      e_multipleCalls,
      e_maintainConnection,
      e_fastConnectRefused,
      e_serviceControl,
      e_circuitInfo,
      e_featureSet,
      e_destinationInfo,
      e_h245SecurityMode
    };

    class protocolIdentifier {
      public:
        typedef ProtocolIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class alternativeAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternativeAddress
    alternativeAddress::const_reference get_alternativeAddress () const;
    alternativeAddress::reference ref_alternativeAddress ();
    alternativeAddress::reference set_alternativeAddress ();
    alternativeAddress::reference set_alternativeAddress (alternativeAddress::const_reference value);
    void omit_alternativeAddress ();
    bool alternativeAddress_isPresent () const;
    class alternativeAliasAddress {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alternativeAliasAddress
    alternativeAliasAddress::const_reference get_alternativeAliasAddress () const;
    alternativeAliasAddress::reference ref_alternativeAliasAddress ();
    alternativeAliasAddress::reference set_alternativeAliasAddress ();
    alternativeAliasAddress::reference set_alternativeAliasAddress (alternativeAliasAddress::const_reference value);
    void omit_alternativeAliasAddress ();
    bool alternativeAliasAddress_isPresent () const;
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    void omit_conferenceID ();
    bool conferenceID_isPresent () const;
    class reason {
      public:
        typedef FacilityReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class destExtraCallInfo {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destExtraCallInfo
    destExtraCallInfo::const_reference get_destExtraCallInfo () const;
    destExtraCallInfo::reference ref_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo ();
    destExtraCallInfo::reference set_destExtraCallInfo (destExtraCallInfo::const_reference value);
    void omit_destExtraCallInfo ();
    bool destExtraCallInfo_isPresent () const;
    class remoteExtensionAddress {
      public:
        typedef AliasAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteExtensionAddress
    remoteExtensionAddress::const_reference get_remoteExtensionAddress () const;
    remoteExtensionAddress::reference ref_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress ();
    remoteExtensionAddress::reference set_remoteExtensionAddress (remoteExtensionAddress::const_reference value);
    void omit_remoteExtensionAddress ();
    bool remoteExtensionAddress_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class conferences {
      public:
        typedef ASN1::SEQUENCE_OF<ConferenceList>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferences
    conferences::const_reference get_conferences () const;
    conferences::reference ref_conferences ();
    conferences::reference set_conferences ();
    conferences::reference set_conferences (conferences::const_reference value);
    void omit_conferences ();
    bool conferences_isPresent () const;
    class h245Address {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Address
    h245Address::const_reference get_h245Address () const;
    h245Address::reference ref_h245Address ();
    h245Address::reference set_h245Address ();
    h245Address::reference set_h245Address (h245Address::const_reference value);
    void omit_h245Address ();
    bool h245Address_isPresent () const;
    class fastStart {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastStart
    fastStart::const_reference get_fastStart () const;
    fastStart::reference ref_fastStart ();
    fastStart::reference set_fastStart ();
    fastStart::reference set_fastStart (fastStart::const_reference value);
    void omit_fastStart ();
    bool fastStart_isPresent () const;
    class multipleCalls {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipleCalls
    multipleCalls::const_reference get_multipleCalls () const;
    multipleCalls::reference ref_multipleCalls ();
    multipleCalls::reference set_multipleCalls ();
    multipleCalls::reference set_multipleCalls (bool value);
    void omit_multipleCalls ();
    bool multipleCalls_isPresent () const;
    class maintainConnection {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintainConnection
    maintainConnection::const_reference get_maintainConnection () const;
    maintainConnection::reference ref_maintainConnection ();
    maintainConnection::reference set_maintainConnection ();
    maintainConnection::reference set_maintainConnection (bool value);
    void omit_maintainConnection ();
    bool maintainConnection_isPresent () const;
    class fastConnectRefused {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fastConnectRefused
    fastConnectRefused::reference set_fastConnectRefused ();
    void omit_fastConnectRefused ();
    bool fastConnectRefused_isPresent () const;
    class serviceControl {
      public:
        typedef ASN1::SEQUENCE_OF<ServiceControlSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControl
    serviceControl::const_reference get_serviceControl () const;
    serviceControl::reference ref_serviceControl ();
    serviceControl::reference set_serviceControl ();
    serviceControl::reference set_serviceControl (serviceControl::const_reference value);
    void omit_serviceControl ();
    bool serviceControl_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    class featureSet {
      public:
        typedef FeatureSet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class featureSet
    featureSet::const_reference get_featureSet () const;
    featureSet::reference ref_featureSet ();
    featureSet::reference set_featureSet ();
    featureSet::reference set_featureSet (featureSet::const_reference value);
    void omit_featureSet ();
    bool featureSet_isPresent () const;
    class destinationInfo {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destinationInfo
    destinationInfo::const_reference get_destinationInfo () const;
    destinationInfo::reference ref_destinationInfo ();
    destinationInfo::reference set_destinationInfo ();
    destinationInfo::reference set_destinationInfo (destinationInfo::const_reference value);
    void omit_destinationInfo ();
    bool destinationInfo_isPresent () const;
    class h245SecurityMode {
      public:
        typedef H245Security value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245SecurityMode
    h245SecurityMode::const_reference get_h245SecurityMode () const;
    h245SecurityMode::reference ref_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode ();
    h245SecurityMode::reference set_h245SecurityMode (h245SecurityMode::const_reference value);
    void omit_h245SecurityMode ();
    bool h245SecurityMode_isPresent () const;
    void swap(Facility_UUIE& other);
    Facility_UUIE * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[21];
    static int fieldIds[21];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[21];
#endif
};

//
// H323_UU_PDU_h323_message_body
//

class H323_UU_PDU_h323_message_body : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H323_UU_PDU_h323_message_body(const void* info) : Inherited(info) {}
  public:
    H323_UU_PDU_h323_message_body() : Inherited(&theInfo) {}
    class setup {
      public:
        enum Id { id_ = 0 };
        typedef Setup_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class setup

    setup::const_reference get_setup () const;
    setup::reference ref_setup (); 
    setup::reference select_setup (); 
    setup::reference select_setup (setup::const_reference value); 
    bool setup_isSelected() const;

    class callProceeding {
      public:
        enum Id { id_ = 1 };
        typedef CallProceeding_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callProceeding

    callProceeding::const_reference get_callProceeding () const;
    callProceeding::reference ref_callProceeding (); 
    callProceeding::reference select_callProceeding (); 
    callProceeding::reference select_callProceeding (callProceeding::const_reference value); 
    bool callProceeding_isSelected() const;

    class connect {
      public:
        enum Id { id_ = 2 };
        typedef Connect_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connect

    connect::const_reference get_connect () const;
    connect::reference ref_connect (); 
    connect::reference select_connect (); 
    connect::reference select_connect (connect::const_reference value); 
    bool connect_isSelected() const;

    class alerting {
      public:
        enum Id { id_ = 3 };
        typedef Alerting_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alerting

    alerting::const_reference get_alerting () const;
    alerting::reference ref_alerting (); 
    alerting::reference select_alerting (); 
    alerting::reference select_alerting (alerting::const_reference value); 
    bool alerting_isSelected() const;

    class information {
      public:
        enum Id { id_ = 4 };
        typedef Information_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class information

    information::const_reference get_information () const;
    information::reference ref_information (); 
    information::reference select_information (); 
    information::reference select_information (information::const_reference value); 
    bool information_isSelected() const;

    class releaseComplete {
      public:
        enum Id { id_ = 5 };
        typedef ReleaseComplete_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class releaseComplete

    releaseComplete::const_reference get_releaseComplete () const;
    releaseComplete::reference ref_releaseComplete (); 
    releaseComplete::reference select_releaseComplete (); 
    releaseComplete::reference select_releaseComplete (releaseComplete::const_reference value); 
    bool releaseComplete_isSelected() const;

    class facility {
      public:
        enum Id { id_ = 6 };
        typedef Facility_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class facility

    facility::const_reference get_facility () const;
    facility::reference ref_facility (); 
    facility::reference select_facility (); 
    facility::reference select_facility (facility::const_reference value); 
    bool facility_isSelected() const;

    class progress {
      public:
        enum Id { id_ = 7 };
        typedef Progress_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class progress

    progress::const_reference get_progress () const;
    progress::reference ref_progress (); 
    progress::reference select_progress (); 
    progress::reference select_progress (progress::const_reference value); 
    bool progress_isSelected() const;

    class empty {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class empty

    empty::reference select_empty (); 
    bool empty_isSelected() const;

    class status {
      public:
        enum Id { id_ = 9 };
        typedef Status_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class status

    status::const_reference get_status () const;
    status::reference ref_status (); 
    status::reference select_status (); 
    status::reference select_status (status::const_reference value); 
    bool status_isSelected() const;

    class statusInquiry {
      public:
        enum Id { id_ = 10 };
        typedef StatusInquiry_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statusInquiry

    statusInquiry::const_reference get_statusInquiry () const;
    statusInquiry::reference ref_statusInquiry (); 
    statusInquiry::reference select_statusInquiry (); 
    statusInquiry::reference select_statusInquiry (statusInquiry::const_reference value); 
    bool statusInquiry_isSelected() const;

    class setupAcknowledge {
      public:
        enum Id { id_ = 11 };
        typedef SetupAcknowledge_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class setupAcknowledge

    setupAcknowledge::const_reference get_setupAcknowledge () const;
    setupAcknowledge::reference ref_setupAcknowledge (); 
    setupAcknowledge::reference select_setupAcknowledge (); 
    setupAcknowledge::reference select_setupAcknowledge (setupAcknowledge::const_reference value); 
    bool setupAcknowledge_isSelected() const;

    class notify {
      public:
        enum Id { id_ = 12 };
        typedef Notify_UUIE value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notify

    notify::const_reference get_notify () const;
    notify::reference ref_notify (); 
    notify::reference select_notify (); 
    notify::reference select_notify (notify::const_reference value); 
    bool notify_isSelected() const;

    H323_UU_PDU_h323_message_body(setup::Id id, setup::const_reference value);
    H323_UU_PDU_h323_message_body(callProceeding::Id id, callProceeding::const_reference value);
    H323_UU_PDU_h323_message_body(connect::Id id, connect::const_reference value);
    H323_UU_PDU_h323_message_body(alerting::Id id, alerting::const_reference value);
    H323_UU_PDU_h323_message_body(information::Id id, information::const_reference value);
    H323_UU_PDU_h323_message_body(releaseComplete::Id id, releaseComplete::const_reference value);
    H323_UU_PDU_h323_message_body(facility::Id id, facility::const_reference value);
    H323_UU_PDU_h323_message_body(progress::Id id, progress::const_reference value);
    H323_UU_PDU_h323_message_body(empty::Id id, empty::const_reference value);
    H323_UU_PDU_h323_message_body(status::Id id, status::const_reference value);
    H323_UU_PDU_h323_message_body(statusInquiry::Id id, statusInquiry::const_reference value);
    H323_UU_PDU_h323_message_body(setupAcknowledge::Id id, setupAcknowledge::const_reference value);
    H323_UU_PDU_h323_message_body(notify::Id id, notify::const_reference value);
    void swap(H323_UU_PDU_h323_message_body & other);
    H323_UU_PDU_h323_message_body(const H323_UU_PDU_h323_message_body & other)
    : Inherited(other) {} 

    H323_UU_PDU_h323_message_body & operator = (const H323_UU_PDU_h323_message_body & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H323_UU_PDU_h323_message_body * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[13];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[13];
#endif
};

//
// H323_UU_PDU
//

class H323_UU_PDU : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H323_UU_PDU(const void* info) : Inherited(info) {}
  public:
    H323_UU_PDU() : Inherited(&theInfo) {}
    H323_UU_PDU(const H323_UU_PDU & other) : Inherited(other)
    {}
    H323_UU_PDU& operator = (const H323_UU_PDU& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_h4501SupplementaryService,
      e_h245Tunneling,
      e_h245Control,
      e_nonStandardControl,
      e_callLinkage,
      e_tunnelledSignallingMessage,
      e_provisionalRespToH245Tunneling,
      e_stimulusControl,
      e_genericData
    };

    class h323_message_body {
      public:
        typedef H323_UU_PDU_h323_message_body value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h323_message_body
    h323_message_body::const_reference get_h323_message_body () const;
    h323_message_body::reference ref_h323_message_body ();
    h323_message_body::reference set_h323_message_body ();
    h323_message_body::reference set_h323_message_body (h323_message_body::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class h4501SupplementaryService {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h4501SupplementaryService
    h4501SupplementaryService::const_reference get_h4501SupplementaryService () const;
    h4501SupplementaryService::reference ref_h4501SupplementaryService ();
    h4501SupplementaryService::reference set_h4501SupplementaryService ();
    h4501SupplementaryService::reference set_h4501SupplementaryService (h4501SupplementaryService::const_reference value);
    void omit_h4501SupplementaryService ();
    bool h4501SupplementaryService_isPresent () const;
    class h245Tunneling {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Tunneling
    h245Tunneling::const_reference get_h245Tunneling () const;
    h245Tunneling::reference ref_h245Tunneling ();
    h245Tunneling::reference set_h245Tunneling ();
    h245Tunneling::reference set_h245Tunneling (bool value);
    void omit_h245Tunneling ();
    bool h245Tunneling_isPresent () const;
    class h245Control {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245Control
    h245Control::const_reference get_h245Control () const;
    h245Control::reference ref_h245Control ();
    h245Control::reference set_h245Control ();
    h245Control::reference set_h245Control (h245Control::const_reference value);
    void omit_h245Control ();
    bool h245Control_isPresent () const;
    class nonStandardControl {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardControl
    nonStandardControl::const_reference get_nonStandardControl () const;
    nonStandardControl::reference ref_nonStandardControl ();
    nonStandardControl::reference set_nonStandardControl ();
    nonStandardControl::reference set_nonStandardControl (nonStandardControl::const_reference value);
    void omit_nonStandardControl ();
    bool nonStandardControl_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class tunnelledSignallingMessage {
      public:
        typedef H323_UU_PDU_tunnelledSignallingMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tunnelledSignallingMessage
    tunnelledSignallingMessage::const_reference get_tunnelledSignallingMessage () const;
    tunnelledSignallingMessage::reference ref_tunnelledSignallingMessage ();
    tunnelledSignallingMessage::reference set_tunnelledSignallingMessage ();
    tunnelledSignallingMessage::reference set_tunnelledSignallingMessage (tunnelledSignallingMessage::const_reference value);
    void omit_tunnelledSignallingMessage ();
    bool tunnelledSignallingMessage_isPresent () const;
    class provisionalRespToH245Tunneling {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class provisionalRespToH245Tunneling
    provisionalRespToH245Tunneling::reference set_provisionalRespToH245Tunneling ();
    void omit_provisionalRespToH245Tunneling ();
    bool provisionalRespToH245Tunneling_isPresent () const;
    class stimulusControl {
      public:
        typedef StimulusControl value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class stimulusControl
    stimulusControl::const_reference get_stimulusControl () const;
    stimulusControl::reference ref_stimulusControl ();
    stimulusControl::reference set_stimulusControl ();
    stimulusControl::reference set_stimulusControl (stimulusControl::const_reference value);
    void omit_stimulusControl ();
    bool stimulusControl_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(H323_UU_PDU& other);
    H323_UU_PDU * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// InfoRequestResponse_perCallInfo_subtype_pdu_subtype
//

class InfoRequestResponse_perCallInfo_subtype_pdu_subtype : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequestResponse_perCallInfo_subtype_pdu_subtype(const void* info) : Inherited(info) {}
  public:
    InfoRequestResponse_perCallInfo_subtype_pdu_subtype() : Inherited(&theInfo) {}
    InfoRequestResponse_perCallInfo_subtype_pdu_subtype(const InfoRequestResponse_perCallInfo_subtype_pdu_subtype & other) : Inherited(other)
    {}
    InfoRequestResponse_perCallInfo_subtype_pdu_subtype& operator = (const InfoRequestResponse_perCallInfo_subtype_pdu_subtype& other)
    { Inherited::operator = (other); return *this; } 
    class h323pdu {
      public:
        typedef H323_UU_PDU value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h323pdu
    h323pdu::const_reference get_h323pdu () const;
    h323pdu::reference ref_h323pdu ();
    h323pdu::reference set_h323pdu ();
    h323pdu::reference set_h323pdu (h323pdu::const_reference value);
    class sent {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sent
    sent::const_reference get_sent () const;
    sent::reference ref_sent ();
    sent::reference set_sent ();
    sent::reference set_sent (bool value);
    void swap(InfoRequestResponse_perCallInfo_subtype_pdu_subtype& other);
    InfoRequestResponse_perCallInfo_subtype_pdu_subtype * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H323_UserInformation
//

class H323_UserInformation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H323_UserInformation(const void* info) : Inherited(info) {}
  public:
    H323_UserInformation() : Inherited(&theInfo) {}
    H323_UserInformation(const H323_UserInformation & other) : Inherited(other)
    {}
    H323_UserInformation& operator = (const H323_UserInformation& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_user_data
    };

    class h323_uu_pdu {
      public:
        typedef H323_UU_PDU value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h323_uu_pdu
    h323_uu_pdu::const_reference get_h323_uu_pdu () const;
    h323_uu_pdu::reference ref_h323_uu_pdu ();
    h323_uu_pdu::reference set_h323_uu_pdu ();
    h323_uu_pdu::reference set_h323_uu_pdu (h323_uu_pdu::const_reference value);
    class user_data {
      public:
        typedef H323_UserInformation_user_data value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class user_data
    user_data::const_reference get_user_data () const;
    user_data::reference ref_user_data ();
    user_data::reference set_user_data ();
    user_data::reference set_user_data (user_data::const_reference value);
    void omit_user_data ();
    bool user_data_isPresent () const;
    void swap(H323_UserInformation& other);
    H323_UserInformation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<InfoRequestResponse_perCallInfo_subtype_pdu_subtype>  InfoRequestResponse_perCallInfo_subtype_pdu;

//
// InfoRequestResponse_perCallInfo_subtype
//

class InfoRequestResponse_perCallInfo_subtype : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequestResponse_perCallInfo_subtype(const void* info) : Inherited(info) {}
  public:
    InfoRequestResponse_perCallInfo_subtype() : Inherited(&theInfo) {}
    InfoRequestResponse_perCallInfo_subtype(const InfoRequestResponse_perCallInfo_subtype & other) : Inherited(other)
    {}
    InfoRequestResponse_perCallInfo_subtype& operator = (const InfoRequestResponse_perCallInfo_subtype& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_originator,
      e_audio,
      e_video,
      e_data,
      e_callIdentifier,
      e_tokens,
      e_cryptoTokens,
      e_substituteConfIDs,
      e_pdu,
      e_callLinkage,
      e_usageInformation,
      e_circuitInfo
    };

    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class callReferenceValue {
      public:
        typedef CallReferenceValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callReferenceValue
    callReferenceValue::const_reference get_callReferenceValue () const;
    callReferenceValue::reference ref_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue ();
    callReferenceValue::reference set_callReferenceValue (callReferenceValue::value_type::int_type value);
    class conferenceID {
      public:
        typedef ConferenceIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    class originator {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class originator
    originator::const_reference get_originator () const;
    originator::reference ref_originator ();
    originator::reference set_originator ();
    originator::reference set_originator (bool value);
    void omit_originator ();
    bool originator_isPresent () const;
    class audio {
      public:
        typedef ASN1::SEQUENCE_OF<RTPSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audio
    audio::const_reference get_audio () const;
    audio::reference ref_audio ();
    audio::reference set_audio ();
    audio::reference set_audio (audio::const_reference value);
    void omit_audio ();
    bool audio_isPresent () const;
    class video {
      public:
        typedef ASN1::SEQUENCE_OF<RTPSession>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class video
    video::const_reference get_video () const;
    video::reference ref_video ();
    video::reference set_video ();
    video::reference set_video (video::const_reference value);
    void omit_video ();
    bool video_isPresent () const;
    class data {
      public:
        typedef ASN1::SEQUENCE_OF<TransportChannelInfo>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data
    data::const_reference get_data () const;
    data::reference ref_data ();
    data::reference set_data ();
    data::reference set_data (data::const_reference value);
    void omit_data ();
    bool data_isPresent () const;
    class h245 {
      public:
        typedef TransportChannelInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h245
    h245::const_reference get_h245 () const;
    h245::reference ref_h245 ();
    h245::reference set_h245 ();
    h245::reference set_h245 (h245::const_reference value);
    class callSignaling {
      public:
        typedef TransportChannelInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignaling
    callSignaling::const_reference get_callSignaling () const;
    callSignaling::reference ref_callSignaling ();
    callSignaling::reference set_callSignaling ();
    callSignaling::reference set_callSignaling (callSignaling::const_reference value);
    class callType {
      public:
        typedef CallType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callType
    callType::const_reference get_callType () const;
    callType::reference ref_callType ();
    callType::reference set_callType ();
    callType::reference set_callType (callType::const_reference value);
    class bandWidth {
      public:
        typedef BandWidth value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandWidth
    bandWidth::const_reference get_bandWidth () const;
    bandWidth::reference ref_bandWidth ();
    bandWidth::reference set_bandWidth ();
    bandWidth::reference set_bandWidth (bandWidth::const_reference value);
    class callModel {
      public:
        typedef CallModel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callModel
    callModel::const_reference get_callModel () const;
    callModel::reference ref_callModel ();
    callModel::reference set_callModel ();
    callModel::reference set_callModel (callModel::const_reference value);
    class callIdentifier {
      public:
        typedef CallIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentifier
    callIdentifier::const_reference get_callIdentifier () const;
    callIdentifier::reference ref_callIdentifier ();
    callIdentifier::reference set_callIdentifier ();
    callIdentifier::reference set_callIdentifier (callIdentifier::const_reference value);
    void omit_callIdentifier ();
    bool callIdentifier_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class substituteConfIDs {
      public:
        typedef ASN1::SEQUENCE_OF<ConferenceIdentifier>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class substituteConfIDs
    substituteConfIDs::const_reference get_substituteConfIDs () const;
    substituteConfIDs::reference ref_substituteConfIDs ();
    substituteConfIDs::reference set_substituteConfIDs ();
    substituteConfIDs::reference set_substituteConfIDs (substituteConfIDs::const_reference value);
    void omit_substituteConfIDs ();
    bool substituteConfIDs_isPresent () const;
    class pdu {
      public:
        typedef InfoRequestResponse_perCallInfo_subtype_pdu value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pdu
    pdu::const_reference get_pdu () const;
    pdu::reference ref_pdu ();
    pdu::reference set_pdu ();
    pdu::reference set_pdu (pdu::const_reference value);
    void omit_pdu ();
    bool pdu_isPresent () const;
    class callLinkage {
      public:
        typedef CallLinkage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callLinkage
    callLinkage::const_reference get_callLinkage () const;
    callLinkage::reference ref_callLinkage ();
    callLinkage::reference set_callLinkage ();
    callLinkage::reference set_callLinkage (callLinkage::const_reference value);
    void omit_callLinkage ();
    bool callLinkage_isPresent () const;
    class usageInformation {
      public:
        typedef RasUsageInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class usageInformation
    usageInformation::const_reference get_usageInformation () const;
    usageInformation::reference ref_usageInformation ();
    usageInformation::reference set_usageInformation ();
    usageInformation::reference set_usageInformation (usageInformation::const_reference value);
    void omit_usageInformation ();
    bool usageInformation_isPresent () const;
    class circuitInfo {
      public:
        typedef CircuitInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class circuitInfo
    circuitInfo::const_reference get_circuitInfo () const;
    circuitInfo::reference ref_circuitInfo ();
    circuitInfo::reference set_circuitInfo ();
    circuitInfo::reference set_circuitInfo (circuitInfo::const_reference value);
    void omit_circuitInfo ();
    bool circuitInfo_isPresent () const;
    void swap(InfoRequestResponse_perCallInfo_subtype& other);
    InfoRequestResponse_perCallInfo_subtype * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[20];
    static int fieldIds[20];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[20];
#endif
};

typedef ASN1::SEQUENCE_OF<InfoRequestResponse_perCallInfo_subtype>  InfoRequestResponse_perCallInfo;

//
// InfoRequestResponse
//

class InfoRequestResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    InfoRequestResponse(const void* info) : Inherited(info) {}
  public:
    InfoRequestResponse() : Inherited(&theInfo) {}
    InfoRequestResponse(const InfoRequestResponse & other) : Inherited(other)
    {}
    InfoRequestResponse& operator = (const InfoRequestResponse& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_endpointAlias,
      e_perCallInfo,
      e_tokens,
      e_cryptoTokens,
      e_integrityCheckValue,
      e_needResponse,
      e_capacity,
      e_irrStatus,
      e_unsolicited,
      e_genericData
    };

    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class requestSeqNum {
      public:
        typedef RequestSeqNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestSeqNum
    requestSeqNum::const_reference get_requestSeqNum () const;
    requestSeqNum::reference ref_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum ();
    requestSeqNum::reference set_requestSeqNum (requestSeqNum::value_type::int_type value);
    class endpointType {
      public:
        typedef EndpointType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointType
    endpointType::const_reference get_endpointType () const;
    endpointType::reference ref_endpointType ();
    endpointType::reference set_endpointType ();
    endpointType::reference set_endpointType (endpointType::const_reference value);
    class endpointIdentifier {
      public:
        typedef EndpointIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointIdentifier
    endpointIdentifier::const_reference get_endpointIdentifier () const;
    endpointIdentifier::reference ref_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier ();
    endpointIdentifier::reference set_endpointIdentifier (const std::wstring& value);
    class rasAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rasAddress
    rasAddress::const_reference get_rasAddress () const;
    rasAddress::reference ref_rasAddress ();
    rasAddress::reference set_rasAddress ();
    rasAddress::reference set_rasAddress (rasAddress::const_reference value);
    class callSignalAddress {
      public:
        typedef ASN1::SEQUENCE_OF<TransportAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callSignalAddress
    callSignalAddress::const_reference get_callSignalAddress () const;
    callSignalAddress::reference ref_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress ();
    callSignalAddress::reference set_callSignalAddress (callSignalAddress::const_reference value);
    class endpointAlias {
      public:
        typedef ASN1::SEQUENCE_OF<AliasAddress>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endpointAlias
    endpointAlias::const_reference get_endpointAlias () const;
    endpointAlias::reference ref_endpointAlias ();
    endpointAlias::reference set_endpointAlias ();
    endpointAlias::reference set_endpointAlias (endpointAlias::const_reference value);
    void omit_endpointAlias ();
    bool endpointAlias_isPresent () const;
    class perCallInfo {
      public:
        typedef InfoRequestResponse_perCallInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class perCallInfo
    perCallInfo::const_reference get_perCallInfo () const;
    perCallInfo::reference ref_perCallInfo ();
    perCallInfo::reference set_perCallInfo ();
    perCallInfo::reference set_perCallInfo (perCallInfo::const_reference value);
    void omit_perCallInfo ();
    bool perCallInfo_isPresent () const;
    class tokens {
      public:
        typedef ASN1::SEQUENCE_OF<H235_SECURITY_MESSAGES::ClearToken>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokens
    tokens::const_reference get_tokens () const;
    tokens::reference ref_tokens ();
    tokens::reference set_tokens ();
    tokens::reference set_tokens (tokens::const_reference value);
    void omit_tokens ();
    bool tokens_isPresent () const;
    class cryptoTokens {
      public:
        typedef ASN1::SEQUENCE_OF<CryptoH323Token>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoTokens
    cryptoTokens::const_reference get_cryptoTokens () const;
    cryptoTokens::reference ref_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens ();
    cryptoTokens::reference set_cryptoTokens (cryptoTokens::const_reference value);
    void omit_cryptoTokens ();
    bool cryptoTokens_isPresent () const;
    class integrityCheckValue {
      public:
        typedef ICV value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integrityCheckValue
    integrityCheckValue::const_reference get_integrityCheckValue () const;
    integrityCheckValue::reference ref_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue ();
    integrityCheckValue::reference set_integrityCheckValue (integrityCheckValue::const_reference value);
    void omit_integrityCheckValue ();
    bool integrityCheckValue_isPresent () const;
    class needResponse {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class needResponse
    needResponse::const_reference get_needResponse () const;
    needResponse::reference ref_needResponse ();
    needResponse::reference set_needResponse ();
    needResponse::reference set_needResponse (bool value);
    void omit_needResponse ();
    bool needResponse_isPresent () const;
    class capacity {
      public:
        typedef CallCapacity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capacity
    capacity::const_reference get_capacity () const;
    capacity::reference ref_capacity ();
    capacity::reference set_capacity ();
    capacity::reference set_capacity (capacity::const_reference value);
    void omit_capacity ();
    bool capacity_isPresent () const;
    class irrStatus {
      public:
        typedef InfoRequestResponseStatus value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class irrStatus
    irrStatus::const_reference get_irrStatus () const;
    irrStatus::reference ref_irrStatus ();
    irrStatus::reference set_irrStatus ();
    irrStatus::reference set_irrStatus (irrStatus::const_reference value);
    void omit_irrStatus ();
    bool irrStatus_isPresent () const;
    class unsolicited {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unsolicited
    unsolicited::const_reference get_unsolicited () const;
    unsolicited::reference ref_unsolicited ();
    unsolicited::reference set_unsolicited ();
    unsolicited::reference set_unsolicited (bool value);
    void omit_unsolicited ();
    bool unsolicited_isPresent () const;
    class genericData {
      public:
        typedef ASN1::SEQUENCE_OF<GenericData>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericData
    genericData::const_reference get_genericData () const;
    genericData::reference ref_genericData ();
    genericData::reference set_genericData ();
    genericData::reference set_genericData (genericData::const_reference value);
    void omit_genericData ();
    bool genericData_isPresent () const;
    void swap(InfoRequestResponse& other);
    InfoRequestResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[16];
    static int fieldIds[16];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[16];
#endif
};

//
// RasMessage
//

class RasMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RasMessage(const void* info) : Inherited(info) {}
  public:
    RasMessage() : Inherited(&theInfo) {}
    class gatekeeperRequest {
      public:
        enum Id { id_ = 0 };
        typedef GatekeeperRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperRequest

    gatekeeperRequest::const_reference get_gatekeeperRequest () const;
    gatekeeperRequest::reference ref_gatekeeperRequest (); 
    gatekeeperRequest::reference select_gatekeeperRequest (); 
    gatekeeperRequest::reference select_gatekeeperRequest (gatekeeperRequest::const_reference value); 
    bool gatekeeperRequest_isSelected() const;

    class gatekeeperConfirm {
      public:
        enum Id { id_ = 1 };
        typedef GatekeeperConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperConfirm

    gatekeeperConfirm::const_reference get_gatekeeperConfirm () const;
    gatekeeperConfirm::reference ref_gatekeeperConfirm (); 
    gatekeeperConfirm::reference select_gatekeeperConfirm (); 
    gatekeeperConfirm::reference select_gatekeeperConfirm (gatekeeperConfirm::const_reference value); 
    bool gatekeeperConfirm_isSelected() const;

    class gatekeeperReject {
      public:
        enum Id { id_ = 2 };
        typedef GatekeeperReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gatekeeperReject

    gatekeeperReject::const_reference get_gatekeeperReject () const;
    gatekeeperReject::reference ref_gatekeeperReject (); 
    gatekeeperReject::reference select_gatekeeperReject (); 
    gatekeeperReject::reference select_gatekeeperReject (gatekeeperReject::const_reference value); 
    bool gatekeeperReject_isSelected() const;

    class registrationRequest {
      public:
        enum Id { id_ = 3 };
        typedef RegistrationRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class registrationRequest

    registrationRequest::const_reference get_registrationRequest () const;
    registrationRequest::reference ref_registrationRequest (); 
    registrationRequest::reference select_registrationRequest (); 
    registrationRequest::reference select_registrationRequest (registrationRequest::const_reference value); 
    bool registrationRequest_isSelected() const;

    class registrationConfirm {
      public:
        enum Id { id_ = 4 };
        typedef RegistrationConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class registrationConfirm

    registrationConfirm::const_reference get_registrationConfirm () const;
    registrationConfirm::reference ref_registrationConfirm (); 
    registrationConfirm::reference select_registrationConfirm (); 
    registrationConfirm::reference select_registrationConfirm (registrationConfirm::const_reference value); 
    bool registrationConfirm_isSelected() const;

    class registrationReject {
      public:
        enum Id { id_ = 5 };
        typedef RegistrationReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class registrationReject

    registrationReject::const_reference get_registrationReject () const;
    registrationReject::reference ref_registrationReject (); 
    registrationReject::reference select_registrationReject (); 
    registrationReject::reference select_registrationReject (registrationReject::const_reference value); 
    bool registrationReject_isSelected() const;

    class unregistrationRequest {
      public:
        enum Id { id_ = 6 };
        typedef UnregistrationRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unregistrationRequest

    unregistrationRequest::const_reference get_unregistrationRequest () const;
    unregistrationRequest::reference ref_unregistrationRequest (); 
    unregistrationRequest::reference select_unregistrationRequest (); 
    unregistrationRequest::reference select_unregistrationRequest (unregistrationRequest::const_reference value); 
    bool unregistrationRequest_isSelected() const;

    class unregistrationConfirm {
      public:
        enum Id { id_ = 7 };
        typedef UnregistrationConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unregistrationConfirm

    unregistrationConfirm::const_reference get_unregistrationConfirm () const;
    unregistrationConfirm::reference ref_unregistrationConfirm (); 
    unregistrationConfirm::reference select_unregistrationConfirm (); 
    unregistrationConfirm::reference select_unregistrationConfirm (unregistrationConfirm::const_reference value); 
    bool unregistrationConfirm_isSelected() const;

    class unregistrationReject {
      public:
        enum Id { id_ = 8 };
        typedef UnregistrationReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unregistrationReject

    unregistrationReject::const_reference get_unregistrationReject () const;
    unregistrationReject::reference ref_unregistrationReject (); 
    unregistrationReject::reference select_unregistrationReject (); 
    unregistrationReject::reference select_unregistrationReject (unregistrationReject::const_reference value); 
    bool unregistrationReject_isSelected() const;

    class admissionRequest {
      public:
        enum Id { id_ = 9 };
        typedef AdmissionRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class admissionRequest

    admissionRequest::const_reference get_admissionRequest () const;
    admissionRequest::reference ref_admissionRequest (); 
    admissionRequest::reference select_admissionRequest (); 
    admissionRequest::reference select_admissionRequest (admissionRequest::const_reference value); 
    bool admissionRequest_isSelected() const;

    class admissionConfirm {
      public:
        enum Id { id_ = 10 };
        typedef AdmissionConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class admissionConfirm

    admissionConfirm::const_reference get_admissionConfirm () const;
    admissionConfirm::reference ref_admissionConfirm (); 
    admissionConfirm::reference select_admissionConfirm (); 
    admissionConfirm::reference select_admissionConfirm (admissionConfirm::const_reference value); 
    bool admissionConfirm_isSelected() const;

    class admissionReject {
      public:
        enum Id { id_ = 11 };
        typedef AdmissionReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class admissionReject

    admissionReject::const_reference get_admissionReject () const;
    admissionReject::reference ref_admissionReject (); 
    admissionReject::reference select_admissionReject (); 
    admissionReject::reference select_admissionReject (admissionReject::const_reference value); 
    bool admissionReject_isSelected() const;

    class bandwidthRequest {
      public:
        enum Id { id_ = 12 };
        typedef BandwidthRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidthRequest

    bandwidthRequest::const_reference get_bandwidthRequest () const;
    bandwidthRequest::reference ref_bandwidthRequest (); 
    bandwidthRequest::reference select_bandwidthRequest (); 
    bandwidthRequest::reference select_bandwidthRequest (bandwidthRequest::const_reference value); 
    bool bandwidthRequest_isSelected() const;

    class bandwidthConfirm {
      public:
        enum Id { id_ = 13 };
        typedef BandwidthConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidthConfirm

    bandwidthConfirm::const_reference get_bandwidthConfirm () const;
    bandwidthConfirm::reference ref_bandwidthConfirm (); 
    bandwidthConfirm::reference select_bandwidthConfirm (); 
    bandwidthConfirm::reference select_bandwidthConfirm (bandwidthConfirm::const_reference value); 
    bool bandwidthConfirm_isSelected() const;

    class bandwidthReject {
      public:
        enum Id { id_ = 14 };
        typedef BandwidthReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bandwidthReject

    bandwidthReject::const_reference get_bandwidthReject () const;
    bandwidthReject::reference ref_bandwidthReject (); 
    bandwidthReject::reference select_bandwidthReject (); 
    bandwidthReject::reference select_bandwidthReject (bandwidthReject::const_reference value); 
    bool bandwidthReject_isSelected() const;

    class disengageRequest {
      public:
        enum Id { id_ = 15 };
        typedef DisengageRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class disengageRequest

    disengageRequest::const_reference get_disengageRequest () const;
    disengageRequest::reference ref_disengageRequest (); 
    disengageRequest::reference select_disengageRequest (); 
    disengageRequest::reference select_disengageRequest (disengageRequest::const_reference value); 
    bool disengageRequest_isSelected() const;

    class disengageConfirm {
      public:
        enum Id { id_ = 16 };
        typedef DisengageConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class disengageConfirm

    disengageConfirm::const_reference get_disengageConfirm () const;
    disengageConfirm::reference ref_disengageConfirm (); 
    disengageConfirm::reference select_disengageConfirm (); 
    disengageConfirm::reference select_disengageConfirm (disengageConfirm::const_reference value); 
    bool disengageConfirm_isSelected() const;

    class disengageReject {
      public:
        enum Id { id_ = 17 };
        typedef DisengageReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class disengageReject

    disengageReject::const_reference get_disengageReject () const;
    disengageReject::reference ref_disengageReject (); 
    disengageReject::reference select_disengageReject (); 
    disengageReject::reference select_disengageReject (disengageReject::const_reference value); 
    bool disengageReject_isSelected() const;

    class locationRequest {
      public:
        enum Id { id_ = 18 };
        typedef LocationRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class locationRequest

    locationRequest::const_reference get_locationRequest () const;
    locationRequest::reference ref_locationRequest (); 
    locationRequest::reference select_locationRequest (); 
    locationRequest::reference select_locationRequest (locationRequest::const_reference value); 
    bool locationRequest_isSelected() const;

    class locationConfirm {
      public:
        enum Id { id_ = 19 };
        typedef LocationConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class locationConfirm

    locationConfirm::const_reference get_locationConfirm () const;
    locationConfirm::reference ref_locationConfirm (); 
    locationConfirm::reference select_locationConfirm (); 
    locationConfirm::reference select_locationConfirm (locationConfirm::const_reference value); 
    bool locationConfirm_isSelected() const;

    class locationReject {
      public:
        enum Id { id_ = 20 };
        typedef LocationReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class locationReject

    locationReject::const_reference get_locationReject () const;
    locationReject::reference ref_locationReject (); 
    locationReject::reference select_locationReject (); 
    locationReject::reference select_locationReject (locationReject::const_reference value); 
    bool locationReject_isSelected() const;

    class infoRequest {
      public:
        enum Id { id_ = 21 };
        typedef InfoRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infoRequest

    infoRequest::const_reference get_infoRequest () const;
    infoRequest::reference ref_infoRequest (); 
    infoRequest::reference select_infoRequest (); 
    infoRequest::reference select_infoRequest (infoRequest::const_reference value); 
    bool infoRequest_isSelected() const;

    class infoRequestResponse {
      public:
        enum Id { id_ = 22 };
        typedef InfoRequestResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infoRequestResponse

    infoRequestResponse::const_reference get_infoRequestResponse () const;
    infoRequestResponse::reference ref_infoRequestResponse (); 
    infoRequestResponse::reference select_infoRequestResponse (); 
    infoRequestResponse::reference select_infoRequestResponse (infoRequestResponse::const_reference value); 
    bool infoRequestResponse_isSelected() const;

    class nonStandardMessage {
      public:
        enum Id { id_ = 23 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardMessage

    nonStandardMessage::const_reference get_nonStandardMessage () const;
    nonStandardMessage::reference ref_nonStandardMessage (); 
    nonStandardMessage::reference select_nonStandardMessage (); 
    nonStandardMessage::reference select_nonStandardMessage (nonStandardMessage::const_reference value); 
    bool nonStandardMessage_isSelected() const;

    class unknownMessageResponse {
      public:
        enum Id { id_ = 24 };
        typedef UnknownMessageResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknownMessageResponse

    unknownMessageResponse::const_reference get_unknownMessageResponse () const;
    unknownMessageResponse::reference ref_unknownMessageResponse (); 
    unknownMessageResponse::reference select_unknownMessageResponse (); 
    unknownMessageResponse::reference select_unknownMessageResponse (unknownMessageResponse::const_reference value); 
    bool unknownMessageResponse_isSelected() const;

    class requestInProgress {
      public:
        enum Id { id_ = 25 };
        typedef RequestInProgress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestInProgress

    requestInProgress::const_reference get_requestInProgress () const;
    requestInProgress::reference ref_requestInProgress (); 
    requestInProgress::reference select_requestInProgress (); 
    requestInProgress::reference select_requestInProgress (requestInProgress::const_reference value); 
    bool requestInProgress_isSelected() const;

    class resourcesAvailableIndicate {
      public:
        enum Id { id_ = 26 };
        typedef ResourcesAvailableIndicate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourcesAvailableIndicate

    resourcesAvailableIndicate::const_reference get_resourcesAvailableIndicate () const;
    resourcesAvailableIndicate::reference ref_resourcesAvailableIndicate (); 
    resourcesAvailableIndicate::reference select_resourcesAvailableIndicate (); 
    resourcesAvailableIndicate::reference select_resourcesAvailableIndicate (resourcesAvailableIndicate::const_reference value); 
    bool resourcesAvailableIndicate_isSelected() const;

    class resourcesAvailableConfirm {
      public:
        enum Id { id_ = 27 };
        typedef ResourcesAvailableConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourcesAvailableConfirm

    resourcesAvailableConfirm::const_reference get_resourcesAvailableConfirm () const;
    resourcesAvailableConfirm::reference ref_resourcesAvailableConfirm (); 
    resourcesAvailableConfirm::reference select_resourcesAvailableConfirm (); 
    resourcesAvailableConfirm::reference select_resourcesAvailableConfirm (resourcesAvailableConfirm::const_reference value); 
    bool resourcesAvailableConfirm_isSelected() const;

    class infoRequestAck {
      public:
        enum Id { id_ = 28 };
        typedef InfoRequestAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infoRequestAck

    infoRequestAck::const_reference get_infoRequestAck () const;
    infoRequestAck::reference ref_infoRequestAck (); 
    infoRequestAck::reference select_infoRequestAck (); 
    infoRequestAck::reference select_infoRequestAck (infoRequestAck::const_reference value); 
    bool infoRequestAck_isSelected() const;

    class infoRequestNak {
      public:
        enum Id { id_ = 29 };
        typedef InfoRequestNak value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infoRequestNak

    infoRequestNak::const_reference get_infoRequestNak () const;
    infoRequestNak::reference ref_infoRequestNak (); 
    infoRequestNak::reference select_infoRequestNak (); 
    infoRequestNak::reference select_infoRequestNak (infoRequestNak::const_reference value); 
    bool infoRequestNak_isSelected() const;

    class serviceControlIndication {
      public:
        enum Id { id_ = 30 };
        typedef ServiceControlIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControlIndication

    serviceControlIndication::const_reference get_serviceControlIndication () const;
    serviceControlIndication::reference ref_serviceControlIndication (); 
    serviceControlIndication::reference select_serviceControlIndication (); 
    serviceControlIndication::reference select_serviceControlIndication (serviceControlIndication::const_reference value); 
    bool serviceControlIndication_isSelected() const;

    class serviceControlResponse {
      public:
        enum Id { id_ = 31 };
        typedef ServiceControlResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceControlResponse

    serviceControlResponse::const_reference get_serviceControlResponse () const;
    serviceControlResponse::reference ref_serviceControlResponse (); 
    serviceControlResponse::reference select_serviceControlResponse (); 
    serviceControlResponse::reference select_serviceControlResponse (serviceControlResponse::const_reference value); 
    bool serviceControlResponse_isSelected() const;

    RasMessage(gatekeeperRequest::Id id, gatekeeperRequest::const_reference value);
    RasMessage(gatekeeperConfirm::Id id, gatekeeperConfirm::const_reference value);
    RasMessage(gatekeeperReject::Id id, gatekeeperReject::const_reference value);
    RasMessage(registrationRequest::Id id, registrationRequest::const_reference value);
    RasMessage(registrationConfirm::Id id, registrationConfirm::const_reference value);
    RasMessage(registrationReject::Id id, registrationReject::const_reference value);
    RasMessage(unregistrationRequest::Id id, unregistrationRequest::const_reference value);
    RasMessage(unregistrationConfirm::Id id, unregistrationConfirm::const_reference value);
    RasMessage(unregistrationReject::Id id, unregistrationReject::const_reference value);
    RasMessage(admissionRequest::Id id, admissionRequest::const_reference value);
    RasMessage(admissionConfirm::Id id, admissionConfirm::const_reference value);
    RasMessage(admissionReject::Id id, admissionReject::const_reference value);
    RasMessage(bandwidthRequest::Id id, bandwidthRequest::const_reference value);
    RasMessage(bandwidthConfirm::Id id, bandwidthConfirm::const_reference value);
    RasMessage(bandwidthReject::Id id, bandwidthReject::const_reference value);
    RasMessage(disengageRequest::Id id, disengageRequest::const_reference value);
    RasMessage(disengageConfirm::Id id, disengageConfirm::const_reference value);
    RasMessage(disengageReject::Id id, disengageReject::const_reference value);
    RasMessage(locationRequest::Id id, locationRequest::const_reference value);
    RasMessage(locationConfirm::Id id, locationConfirm::const_reference value);
    RasMessage(locationReject::Id id, locationReject::const_reference value);
    RasMessage(infoRequest::Id id, infoRequest::const_reference value);
    RasMessage(infoRequestResponse::Id id, infoRequestResponse::const_reference value);
    RasMessage(nonStandardMessage::Id id, nonStandardMessage::const_reference value);
    RasMessage(unknownMessageResponse::Id id, unknownMessageResponse::const_reference value);
    RasMessage(requestInProgress::Id id, requestInProgress::const_reference value);
    RasMessage(resourcesAvailableIndicate::Id id, resourcesAvailableIndicate::const_reference value);
    RasMessage(resourcesAvailableConfirm::Id id, resourcesAvailableConfirm::const_reference value);
    RasMessage(infoRequestAck::Id id, infoRequestAck::const_reference value);
    RasMessage(infoRequestNak::Id id, infoRequestNak::const_reference value);
    RasMessage(serviceControlIndication::Id id, serviceControlIndication::const_reference value);
    RasMessage(serviceControlResponse::Id id, serviceControlResponse::const_reference value);
    void swap(RasMessage & other);
    RasMessage(const RasMessage & other)
    : Inherited(other) {} 

    RasMessage & operator = (const RasMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RasMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[32];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[32];
#endif
};

#include "h323_messages.inl"
} // namespace H323_MESSAGES

#endif // __H323_MESSAGES_H


// End of h323_messages.h
