//
// manufacturer_specific_service_extension_definition.h
//
// Code automatically generated by asnparser.
//

#ifndef __MANUFACTURER_SPECIFIC_SERVICE_EXTENSION_DEFINITION_H
#define __MANUFACTURER_SPECIFIC_SERVICE_EXTENSION_DEFINITION_H

#include <asn1.h>

namespace Manufacturer_specific_service_extension_definition {

//
// Extension<ExtensionSet>
//

template <class ExtensionSet>
class Extension : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Extension(const void* info) : Inherited(info) {}
  public:
    Extension() : Inherited(&theInfo) {}
    Extension(const Extension<ExtensionSet> & other) : Inherited(other)
    {}
    Extension<ExtensionSet>& operator = (const Extension<ExtensionSet>& other)
    { Inherited::operator = (other); return *this; } 
    class extensionId {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionId
    typename extensionId::const_reference get_extensionId () const;
    typename extensionId::reference ref_extensionId ();
    typename extensionId::reference set_extensionId ();
    typename extensionId::reference set_extensionId (typename extensionId::const_reference value);
    class extensionArgument {
      public:
        typedef ASN1::OpenData value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionArgument
    typename extensionArgument::const_reference get_extensionArgument () const;
    typename extensionArgument::reference ref_extensionArgument ();
    typename extensionArgument::reference set_extensionArgument ();
    typename extensionArgument::reference set_extensionArgument (typename extensionArgument::const_reference value);
    void swap(Extension& other);
    Extension<ExtensionSet> * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
    static ASN1::AbstractData* create(const void*);
    bool do_accept(ASN1::Visitor& visitor);
};


//
// EXTENSION
//

class EXTENSION
{
  public:
    typedef ASN1::OBJECT_IDENTIFIER key_type;
    class info_type
    {
      public:
        info_type();
        ASN1::AbstractData* get_ArgumentType() const { return m_ArgumentType ? ASN1::AbstractData::create(m_ArgumentType) : NULL; }
      protected:
        const void* m_ArgumentType;
    };

    typedef const info_type* mapped_type;

    class value_type : public std::pair<key_type, mapped_type>
    {
        typedef std::pair<key_type, mapped_type> Inherited;
      public:
        value_type(const key_type& key, mapped_type mt) : Inherited(key,mt) {}
        ASN1::AbstractData* get_ArgumentType() const { return second->get_ArgumentType(); }
    };

    typedef value_type& reference;
    typedef const value_type& const_reference;
    typedef value_type* pointer;
    typedef const value_type* const_pointer;
    typedef Loki::AssocVector<key_type, mapped_type> map_type;

  private:
    typedef boost::iterator<std::bidirectional_iterator_tag, value_type> my_iterator_traits;
    typedef boost::iterator<std::bidirectional_iterator_tag, const value_type> my_const_iterator_traits;
  public:
    class iterator : public my_iterator_traits
    {
      public:
        iterator() {}
        iterator(map_type::iterator i) : itsIter(i) {}
        map_type::iterator base() const {return itsIter;}
        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}
        iterator& operator++()          {++itsIter; return *this;}
        iterator& operator--()          {--itsIter; return *this;}
        iterator operator++(int)        {iterator t(*this); ++itsIter; return t;}
        iterator operator--(int)        {iterator t(*this); --itsIter; return t;}

        bool operator==(const iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::iterator itsIter;
    };
    class const_iterator : public my_const_iterator_traits
    {
      public:
        const_iterator() {}
        const_iterator(EXTENSION::iterator i) : itsIter(i.base()) {}
        const_iterator(map_type::const_iterator i) : itsIter(i) {}
        map_type::const_iterator base() const {return itsIter;}

        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}

        const_iterator& operator++()          {++itsIter; return *this;}
        const_iterator& operator--()          {--itsIter; return *this;}
        const_iterator operator++(int)        {const_iterator t(*this); ++itsIter; return t;}
        const_iterator operator--(int)        {const_iterator t(*this); --itsIter; return t;}

        bool operator==(const const_iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const const_iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::const_iterator itsIter;
    };

#if defined(BOOST_NO_STD_ITERATOR) || defined (BOOST_MSVC_STD_ITERATOR)
    typedef std::reverse_bidirectional_iterator<iterator, value_type> reverse_iterator;
    typedef std::reverse_bidirectional_iterator<const_iterator, const value_type> const_reverse_iterator;
#else
    typedef std::reverse_iterator<iterator> reverse_iterator;
    typedef std::reverse_iterator<const_iterator> const_reverse_iterator;
#endif

    typedef map_type::key_compare key_compare;
    typedef map_type::difference_type difference_type;
    typedef map_type::size_type size_type;

    EXTENSION(){}
    template <class InputIterator>
            EXTENSION(InputIterator first, InputIterator last)
        : rep(first, last) {}
    EXTENSION(const EXTENSION& other)
        : rep(other.rep) {}

        EXTENSION& operator = (const EXTENSION& other)
    { EXTENSION tmp(other); swap(tmp);  return *this; }

    // iterators
    iterator begin() { return iterator(rep.begin());}
    const_iterator begin() const { return const_iterator(rep.begin());}
    iterator end() { return iterator(rep.end()); }
    const_iterator end() const { return const_iterator(rep.end()); }

    reverse_iterator rbegin() { return reverse_iterator(end());}
    const_reverse_iterator rbegin() const { return const_reverse_iterator(end());}
    reverse_iterator rend() { return reverse_iterator(begin()); }
    const_reverse_iterator rend() const { return const_reverse_iterator(begin()); }
    // capacity
    bool empty() const { return rep.empty(); }
    size_type size() const { return rep.size(); }
    // modifiers
    std::pair<iterator, bool> insert(const value_type& x)
    { 
        std::pair<map_type::iterator, bool> r = rep.insert(x); 
        return std::pair<iterator, bool>(r.first, r.second);
    }
    iterator insert(iterator position, const value_type& x)
    { return iterator(rep.insert(position.base(), x)); }
    void insert(const_iterator first, const_iterator last)
    { rep.insert(first.base(), last.base()); }
    void erase(iterator position) { rep.erase(position.base()); }
    void erase(const key_type& key) { rep.erase(key); }
    void erase(iterator first, iterator last) { rep.erase(first.base(), last.base()); }
    void swap(EXTENSION& other) { rep.swap(other.rep); }
    void clear() { rep.clear(); }
    key_compare key_comp() const { return rep.key_comp(); }
    // operations
    iterator find(const key_type& key) { return iterator(rep.find(key)); }
    const_iterator find(const key_type& key) const { return const_iterator(rep.find(key)); }
    size_type count(const key_type& key) const { return rep.count(key); }
  private:
    map_type rep;
};
#include "manufacturer_specific_service_extension_definition.inl"
} // namespace Manufacturer_specific_service_extension_definition

#endif // __MANUFACTURER_SPECIFIC_SERVICE_EXTENSION_DEFINITION_H


// End of manufacturer_specific_service_extension_definition.h
