//
// multimedia_system_control.h
//
// Code automatically generated by asnparser.
//

#ifndef __MULTIMEDIA_SYSTEM_CONTROL_H
#define __MULTIMEDIA_SYSTEM_CONTROL_H

#include <asn1.h>

#include "msc_t38faxprofile.h"
#include "msc_transportaddress.h"
#include "msc_capabilitytableentry.h"
#include "msc_openlogicalchannel.h"
namespace MULTIMEDIA_SYSTEM_CONTROL {

//
// NonStandardMessage
//

class NonStandardMessage : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NonStandardMessage(const void* info) : Inherited(info) {}
  public:
    NonStandardMessage() : Inherited(&theInfo) {}
    NonStandardMessage(const NonStandardMessage & other) : Inherited(other)
    {}
    NonStandardMessage& operator = (const NonStandardMessage& other)
    { Inherited::operator = (other); return *this; } 
    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void swap(NonStandardMessage& other);
    NonStandardMessage * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MasterSlaveDetermination
//

class MasterSlaveDetermination : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MasterSlaveDetermination(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDetermination() : Inherited(&theInfo) {}
    MasterSlaveDetermination(const MasterSlaveDetermination & other) : Inherited(other)
    {}
    MasterSlaveDetermination& operator = (const MasterSlaveDetermination& other)
    { Inherited::operator = (other); return *this; } 
    class terminalType {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalType
    terminalType::const_reference get_terminalType () const;
    terminalType::reference ref_terminalType ();
    terminalType::reference set_terminalType ();
    terminalType::reference set_terminalType (terminalType::value_type::int_type value);
    class statusDeterminationNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statusDeterminationNumber
    statusDeterminationNumber::const_reference get_statusDeterminationNumber () const;
    statusDeterminationNumber::reference ref_statusDeterminationNumber ();
    statusDeterminationNumber::reference set_statusDeterminationNumber ();
    statusDeterminationNumber::reference set_statusDeterminationNumber (statusDeterminationNumber::value_type::int_type value);
    void swap(MasterSlaveDetermination& other);
    MasterSlaveDetermination * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MasterSlaveDeterminationRelease
//

class MasterSlaveDeterminationRelease : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MasterSlaveDeterminationRelease(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDeterminationRelease() : Inherited(&theInfo) {}
    MasterSlaveDeterminationRelease(const MasterSlaveDeterminationRelease & other) : Inherited(other)
    {}
    MasterSlaveDeterminationRelease& operator = (const MasterSlaveDeterminationRelease& other)
    { Inherited::operator = (other); return *this; } 
    void swap(MasterSlaveDeterminationRelease& other);
    MasterSlaveDeterminationRelease * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  CapabilityDescriptorNumber;

//
// TerminalCapabilitySetRelease
//

class TerminalCapabilitySetRelease : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalCapabilitySetRelease(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySetRelease() : Inherited(&theInfo) {}
    TerminalCapabilitySetRelease(const TerminalCapabilitySetRelease & other) : Inherited(other)
    {}
    TerminalCapabilitySetRelease& operator = (const TerminalCapabilitySetRelease& other)
    { Inherited::operator = (other); return *this; } 
    void swap(TerminalCapabilitySetRelease& other);
    TerminalCapabilitySetRelease * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// V75Capability
//

class V75Capability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V75Capability(const void* info) : Inherited(info) {}
  public:
    V75Capability() : Inherited(&theInfo) {}
    V75Capability(const V75Capability & other) : Inherited(other)
    {}
    V75Capability& operator = (const V75Capability& other)
    { Inherited::operator = (other); return *this; } 
    class audioHeader {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioHeader
    audioHeader::const_reference get_audioHeader () const;
    audioHeader::reference ref_audioHeader ();
    audioHeader::reference set_audioHeader ();
    audioHeader::reference set_audioHeader (bool value);
    void swap(V75Capability& other);
    V75Capability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MediaPacketizationCapability
//

class MediaPacketizationCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MediaPacketizationCapability(const void* info) : Inherited(info) {}
  public:
    MediaPacketizationCapability() : Inherited(&theInfo) {}
    MediaPacketizationCapability(const MediaPacketizationCapability & other) : Inherited(other)
    {}
    MediaPacketizationCapability& operator = (const MediaPacketizationCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_rtpPayloadType
    };

    class h261aVideoPacketization {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h261aVideoPacketization
    h261aVideoPacketization::const_reference get_h261aVideoPacketization () const;
    h261aVideoPacketization::reference ref_h261aVideoPacketization ();
    h261aVideoPacketization::reference set_h261aVideoPacketization ();
    h261aVideoPacketization::reference set_h261aVideoPacketization (bool value);
    class rtpPayloadType {
      public:
        typedef ASN1::SEQUENCE_OF<RTPPayloadType,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpPayloadType
    rtpPayloadType::const_reference get_rtpPayloadType () const;
    rtpPayloadType::reference ref_rtpPayloadType ();
    rtpPayloadType::reference set_rtpPayloadType ();
    rtpPayloadType::reference set_rtpPayloadType (rtpPayloadType::const_reference value);
    void omit_rtpPayloadType ();
    bool rtpPayloadType_isPresent () const;
    void swap(MediaPacketizationCapability& other);
    MediaPacketizationCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RedundancyEncodingCapability
//

class RedundancyEncodingCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RedundancyEncodingCapability(const void* info) : Inherited(info) {}
  public:
    RedundancyEncodingCapability() : Inherited(&theInfo) {}
    RedundancyEncodingCapability(const RedundancyEncodingCapability & other) : Inherited(other)
    {}
    RedundancyEncodingCapability& operator = (const RedundancyEncodingCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_secondaryEncoding
    };

    class redundancyEncodingMethod {
      public:
        typedef RedundancyEncodingMethod value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncodingMethod
    redundancyEncodingMethod::const_reference get_redundancyEncodingMethod () const;
    redundancyEncodingMethod::reference ref_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod (redundancyEncodingMethod::const_reference value);
    class primaryEncoding {
      public:
        typedef CapabilityTableEntryNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class primaryEncoding
    primaryEncoding::const_reference get_primaryEncoding () const;
    primaryEncoding::reference ref_primaryEncoding ();
    primaryEncoding::reference set_primaryEncoding ();
    primaryEncoding::reference set_primaryEncoding (primaryEncoding::value_type::int_type value);
    class secondaryEncoding {
      public:
        typedef ASN1::SEQUENCE_OF<CapabilityTableEntryNumber,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secondaryEncoding
    secondaryEncoding::const_reference get_secondaryEncoding () const;
    secondaryEncoding::reference ref_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding (secondaryEncoding::const_reference value);
    void omit_secondaryEncoding ();
    bool secondaryEncoding_isPresent () const;
    void swap(RedundancyEncodingCapability& other);
    RedundancyEncodingCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MediaDistributionCapability
//

class MediaDistributionCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MediaDistributionCapability(const void* info) : Inherited(info) {}
  public:
    MediaDistributionCapability() : Inherited(&theInfo) {}
    MediaDistributionCapability(const MediaDistributionCapability & other) : Inherited(other)
    {}
    MediaDistributionCapability& operator = (const MediaDistributionCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_centralizedData,
      e_distributedData
    };

    class centralizedControl {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class centralizedControl
    centralizedControl::const_reference get_centralizedControl () const;
    centralizedControl::reference ref_centralizedControl ();
    centralizedControl::reference set_centralizedControl ();
    centralizedControl::reference set_centralizedControl (bool value);
    class distributedControl {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class distributedControl
    distributedControl::const_reference get_distributedControl () const;
    distributedControl::reference ref_distributedControl ();
    distributedControl::reference set_distributedControl ();
    distributedControl::reference set_distributedControl (bool value);
    class centralizedAudio {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class centralizedAudio
    centralizedAudio::const_reference get_centralizedAudio () const;
    centralizedAudio::reference ref_centralizedAudio ();
    centralizedAudio::reference set_centralizedAudio ();
    centralizedAudio::reference set_centralizedAudio (bool value);
    class distributedAudio {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class distributedAudio
    distributedAudio::const_reference get_distributedAudio () const;
    distributedAudio::reference ref_distributedAudio ();
    distributedAudio::reference set_distributedAudio ();
    distributedAudio::reference set_distributedAudio (bool value);
    class centralizedVideo {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class centralizedVideo
    centralizedVideo::const_reference get_centralizedVideo () const;
    centralizedVideo::reference ref_centralizedVideo ();
    centralizedVideo::reference set_centralizedVideo ();
    centralizedVideo::reference set_centralizedVideo (bool value);
    class distributedVideo {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class distributedVideo
    distributedVideo::const_reference get_distributedVideo () const;
    distributedVideo::reference ref_distributedVideo ();
    distributedVideo::reference set_distributedVideo ();
    distributedVideo::reference set_distributedVideo (bool value);
    class centralizedData {
      public:
        typedef ASN1::SEQUENCE_OF<DataApplicationCapability>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class centralizedData
    centralizedData::const_reference get_centralizedData () const;
    centralizedData::reference ref_centralizedData ();
    centralizedData::reference set_centralizedData ();
    centralizedData::reference set_centralizedData (centralizedData::const_reference value);
    void omit_centralizedData ();
    bool centralizedData_isPresent () const;
    class distributedData {
      public:
        typedef ASN1::SEQUENCE_OF<DataApplicationCapability>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class distributedData
    distributedData::const_reference get_distributedData () const;
    distributedData::reference ref_distributedData ();
    distributedData::reference set_distributedData ();
    distributedData::reference set_distributedData (distributedData::const_reference value);
    void omit_distributedData ();
    bool distributedData_isPresent () const;
    void swap(MediaDistributionCapability& other);
    MediaDistributionCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// OpenLogicalChannelConfirm
//

class OpenLogicalChannelConfirm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannelConfirm(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelConfirm() : Inherited(&theInfo) {}
    OpenLogicalChannelConfirm(const OpenLogicalChannelConfirm & other) : Inherited(other)
    {}
    OpenLogicalChannelConfirm& operator = (const OpenLogicalChannelConfirm& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    void swap(OpenLogicalChannelConfirm& other);
    OpenLogicalChannelConfirm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// RequestModeRelease
//

class RequestModeRelease : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestModeRelease(const void* info) : Inherited(info) {}
  public:
    RequestModeRelease() : Inherited(&theInfo) {}
    RequestModeRelease(const RequestModeRelease & other) : Inherited(other)
    {}
    RequestModeRelease& operator = (const RequestModeRelease& other)
    { Inherited::operator = (other); return *this; } 
    void swap(RequestModeRelease& other);
    RequestModeRelease * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// MultiplexedStreamModeParameters
//

class MultiplexedStreamModeParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultiplexedStreamModeParameters(const void* info) : Inherited(info) {}
  public:
    MultiplexedStreamModeParameters() : Inherited(&theInfo) {}
    MultiplexedStreamModeParameters(const MultiplexedStreamModeParameters & other) : Inherited(other)
    {}
    MultiplexedStreamModeParameters& operator = (const MultiplexedStreamModeParameters& other)
    { Inherited::operator = (other); return *this; } 
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    void swap(MultiplexedStreamModeParameters& other);
    MultiplexedStreamModeParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// V76ModeParameters
//

class V76ModeParameters : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    V76ModeParameters(const void* info) : Inherited(info) {}
  public:
    V76ModeParameters() : Inherited(&theInfo) {}
    class suspendResumewAddress {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumewAddress

    suspendResumewAddress::reference select_suspendResumewAddress (); 
    bool suspendResumewAddress_isSelected() const;

    class suspendResumewoAddress {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumewoAddress

    suspendResumewoAddress::reference select_suspendResumewoAddress (); 
    bool suspendResumewoAddress_isSelected() const;

    V76ModeParameters(suspendResumewAddress::Id id, suspendResumewAddress::const_reference value);
    V76ModeParameters(suspendResumewoAddress::Id id, suspendResumewoAddress::const_reference value);
    void swap(V76ModeParameters & other);
    V76ModeParameters(const V76ModeParameters & other)
    : Inherited(other) {} 

    V76ModeParameters & operator = (const V76ModeParameters & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    V76ModeParameters * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// IS11172VideoMode
//

class IS11172VideoMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IS11172VideoMode(const void* info) : Inherited(info) {}
  public:
    IS11172VideoMode() : Inherited(&theInfo) {}
    IS11172VideoMode(const IS11172VideoMode & other) : Inherited(other)
    {}
    IS11172VideoMode& operator = (const IS11172VideoMode& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_videoBitRate,
      e_vbvBufferSize,
      e_samplesPerLine,
      e_linesPerFrame,
      e_pictureRate,
      e_luminanceSampleRate
    };

    class constrainedBitstream {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class constrainedBitstream
    constrainedBitstream::const_reference get_constrainedBitstream () const;
    constrainedBitstream::reference ref_constrainedBitstream ();
    constrainedBitstream::reference set_constrainedBitstream ();
    constrainedBitstream::reference set_constrainedBitstream (bool value);
    class videoBitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 1073741823>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoBitRate
    videoBitRate::const_reference get_videoBitRate () const;
    videoBitRate::reference ref_videoBitRate ();
    videoBitRate::reference set_videoBitRate ();
    videoBitRate::reference set_videoBitRate (videoBitRate::value_type::int_type value);
    void omit_videoBitRate ();
    bool videoBitRate_isPresent () const;
    class vbvBufferSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 262143>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class vbvBufferSize
    vbvBufferSize::const_reference get_vbvBufferSize () const;
    vbvBufferSize::reference ref_vbvBufferSize ();
    vbvBufferSize::reference set_vbvBufferSize ();
    vbvBufferSize::reference set_vbvBufferSize (vbvBufferSize::value_type::int_type value);
    void omit_vbvBufferSize ();
    bool vbvBufferSize_isPresent () const;
    class samplesPerLine {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16383>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class samplesPerLine
    samplesPerLine::const_reference get_samplesPerLine () const;
    samplesPerLine::reference ref_samplesPerLine ();
    samplesPerLine::reference set_samplesPerLine ();
    samplesPerLine::reference set_samplesPerLine (samplesPerLine::value_type::int_type value);
    void omit_samplesPerLine ();
    bool samplesPerLine_isPresent () const;
    class linesPerFrame {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16383>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class linesPerFrame
    linesPerFrame::const_reference get_linesPerFrame () const;
    linesPerFrame::reference ref_linesPerFrame ();
    linesPerFrame::reference set_linesPerFrame ();
    linesPerFrame::reference set_linesPerFrame (linesPerFrame::value_type::int_type value);
    void omit_linesPerFrame ();
    bool linesPerFrame_isPresent () const;
    class pictureRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pictureRate
    pictureRate::const_reference get_pictureRate () const;
    pictureRate::reference ref_pictureRate ();
    pictureRate::reference set_pictureRate ();
    pictureRate::reference set_pictureRate (pictureRate::value_type::int_type value);
    void omit_pictureRate ();
    bool pictureRate_isPresent () const;
    class luminanceSampleRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class luminanceSampleRate
    luminanceSampleRate::const_reference get_luminanceSampleRate () const;
    luminanceSampleRate::reference ref_luminanceSampleRate ();
    luminanceSampleRate::reference set_luminanceSampleRate ();
    luminanceSampleRate::reference set_luminanceSampleRate (luminanceSampleRate::value_type::int_type value);
    void omit_luminanceSampleRate ();
    bool luminanceSampleRate_isPresent () const;
    void swap(IS11172VideoMode& other);
    IS11172VideoMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// MaintenanceLoopOffCommand
//

class MaintenanceLoopOffCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MaintenanceLoopOffCommand(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopOffCommand() : Inherited(&theInfo) {}
    MaintenanceLoopOffCommand(const MaintenanceLoopOffCommand & other) : Inherited(other)
    {}
    MaintenanceLoopOffCommand& operator = (const MaintenanceLoopOffCommand& other)
    { Inherited::operator = (other); return *this; } 
    void swap(MaintenanceLoopOffCommand& other);
    MaintenanceLoopOffCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// CommunicationModeRequest
//

class CommunicationModeRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CommunicationModeRequest(const void* info) : Inherited(info) {}
  public:
    CommunicationModeRequest() : Inherited(&theInfo) {}
    CommunicationModeRequest(const CommunicationModeRequest & other) : Inherited(other)
    {}
    CommunicationModeRequest& operator = (const CommunicationModeRequest& other)
    { Inherited::operator = (other); return *this; } 
    void swap(CommunicationModeRequest& other);
    CommunicationModeRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// Criteria
//

class Criteria : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Criteria(const void* info) : Inherited(info) {}
  public:
    Criteria() : Inherited(&theInfo) {}
    Criteria(const Criteria & other) : Inherited(other)
    {}
    Criteria& operator = (const Criteria& other)
    { Inherited::operator = (other); return *this; } 
    class field {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class field
    field::const_reference get_field () const;
    field::reference ref_field ();
    field::reference set_field ();
    field::reference set_field (field::const_reference value);
    class value {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class value
    value::const_reference get_value () const;
    value::reference ref_value ();
    value::reference set_value ();
    value::reference set_value (const std::vector<char>& value);
    void swap(Criteria& other);
    Criteria * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 128> >  TerminalID;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 32> >  ConferenceID;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 32> >  Password;

//
// TerminalInformation
//

class TerminalInformation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalInformation(const void* info) : Inherited(info) {}
  public:
    TerminalInformation() : Inherited(&theInfo) {}
    TerminalInformation(const TerminalInformation & other) : Inherited(other)
    {}
    TerminalInformation& operator = (const TerminalInformation& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class terminalID {
      public:
        typedef TerminalID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalID
    terminalID::const_reference get_terminalID () const;
    terminalID::reference ref_terminalID ();
    terminalID::reference set_terminalID ();
    terminalID::reference set_terminalID (const std::vector<char>& value);
    void swap(TerminalInformation& other);
    TerminalInformation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RemoteMCRequest
//

class RemoteMCRequest : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RemoteMCRequest(const void* info) : Inherited(info) {}
  public:
    RemoteMCRequest() : Inherited(&theInfo) {}
    class masterActivate {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterActivate

    masterActivate::reference select_masterActivate (); 
    bool masterActivate_isSelected() const;

    class slaveActivate {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class slaveActivate

    slaveActivate::reference select_slaveActivate (); 
    bool slaveActivate_isSelected() const;

    class deActivate {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deActivate

    deActivate::reference select_deActivate (); 
    bool deActivate_isSelected() const;

    RemoteMCRequest(masterActivate::Id id, masterActivate::const_reference value);
    RemoteMCRequest(slaveActivate::Id id, slaveActivate::const_reference value);
    RemoteMCRequest(deActivate::Id id, deActivate::const_reference value);
    void swap(RemoteMCRequest & other);
    RemoteMCRequest(const RemoteMCRequest & other)
    : Inherited(other) {} 

    RemoteMCRequest & operator = (const RemoteMCRequest & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RemoteMCRequest * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// DialingInformationNetworkType
//

class DialingInformationNetworkType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DialingInformationNetworkType(const void* info) : Inherited(info) {}
  public:
    DialingInformationNetworkType() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class n_isdn {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class n_isdn

    n_isdn::reference select_n_isdn (); 
    bool n_isdn_isSelected() const;

    class gstn {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gstn

    gstn::reference select_gstn (); 
    bool gstn_isSelected() const;

    class mobile {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mobile

    mobile::reference select_mobile (); 
    bool mobile_isSelected() const;

    DialingInformationNetworkType(nonStandard::Id id, nonStandard::const_reference value);
    DialingInformationNetworkType(n_isdn::Id id, n_isdn::const_reference value);
    DialingInformationNetworkType(gstn::Id id, gstn::const_reference value);
    DialingInformationNetworkType(mobile::Id id, mobile::const_reference value);
    void swap(DialingInformationNetworkType & other);
    DialingInformationNetworkType(const DialingInformationNetworkType & other)
    : Inherited(other) {} 

    DialingInformationNetworkType & operator = (const DialingInformationNetworkType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DialingInformationNetworkType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// ConnectionIdentifier
//

class ConnectionIdentifier : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConnectionIdentifier(const void* info) : Inherited(info) {}
  public:
    ConnectionIdentifier() : Inherited(&theInfo) {}
    ConnectionIdentifier(const ConnectionIdentifier & other) : Inherited(other)
    {}
    ConnectionIdentifier& operator = (const ConnectionIdentifier& other)
    { Inherited::operator = (other); return *this; } 
    class channelTag {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class channelTag
    channelTag::const_reference get_channelTag () const;
    channelTag::reference ref_channelTag ();
    channelTag::reference set_channelTag ();
    channelTag::reference set_channelTag (channelTag::value_type::int_type value);
    class sequenceNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    void swap(ConnectionIdentifier& other);
    ConnectionIdentifier * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  MaximumBitRate;

//
// LogicalChannelRateRejectReason
//

class LogicalChannelRateRejectReason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    LogicalChannelRateRejectReason(const void* info) : Inherited(info) {}
  public:
    LogicalChannelRateRejectReason() : Inherited(&theInfo) {}
    class undefinedReason {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedReason

    undefinedReason::reference select_undefinedReason (); 
    bool undefinedReason_isSelected() const;

    class insufficientResources {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class insufficientResources

    insufficientResources::reference select_insufficientResources (); 
    bool insufficientResources_isSelected() const;

    LogicalChannelRateRejectReason(undefinedReason::Id id, undefinedReason::const_reference value);
    LogicalChannelRateRejectReason(insufficientResources::Id id, insufficientResources::const_reference value);
    void swap(LogicalChannelRateRejectReason & other);
    LogicalChannelRateRejectReason(const LogicalChannelRateRejectReason & other)
    : Inherited(other) {} 

    LogicalChannelRateRejectReason & operator = (const LogicalChannelRateRejectReason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    LogicalChannelRateRejectReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// LogicalChannelRateRelease
//

class LogicalChannelRateRelease : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LogicalChannelRateRelease(const void* info) : Inherited(info) {}
  public:
    LogicalChannelRateRelease() : Inherited(&theInfo) {}
    LogicalChannelRateRelease(const LogicalChannelRateRelease & other) : Inherited(other)
    {}
    LogicalChannelRateRelease& operator = (const LogicalChannelRateRelease& other)
    { Inherited::operator = (other); return *this; } 
    void swap(LogicalChannelRateRelease& other);
    LogicalChannelRateRelease * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// SubstituteConferenceIDCommand
//

class SubstituteConferenceIDCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SubstituteConferenceIDCommand(const void* info) : Inherited(info) {}
  public:
    SubstituteConferenceIDCommand() : Inherited(&theInfo) {}
    SubstituteConferenceIDCommand(const SubstituteConferenceIDCommand & other) : Inherited(other)
    {}
    SubstituteConferenceIDCommand& operator = (const SubstituteConferenceIDCommand& other)
    { Inherited::operator = (other); return *this; } 
    class conferenceIdentifier {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 16, 16> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceIdentifier
    conferenceIdentifier::const_reference get_conferenceIdentifier () const;
    conferenceIdentifier::reference ref_conferenceIdentifier ();
    conferenceIdentifier::reference set_conferenceIdentifier ();
    conferenceIdentifier::reference set_conferenceIdentifier (const std::vector<char>& value);
    void swap(SubstituteConferenceIDCommand& other);
    SubstituteConferenceIDCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// KeyProtectionMethod
//

class KeyProtectionMethod : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    KeyProtectionMethod(const void* info) : Inherited(info) {}
  public:
    KeyProtectionMethod() : Inherited(&theInfo) {}
    KeyProtectionMethod(const KeyProtectionMethod & other) : Inherited(other)
    {}
    KeyProtectionMethod& operator = (const KeyProtectionMethod& other)
    { Inherited::operator = (other); return *this; } 
    class secureChannel {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secureChannel
    secureChannel::const_reference get_secureChannel () const;
    secureChannel::reference ref_secureChannel ();
    secureChannel::reference set_secureChannel ();
    secureChannel::reference set_secureChannel (bool value);
    class sharedSecret {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sharedSecret
    sharedSecret::const_reference get_sharedSecret () const;
    sharedSecret::reference ref_sharedSecret ();
    sharedSecret::reference set_sharedSecret ();
    sharedSecret::reference set_sharedSecret (bool value);
    class certProtectedKey {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certProtectedKey
    certProtectedKey::const_reference get_certProtectedKey () const;
    certProtectedKey::reference ref_certProtectedKey ();
    certProtectedKey::reference set_certProtectedKey ();
    certProtectedKey::reference set_certProtectedKey (bool value);
    void swap(KeyProtectionMethod& other);
    KeyProtectionMethod * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// EncryptionUpdateRequest
//

class EncryptionUpdateRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EncryptionUpdateRequest(const void* info) : Inherited(info) {}
  public:
    EncryptionUpdateRequest() : Inherited(&theInfo) {}
    EncryptionUpdateRequest(const EncryptionUpdateRequest & other) : Inherited(other)
    {}
    EncryptionUpdateRequest& operator = (const EncryptionUpdateRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_keyProtectionMethod
    };

    class keyProtectionMethod {
      public:
        typedef KeyProtectionMethod value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keyProtectionMethod
    keyProtectionMethod::const_reference get_keyProtectionMethod () const;
    keyProtectionMethod::reference ref_keyProtectionMethod ();
    keyProtectionMethod::reference set_keyProtectionMethod ();
    keyProtectionMethod::reference set_keyProtectionMethod (keyProtectionMethod::const_reference value);
    void omit_keyProtectionMethod ();
    bool keyProtectionMethod_isPresent () const;
    void swap(EncryptionUpdateRequest& other);
    EncryptionUpdateRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// PictureReference
//

class PictureReference : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    PictureReference(const void* info) : Inherited(info) {}
  public:
    PictureReference() : Inherited(&theInfo) {}
    class pictureNumber {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 1023>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pictureNumber

    pictureNumber::const_reference get_pictureNumber () const;
    pictureNumber::reference ref_pictureNumber (); 
    pictureNumber::reference select_pictureNumber (); 
    pictureNumber::reference select_pictureNumber (pictureNumber::value_type::int_type value); 
    bool pictureNumber_isSelected() const;

    class longTermPictureIndex {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class longTermPictureIndex

    longTermPictureIndex::const_reference get_longTermPictureIndex () const;
    longTermPictureIndex::reference ref_longTermPictureIndex (); 
    longTermPictureIndex::reference select_longTermPictureIndex (); 
    longTermPictureIndex::reference select_longTermPictureIndex (longTermPictureIndex::value_type::int_type value); 
    bool longTermPictureIndex_isSelected() const;

    PictureReference(pictureNumber::Id id, pictureNumber::value_type::int_type value);
    PictureReference(longTermPictureIndex::Id id, longTermPictureIndex::value_type::int_type value);
    void swap(PictureReference & other);
    PictureReference(const PictureReference & other)
    : Inherited(other) {} 

    PictureReference & operator = (const PictureReference & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    PictureReference * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// TerminalYouAreSeeingInSubPictureNumber
//

class TerminalYouAreSeeingInSubPictureNumber : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalYouAreSeeingInSubPictureNumber(const void* info) : Inherited(info) {}
  public:
    TerminalYouAreSeeingInSubPictureNumber() : Inherited(&theInfo) {}
    TerminalYouAreSeeingInSubPictureNumber(const TerminalYouAreSeeingInSubPictureNumber & other) : Inherited(other)
    {}
    TerminalYouAreSeeingInSubPictureNumber& operator = (const TerminalYouAreSeeingInSubPictureNumber& other)
    { Inherited::operator = (other); return *this; } 
    class terminalNumber {
      public:
        typedef TerminalNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalNumber
    terminalNumber::const_reference get_terminalNumber () const;
    terminalNumber::reference ref_terminalNumber ();
    terminalNumber::reference set_terminalNumber ();
    terminalNumber::reference set_terminalNumber (terminalNumber::value_type::int_type value);
    class subPictureNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class subPictureNumber
    subPictureNumber::const_reference get_subPictureNumber () const;
    subPictureNumber::reference ref_subPictureNumber ();
    subPictureNumber::reference set_subPictureNumber ();
    subPictureNumber::reference set_subPictureNumber (subPictureNumber::value_type::int_type value);
    void swap(TerminalYouAreSeeingInSubPictureNumber& other);
    TerminalYouAreSeeingInSubPictureNumber * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// VideoIndicateCompose
//

class VideoIndicateCompose : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    VideoIndicateCompose(const void* info) : Inherited(info) {}
  public:
    VideoIndicateCompose() : Inherited(&theInfo) {}
    VideoIndicateCompose(const VideoIndicateCompose & other) : Inherited(other)
    {}
    VideoIndicateCompose& operator = (const VideoIndicateCompose& other)
    { Inherited::operator = (other); return *this; } 
    class compositionNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class compositionNumber
    compositionNumber::const_reference get_compositionNumber () const;
    compositionNumber::reference ref_compositionNumber ();
    compositionNumber::reference set_compositionNumber ();
    compositionNumber::reference set_compositionNumber (compositionNumber::value_type::int_type value);
    void swap(VideoIndicateCompose& other);
    VideoIndicateCompose * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// H2250MaximumSkewIndication
//

class H2250MaximumSkewIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250MaximumSkewIndication(const void* info) : Inherited(info) {}
  public:
    H2250MaximumSkewIndication() : Inherited(&theInfo) {}
    H2250MaximumSkewIndication(const H2250MaximumSkewIndication & other) : Inherited(other)
    {}
    H2250MaximumSkewIndication& operator = (const H2250MaximumSkewIndication& other)
    { Inherited::operator = (other); return *this; } 
    class logicalChannelNumber1 {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber1
    logicalChannelNumber1::const_reference get_logicalChannelNumber1 () const;
    logicalChannelNumber1::reference ref_logicalChannelNumber1 ();
    logicalChannelNumber1::reference set_logicalChannelNumber1 ();
    logicalChannelNumber1::reference set_logicalChannelNumber1 (logicalChannelNumber1::value_type::int_type value);
    class logicalChannelNumber2 {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber2
    logicalChannelNumber2::const_reference get_logicalChannelNumber2 () const;
    logicalChannelNumber2::reference ref_logicalChannelNumber2 ();
    logicalChannelNumber2::reference set_logicalChannelNumber2 ();
    logicalChannelNumber2::reference set_logicalChannelNumber2 (logicalChannelNumber2::value_type::int_type value);
    class maximumSkew {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4095>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumSkew
    maximumSkew::const_reference get_maximumSkew () const;
    maximumSkew::reference ref_maximumSkew ();
    maximumSkew::reference set_maximumSkew ();
    maximumSkew::reference set_maximumSkew (maximumSkew::value_type::int_type value);
    void swap(H2250MaximumSkewIndication& other);
    H2250MaximumSkewIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MCLocationIndication
//

class MCLocationIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MCLocationIndication(const void* info) : Inherited(info) {}
  public:
    MCLocationIndication() : Inherited(&theInfo) {}
    MCLocationIndication(const MCLocationIndication & other) : Inherited(other)
    {}
    MCLocationIndication& operator = (const MCLocationIndication& other)
    { Inherited::operator = (other); return *this; } 
    class signalAddress {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalAddress
    signalAddress::const_reference get_signalAddress () const;
    signalAddress::reference ref_signalAddress ();
    signalAddress::reference set_signalAddress ();
    signalAddress::reference set_signalAddress (signalAddress::const_reference value);
    void swap(MCLocationIndication& other);
    MCLocationIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// VendorIdentification
//

class VendorIdentification : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    VendorIdentification(const void* info) : Inherited(info) {}
  public:
    VendorIdentification() : Inherited(&theInfo) {}
    VendorIdentification(const VendorIdentification & other) : Inherited(other)
    {}
    VendorIdentification& operator = (const VendorIdentification& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_productNumber,
      e_versionNumber
    };

    class vendor {
      public:
        typedef NonStandardIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class vendor
    vendor::const_reference get_vendor () const;
    vendor::reference ref_vendor ();
    vendor::reference set_vendor ();
    vendor::reference set_vendor (vendor::const_reference value);
    class productNumber {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class productNumber
    productNumber::const_reference get_productNumber () const;
    productNumber::reference ref_productNumber ();
    productNumber::reference set_productNumber ();
    productNumber::reference set_productNumber (const std::vector<char>& value);
    void omit_productNumber ();
    bool productNumber_isPresent () const;
    class versionNumber {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class versionNumber
    versionNumber::const_reference get_versionNumber () const;
    versionNumber::reference ref_versionNumber ();
    versionNumber::reference set_versionNumber ();
    versionNumber::reference set_versionNumber (const std::vector<char>& value);
    void omit_versionNumber ();
    bool versionNumber_isPresent () const;
    void swap(VendorIdentification& other);
    VendorIdentification * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MobileMultilinkReconfigurationIndication
//

class MobileMultilinkReconfigurationIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MobileMultilinkReconfigurationIndication(const void* info) : Inherited(info) {}
  public:
    MobileMultilinkReconfigurationIndication() : Inherited(&theInfo) {}
    MobileMultilinkReconfigurationIndication(const MobileMultilinkReconfigurationIndication & other) : Inherited(other)
    {}
    MobileMultilinkReconfigurationIndication& operator = (const MobileMultilinkReconfigurationIndication& other)
    { Inherited::operator = (other); return *this; } 
    class sampleSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sampleSize
    sampleSize::const_reference get_sampleSize () const;
    sampleSize::reference ref_sampleSize ();
    sampleSize::reference set_sampleSize ();
    sampleSize::reference set_sampleSize (sampleSize::value_type::int_type value);
    class samplesPerFrame {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class samplesPerFrame
    samplesPerFrame::const_reference get_samplesPerFrame () const;
    samplesPerFrame::reference ref_samplesPerFrame ();
    samplesPerFrame::reference set_samplesPerFrame ();
    samplesPerFrame::reference set_samplesPerFrame (samplesPerFrame::value_type::int_type value);
    void swap(MobileMultilinkReconfigurationIndication& other);
    MobileMultilinkReconfigurationIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  SequenceNumber;

//
// MasterSlaveDeterminationAck_decision
//

class MasterSlaveDeterminationAck_decision : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MasterSlaveDeterminationAck_decision(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDeterminationAck_decision() : Inherited(&theInfo) {}
    class master {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class master

    master::reference select_master (); 
    bool master_isSelected() const;

    class slave {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class slave

    slave::reference select_slave (); 
    bool slave_isSelected() const;

    MasterSlaveDeterminationAck_decision(master::Id id, master::const_reference value);
    MasterSlaveDeterminationAck_decision(slave::Id id, slave::const_reference value);
    void swap(MasterSlaveDeterminationAck_decision & other);
    MasterSlaveDeterminationAck_decision(const MasterSlaveDeterminationAck_decision & other)
    : Inherited(other) {} 

    MasterSlaveDeterminationAck_decision & operator = (const MasterSlaveDeterminationAck_decision & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MasterSlaveDeterminationAck_decision * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MasterSlaveDeterminationReject_cause
//

class MasterSlaveDeterminationReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MasterSlaveDeterminationReject_cause(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDeterminationReject_cause() : Inherited(&theInfo) {}
    class identicalNumbers {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class identicalNumbers

    identicalNumbers::reference select_identicalNumbers (); 
    bool identicalNumbers_isSelected() const;

    MasterSlaveDeterminationReject_cause(identicalNumbers::Id id, identicalNumbers::const_reference value);
    void swap(MasterSlaveDeterminationReject_cause & other);
    MasterSlaveDeterminationReject_cause(const MasterSlaveDeterminationReject_cause & other)
    : Inherited(other) {} 

    MasterSlaveDeterminationReject_cause & operator = (const MasterSlaveDeterminationReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MasterSlaveDeterminationReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[1];
#endif
};

//
// H2250Capability_mcCapability
//

class H2250Capability_mcCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250Capability_mcCapability(const void* info) : Inherited(info) {}
  public:
    H2250Capability_mcCapability() : Inherited(&theInfo) {}
    H2250Capability_mcCapability(const H2250Capability_mcCapability & other) : Inherited(other)
    {}
    H2250Capability_mcCapability& operator = (const H2250Capability_mcCapability& other)
    { Inherited::operator = (other); return *this; } 
    class centralizedConferenceMC {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class centralizedConferenceMC
    centralizedConferenceMC::const_reference get_centralizedConferenceMC () const;
    centralizedConferenceMC::reference ref_centralizedConferenceMC ();
    centralizedConferenceMC::reference set_centralizedConferenceMC ();
    centralizedConferenceMC::reference set_centralizedConferenceMC (bool value);
    class decentralizedConferenceMC {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class decentralizedConferenceMC
    decentralizedConferenceMC::const_reference get_decentralizedConferenceMC () const;
    decentralizedConferenceMC::reference ref_decentralizedConferenceMC ();
    decentralizedConferenceMC::reference set_decentralizedConferenceMC ();
    decentralizedConferenceMC::reference set_decentralizedConferenceMC (bool value);
    void swap(H2250Capability_mcCapability& other);
    H2250Capability_mcCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RequestModeAck_response
//

class RequestModeAck_response : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RequestModeAck_response(const void* info) : Inherited(info) {}
  public:
    RequestModeAck_response() : Inherited(&theInfo) {}
    class willTransmitMostPreferredMode {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willTransmitMostPreferredMode

    willTransmitMostPreferredMode::reference select_willTransmitMostPreferredMode (); 
    bool willTransmitMostPreferredMode_isSelected() const;

    class willTransmitLessPreferredMode {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class willTransmitLessPreferredMode

    willTransmitLessPreferredMode::reference select_willTransmitLessPreferredMode (); 
    bool willTransmitLessPreferredMode_isSelected() const;

    RequestModeAck_response(willTransmitMostPreferredMode::Id id, willTransmitMostPreferredMode::const_reference value);
    RequestModeAck_response(willTransmitLessPreferredMode::Id id, willTransmitLessPreferredMode::const_reference value);
    void swap(RequestModeAck_response & other);
    RequestModeAck_response(const RequestModeAck_response & other)
    : Inherited(other) {} 

    RequestModeAck_response & operator = (const RequestModeAck_response & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RequestModeAck_response * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// RequestModeReject_cause
//

class RequestModeReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RequestModeReject_cause(const void* info) : Inherited(info) {}
  public:
    RequestModeReject_cause() : Inherited(&theInfo) {}
    class modeUnavailable {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modeUnavailable

    modeUnavailable::reference select_modeUnavailable (); 
    bool modeUnavailable_isSelected() const;

    class multipointConstraint {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipointConstraint

    multipointConstraint::reference select_multipointConstraint (); 
    bool multipointConstraint_isSelected() const;

    class requestDenied {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestDenied

    requestDenied::reference select_requestDenied (); 
    bool requestDenied_isSelected() const;

    RequestModeReject_cause(modeUnavailable::Id id, modeUnavailable::const_reference value);
    RequestModeReject_cause(multipointConstraint::Id id, multipointConstraint::const_reference value);
    RequestModeReject_cause(requestDenied::Id id, requestDenied::const_reference value);
    void swap(RequestModeReject_cause & other);
    RequestModeReject_cause(const RequestModeReject_cause & other)
    : Inherited(other) {} 

    RequestModeReject_cause & operator = (const RequestModeReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RequestModeReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H261VideoMode_resolution
//

class H261VideoMode_resolution : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H261VideoMode_resolution(const void* info) : Inherited(info) {}
  public:
    H261VideoMode_resolution() : Inherited(&theInfo) {}
    class qcif {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qcif

    qcif::reference select_qcif (); 
    bool qcif_isSelected() const;

    class cif {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cif

    cif::reference select_cif (); 
    bool cif_isSelected() const;

    H261VideoMode_resolution(qcif::Id id, qcif::const_reference value);
    H261VideoMode_resolution(cif::Id id, cif::const_reference value);
    void swap(H261VideoMode_resolution & other);
    H261VideoMode_resolution(const H261VideoMode_resolution & other)
    : Inherited(other) {} 

    H261VideoMode_resolution & operator = (const H261VideoMode_resolution & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H261VideoMode_resolution * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H262VideoMode_profileAndLevel
//

class H262VideoMode_profileAndLevel : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H262VideoMode_profileAndLevel(const void* info) : Inherited(info) {}
  public:
    H262VideoMode_profileAndLevel() : Inherited(&theInfo) {}
    class profileAndLevel_SPatML {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_SPatML

    profileAndLevel_SPatML::reference select_profileAndLevel_SPatML (); 
    bool profileAndLevel_SPatML_isSelected() const;

    class profileAndLevel_MPatLL {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_MPatLL

    profileAndLevel_MPatLL::reference select_profileAndLevel_MPatLL (); 
    bool profileAndLevel_MPatLL_isSelected() const;

    class profileAndLevel_MPatML {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_MPatML

    profileAndLevel_MPatML::reference select_profileAndLevel_MPatML (); 
    bool profileAndLevel_MPatML_isSelected() const;

    class profileAndLevel_MPatH_14 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_MPatH_14

    profileAndLevel_MPatH_14::reference select_profileAndLevel_MPatH_14 (); 
    bool profileAndLevel_MPatH_14_isSelected() const;

    class profileAndLevel_MPatHL {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_MPatHL

    profileAndLevel_MPatHL::reference select_profileAndLevel_MPatHL (); 
    bool profileAndLevel_MPatHL_isSelected() const;

    class profileAndLevel_SNRatLL {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_SNRatLL

    profileAndLevel_SNRatLL::reference select_profileAndLevel_SNRatLL (); 
    bool profileAndLevel_SNRatLL_isSelected() const;

    class profileAndLevel_SNRatML {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_SNRatML

    profileAndLevel_SNRatML::reference select_profileAndLevel_SNRatML (); 
    bool profileAndLevel_SNRatML_isSelected() const;

    class profileAndLevel_SpatialatH_14 {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_SpatialatH_14

    profileAndLevel_SpatialatH_14::reference select_profileAndLevel_SpatialatH_14 (); 
    bool profileAndLevel_SpatialatH_14_isSelected() const;

    class profileAndLevel_HPatML {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_HPatML

    profileAndLevel_HPatML::reference select_profileAndLevel_HPatML (); 
    bool profileAndLevel_HPatML_isSelected() const;

    class profileAndLevel_HPatH_14 {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_HPatH_14

    profileAndLevel_HPatH_14::reference select_profileAndLevel_HPatH_14 (); 
    bool profileAndLevel_HPatH_14_isSelected() const;

    class profileAndLevel_HPatHL {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel_HPatHL

    profileAndLevel_HPatHL::reference select_profileAndLevel_HPatHL (); 
    bool profileAndLevel_HPatHL_isSelected() const;

    H262VideoMode_profileAndLevel(profileAndLevel_SPatML::Id id, profileAndLevel_SPatML::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_MPatLL::Id id, profileAndLevel_MPatLL::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_MPatML::Id id, profileAndLevel_MPatML::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_MPatH_14::Id id, profileAndLevel_MPatH_14::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_MPatHL::Id id, profileAndLevel_MPatHL::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_SNRatLL::Id id, profileAndLevel_SNRatLL::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_SNRatML::Id id, profileAndLevel_SNRatML::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_SpatialatH_14::Id id, profileAndLevel_SpatialatH_14::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_HPatML::Id id, profileAndLevel_HPatML::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_HPatH_14::Id id, profileAndLevel_HPatH_14::const_reference value);
    H262VideoMode_profileAndLevel(profileAndLevel_HPatHL::Id id, profileAndLevel_HPatHL::const_reference value);
    void swap(H262VideoMode_profileAndLevel & other);
    H262VideoMode_profileAndLevel(const H262VideoMode_profileAndLevel & other)
    : Inherited(other) {} 

    H262VideoMode_profileAndLevel & operator = (const H262VideoMode_profileAndLevel & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H262VideoMode_profileAndLevel * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[11];
#endif
};

//
// H263VideoMode_resolution
//

class H263VideoMode_resolution : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H263VideoMode_resolution(const void* info) : Inherited(info) {}
  public:
    H263VideoMode_resolution() : Inherited(&theInfo) {}
    class sqcif {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sqcif

    sqcif::reference select_sqcif (); 
    bool sqcif_isSelected() const;

    class qcif {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qcif

    qcif::reference select_qcif (); 
    bool qcif_isSelected() const;

    class cif {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cif

    cif::reference select_cif (); 
    bool cif_isSelected() const;

    class cif4 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cif4

    cif4::reference select_cif4 (); 
    bool cif4_isSelected() const;

    class cif16 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cif16

    cif16::reference select_cif16 (); 
    bool cif16_isSelected() const;

    H263VideoMode_resolution(sqcif::Id id, sqcif::const_reference value);
    H263VideoMode_resolution(qcif::Id id, qcif::const_reference value);
    H263VideoMode_resolution(cif::Id id, cif::const_reference value);
    H263VideoMode_resolution(cif4::Id id, cif4::const_reference value);
    H263VideoMode_resolution(cif16::Id id, cif16::const_reference value);
    void swap(H263VideoMode_resolution & other);
    H263VideoMode_resolution(const H263VideoMode_resolution & other)
    : Inherited(other) {} 

    H263VideoMode_resolution & operator = (const H263VideoMode_resolution & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H263VideoMode_resolution * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// AudioMode_g7231
//

class AudioMode_g7231 : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AudioMode_g7231(const void* info) : Inherited(info) {}
  public:
    AudioMode_g7231() : Inherited(&theInfo) {}
    class noSilenceSuppressionLowRate {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noSilenceSuppressionLowRate

    noSilenceSuppressionLowRate::reference select_noSilenceSuppressionLowRate (); 
    bool noSilenceSuppressionLowRate_isSelected() const;

    class noSilenceSuppressionHighRate {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noSilenceSuppressionHighRate

    noSilenceSuppressionHighRate::reference select_noSilenceSuppressionHighRate (); 
    bool noSilenceSuppressionHighRate_isSelected() const;

    class silenceSuppressionLowRate {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class silenceSuppressionLowRate

    silenceSuppressionLowRate::reference select_silenceSuppressionLowRate (); 
    bool silenceSuppressionLowRate_isSelected() const;

    class silenceSuppressionHighRate {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class silenceSuppressionHighRate

    silenceSuppressionHighRate::reference select_silenceSuppressionHighRate (); 
    bool silenceSuppressionHighRate_isSelected() const;

    AudioMode_g7231(noSilenceSuppressionLowRate::Id id, noSilenceSuppressionLowRate::const_reference value);
    AudioMode_g7231(noSilenceSuppressionHighRate::Id id, noSilenceSuppressionHighRate::const_reference value);
    AudioMode_g7231(silenceSuppressionLowRate::Id id, silenceSuppressionLowRate::const_reference value);
    AudioMode_g7231(silenceSuppressionHighRate::Id id, silenceSuppressionHighRate::const_reference value);
    void swap(AudioMode_g7231 & other);
    AudioMode_g7231(const AudioMode_g7231 & other)
    : Inherited(other) {} 

    AudioMode_g7231 & operator = (const AudioMode_g7231 & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AudioMode_g7231 * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// IS11172AudioMode_audioLayer
//

class IS11172AudioMode_audioLayer : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS11172AudioMode_audioLayer(const void* info) : Inherited(info) {}
  public:
    IS11172AudioMode_audioLayer() : Inherited(&theInfo) {}
    class audioLayer1 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer1

    audioLayer1::reference select_audioLayer1 (); 
    bool audioLayer1_isSelected() const;

    class audioLayer2 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer2

    audioLayer2::reference select_audioLayer2 (); 
    bool audioLayer2_isSelected() const;

    class audioLayer3 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer3

    audioLayer3::reference select_audioLayer3 (); 
    bool audioLayer3_isSelected() const;

    IS11172AudioMode_audioLayer(audioLayer1::Id id, audioLayer1::const_reference value);
    IS11172AudioMode_audioLayer(audioLayer2::Id id, audioLayer2::const_reference value);
    IS11172AudioMode_audioLayer(audioLayer3::Id id, audioLayer3::const_reference value);
    void swap(IS11172AudioMode_audioLayer & other);
    IS11172AudioMode_audioLayer(const IS11172AudioMode_audioLayer & other)
    : Inherited(other) {} 

    IS11172AudioMode_audioLayer & operator = (const IS11172AudioMode_audioLayer & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS11172AudioMode_audioLayer * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// IS11172AudioMode_audioSampling
//

class IS11172AudioMode_audioSampling : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS11172AudioMode_audioSampling(const void* info) : Inherited(info) {}
  public:
    IS11172AudioMode_audioSampling() : Inherited(&theInfo) {}
    class audioSampling32k {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling32k

    audioSampling32k::reference select_audioSampling32k (); 
    bool audioSampling32k_isSelected() const;

    class audioSampling44k1 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling44k1

    audioSampling44k1::reference select_audioSampling44k1 (); 
    bool audioSampling44k1_isSelected() const;

    class audioSampling48k {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling48k

    audioSampling48k::reference select_audioSampling48k (); 
    bool audioSampling48k_isSelected() const;

    IS11172AudioMode_audioSampling(audioSampling32k::Id id, audioSampling32k::const_reference value);
    IS11172AudioMode_audioSampling(audioSampling44k1::Id id, audioSampling44k1::const_reference value);
    IS11172AudioMode_audioSampling(audioSampling48k::Id id, audioSampling48k::const_reference value);
    void swap(IS11172AudioMode_audioSampling & other);
    IS11172AudioMode_audioSampling(const IS11172AudioMode_audioSampling & other)
    : Inherited(other) {} 

    IS11172AudioMode_audioSampling & operator = (const IS11172AudioMode_audioSampling & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS11172AudioMode_audioSampling * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// IS11172AudioMode_multichannelType
//

class IS11172AudioMode_multichannelType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS11172AudioMode_multichannelType(const void* info) : Inherited(info) {}
  public:
    IS11172AudioMode_multichannelType() : Inherited(&theInfo) {}
    class singleChannel {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class singleChannel

    singleChannel::reference select_singleChannel (); 
    bool singleChannel_isSelected() const;

    class twoChannelStereo {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class twoChannelStereo

    twoChannelStereo::reference select_twoChannelStereo (); 
    bool twoChannelStereo_isSelected() const;

    class twoChannelDual {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class twoChannelDual

    twoChannelDual::reference select_twoChannelDual (); 
    bool twoChannelDual_isSelected() const;

    IS11172AudioMode_multichannelType(singleChannel::Id id, singleChannel::const_reference value);
    IS11172AudioMode_multichannelType(twoChannelStereo::Id id, twoChannelStereo::const_reference value);
    IS11172AudioMode_multichannelType(twoChannelDual::Id id, twoChannelDual::const_reference value);
    void swap(IS11172AudioMode_multichannelType & other);
    IS11172AudioMode_multichannelType(const IS11172AudioMode_multichannelType & other)
    : Inherited(other) {} 

    IS11172AudioMode_multichannelType & operator = (const IS11172AudioMode_multichannelType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS11172AudioMode_multichannelType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// IS13818AudioMode_audioLayer
//

class IS13818AudioMode_audioLayer : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS13818AudioMode_audioLayer(const void* info) : Inherited(info) {}
  public:
    IS13818AudioMode_audioLayer() : Inherited(&theInfo) {}
    class audioLayer1 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer1

    audioLayer1::reference select_audioLayer1 (); 
    bool audioLayer1_isSelected() const;

    class audioLayer2 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer2

    audioLayer2::reference select_audioLayer2 (); 
    bool audioLayer2_isSelected() const;

    class audioLayer3 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer3

    audioLayer3::reference select_audioLayer3 (); 
    bool audioLayer3_isSelected() const;

    IS13818AudioMode_audioLayer(audioLayer1::Id id, audioLayer1::const_reference value);
    IS13818AudioMode_audioLayer(audioLayer2::Id id, audioLayer2::const_reference value);
    IS13818AudioMode_audioLayer(audioLayer3::Id id, audioLayer3::const_reference value);
    void swap(IS13818AudioMode_audioLayer & other);
    IS13818AudioMode_audioLayer(const IS13818AudioMode_audioLayer & other)
    : Inherited(other) {} 

    IS13818AudioMode_audioLayer & operator = (const IS13818AudioMode_audioLayer & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS13818AudioMode_audioLayer * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// IS13818AudioMode_audioSampling
//

class IS13818AudioMode_audioSampling : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS13818AudioMode_audioSampling(const void* info) : Inherited(info) {}
  public:
    IS13818AudioMode_audioSampling() : Inherited(&theInfo) {}
    class audioSampling16k {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling16k

    audioSampling16k::reference select_audioSampling16k (); 
    bool audioSampling16k_isSelected() const;

    class audioSampling22k05 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling22k05

    audioSampling22k05::reference select_audioSampling22k05 (); 
    bool audioSampling22k05_isSelected() const;

    class audioSampling24k {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling24k

    audioSampling24k::reference select_audioSampling24k (); 
    bool audioSampling24k_isSelected() const;

    class audioSampling32k {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling32k

    audioSampling32k::reference select_audioSampling32k (); 
    bool audioSampling32k_isSelected() const;

    class audioSampling44k1 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling44k1

    audioSampling44k1::reference select_audioSampling44k1 (); 
    bool audioSampling44k1_isSelected() const;

    class audioSampling48k {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling48k

    audioSampling48k::reference select_audioSampling48k (); 
    bool audioSampling48k_isSelected() const;

    IS13818AudioMode_audioSampling(audioSampling16k::Id id, audioSampling16k::const_reference value);
    IS13818AudioMode_audioSampling(audioSampling22k05::Id id, audioSampling22k05::const_reference value);
    IS13818AudioMode_audioSampling(audioSampling24k::Id id, audioSampling24k::const_reference value);
    IS13818AudioMode_audioSampling(audioSampling32k::Id id, audioSampling32k::const_reference value);
    IS13818AudioMode_audioSampling(audioSampling44k1::Id id, audioSampling44k1::const_reference value);
    IS13818AudioMode_audioSampling(audioSampling48k::Id id, audioSampling48k::const_reference value);
    void swap(IS13818AudioMode_audioSampling & other);
    IS13818AudioMode_audioSampling(const IS13818AudioMode_audioSampling & other)
    : Inherited(other) {} 

    IS13818AudioMode_audioSampling & operator = (const IS13818AudioMode_audioSampling & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS13818AudioMode_audioSampling * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// IS13818AudioMode_multichannelType
//

class IS13818AudioMode_multichannelType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IS13818AudioMode_multichannelType(const void* info) : Inherited(info) {}
  public:
    IS13818AudioMode_multichannelType() : Inherited(&theInfo) {}
    class singleChannel {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class singleChannel

    singleChannel::reference select_singleChannel (); 
    bool singleChannel_isSelected() const;

    class twoChannelStereo {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class twoChannelStereo

    twoChannelStereo::reference select_twoChannelStereo (); 
    bool twoChannelStereo_isSelected() const;

    class twoChannelDual {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class twoChannelDual

    twoChannelDual::reference select_twoChannelDual (); 
    bool twoChannelDual_isSelected() const;

    class threeChannels2_1 {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class threeChannels2_1

    threeChannels2_1::reference select_threeChannels2_1 (); 
    bool threeChannels2_1_isSelected() const;

    class threeChannels3_0 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class threeChannels3_0

    threeChannels3_0::reference select_threeChannels3_0 (); 
    bool threeChannels3_0_isSelected() const;

    class fourChannels2_0_2_0 {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fourChannels2_0_2_0

    fourChannels2_0_2_0::reference select_fourChannels2_0_2_0 (); 
    bool fourChannels2_0_2_0_isSelected() const;

    class fourChannels2_2 {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fourChannels2_2

    fourChannels2_2::reference select_fourChannels2_2 (); 
    bool fourChannels2_2_isSelected() const;

    class fourChannels3_1 {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fourChannels3_1

    fourChannels3_1::reference select_fourChannels3_1 (); 
    bool fourChannels3_1_isSelected() const;

    class fiveChannels3_0_2_0 {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fiveChannels3_0_2_0

    fiveChannels3_0_2_0::reference select_fiveChannels3_0_2_0 (); 
    bool fiveChannels3_0_2_0_isSelected() const;

    class fiveChannels3_2 {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fiveChannels3_2

    fiveChannels3_2::reference select_fiveChannels3_2 (); 
    bool fiveChannels3_2_isSelected() const;

    IS13818AudioMode_multichannelType(singleChannel::Id id, singleChannel::const_reference value);
    IS13818AudioMode_multichannelType(twoChannelStereo::Id id, twoChannelStereo::const_reference value);
    IS13818AudioMode_multichannelType(twoChannelDual::Id id, twoChannelDual::const_reference value);
    IS13818AudioMode_multichannelType(threeChannels2_1::Id id, threeChannels2_1::const_reference value);
    IS13818AudioMode_multichannelType(threeChannels3_0::Id id, threeChannels3_0::const_reference value);
    IS13818AudioMode_multichannelType(fourChannels2_0_2_0::Id id, fourChannels2_0_2_0::const_reference value);
    IS13818AudioMode_multichannelType(fourChannels2_2::Id id, fourChannels2_2::const_reference value);
    IS13818AudioMode_multichannelType(fourChannels3_1::Id id, fourChannels3_1::const_reference value);
    IS13818AudioMode_multichannelType(fiveChannels3_0_2_0::Id id, fiveChannels3_0_2_0::const_reference value);
    IS13818AudioMode_multichannelType(fiveChannels3_2::Id id, fiveChannels3_2::const_reference value);
    void swap(IS13818AudioMode_multichannelType & other);
    IS13818AudioMode_multichannelType(const IS13818AudioMode_multichannelType & other)
    : Inherited(other) {} 

    IS13818AudioMode_multichannelType & operator = (const IS13818AudioMode_multichannelType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IS13818AudioMode_multichannelType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[10];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[10];
#endif
};

//
// G7231AnnexCMode_g723AnnexCAudioMode
//

class G7231AnnexCMode_g723AnnexCAudioMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    G7231AnnexCMode_g723AnnexCAudioMode(const void* info) : Inherited(info) {}
  public:
    G7231AnnexCMode_g723AnnexCAudioMode() : Inherited(&theInfo) {}
    G7231AnnexCMode_g723AnnexCAudioMode(const G7231AnnexCMode_g723AnnexCAudioMode & other) : Inherited(other)
    {}
    G7231AnnexCMode_g723AnnexCAudioMode& operator = (const G7231AnnexCMode_g723AnnexCAudioMode& other)
    { Inherited::operator = (other); return *this; } 
    class highRateMode0 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 27, 78>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class highRateMode0
    highRateMode0::const_reference get_highRateMode0 () const;
    highRateMode0::reference ref_highRateMode0 ();
    highRateMode0::reference set_highRateMode0 ();
    highRateMode0::reference set_highRateMode0 (highRateMode0::value_type::int_type value);
    class highRateMode1 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 27, 78>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class highRateMode1
    highRateMode1::const_reference get_highRateMode1 () const;
    highRateMode1::reference ref_highRateMode1 ();
    highRateMode1::reference set_highRateMode1 ();
    highRateMode1::reference set_highRateMode1 (highRateMode1::value_type::int_type value);
    class lowRateMode0 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 23, 66>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lowRateMode0
    lowRateMode0::const_reference get_lowRateMode0 () const;
    lowRateMode0::reference ref_lowRateMode0 ();
    lowRateMode0::reference set_lowRateMode0 ();
    lowRateMode0::reference set_lowRateMode0 (lowRateMode0::value_type::int_type value);
    class lowRateMode1 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 23, 66>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lowRateMode1
    lowRateMode1::const_reference get_lowRateMode1 () const;
    lowRateMode1::reference ref_lowRateMode1 ();
    lowRateMode1::reference set_lowRateMode1 ();
    lowRateMode1::reference set_lowRateMode1 (lowRateMode1::value_type::int_type value);
    class sidMode0 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 6, 17>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sidMode0
    sidMode0::const_reference get_sidMode0 () const;
    sidMode0::reference ref_sidMode0 ();
    sidMode0::reference set_sidMode0 ();
    sidMode0::reference set_sidMode0 (sidMode0::value_type::int_type value);
    class sidMode1 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 6, 17>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sidMode1
    sidMode1::const_reference get_sidMode1 () const;
    sidMode1::reference ref_sidMode1 ();
    sidMode1::reference set_sidMode1 ();
    sidMode1::reference set_sidMode1 (sidMode1::value_type::int_type value);
    void swap(G7231AnnexCMode_g723AnnexCAudioMode& other);
    G7231AnnexCMode_g723AnnexCAudioMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// MaintenanceLoopRequest_type
//

class MaintenanceLoopRequest_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MaintenanceLoopRequest_type(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopRequest_type() : Inherited(&theInfo) {}
    class systemLoop {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class systemLoop

    systemLoop::reference select_systemLoop (); 
    bool systemLoop_isSelected() const;

    class mediaLoop {
      public:
        enum Id { id_ = 1 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaLoop

    mediaLoop::const_reference get_mediaLoop () const;
    mediaLoop::reference ref_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (mediaLoop::value_type::int_type value); 
    bool mediaLoop_isSelected() const;

    class logicalChannelLoop {
      public:
        enum Id { id_ = 2 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelLoop

    logicalChannelLoop::const_reference get_logicalChannelLoop () const;
    logicalChannelLoop::reference ref_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (logicalChannelLoop::value_type::int_type value); 
    bool logicalChannelLoop_isSelected() const;

    MaintenanceLoopRequest_type(systemLoop::Id id, systemLoop::const_reference value);
    MaintenanceLoopRequest_type(mediaLoop::Id id, mediaLoop::value_type::int_type value);
    MaintenanceLoopRequest_type(logicalChannelLoop::Id id, logicalChannelLoop::value_type::int_type value);
    void swap(MaintenanceLoopRequest_type & other);
    MaintenanceLoopRequest_type(const MaintenanceLoopRequest_type & other)
    : Inherited(other) {} 

    MaintenanceLoopRequest_type & operator = (const MaintenanceLoopRequest_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MaintenanceLoopRequest_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MaintenanceLoopAck_type
//

class MaintenanceLoopAck_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MaintenanceLoopAck_type(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopAck_type() : Inherited(&theInfo) {}
    class systemLoop {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class systemLoop

    systemLoop::reference select_systemLoop (); 
    bool systemLoop_isSelected() const;

    class mediaLoop {
      public:
        enum Id { id_ = 1 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaLoop

    mediaLoop::const_reference get_mediaLoop () const;
    mediaLoop::reference ref_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (mediaLoop::value_type::int_type value); 
    bool mediaLoop_isSelected() const;

    class logicalChannelLoop {
      public:
        enum Id { id_ = 2 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelLoop

    logicalChannelLoop::const_reference get_logicalChannelLoop () const;
    logicalChannelLoop::reference ref_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (logicalChannelLoop::value_type::int_type value); 
    bool logicalChannelLoop_isSelected() const;

    MaintenanceLoopAck_type(systemLoop::Id id, systemLoop::const_reference value);
    MaintenanceLoopAck_type(mediaLoop::Id id, mediaLoop::value_type::int_type value);
    MaintenanceLoopAck_type(logicalChannelLoop::Id id, logicalChannelLoop::value_type::int_type value);
    void swap(MaintenanceLoopAck_type & other);
    MaintenanceLoopAck_type(const MaintenanceLoopAck_type & other)
    : Inherited(other) {} 

    MaintenanceLoopAck_type & operator = (const MaintenanceLoopAck_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MaintenanceLoopAck_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MaintenanceLoopReject_type
//

class MaintenanceLoopReject_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MaintenanceLoopReject_type(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopReject_type() : Inherited(&theInfo) {}
    class systemLoop {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class systemLoop

    systemLoop::reference select_systemLoop (); 
    bool systemLoop_isSelected() const;

    class mediaLoop {
      public:
        enum Id { id_ = 1 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaLoop

    mediaLoop::const_reference get_mediaLoop () const;
    mediaLoop::reference ref_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (); 
    mediaLoop::reference select_mediaLoop (mediaLoop::value_type::int_type value); 
    bool mediaLoop_isSelected() const;

    class logicalChannelLoop {
      public:
        enum Id { id_ = 2 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelLoop

    logicalChannelLoop::const_reference get_logicalChannelLoop () const;
    logicalChannelLoop::reference ref_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (); 
    logicalChannelLoop::reference select_logicalChannelLoop (logicalChannelLoop::value_type::int_type value); 
    bool logicalChannelLoop_isSelected() const;

    MaintenanceLoopReject_type(systemLoop::Id id, systemLoop::const_reference value);
    MaintenanceLoopReject_type(mediaLoop::Id id, mediaLoop::value_type::int_type value);
    MaintenanceLoopReject_type(logicalChannelLoop::Id id, logicalChannelLoop::value_type::int_type value);
    void swap(MaintenanceLoopReject_type & other);
    MaintenanceLoopReject_type(const MaintenanceLoopReject_type & other)
    : Inherited(other) {} 

    MaintenanceLoopReject_type & operator = (const MaintenanceLoopReject_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MaintenanceLoopReject_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MaintenanceLoopReject_cause
//

class MaintenanceLoopReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MaintenanceLoopReject_cause(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopReject_cause() : Inherited(&theInfo) {}
    class canNotPerformLoop {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class canNotPerformLoop

    canNotPerformLoop::reference select_canNotPerformLoop (); 
    bool canNotPerformLoop_isSelected() const;

    MaintenanceLoopReject_cause(canNotPerformLoop::Id id, canNotPerformLoop::const_reference value);
    void swap(MaintenanceLoopReject_cause & other);
    MaintenanceLoopReject_cause(const MaintenanceLoopReject_cause & other)
    : Inherited(other) {} 

    MaintenanceLoopReject_cause & operator = (const MaintenanceLoopReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MaintenanceLoopReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[1];
#endif
};

//
// CommunicationModeTableEntry_dataType
//

class CommunicationModeTableEntry_dataType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CommunicationModeTableEntry_dataType(const void* info) : Inherited(info) {}
  public:
    CommunicationModeTableEntry_dataType() : Inherited(&theInfo) {}
    class videoData {
      public:
        enum Id { id_ = 0 };
        typedef VideoCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoData

    videoData::const_reference get_videoData () const;
    videoData::reference ref_videoData (); 
    videoData::reference select_videoData (); 
    videoData::reference select_videoData (videoData::const_reference value); 
    bool videoData_isSelected() const;

    class audioData {
      public:
        enum Id { id_ = 1 };
        typedef AudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioData

    audioData::const_reference get_audioData () const;
    audioData::reference ref_audioData (); 
    audioData::reference select_audioData (); 
    audioData::reference select_audioData (audioData::const_reference value); 
    bool audioData_isSelected() const;

    class data {
      public:
        enum Id { id_ = 2 };
        typedef DataApplicationCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data

    data::const_reference get_data () const;
    data::reference ref_data (); 
    data::reference select_data (); 
    data::reference select_data (data::const_reference value); 
    bool data_isSelected() const;

    CommunicationModeTableEntry_dataType(videoData::Id id, videoData::const_reference value);
    CommunicationModeTableEntry_dataType(audioData::Id id, audioData::const_reference value);
    CommunicationModeTableEntry_dataType(data::Id id, data::const_reference value);
    void swap(CommunicationModeTableEntry_dataType & other);
    CommunicationModeTableEntry_dataType(const CommunicationModeTableEntry_dataType & other)
    : Inherited(other) {} 

    CommunicationModeTableEntry_dataType & operator = (const CommunicationModeTableEntry_dataType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CommunicationModeTableEntry_dataType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// ConferenceResponse_mCTerminalIDResponse
//

class ConferenceResponse_mCTerminalIDResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_mCTerminalIDResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_mCTerminalIDResponse() : Inherited(&theInfo) {}
    ConferenceResponse_mCTerminalIDResponse(const ConferenceResponse_mCTerminalIDResponse & other) : Inherited(other)
    {}
    ConferenceResponse_mCTerminalIDResponse& operator = (const ConferenceResponse_mCTerminalIDResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class terminalID {
      public:
        typedef TerminalID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalID
    terminalID::const_reference get_terminalID () const;
    terminalID::reference ref_terminalID ();
    terminalID::reference set_terminalID ();
    terminalID::reference set_terminalID (const std::vector<char>& value);
    void swap(ConferenceResponse_mCTerminalIDResponse& other);
    ConferenceResponse_mCTerminalIDResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_terminalIDResponse
//

class ConferenceResponse_terminalIDResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_terminalIDResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_terminalIDResponse() : Inherited(&theInfo) {}
    ConferenceResponse_terminalIDResponse(const ConferenceResponse_terminalIDResponse & other) : Inherited(other)
    {}
    ConferenceResponse_terminalIDResponse& operator = (const ConferenceResponse_terminalIDResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class terminalID {
      public:
        typedef TerminalID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalID
    terminalID::const_reference get_terminalID () const;
    terminalID::reference ref_terminalID ();
    terminalID::reference set_terminalID ();
    terminalID::reference set_terminalID (const std::vector<char>& value);
    void swap(ConferenceResponse_terminalIDResponse& other);
    ConferenceResponse_terminalIDResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_conferenceIDResponse
//

class ConferenceResponse_conferenceIDResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_conferenceIDResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_conferenceIDResponse() : Inherited(&theInfo) {}
    ConferenceResponse_conferenceIDResponse(const ConferenceResponse_conferenceIDResponse & other) : Inherited(other)
    {}
    ConferenceResponse_conferenceIDResponse& operator = (const ConferenceResponse_conferenceIDResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class conferenceID {
      public:
        typedef ConferenceID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceID
    conferenceID::const_reference get_conferenceID () const;
    conferenceID::reference ref_conferenceID ();
    conferenceID::reference set_conferenceID ();
    conferenceID::reference set_conferenceID (const std::vector<char>& value);
    void swap(ConferenceResponse_conferenceIDResponse& other);
    ConferenceResponse_conferenceIDResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_passwordResponse
//

class ConferenceResponse_passwordResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_passwordResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_passwordResponse() : Inherited(&theInfo) {}
    ConferenceResponse_passwordResponse(const ConferenceResponse_passwordResponse & other) : Inherited(other)
    {}
    ConferenceResponse_passwordResponse& operator = (const ConferenceResponse_passwordResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class password {
      public:
        typedef Password value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class password
    password::const_reference get_password () const;
    password::reference ref_password ();
    password::reference set_password ();
    password::reference set_password (const std::vector<char>& value);
    void swap(ConferenceResponse_passwordResponse& other);
    ConferenceResponse_passwordResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_makeMeChairResponse
//

class ConferenceResponse_makeMeChairResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceResponse_makeMeChairResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_makeMeChairResponse() : Inherited(&theInfo) {}
    class grantedChairToken {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class grantedChairToken

    grantedChairToken::reference select_grantedChairToken (); 
    bool grantedChairToken_isSelected() const;

    class deniedChairToken {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deniedChairToken

    deniedChairToken::reference select_deniedChairToken (); 
    bool deniedChairToken_isSelected() const;

    ConferenceResponse_makeMeChairResponse(grantedChairToken::Id id, grantedChairToken::const_reference value);
    ConferenceResponse_makeMeChairResponse(deniedChairToken::Id id, deniedChairToken::const_reference value);
    void swap(ConferenceResponse_makeMeChairResponse & other);
    ConferenceResponse_makeMeChairResponse(const ConferenceResponse_makeMeChairResponse & other)
    : Inherited(other) {} 

    ConferenceResponse_makeMeChairResponse & operator = (const ConferenceResponse_makeMeChairResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceResponse_makeMeChairResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// ConferenceResponse_extensionAddressResponse
//

class ConferenceResponse_extensionAddressResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_extensionAddressResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_extensionAddressResponse() : Inherited(&theInfo) {}
    ConferenceResponse_extensionAddressResponse(const ConferenceResponse_extensionAddressResponse & other) : Inherited(other)
    {}
    ConferenceResponse_extensionAddressResponse& operator = (const ConferenceResponse_extensionAddressResponse& other)
    { Inherited::operator = (other); return *this; } 
    class extensionAddress {
      public:
        typedef TerminalID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionAddress
    extensionAddress::const_reference get_extensionAddress () const;
    extensionAddress::reference ref_extensionAddress ();
    extensionAddress::reference set_extensionAddress ();
    extensionAddress::reference set_extensionAddress (const std::vector<char>& value);
    void swap(ConferenceResponse_extensionAddressResponse& other);
    ConferenceResponse_extensionAddressResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// ConferenceResponse_chairTokenOwnerResponse
//

class ConferenceResponse_chairTokenOwnerResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_chairTokenOwnerResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_chairTokenOwnerResponse() : Inherited(&theInfo) {}
    ConferenceResponse_chairTokenOwnerResponse(const ConferenceResponse_chairTokenOwnerResponse & other) : Inherited(other)
    {}
    ConferenceResponse_chairTokenOwnerResponse& operator = (const ConferenceResponse_chairTokenOwnerResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    class terminalID {
      public:
        typedef TerminalID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalID
    terminalID::const_reference get_terminalID () const;
    terminalID::reference ref_terminalID ();
    terminalID::reference set_terminalID ();
    terminalID::reference set_terminalID (const std::vector<char>& value);
    void swap(ConferenceResponse_chairTokenOwnerResponse& other);
    ConferenceResponse_chairTokenOwnerResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_terminalCertificateResponse
//

class ConferenceResponse_terminalCertificateResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceResponse_terminalCertificateResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_terminalCertificateResponse() : Inherited(&theInfo) {}
    ConferenceResponse_terminalCertificateResponse(const ConferenceResponse_terminalCertificateResponse & other) : Inherited(other)
    {}
    ConferenceResponse_terminalCertificateResponse& operator = (const ConferenceResponse_terminalCertificateResponse& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_terminalLabel,
      e_certificateResponse
    };

    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    void omit_terminalLabel ();
    bool terminalLabel_isPresent () const;
    class certificateResponse {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certificateResponse
    certificateResponse::const_reference get_certificateResponse () const;
    certificateResponse::reference ref_certificateResponse ();
    certificateResponse::reference set_certificateResponse ();
    certificateResponse::reference set_certificateResponse (const std::vector<char>& value);
    void omit_certificateResponse ();
    bool certificateResponse_isPresent () const;
    void swap(ConferenceResponse_terminalCertificateResponse& other);
    ConferenceResponse_terminalCertificateResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceResponse_broadcastMyLogicalChannelResponse
//

class ConferenceResponse_broadcastMyLogicalChannelResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceResponse_broadcastMyLogicalChannelResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_broadcastMyLogicalChannelResponse() : Inherited(&theInfo) {}
    class grantedBroadcastMyLogicalChannel {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class grantedBroadcastMyLogicalChannel

    grantedBroadcastMyLogicalChannel::reference select_grantedBroadcastMyLogicalChannel (); 
    bool grantedBroadcastMyLogicalChannel_isSelected() const;

    class deniedBroadcastMyLogicalChannel {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deniedBroadcastMyLogicalChannel

    deniedBroadcastMyLogicalChannel::reference select_deniedBroadcastMyLogicalChannel (); 
    bool deniedBroadcastMyLogicalChannel_isSelected() const;

    ConferenceResponse_broadcastMyLogicalChannelResponse(grantedBroadcastMyLogicalChannel::Id id, grantedBroadcastMyLogicalChannel::const_reference value);
    ConferenceResponse_broadcastMyLogicalChannelResponse(deniedBroadcastMyLogicalChannel::Id id, deniedBroadcastMyLogicalChannel::const_reference value);
    void swap(ConferenceResponse_broadcastMyLogicalChannelResponse & other);
    ConferenceResponse_broadcastMyLogicalChannelResponse(const ConferenceResponse_broadcastMyLogicalChannelResponse & other)
    : Inherited(other) {} 

    ConferenceResponse_broadcastMyLogicalChannelResponse & operator = (const ConferenceResponse_broadcastMyLogicalChannelResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceResponse_broadcastMyLogicalChannelResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// ConferenceResponse_makeTerminalBroadcasterResponse
//

class ConferenceResponse_makeTerminalBroadcasterResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceResponse_makeTerminalBroadcasterResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_makeTerminalBroadcasterResponse() : Inherited(&theInfo) {}
    class grantedMakeTerminalBroadcaster {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class grantedMakeTerminalBroadcaster

    grantedMakeTerminalBroadcaster::reference select_grantedMakeTerminalBroadcaster (); 
    bool grantedMakeTerminalBroadcaster_isSelected() const;

    class deniedMakeTerminalBroadcaster {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deniedMakeTerminalBroadcaster

    deniedMakeTerminalBroadcaster::reference select_deniedMakeTerminalBroadcaster (); 
    bool deniedMakeTerminalBroadcaster_isSelected() const;

    ConferenceResponse_makeTerminalBroadcasterResponse(grantedMakeTerminalBroadcaster::Id id, grantedMakeTerminalBroadcaster::const_reference value);
    ConferenceResponse_makeTerminalBroadcasterResponse(deniedMakeTerminalBroadcaster::Id id, deniedMakeTerminalBroadcaster::const_reference value);
    void swap(ConferenceResponse_makeTerminalBroadcasterResponse & other);
    ConferenceResponse_makeTerminalBroadcasterResponse(const ConferenceResponse_makeTerminalBroadcasterResponse & other)
    : Inherited(other) {} 

    ConferenceResponse_makeTerminalBroadcasterResponse & operator = (const ConferenceResponse_makeTerminalBroadcasterResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceResponse_makeTerminalBroadcasterResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// ConferenceResponse_sendThisSourceResponse
//

class ConferenceResponse_sendThisSourceResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceResponse_sendThisSourceResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse_sendThisSourceResponse() : Inherited(&theInfo) {}
    class grantedSendThisSource {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class grantedSendThisSource

    grantedSendThisSource::reference select_grantedSendThisSource (); 
    bool grantedSendThisSource_isSelected() const;

    class deniedSendThisSource {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deniedSendThisSource

    deniedSendThisSource::reference select_deniedSendThisSource (); 
    bool deniedSendThisSource_isSelected() const;

    ConferenceResponse_sendThisSourceResponse(grantedSendThisSource::Id id, grantedSendThisSource::const_reference value);
    ConferenceResponse_sendThisSourceResponse(deniedSendThisSource::Id id, deniedSendThisSource::const_reference value);
    void swap(ConferenceResponse_sendThisSourceResponse & other);
    ConferenceResponse_sendThisSourceResponse(const ConferenceResponse_sendThisSourceResponse & other)
    : Inherited(other) {} 

    ConferenceResponse_sendThisSourceResponse & operator = (const ConferenceResponse_sendThisSourceResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceResponse_sendThisSourceResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// RemoteMCResponse_reject
//

class RemoteMCResponse_reject : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RemoteMCResponse_reject(const void* info) : Inherited(info) {}
  public:
    RemoteMCResponse_reject() : Inherited(&theInfo) {}
    class unspecified {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unspecified

    unspecified::reference select_unspecified (); 
    bool unspecified_isSelected() const;

    class functionNotSupported {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class functionNotSupported

    functionNotSupported::reference select_functionNotSupported (); 
    bool functionNotSupported_isSelected() const;

    RemoteMCResponse_reject(unspecified::Id id, unspecified::const_reference value);
    RemoteMCResponse_reject(functionNotSupported::Id id, functionNotSupported::const_reference value);
    void swap(RemoteMCResponse_reject & other);
    RemoteMCResponse_reject(const RemoteMCResponse_reject & other)
    : Inherited(other) {} 

    RemoteMCResponse_reject & operator = (const RemoteMCResponse_reject & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RemoteMCResponse_reject * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MultilinkRequest_callInformation
//

class MultilinkRequest_callInformation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkRequest_callInformation(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest_callInformation() : Inherited(&theInfo) {}
    MultilinkRequest_callInformation(const MultilinkRequest_callInformation & other) : Inherited(other)
    {}
    MultilinkRequest_callInformation& operator = (const MultilinkRequest_callInformation& other)
    { Inherited::operator = (other); return *this; } 
    class maxNumberOfAdditionalConnections {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxNumberOfAdditionalConnections
    maxNumberOfAdditionalConnections::const_reference get_maxNumberOfAdditionalConnections () const;
    maxNumberOfAdditionalConnections::reference ref_maxNumberOfAdditionalConnections ();
    maxNumberOfAdditionalConnections::reference set_maxNumberOfAdditionalConnections ();
    maxNumberOfAdditionalConnections::reference set_maxNumberOfAdditionalConnections (maxNumberOfAdditionalConnections::value_type::int_type value);
    void swap(MultilinkRequest_callInformation& other);
    MultilinkRequest_callInformation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MultilinkRequest_removeConnection
//

class MultilinkRequest_removeConnection : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkRequest_removeConnection(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest_removeConnection() : Inherited(&theInfo) {}
    MultilinkRequest_removeConnection(const MultilinkRequest_removeConnection & other) : Inherited(other)
    {}
    MultilinkRequest_removeConnection& operator = (const MultilinkRequest_removeConnection& other)
    { Inherited::operator = (other); return *this; } 
    class connectionIdentifier {
      public:
        typedef ConnectionIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionIdentifier
    connectionIdentifier::const_reference get_connectionIdentifier () const;
    connectionIdentifier::reference ref_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier (connectionIdentifier::const_reference value);
    void swap(MultilinkRequest_removeConnection& other);
    MultilinkRequest_removeConnection * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MultilinkResponse_removeConnection
//

class MultilinkResponse_removeConnection : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkResponse_removeConnection(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_removeConnection() : Inherited(&theInfo) {}
    MultilinkResponse_removeConnection(const MultilinkResponse_removeConnection & other) : Inherited(other)
    {}
    MultilinkResponse_removeConnection& operator = (const MultilinkResponse_removeConnection& other)
    { Inherited::operator = (other); return *this; } 
    class connectionIdentifier {
      public:
        typedef ConnectionIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionIdentifier
    connectionIdentifier::const_reference get_connectionIdentifier () const;
    connectionIdentifier::reference ref_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier (connectionIdentifier::const_reference value);
    void swap(MultilinkResponse_removeConnection& other);
    MultilinkResponse_removeConnection * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MultilinkResponse_maximumHeaderInterval
//

class MultilinkResponse_maximumHeaderInterval : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkResponse_maximumHeaderInterval(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_maximumHeaderInterval() : Inherited(&theInfo) {}
    MultilinkResponse_maximumHeaderInterval(const MultilinkResponse_maximumHeaderInterval & other) : Inherited(other)
    {}
    MultilinkResponse_maximumHeaderInterval& operator = (const MultilinkResponse_maximumHeaderInterval& other)
    { Inherited::operator = (other); return *this; } 
    class currentInterval {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class currentInterval
    currentInterval::const_reference get_currentInterval () const;
    currentInterval::reference ref_currentInterval ();
    currentInterval::reference set_currentInterval ();
    currentInterval::reference set_currentInterval (currentInterval::value_type::int_type value);
    void swap(MultilinkResponse_maximumHeaderInterval& other);
    MultilinkResponse_maximumHeaderInterval * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MultilinkIndication_crcDesired
//

class MultilinkIndication_crcDesired : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkIndication_crcDesired(const void* info) : Inherited(info) {}
  public:
    MultilinkIndication_crcDesired() : Inherited(&theInfo) {}
    MultilinkIndication_crcDesired(const MultilinkIndication_crcDesired & other) : Inherited(other)
    {}
    MultilinkIndication_crcDesired& operator = (const MultilinkIndication_crcDesired& other)
    { Inherited::operator = (other); return *this; } 
    void swap(MultilinkIndication_crcDesired& other);
    MultilinkIndication_crcDesired * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

//
// MultilinkIndication_excessiveError
//

class MultilinkIndication_excessiveError : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkIndication_excessiveError(const void* info) : Inherited(info) {}
  public:
    MultilinkIndication_excessiveError() : Inherited(&theInfo) {}
    MultilinkIndication_excessiveError(const MultilinkIndication_excessiveError & other) : Inherited(other)
    {}
    MultilinkIndication_excessiveError& operator = (const MultilinkIndication_excessiveError& other)
    { Inherited::operator = (other); return *this; } 
    class connectionIdentifier {
      public:
        typedef ConnectionIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionIdentifier
    connectionIdentifier::const_reference get_connectionIdentifier () const;
    connectionIdentifier::reference ref_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier ();
    connectionIdentifier::reference set_connectionIdentifier (connectionIdentifier::const_reference value);
    void swap(MultilinkIndication_excessiveError& other);
    MultilinkIndication_excessiveError * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// SendTerminalCapabilitySet_specificRequest
//

class SendTerminalCapabilitySet_specificRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SendTerminalCapabilitySet_specificRequest(const void* info) : Inherited(info) {}
  public:
    SendTerminalCapabilitySet_specificRequest() : Inherited(&theInfo) {}
    SendTerminalCapabilitySet_specificRequest(const SendTerminalCapabilitySet_specificRequest & other) : Inherited(other)
    {}
    SendTerminalCapabilitySet_specificRequest& operator = (const SendTerminalCapabilitySet_specificRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_capabilityTableEntryNumbers,
      e_capabilityDescriptorNumbers
    };

    class multiplexCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexCapability
    multiplexCapability::const_reference get_multiplexCapability () const;
    multiplexCapability::reference ref_multiplexCapability ();
    multiplexCapability::reference set_multiplexCapability ();
    multiplexCapability::reference set_multiplexCapability (bool value);
    class capabilityTableEntryNumbers {
      public:
        typedef ASN1::SET_OF<CapabilityTableEntryNumber,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capabilityTableEntryNumbers
    capabilityTableEntryNumbers::const_reference get_capabilityTableEntryNumbers () const;
    capabilityTableEntryNumbers::reference ref_capabilityTableEntryNumbers ();
    capabilityTableEntryNumbers::reference set_capabilityTableEntryNumbers ();
    capabilityTableEntryNumbers::reference set_capabilityTableEntryNumbers (capabilityTableEntryNumbers::const_reference value);
    void omit_capabilityTableEntryNumbers ();
    bool capabilityTableEntryNumbers_isPresent () const;
    class capabilityDescriptorNumbers {
      public:
        typedef ASN1::SET_OF<CapabilityDescriptorNumber,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capabilityDescriptorNumbers
    capabilityDescriptorNumbers::const_reference get_capabilityDescriptorNumbers () const;
    capabilityDescriptorNumbers::reference ref_capabilityDescriptorNumbers ();
    capabilityDescriptorNumbers::reference set_capabilityDescriptorNumbers ();
    capabilityDescriptorNumbers::reference set_capabilityDescriptorNumbers (capabilityDescriptorNumbers::const_reference value);
    void omit_capabilityDescriptorNumbers ();
    bool capabilityDescriptorNumbers_isPresent () const;
    void swap(SendTerminalCapabilitySet_specificRequest& other);
    SendTerminalCapabilitySet_specificRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// EncryptionCommand_encryptionAlgorithmID
//

class EncryptionCommand_encryptionAlgorithmID : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EncryptionCommand_encryptionAlgorithmID(const void* info) : Inherited(info) {}
  public:
    EncryptionCommand_encryptionAlgorithmID() : Inherited(&theInfo) {}
    EncryptionCommand_encryptionAlgorithmID(const EncryptionCommand_encryptionAlgorithmID & other) : Inherited(other)
    {}
    EncryptionCommand_encryptionAlgorithmID& operator = (const EncryptionCommand_encryptionAlgorithmID& other)
    { Inherited::operator = (other); return *this; } 
    class h233AlgorithmIdentifier {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h233AlgorithmIdentifier
    h233AlgorithmIdentifier::const_reference get_h233AlgorithmIdentifier () const;
    h233AlgorithmIdentifier::reference ref_h233AlgorithmIdentifier ();
    h233AlgorithmIdentifier::reference set_h233AlgorithmIdentifier ();
    h233AlgorithmIdentifier::reference set_h233AlgorithmIdentifier (h233AlgorithmIdentifier::value_type::int_type value);
    class associatedAlgorithm {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class associatedAlgorithm
    associatedAlgorithm::const_reference get_associatedAlgorithm () const;
    associatedAlgorithm::reference ref_associatedAlgorithm ();
    associatedAlgorithm::reference set_associatedAlgorithm ();
    associatedAlgorithm::reference set_associatedAlgorithm (associatedAlgorithm::const_reference value);
    void swap(EncryptionCommand_encryptionAlgorithmID& other);
    EncryptionCommand_encryptionAlgorithmID * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// FlowControlCommand_scope
//

class FlowControlCommand_scope : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FlowControlCommand_scope(const void* info) : Inherited(info) {}
  public:
    FlowControlCommand_scope() : Inherited(&theInfo) {}
    class logicalChannelNumber {
      public:
        enum Id { id_ = 0 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber

    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (logicalChannelNumber::value_type::int_type value); 
    bool logicalChannelNumber_isSelected() const;

    class resourceID {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceID

    resourceID::const_reference get_resourceID () const;
    resourceID::reference ref_resourceID (); 
    resourceID::reference select_resourceID (); 
    resourceID::reference select_resourceID (resourceID::value_type::int_type value); 
    bool resourceID_isSelected() const;

    class wholeMultiplex {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wholeMultiplex

    wholeMultiplex::reference select_wholeMultiplex (); 
    bool wholeMultiplex_isSelected() const;

    FlowControlCommand_scope(logicalChannelNumber::Id id, logicalChannelNumber::value_type::int_type value);
    FlowControlCommand_scope(resourceID::Id id, resourceID::value_type::int_type value);
    FlowControlCommand_scope(wholeMultiplex::Id id, wholeMultiplex::const_reference value);
    void swap(FlowControlCommand_scope & other);
    FlowControlCommand_scope(const FlowControlCommand_scope & other)
    : Inherited(other) {} 

    FlowControlCommand_scope & operator = (const FlowControlCommand_scope & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FlowControlCommand_scope * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// FlowControlCommand_restriction
//

class FlowControlCommand_restriction : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FlowControlCommand_restriction(const void* info) : Inherited(info) {}
  public:
    FlowControlCommand_restriction() : Inherited(&theInfo) {}
    class maximumBitRate {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumBitRate

    maximumBitRate::const_reference get_maximumBitRate () const;
    maximumBitRate::reference ref_maximumBitRate (); 
    maximumBitRate::reference select_maximumBitRate (); 
    maximumBitRate::reference select_maximumBitRate (maximumBitRate::value_type::int_type value); 
    bool maximumBitRate_isSelected() const;

    class noRestriction {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noRestriction

    noRestriction::reference select_noRestriction (); 
    bool noRestriction_isSelected() const;

    FlowControlCommand_restriction(maximumBitRate::Id id, maximumBitRate::value_type::int_type value);
    FlowControlCommand_restriction(noRestriction::Id id, noRestriction::const_reference value);
    void swap(FlowControlCommand_restriction & other);
    FlowControlCommand_restriction(const FlowControlCommand_restriction & other)
    : Inherited(other) {} 

    FlowControlCommand_restriction & operator = (const FlowControlCommand_restriction & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FlowControlCommand_restriction * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// EndSessionCommand_gstnOptions
//

class EndSessionCommand_gstnOptions : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EndSessionCommand_gstnOptions(const void* info) : Inherited(info) {}
  public:
    EndSessionCommand_gstnOptions() : Inherited(&theInfo) {}
    class telephonyMode {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class telephonyMode

    telephonyMode::reference select_telephonyMode (); 
    bool telephonyMode_isSelected() const;

    class v8bis {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v8bis

    v8bis::reference select_v8bis (); 
    bool v8bis_isSelected() const;

    class v34DSVD {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v34DSVD

    v34DSVD::reference select_v34DSVD (); 
    bool v34DSVD_isSelected() const;

    class v34DuplexFAX {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v34DuplexFAX

    v34DuplexFAX::reference select_v34DuplexFAX (); 
    bool v34DuplexFAX_isSelected() const;

    class v34H324 {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v34H324

    v34H324::reference select_v34H324 (); 
    bool v34H324_isSelected() const;

    EndSessionCommand_gstnOptions(telephonyMode::Id id, telephonyMode::const_reference value);
    EndSessionCommand_gstnOptions(v8bis::Id id, v8bis::const_reference value);
    EndSessionCommand_gstnOptions(v34DSVD::Id id, v34DSVD::const_reference value);
    EndSessionCommand_gstnOptions(v34DuplexFAX::Id id, v34DuplexFAX::const_reference value);
    EndSessionCommand_gstnOptions(v34H324::Id id, v34H324::const_reference value);
    void swap(EndSessionCommand_gstnOptions & other);
    EndSessionCommand_gstnOptions(const EndSessionCommand_gstnOptions & other)
    : Inherited(other) {} 

    EndSessionCommand_gstnOptions & operator = (const EndSessionCommand_gstnOptions & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EndSessionCommand_gstnOptions * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// EndSessionCommand_isdnOptions
//

class EndSessionCommand_isdnOptions : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EndSessionCommand_isdnOptions(const void* info) : Inherited(info) {}
  public:
    EndSessionCommand_isdnOptions() : Inherited(&theInfo) {}
    class telephonyMode {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class telephonyMode

    telephonyMode::reference select_telephonyMode (); 
    bool telephonyMode_isSelected() const;

    class v140 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v140

    v140::reference select_v140 (); 
    bool v140_isSelected() const;

    class terminalOnHold {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalOnHold

    terminalOnHold::reference select_terminalOnHold (); 
    bool terminalOnHold_isSelected() const;

    EndSessionCommand_isdnOptions(telephonyMode::Id id, telephonyMode::const_reference value);
    EndSessionCommand_isdnOptions(v140::Id id, v140::const_reference value);
    EndSessionCommand_isdnOptions(terminalOnHold::Id id, terminalOnHold::const_reference value);
    void swap(EndSessionCommand_isdnOptions & other);
    EndSessionCommand_isdnOptions(const EndSessionCommand_isdnOptions & other)
    : Inherited(other) {} 

    EndSessionCommand_isdnOptions & operator = (const EndSessionCommand_isdnOptions & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EndSessionCommand_isdnOptions * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H223MultiplexReconfiguration_h223ModeChange
//

class H223MultiplexReconfiguration_h223ModeChange : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223MultiplexReconfiguration_h223ModeChange(const void* info) : Inherited(info) {}
  public:
    H223MultiplexReconfiguration_h223ModeChange() : Inherited(&theInfo) {}
    class toLevel0 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class toLevel0

    toLevel0::reference select_toLevel0 (); 
    bool toLevel0_isSelected() const;

    class toLevel1 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class toLevel1

    toLevel1::reference select_toLevel1 (); 
    bool toLevel1_isSelected() const;

    class toLevel2 {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class toLevel2

    toLevel2::reference select_toLevel2 (); 
    bool toLevel2_isSelected() const;

    class toLevel2withOptionalHeader {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class toLevel2withOptionalHeader

    toLevel2withOptionalHeader::reference select_toLevel2withOptionalHeader (); 
    bool toLevel2withOptionalHeader_isSelected() const;

    H223MultiplexReconfiguration_h223ModeChange(toLevel0::Id id, toLevel0::const_reference value);
    H223MultiplexReconfiguration_h223ModeChange(toLevel1::Id id, toLevel1::const_reference value);
    H223MultiplexReconfiguration_h223ModeChange(toLevel2::Id id, toLevel2::const_reference value);
    H223MultiplexReconfiguration_h223ModeChange(toLevel2withOptionalHeader::Id id, toLevel2withOptionalHeader::const_reference value);
    void swap(H223MultiplexReconfiguration_h223ModeChange & other);
    H223MultiplexReconfiguration_h223ModeChange(const H223MultiplexReconfiguration_h223ModeChange & other)
    : Inherited(other) {} 

    H223MultiplexReconfiguration_h223ModeChange & operator = (const H223MultiplexReconfiguration_h223ModeChange & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223MultiplexReconfiguration_h223ModeChange * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// H223MultiplexReconfiguration_h223AnnexADoubleFlag
//

class H223MultiplexReconfiguration_h223AnnexADoubleFlag : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223MultiplexReconfiguration_h223AnnexADoubleFlag(const void* info) : Inherited(info) {}
  public:
    H223MultiplexReconfiguration_h223AnnexADoubleFlag() : Inherited(&theInfo) {}
    class start {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class start

    start::reference select_start (); 
    bool start_isSelected() const;

    class stop {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class stop

    stop::reference select_stop (); 
    bool stop_isSelected() const;

    H223MultiplexReconfiguration_h223AnnexADoubleFlag(start::Id id, start::const_reference value);
    H223MultiplexReconfiguration_h223AnnexADoubleFlag(stop::Id id, stop::const_reference value);
    void swap(H223MultiplexReconfiguration_h223AnnexADoubleFlag & other);
    H223MultiplexReconfiguration_h223AnnexADoubleFlag(const H223MultiplexReconfiguration_h223AnnexADoubleFlag & other)
    : Inherited(other) {} 

    H223MultiplexReconfiguration_h223AnnexADoubleFlag & operator = (const H223MultiplexReconfiguration_h223AnnexADoubleFlag & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223MultiplexReconfiguration_h223AnnexADoubleFlag * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// NewATMVCCommand_multiplex
//

class NewATMVCCommand_multiplex : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NewATMVCCommand_multiplex(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_multiplex() : Inherited(&theInfo) {}
    class noMultiplex {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noMultiplex

    noMultiplex::reference select_noMultiplex (); 
    bool noMultiplex_isSelected() const;

    class transportStream {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportStream

    transportStream::reference select_transportStream (); 
    bool transportStream_isSelected() const;

    class programStream {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class programStream

    programStream::reference select_programStream (); 
    bool programStream_isSelected() const;

    NewATMVCCommand_multiplex(noMultiplex::Id id, noMultiplex::const_reference value);
    NewATMVCCommand_multiplex(transportStream::Id id, transportStream::const_reference value);
    NewATMVCCommand_multiplex(programStream::Id id, programStream::const_reference value);
    void swap(NewATMVCCommand_multiplex & other);
    NewATMVCCommand_multiplex(const NewATMVCCommand_multiplex & other)
    : Inherited(other) {} 

    NewATMVCCommand_multiplex & operator = (const NewATMVCCommand_multiplex & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NewATMVCCommand_multiplex * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MobileMultilinkReconfigurationCommand_status
//

class MobileMultilinkReconfigurationCommand_status : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MobileMultilinkReconfigurationCommand_status(const void* info) : Inherited(info) {}
  public:
    MobileMultilinkReconfigurationCommand_status() : Inherited(&theInfo) {}
    class synchronized {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class synchronized

    synchronized::reference select_synchronized (); 
    bool synchronized_isSelected() const;

    class reconfiguration {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reconfiguration

    reconfiguration::reference select_reconfiguration (); 
    bool reconfiguration_isSelected() const;

    MobileMultilinkReconfigurationCommand_status(synchronized::Id id, synchronized::const_reference value);
    MobileMultilinkReconfigurationCommand_status(reconfiguration::Id id, reconfiguration::const_reference value);
    void swap(MobileMultilinkReconfigurationCommand_status & other);
    MobileMultilinkReconfigurationCommand_status(const MobileMultilinkReconfigurationCommand_status & other)
    : Inherited(other) {} 

    MobileMultilinkReconfigurationCommand_status & operator = (const MobileMultilinkReconfigurationCommand_status & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MobileMultilinkReconfigurationCommand_status * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// FunctionNotSupported_cause
//

class FunctionNotSupported_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FunctionNotSupported_cause(const void* info) : Inherited(info) {}
  public:
    FunctionNotSupported_cause() : Inherited(&theInfo) {}
    class syntaxError {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class syntaxError

    syntaxError::reference select_syntaxError (); 
    bool syntaxError_isSelected() const;

    class semanticError {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class semanticError

    semanticError::reference select_semanticError (); 
    bool semanticError_isSelected() const;

    class unknownFunction {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknownFunction

    unknownFunction::reference select_unknownFunction (); 
    bool unknownFunction_isSelected() const;

    FunctionNotSupported_cause(syntaxError::Id id, syntaxError::const_reference value);
    FunctionNotSupported_cause(semanticError::Id id, semanticError::const_reference value);
    FunctionNotSupported_cause(unknownFunction::Id id, unknownFunction::const_reference value);
    void swap(FunctionNotSupported_cause & other);
    FunctionNotSupported_cause(const FunctionNotSupported_cause & other)
    : Inherited(other) {} 

    FunctionNotSupported_cause & operator = (const FunctionNotSupported_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FunctionNotSupported_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// JitterIndication_scope
//

class JitterIndication_scope : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    JitterIndication_scope(const void* info) : Inherited(info) {}
  public:
    JitterIndication_scope() : Inherited(&theInfo) {}
    class logicalChannelNumber {
      public:
        enum Id { id_ = 0 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber

    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (logicalChannelNumber::value_type::int_type value); 
    bool logicalChannelNumber_isSelected() const;

    class resourceID {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceID

    resourceID::const_reference get_resourceID () const;
    resourceID::reference ref_resourceID (); 
    resourceID::reference select_resourceID (); 
    resourceID::reference select_resourceID (resourceID::value_type::int_type value); 
    bool resourceID_isSelected() const;

    class wholeMultiplex {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wholeMultiplex

    wholeMultiplex::reference select_wholeMultiplex (); 
    bool wholeMultiplex_isSelected() const;

    JitterIndication_scope(logicalChannelNumber::Id id, logicalChannelNumber::value_type::int_type value);
    JitterIndication_scope(resourceID::Id id, resourceID::value_type::int_type value);
    JitterIndication_scope(wholeMultiplex::Id id, wholeMultiplex::const_reference value);
    void swap(JitterIndication_scope & other);
    JitterIndication_scope(const JitterIndication_scope & other)
    : Inherited(other) {} 

    JitterIndication_scope & operator = (const JitterIndication_scope & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    JitterIndication_scope * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// UserInputIndication_userInputSupportIndication
//

class UserInputIndication_userInputSupportIndication : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    UserInputIndication_userInputSupportIndication(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_userInputSupportIndication() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class basicString {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicString

    basicString::reference select_basicString (); 
    bool basicString_isSelected() const;

    class iA5String {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class iA5String

    iA5String::reference select_iA5String (); 
    bool iA5String_isSelected() const;

    class generalString {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generalString

    generalString::reference select_generalString (); 
    bool generalString_isSelected() const;

    UserInputIndication_userInputSupportIndication(nonStandard::Id id, nonStandard::const_reference value);
    UserInputIndication_userInputSupportIndication(basicString::Id id, basicString::const_reference value);
    UserInputIndication_userInputSupportIndication(iA5String::Id id, iA5String::const_reference value);
    UserInputIndication_userInputSupportIndication(generalString::Id id, generalString::const_reference value);
    void swap(UserInputIndication_userInputSupportIndication & other);
    UserInputIndication_userInputSupportIndication(const UserInputIndication_userInputSupportIndication & other)
    : Inherited(other) {} 

    UserInputIndication_userInputSupportIndication & operator = (const UserInputIndication_userInputSupportIndication & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    UserInputIndication_userInputSupportIndication * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// UserInputIndication_extendedAlphanumeric
//

class UserInputIndication_extendedAlphanumeric : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UserInputIndication_extendedAlphanumeric(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_extendedAlphanumeric() : Inherited(&theInfo) {}
    UserInputIndication_extendedAlphanumeric(const UserInputIndication_extendedAlphanumeric & other) : Inherited(other)
    {}
    UserInputIndication_extendedAlphanumeric& operator = (const UserInputIndication_extendedAlphanumeric& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_rtpPayloadIndication
    };

    class alphanumeric {
      public:
        typedef ASN1::GeneralString value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alphanumeric
    alphanumeric::const_reference get_alphanumeric () const;
    alphanumeric::reference ref_alphanumeric ();
    alphanumeric::reference set_alphanumeric ();
    alphanumeric::reference set_alphanumeric (const std::string& value);
    class rtpPayloadIndication {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpPayloadIndication
    rtpPayloadIndication::reference set_rtpPayloadIndication ();
    void omit_rtpPayloadIndication ();
    bool rtpPayloadIndication_isPresent () const;
    void swap(UserInputIndication_extendedAlphanumeric& other);
    UserInputIndication_extendedAlphanumeric * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// FlowControlIndication_scope
//

class FlowControlIndication_scope : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FlowControlIndication_scope(const void* info) : Inherited(info) {}
  public:
    FlowControlIndication_scope() : Inherited(&theInfo) {}
    class logicalChannelNumber {
      public:
        enum Id { id_ = 0 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber

    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (); 
    logicalChannelNumber::reference select_logicalChannelNumber (logicalChannelNumber::value_type::int_type value); 
    bool logicalChannelNumber_isSelected() const;

    class resourceID {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceID

    resourceID::const_reference get_resourceID () const;
    resourceID::reference ref_resourceID (); 
    resourceID::reference select_resourceID (); 
    resourceID::reference select_resourceID (resourceID::value_type::int_type value); 
    bool resourceID_isSelected() const;

    class wholeMultiplex {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wholeMultiplex

    wholeMultiplex::reference select_wholeMultiplex (); 
    bool wholeMultiplex_isSelected() const;

    FlowControlIndication_scope(logicalChannelNumber::Id id, logicalChannelNumber::value_type::int_type value);
    FlowControlIndication_scope(resourceID::Id id, resourceID::value_type::int_type value);
    FlowControlIndication_scope(wholeMultiplex::Id id, wholeMultiplex::const_reference value);
    void swap(FlowControlIndication_scope & other);
    FlowControlIndication_scope(const FlowControlIndication_scope & other)
    : Inherited(other) {} 

    FlowControlIndication_scope & operator = (const FlowControlIndication_scope & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FlowControlIndication_scope * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// FlowControlIndication_restriction
//

class FlowControlIndication_restriction : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FlowControlIndication_restriction(const void* info) : Inherited(info) {}
  public:
    FlowControlIndication_restriction() : Inherited(&theInfo) {}
    class maximumBitRate {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumBitRate

    maximumBitRate::const_reference get_maximumBitRate () const;
    maximumBitRate::reference ref_maximumBitRate (); 
    maximumBitRate::reference select_maximumBitRate (); 
    maximumBitRate::reference select_maximumBitRate (maximumBitRate::value_type::int_type value); 
    bool maximumBitRate_isSelected() const;

    class noRestriction {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noRestriction

    noRestriction::reference select_noRestriction (); 
    bool noRestriction_isSelected() const;

    FlowControlIndication_restriction(maximumBitRate::Id id, maximumBitRate::value_type::int_type value);
    FlowControlIndication_restriction(noRestriction::Id id, noRestriction::const_reference value);
    void swap(FlowControlIndication_restriction & other);
    FlowControlIndication_restriction(const FlowControlIndication_restriction & other)
    : Inherited(other) {} 

    FlowControlIndication_restriction & operator = (const FlowControlIndication_restriction & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FlowControlIndication_restriction * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded
//

class TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded() : Inherited(&theInfo) {}
    class highestEntryNumberProcessed {
      public:
        enum Id { id_ = 0 };
        typedef CapabilityTableEntryNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class highestEntryNumberProcessed

    highestEntryNumberProcessed::const_reference get_highestEntryNumberProcessed () const;
    highestEntryNumberProcessed::reference ref_highestEntryNumberProcessed (); 
    highestEntryNumberProcessed::reference select_highestEntryNumberProcessed (); 
    highestEntryNumberProcessed::reference select_highestEntryNumberProcessed (highestEntryNumberProcessed::value_type::int_type value); 
    bool highestEntryNumberProcessed_isSelected() const;

    class noneProcessed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noneProcessed

    noneProcessed::reference select_noneProcessed (); 
    bool noneProcessed_isSelected() const;

    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(highestEntryNumberProcessed::Id id, highestEntryNumberProcessed::value_type::int_type value);
    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(noneProcessed::Id id, noneProcessed::const_reference value);
    void swap(TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded & other);
    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded(const TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded & other)
    : Inherited(other) {} 

    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded & operator = (const TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223ModeParameters_adaptationLayerType_al3
//

class H223ModeParameters_adaptationLayerType_al3 : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223ModeParameters_adaptationLayerType_al3(const void* info) : Inherited(info) {}
  public:
    H223ModeParameters_adaptationLayerType_al3() : Inherited(&theInfo) {}
    H223ModeParameters_adaptationLayerType_al3(const H223ModeParameters_adaptationLayerType_al3 & other) : Inherited(other)
    {}
    H223ModeParameters_adaptationLayerType_al3& operator = (const H223ModeParameters_adaptationLayerType_al3& other)
    { Inherited::operator = (other); return *this; } 
    class controlFieldOctets {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 2>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class controlFieldOctets
    controlFieldOctets::const_reference get_controlFieldOctets () const;
    controlFieldOctets::reference ref_controlFieldOctets ();
    controlFieldOctets::reference set_controlFieldOctets ();
    controlFieldOctets::reference set_controlFieldOctets (controlFieldOctets::value_type::int_type value);
    class sendBufferSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendBufferSize
    sendBufferSize::const_reference get_sendBufferSize () const;
    sendBufferSize::reference ref_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize (sendBufferSize::value_type::int_type value);
    void swap(H223ModeParameters_adaptationLayerType_al3& other);
    H223ModeParameters_adaptationLayerType_al3 * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// DataMode_application_nlpid
//

class DataMode_application_nlpid : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DataMode_application_nlpid(const void* info) : Inherited(info) {}
  public:
    DataMode_application_nlpid() : Inherited(&theInfo) {}
    DataMode_application_nlpid(const DataMode_application_nlpid & other) : Inherited(other)
    {}
    DataMode_application_nlpid& operator = (const DataMode_application_nlpid& other)
    { Inherited::operator = (other); return *this; } 
    class nlpidProtocol {
      public:
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nlpidProtocol
    nlpidProtocol::const_reference get_nlpidProtocol () const;
    nlpidProtocol::reference ref_nlpidProtocol ();
    nlpidProtocol::reference set_nlpidProtocol ();
    nlpidProtocol::reference set_nlpidProtocol (nlpidProtocol::const_reference value);
    class nlpidData {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nlpidData
    nlpidData::const_reference get_nlpidData () const;
    nlpidData::reference ref_nlpidData ();
    nlpidData::reference set_nlpidData ();
    nlpidData::reference set_nlpidData (const std::vector<char>& value);
    void swap(DataMode_application_nlpid& other);
    DataMode_application_nlpid * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// DataMode_application_t38fax
//

class DataMode_application_t38fax : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DataMode_application_t38fax(const void* info) : Inherited(info) {}
  public:
    DataMode_application_t38fax() : Inherited(&theInfo) {}
    DataMode_application_t38fax(const DataMode_application_t38fax & other) : Inherited(other)
    {}
    DataMode_application_t38fax& operator = (const DataMode_application_t38fax& other)
    { Inherited::operator = (other); return *this; } 
    class t38FaxProtocol {
      public:
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t38FaxProtocol
    t38FaxProtocol::const_reference get_t38FaxProtocol () const;
    t38FaxProtocol::reference ref_t38FaxProtocol ();
    t38FaxProtocol::reference set_t38FaxProtocol ();
    t38FaxProtocol::reference set_t38FaxProtocol (t38FaxProtocol::const_reference value);
    class t38FaxProfile {
      public:
        typedef T38FaxProfile value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t38FaxProfile
    t38FaxProfile::const_reference get_t38FaxProfile () const;
    t38FaxProfile::reference ref_t38FaxProfile ();
    t38FaxProfile::reference set_t38FaxProfile ();
    t38FaxProfile::reference set_t38FaxProfile (t38FaxProfile::const_reference value);
    void swap(DataMode_application_t38fax& other);
    DataMode_application_t38fax * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MultilinkRequest_maximumHeaderInterval_requestType
//

class MultilinkRequest_maximumHeaderInterval_requestType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkRequest_maximumHeaderInterval_requestType(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest_maximumHeaderInterval_requestType() : Inherited(&theInfo) {}
    class currentIntervalInformation {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class currentIntervalInformation

    currentIntervalInformation::reference select_currentIntervalInformation (); 
    bool currentIntervalInformation_isSelected() const;

    class requestedInterval {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestedInterval

    requestedInterval::const_reference get_requestedInterval () const;
    requestedInterval::reference ref_requestedInterval (); 
    requestedInterval::reference select_requestedInterval (); 
    requestedInterval::reference select_requestedInterval (requestedInterval::value_type::int_type value); 
    bool requestedInterval_isSelected() const;

    MultilinkRequest_maximumHeaderInterval_requestType(currentIntervalInformation::Id id, currentIntervalInformation::const_reference value);
    MultilinkRequest_maximumHeaderInterval_requestType(requestedInterval::Id id, requestedInterval::value_type::int_type value);
    void swap(MultilinkRequest_maximumHeaderInterval_requestType & other);
    MultilinkRequest_maximumHeaderInterval_requestType(const MultilinkRequest_maximumHeaderInterval_requestType & other)
    : Inherited(other) {} 

    MultilinkRequest_maximumHeaderInterval_requestType & operator = (const MultilinkRequest_maximumHeaderInterval_requestType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkRequest_maximumHeaderInterval_requestType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MiscellaneousCommand_type_videoFastUpdateGOB
//

class MiscellaneousCommand_type_videoFastUpdateGOB : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand_type_videoFastUpdateGOB(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_videoFastUpdateGOB() : Inherited(&theInfo) {}
    MiscellaneousCommand_type_videoFastUpdateGOB(const MiscellaneousCommand_type_videoFastUpdateGOB & other) : Inherited(other)
    {}
    MiscellaneousCommand_type_videoFastUpdateGOB& operator = (const MiscellaneousCommand_type_videoFastUpdateGOB& other)
    { Inherited::operator = (other); return *this; } 
    class firstGOB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 17>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstGOB
    firstGOB::const_reference get_firstGOB () const;
    firstGOB::reference ref_firstGOB ();
    firstGOB::reference set_firstGOB ();
    firstGOB::reference set_firstGOB (firstGOB::value_type::int_type value);
    class numberOfGOBs {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 18>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfGOBs
    numberOfGOBs::const_reference get_numberOfGOBs () const;
    numberOfGOBs::reference ref_numberOfGOBs ();
    numberOfGOBs::reference set_numberOfGOBs ();
    numberOfGOBs::reference set_numberOfGOBs (numberOfGOBs::value_type::int_type value);
    void swap(MiscellaneousCommand_type_videoFastUpdateGOB& other);
    MiscellaneousCommand_type_videoFastUpdateGOB * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MiscellaneousCommand_type_videoFastUpdateMB
//

class MiscellaneousCommand_type_videoFastUpdateMB : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand_type_videoFastUpdateMB(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_videoFastUpdateMB() : Inherited(&theInfo) {}
    MiscellaneousCommand_type_videoFastUpdateMB(const MiscellaneousCommand_type_videoFastUpdateMB & other) : Inherited(other)
    {}
    MiscellaneousCommand_type_videoFastUpdateMB& operator = (const MiscellaneousCommand_type_videoFastUpdateMB& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_firstGOB,
      e_firstMB
    };

    class firstGOB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstGOB
    firstGOB::const_reference get_firstGOB () const;
    firstGOB::reference ref_firstGOB ();
    firstGOB::reference set_firstGOB ();
    firstGOB::reference set_firstGOB (firstGOB::value_type::int_type value);
    void omit_firstGOB ();
    bool firstGOB_isPresent () const;
    class firstMB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 8192>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstMB
    firstMB::const_reference get_firstMB () const;
    firstMB::reference ref_firstMB ();
    firstMB::reference set_firstMB ();
    firstMB::reference set_firstMB (firstMB::value_type::int_type value);
    void omit_firstMB ();
    bool firstMB_isPresent () const;
    class numberOfMBs {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 8192>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfMBs
    numberOfMBs::const_reference get_numberOfMBs () const;
    numberOfMBs::reference ref_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs (numberOfMBs::value_type::int_type value);
    void swap(MiscellaneousCommand_type_videoFastUpdateMB& other);
    MiscellaneousCommand_type_videoFastUpdateMB * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MiscellaneousCommand_type_videoBadMBs
//

class MiscellaneousCommand_type_videoBadMBs : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand_type_videoBadMBs(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_videoBadMBs() : Inherited(&theInfo) {}
    MiscellaneousCommand_type_videoBadMBs(const MiscellaneousCommand_type_videoBadMBs & other) : Inherited(other)
    {}
    MiscellaneousCommand_type_videoBadMBs& operator = (const MiscellaneousCommand_type_videoBadMBs& other)
    { Inherited::operator = (other); return *this; } 
    class firstMB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 9216>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstMB
    firstMB::const_reference get_firstMB () const;
    firstMB::reference ref_firstMB ();
    firstMB::reference set_firstMB ();
    firstMB::reference set_firstMB (firstMB::value_type::int_type value);
    class numberOfMBs {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 9216>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfMBs
    numberOfMBs::const_reference get_numberOfMBs () const;
    numberOfMBs::reference ref_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs (numberOfMBs::value_type::int_type value);
    class temporalReference {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 1023>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class temporalReference
    temporalReference::const_reference get_temporalReference () const;
    temporalReference::reference ref_temporalReference ();
    temporalReference::reference set_temporalReference ();
    temporalReference::reference set_temporalReference (temporalReference::value_type::int_type value);
    void swap(MiscellaneousCommand_type_videoBadMBs& other);
    MiscellaneousCommand_type_videoBadMBs * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MiscellaneousCommand_type_lostPartialPicture
//

class MiscellaneousCommand_type_lostPartialPicture : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand_type_lostPartialPicture(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_lostPartialPicture() : Inherited(&theInfo) {}
    MiscellaneousCommand_type_lostPartialPicture(const MiscellaneousCommand_type_lostPartialPicture & other) : Inherited(other)
    {}
    MiscellaneousCommand_type_lostPartialPicture& operator = (const MiscellaneousCommand_type_lostPartialPicture& other)
    { Inherited::operator = (other); return *this; } 
    class pictureReference {
      public:
        typedef PictureReference value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pictureReference
    pictureReference::const_reference get_pictureReference () const;
    pictureReference::reference ref_pictureReference ();
    pictureReference::reference set_pictureReference ();
    pictureReference::reference set_pictureReference (pictureReference::const_reference value);
    class firstMB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 9216>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstMB
    firstMB::const_reference get_firstMB () const;
    firstMB::reference ref_firstMB ();
    firstMB::reference set_firstMB ();
    firstMB::reference set_firstMB (firstMB::value_type::int_type value);
    class numberOfMBs {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 9216>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfMBs
    numberOfMBs::const_reference get_numberOfMBs () const;
    numberOfMBs::reference ref_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs (numberOfMBs::value_type::int_type value);
    void swap(MiscellaneousCommand_type_lostPartialPicture& other);
    MiscellaneousCommand_type_lostPartialPicture * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// NewATMVCCommand_aal_aal5
//

class NewATMVCCommand_aal_aal5 : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NewATMVCCommand_aal_aal5(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_aal_aal5() : Inherited(&theInfo) {}
    NewATMVCCommand_aal_aal5(const NewATMVCCommand_aal_aal5 & other) : Inherited(other)
    {}
    NewATMVCCommand_aal_aal5& operator = (const NewATMVCCommand_aal_aal5& other)
    { Inherited::operator = (other); return *this; } 
    class forwardMaximumSDUSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardMaximumSDUSize
    forwardMaximumSDUSize::const_reference get_forwardMaximumSDUSize () const;
    forwardMaximumSDUSize::reference ref_forwardMaximumSDUSize ();
    forwardMaximumSDUSize::reference set_forwardMaximumSDUSize ();
    forwardMaximumSDUSize::reference set_forwardMaximumSDUSize (forwardMaximumSDUSize::value_type::int_type value);
    class backwardMaximumSDUSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class backwardMaximumSDUSize
    backwardMaximumSDUSize::const_reference get_backwardMaximumSDUSize () const;
    backwardMaximumSDUSize::reference ref_backwardMaximumSDUSize ();
    backwardMaximumSDUSize::reference set_backwardMaximumSDUSize ();
    backwardMaximumSDUSize::reference set_backwardMaximumSDUSize (backwardMaximumSDUSize::value_type::int_type value);
    void swap(NewATMVCCommand_aal_aal5& other);
    NewATMVCCommand_aal_aal5 * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// NewATMVCCommand_reverseParameters_multiplex
//

class NewATMVCCommand_reverseParameters_multiplex : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NewATMVCCommand_reverseParameters_multiplex(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_reverseParameters_multiplex() : Inherited(&theInfo) {}
    class noMultiplex {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noMultiplex

    noMultiplex::reference select_noMultiplex (); 
    bool noMultiplex_isSelected() const;

    class transportStream {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportStream

    transportStream::reference select_transportStream (); 
    bool transportStream_isSelected() const;

    class programStream {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class programStream

    programStream::reference select_programStream (); 
    bool programStream_isSelected() const;

    NewATMVCCommand_reverseParameters_multiplex(noMultiplex::Id id, noMultiplex::const_reference value);
    NewATMVCCommand_reverseParameters_multiplex(transportStream::Id id, transportStream::const_reference value);
    NewATMVCCommand_reverseParameters_multiplex(programStream::Id id, programStream::const_reference value);
    void swap(NewATMVCCommand_reverseParameters_multiplex & other);
    NewATMVCCommand_reverseParameters_multiplex(const NewATMVCCommand_reverseParameters_multiplex & other)
    : Inherited(other) {} 

    NewATMVCCommand_reverseParameters_multiplex & operator = (const NewATMVCCommand_reverseParameters_multiplex & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NewATMVCCommand_reverseParameters_multiplex * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MiscellaneousIndication_type_videoNotDecodedMBs
//

class MiscellaneousIndication_type_videoNotDecodedMBs : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousIndication_type_videoNotDecodedMBs(const void* info) : Inherited(info) {}
  public:
    MiscellaneousIndication_type_videoNotDecodedMBs() : Inherited(&theInfo) {}
    MiscellaneousIndication_type_videoNotDecodedMBs(const MiscellaneousIndication_type_videoNotDecodedMBs & other) : Inherited(other)
    {}
    MiscellaneousIndication_type_videoNotDecodedMBs& operator = (const MiscellaneousIndication_type_videoNotDecodedMBs& other)
    { Inherited::operator = (other); return *this; } 
    class firstMB {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 8192>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstMB
    firstMB::const_reference get_firstMB () const;
    firstMB::reference ref_firstMB ();
    firstMB::reference set_firstMB ();
    firstMB::reference set_firstMB (firstMB::value_type::int_type value);
    class numberOfMBs {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 8192>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfMBs
    numberOfMBs::const_reference get_numberOfMBs () const;
    numberOfMBs::reference ref_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs ();
    numberOfMBs::reference set_numberOfMBs (numberOfMBs::value_type::int_type value);
    class temporalReference {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class temporalReference
    temporalReference::const_reference get_temporalReference () const;
    temporalReference::reference ref_temporalReference ();
    temporalReference::reference set_temporalReference ();
    temporalReference::reference set_temporalReference (temporalReference::value_type::int_type value);
    void swap(MiscellaneousIndication_type_videoNotDecodedMBs& other);
    MiscellaneousIndication_type_videoNotDecodedMBs * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// UserInputIndication_signal_rtp
//

class UserInputIndication_signal_rtp : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UserInputIndication_signal_rtp(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_signal_rtp() : Inherited(&theInfo) {}
    UserInputIndication_signal_rtp(const UserInputIndication_signal_rtp & other) : Inherited(other)
    {}
    UserInputIndication_signal_rtp& operator = (const UserInputIndication_signal_rtp& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_timestamp,
      e_expirationTime
    };

    class timestamp {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timestamp
    timestamp::const_reference get_timestamp () const;
    timestamp::reference ref_timestamp ();
    timestamp::reference set_timestamp ();
    timestamp::reference set_timestamp (timestamp::value_type::int_type value);
    void omit_timestamp ();
    bool timestamp_isPresent () const;
    class expirationTime {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class expirationTime
    expirationTime::const_reference get_expirationTime () const;
    expirationTime::reference ref_expirationTime ();
    expirationTime::reference set_expirationTime ();
    expirationTime::reference set_expirationTime (expirationTime::value_type::int_type value);
    void omit_expirationTime ();
    bool expirationTime_isPresent () const;
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    void swap(UserInputIndication_signal_rtp& other);
    UserInputIndication_signal_rtp * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// UserInputIndication_signalUpdate_rtp
//

class UserInputIndication_signalUpdate_rtp : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UserInputIndication_signalUpdate_rtp(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_signalUpdate_rtp() : Inherited(&theInfo) {}
    UserInputIndication_signalUpdate_rtp(const UserInputIndication_signalUpdate_rtp & other) : Inherited(other)
    {}
    UserInputIndication_signalUpdate_rtp& operator = (const UserInputIndication_signalUpdate_rtp& other)
    { Inherited::operator = (other); return *this; } 
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    void swap(UserInputIndication_signalUpdate_rtp& other);
    UserInputIndication_signalUpdate_rtp * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MultilinkResponse_addConnection_responseCode_rejected
//

class MultilinkResponse_addConnection_responseCode_rejected : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkResponse_addConnection_responseCode_rejected(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_addConnection_responseCode_rejected() : Inherited(&theInfo) {}
    class connectionsNotAvailable {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectionsNotAvailable

    connectionsNotAvailable::reference select_connectionsNotAvailable (); 
    bool connectionsNotAvailable_isSelected() const;

    class userRejected {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class userRejected

    userRejected::reference select_userRejected (); 
    bool userRejected_isSelected() const;

    MultilinkResponse_addConnection_responseCode_rejected(connectionsNotAvailable::Id id, connectionsNotAvailable::const_reference value);
    MultilinkResponse_addConnection_responseCode_rejected(userRejected::Id id, userRejected::const_reference value);
    void swap(MultilinkResponse_addConnection_responseCode_rejected & other);
    MultilinkResponse_addConnection_responseCode_rejected(const MultilinkResponse_addConnection_responseCode_rejected & other)
    : Inherited(other) {} 

    MultilinkResponse_addConnection_responseCode_rejected & operator = (const MultilinkResponse_addConnection_responseCode_rejected & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkResponse_addConnection_responseCode_rejected * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MiscellaneousCommand_type_progressiveRefinementStart_repeatCount
//

class MiscellaneousCommand_type_progressiveRefinementStart_repeatCount : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount() : Inherited(&theInfo) {}
    class doOneProgression {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class doOneProgression

    doOneProgression::reference select_doOneProgression (); 
    bool doOneProgression_isSelected() const;

    class doContinuousProgressions {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class doContinuousProgressions

    doContinuousProgressions::reference select_doContinuousProgressions (); 
    bool doContinuousProgressions_isSelected() const;

    class doOneIndependentProgression {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class doOneIndependentProgression

    doOneIndependentProgression::reference select_doOneIndependentProgression (); 
    bool doOneIndependentProgression_isSelected() const;

    class doContinuousIndependentProgressions {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class doContinuousIndependentProgressions

    doContinuousIndependentProgressions::reference select_doContinuousIndependentProgressions (); 
    bool doContinuousIndependentProgressions_isSelected() const;

    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(doOneProgression::Id id, doOneProgression::const_reference value);
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(doContinuousProgressions::Id id, doContinuousProgressions::const_reference value);
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(doOneIndependentProgression::Id id, doOneIndependentProgression::const_reference value);
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(doContinuousIndependentProgressions::Id id, doContinuousIndependentProgressions::const_reference value);
    void swap(MiscellaneousCommand_type_progressiveRefinementStart_repeatCount & other);
    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount(const MiscellaneousCommand_type_progressiveRefinementStart_repeatCount & other)
    : Inherited(other) {} 

    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount & operator = (const MiscellaneousCommand_type_progressiveRefinementStart_repeatCount & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MiscellaneousCommand_type_progressiveRefinementStart_repeatCount * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// NewATMVCCommand_aal_aal1_clockRecovery
//

class NewATMVCCommand_aal_aal1_clockRecovery : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NewATMVCCommand_aal_aal1_clockRecovery(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_aal_aal1_clockRecovery() : Inherited(&theInfo) {}
    class nullClockRecovery {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nullClockRecovery

    nullClockRecovery::reference select_nullClockRecovery (); 
    bool nullClockRecovery_isSelected() const;

    class srtsClockRecovery {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class srtsClockRecovery

    srtsClockRecovery::reference select_srtsClockRecovery (); 
    bool srtsClockRecovery_isSelected() const;

    class adaptiveClockRecovery {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class adaptiveClockRecovery

    adaptiveClockRecovery::reference select_adaptiveClockRecovery (); 
    bool adaptiveClockRecovery_isSelected() const;

    NewATMVCCommand_aal_aal1_clockRecovery(nullClockRecovery::Id id, nullClockRecovery::const_reference value);
    NewATMVCCommand_aal_aal1_clockRecovery(srtsClockRecovery::Id id, srtsClockRecovery::const_reference value);
    NewATMVCCommand_aal_aal1_clockRecovery(adaptiveClockRecovery::Id id, adaptiveClockRecovery::const_reference value);
    void swap(NewATMVCCommand_aal_aal1_clockRecovery & other);
    NewATMVCCommand_aal_aal1_clockRecovery(const NewATMVCCommand_aal_aal1_clockRecovery & other)
    : Inherited(other) {} 

    NewATMVCCommand_aal_aal1_clockRecovery & operator = (const NewATMVCCommand_aal_aal1_clockRecovery & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NewATMVCCommand_aal_aal1_clockRecovery * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// NewATMVCCommand_aal_aal1_errorCorrection
//

class NewATMVCCommand_aal_aal1_errorCorrection : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NewATMVCCommand_aal_aal1_errorCorrection(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_aal_aal1_errorCorrection() : Inherited(&theInfo) {}
    class nullErrorCorrection {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nullErrorCorrection

    nullErrorCorrection::reference select_nullErrorCorrection (); 
    bool nullErrorCorrection_isSelected() const;

    class longInterleaver {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class longInterleaver

    longInterleaver::reference select_longInterleaver (); 
    bool longInterleaver_isSelected() const;

    class shortInterleaver {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class shortInterleaver

    shortInterleaver::reference select_shortInterleaver (); 
    bool shortInterleaver_isSelected() const;

    class errorCorrectionOnly {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorCorrectionOnly

    errorCorrectionOnly::reference select_errorCorrectionOnly (); 
    bool errorCorrectionOnly_isSelected() const;

    NewATMVCCommand_aal_aal1_errorCorrection(nullErrorCorrection::Id id, nullErrorCorrection::const_reference value);
    NewATMVCCommand_aal_aal1_errorCorrection(longInterleaver::Id id, longInterleaver::const_reference value);
    NewATMVCCommand_aal_aal1_errorCorrection(shortInterleaver::Id id, shortInterleaver::const_reference value);
    NewATMVCCommand_aal_aal1_errorCorrection(errorCorrectionOnly::Id id, errorCorrectionOnly::const_reference value);
    void swap(NewATMVCCommand_aal_aal1_errorCorrection & other);
    NewATMVCCommand_aal_aal1_errorCorrection(const NewATMVCCommand_aal_aal1_errorCorrection & other)
    : Inherited(other) {} 

    NewATMVCCommand_aal_aal1_errorCorrection & operator = (const NewATMVCCommand_aal_aal1_errorCorrection & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NewATMVCCommand_aal_aal1_errorCorrection * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// MasterSlaveDeterminationAck
//

class MasterSlaveDeterminationAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MasterSlaveDeterminationAck(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDeterminationAck() : Inherited(&theInfo) {}
    MasterSlaveDeterminationAck(const MasterSlaveDeterminationAck & other) : Inherited(other)
    {}
    MasterSlaveDeterminationAck& operator = (const MasterSlaveDeterminationAck& other)
    { Inherited::operator = (other); return *this; } 
    class decision {
      public:
        typedef MasterSlaveDeterminationAck_decision value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class decision
    decision::const_reference get_decision () const;
    decision::reference ref_decision ();
    decision::reference set_decision ();
    decision::reference set_decision (decision::const_reference value);
    void swap(MasterSlaveDeterminationAck& other);
    MasterSlaveDeterminationAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MasterSlaveDeterminationReject
//

class MasterSlaveDeterminationReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MasterSlaveDeterminationReject(const void* info) : Inherited(info) {}
  public:
    MasterSlaveDeterminationReject() : Inherited(&theInfo) {}
    MasterSlaveDeterminationReject(const MasterSlaveDeterminationReject & other) : Inherited(other)
    {}
    MasterSlaveDeterminationReject& operator = (const MasterSlaveDeterminationReject& other)
    { Inherited::operator = (other); return *this; } 
    class cause {
      public:
        typedef MasterSlaveDeterminationReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(MasterSlaveDeterminationReject& other);
    MasterSlaveDeterminationReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CapabilityDescriptor
//

class CapabilityDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CapabilityDescriptor(const void* info) : Inherited(info) {}
  public:
    CapabilityDescriptor() : Inherited(&theInfo) {}
    CapabilityDescriptor(const CapabilityDescriptor & other) : Inherited(other)
    {}
    CapabilityDescriptor& operator = (const CapabilityDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_simultaneousCapabilities
    };

    class capabilityDescriptorNumber {
      public:
        typedef CapabilityDescriptorNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capabilityDescriptorNumber
    capabilityDescriptorNumber::const_reference get_capabilityDescriptorNumber () const;
    capabilityDescriptorNumber::reference ref_capabilityDescriptorNumber ();
    capabilityDescriptorNumber::reference set_capabilityDescriptorNumber ();
    capabilityDescriptorNumber::reference set_capabilityDescriptorNumber (capabilityDescriptorNumber::value_type::int_type value);
    class simultaneousCapabilities {
      public:
        typedef ASN1::SET_OF<AlternativeCapabilitySet,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class simultaneousCapabilities
    simultaneousCapabilities::const_reference get_simultaneousCapabilities () const;
    simultaneousCapabilities::reference ref_simultaneousCapabilities ();
    simultaneousCapabilities::reference set_simultaneousCapabilities ();
    simultaneousCapabilities::reference set_simultaneousCapabilities (simultaneousCapabilities::const_reference value);
    void omit_simultaneousCapabilities ();
    bool simultaneousCapabilities_isPresent () const;
    void swap(CapabilityDescriptor& other);
    CapabilityDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TerminalCapabilitySetAck
//

class TerminalCapabilitySetAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalCapabilitySetAck(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySetAck() : Inherited(&theInfo) {}
    TerminalCapabilitySetAck(const TerminalCapabilitySetAck & other) : Inherited(other)
    {}
    TerminalCapabilitySetAck& operator = (const TerminalCapabilitySetAck& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    void swap(TerminalCapabilitySetAck& other);
    TerminalCapabilitySetAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// V76Capability
//

class V76Capability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V76Capability(const void* info) : Inherited(info) {}
  public:
    V76Capability() : Inherited(&theInfo) {}
    V76Capability(const V76Capability & other) : Inherited(other)
    {}
    V76Capability& operator = (const V76Capability& other)
    { Inherited::operator = (other); return *this; } 
    class suspendResumeCapabilitywAddress {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumeCapabilitywAddress
    suspendResumeCapabilitywAddress::const_reference get_suspendResumeCapabilitywAddress () const;
    suspendResumeCapabilitywAddress::reference ref_suspendResumeCapabilitywAddress ();
    suspendResumeCapabilitywAddress::reference set_suspendResumeCapabilitywAddress ();
    suspendResumeCapabilitywAddress::reference set_suspendResumeCapabilitywAddress (bool value);
    class suspendResumeCapabilitywoAddress {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumeCapabilitywoAddress
    suspendResumeCapabilitywoAddress::const_reference get_suspendResumeCapabilitywoAddress () const;
    suspendResumeCapabilitywoAddress::reference ref_suspendResumeCapabilitywoAddress ();
    suspendResumeCapabilitywoAddress::reference set_suspendResumeCapabilitywoAddress ();
    suspendResumeCapabilitywoAddress::reference set_suspendResumeCapabilitywoAddress (bool value);
    class rejCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejCapability
    rejCapability::const_reference get_rejCapability () const;
    rejCapability::reference ref_rejCapability ();
    rejCapability::reference set_rejCapability ();
    rejCapability::reference set_rejCapability (bool value);
    class sREJCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sREJCapability
    sREJCapability::const_reference get_sREJCapability () const;
    sREJCapability::reference ref_sREJCapability ();
    sREJCapability::reference set_sREJCapability ();
    sREJCapability::reference set_sREJCapability (bool value);
    class mREJCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mREJCapability
    mREJCapability::const_reference get_mREJCapability () const;
    mREJCapability::reference ref_mREJCapability ();
    mREJCapability::reference set_mREJCapability ();
    mREJCapability::reference set_mREJCapability (bool value);
    class crc8bitCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc8bitCapability
    crc8bitCapability::const_reference get_crc8bitCapability () const;
    crc8bitCapability::reference ref_crc8bitCapability ();
    crc8bitCapability::reference set_crc8bitCapability ();
    crc8bitCapability::reference set_crc8bitCapability (bool value);
    class crc16bitCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc16bitCapability
    crc16bitCapability::const_reference get_crc16bitCapability () const;
    crc16bitCapability::reference ref_crc16bitCapability ();
    crc16bitCapability::reference set_crc16bitCapability ();
    crc16bitCapability::reference set_crc16bitCapability (bool value);
    class crc32bitCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc32bitCapability
    crc32bitCapability::const_reference get_crc32bitCapability () const;
    crc32bitCapability::reference ref_crc32bitCapability ();
    crc32bitCapability::reference set_crc32bitCapability ();
    crc32bitCapability::reference set_crc32bitCapability (bool value);
    class uihCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class uihCapability
    uihCapability::const_reference get_uihCapability () const;
    uihCapability::reference ref_uihCapability ();
    uihCapability::reference set_uihCapability ();
    uihCapability::reference set_uihCapability (bool value);
    class numOfDLCS {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 2, 8191>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numOfDLCS
    numOfDLCS::const_reference get_numOfDLCS () const;
    numOfDLCS::reference ref_numOfDLCS ();
    numOfDLCS::reference set_numOfDLCS ();
    numOfDLCS::reference set_numOfDLCS (numOfDLCS::value_type::int_type value);
    class twoOctetAddressFieldCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class twoOctetAddressFieldCapability
    twoOctetAddressFieldCapability::const_reference get_twoOctetAddressFieldCapability () const;
    twoOctetAddressFieldCapability::reference ref_twoOctetAddressFieldCapability ();
    twoOctetAddressFieldCapability::reference set_twoOctetAddressFieldCapability ();
    twoOctetAddressFieldCapability::reference set_twoOctetAddressFieldCapability (bool value);
    class loopBackTestCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class loopBackTestCapability
    loopBackTestCapability::const_reference get_loopBackTestCapability () const;
    loopBackTestCapability::reference ref_loopBackTestCapability ();
    loopBackTestCapability::reference set_loopBackTestCapability ();
    loopBackTestCapability::reference set_loopBackTestCapability (bool value);
    class n401Capability {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4095>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class n401Capability
    n401Capability::const_reference get_n401Capability () const;
    n401Capability::reference ref_n401Capability ();
    n401Capability::reference set_n401Capability ();
    n401Capability::reference set_n401Capability (n401Capability::value_type::int_type value);
    class maxWindowSizeCapability {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxWindowSizeCapability
    maxWindowSizeCapability::const_reference get_maxWindowSizeCapability () const;
    maxWindowSizeCapability::reference ref_maxWindowSizeCapability ();
    maxWindowSizeCapability::reference set_maxWindowSizeCapability ();
    maxWindowSizeCapability::reference set_maxWindowSizeCapability (maxWindowSizeCapability::value_type::int_type value);
    class v75Capability {
      public:
        typedef V75Capability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v75Capability
    v75Capability::const_reference get_v75Capability () const;
    v75Capability::reference ref_v75Capability ();
    v75Capability::reference set_v75Capability ();
    v75Capability::reference set_v75Capability (v75Capability::const_reference value);
    void swap(V76Capability& other);
    V76Capability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[15];
    static int fieldIds[15];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[15];
#endif
};

//
// MultipointCapability
//

class MultipointCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultipointCapability(const void* info) : Inherited(info) {}
  public:
    MultipointCapability() : Inherited(&theInfo) {}
    MultipointCapability(const MultipointCapability & other) : Inherited(other)
    {}
    MultipointCapability& operator = (const MultipointCapability& other)
    { Inherited::operator = (other); return *this; } 
    class multicastCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multicastCapability
    multicastCapability::const_reference get_multicastCapability () const;
    multicastCapability::reference ref_multicastCapability ();
    multicastCapability::reference set_multicastCapability ();
    multicastCapability::reference set_multicastCapability (bool value);
    class multiUniCastConference {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiUniCastConference
    multiUniCastConference::const_reference get_multiUniCastConference () const;
    multiUniCastConference::reference ref_multiUniCastConference ();
    multiUniCastConference::reference set_multiUniCastConference ();
    multiUniCastConference::reference set_multiUniCastConference (bool value);
    class mediaDistributionCapability {
      public:
        typedef ASN1::SEQUENCE_OF<MediaDistributionCapability>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaDistributionCapability
    mediaDistributionCapability::const_reference get_mediaDistributionCapability () const;
    mediaDistributionCapability::reference ref_mediaDistributionCapability ();
    mediaDistributionCapability::reference set_mediaDistributionCapability ();
    mediaDistributionCapability::reference set_mediaDistributionCapability (mediaDistributionCapability::const_reference value);
    void swap(MultipointCapability& other);
    MultipointCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RequestModeAck
//

class RequestModeAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestModeAck(const void* info) : Inherited(info) {}
  public:
    RequestModeAck() : Inherited(&theInfo) {}
    RequestModeAck(const RequestModeAck & other) : Inherited(other)
    {}
    RequestModeAck& operator = (const RequestModeAck& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class response {
      public:
        typedef RequestModeAck_response value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class response
    response::const_reference get_response () const;
    response::reference ref_response ();
    response::reference set_response ();
    response::reference set_response (response::const_reference value);
    void swap(RequestModeAck& other);
    RequestModeAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RequestModeReject
//

class RequestModeReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestModeReject(const void* info) : Inherited(info) {}
  public:
    RequestModeReject() : Inherited(&theInfo) {}
    RequestModeReject(const RequestModeReject & other) : Inherited(other)
    {}
    RequestModeReject& operator = (const RequestModeReject& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class cause {
      public:
        typedef RequestModeReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(RequestModeReject& other);
    RequestModeReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H261VideoMode
//

class H261VideoMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H261VideoMode(const void* info) : Inherited(info) {}
  public:
    H261VideoMode() : Inherited(&theInfo) {}
    H261VideoMode(const H261VideoMode & other) : Inherited(other)
    {}
    H261VideoMode& operator = (const H261VideoMode& other)
    { Inherited::operator = (other); return *this; } 
    class resolution {
      public:
        typedef H261VideoMode_resolution value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resolution
    resolution::const_reference get_resolution () const;
    resolution::reference ref_resolution ();
    resolution::reference set_resolution ();
    resolution::reference set_resolution (resolution::const_reference value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 19200>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    class stillImageTransmission {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class stillImageTransmission
    stillImageTransmission::const_reference get_stillImageTransmission () const;
    stillImageTransmission::reference ref_stillImageTransmission ();
    stillImageTransmission::reference set_stillImageTransmission ();
    stillImageTransmission::reference set_stillImageTransmission (bool value);
    void swap(H261VideoMode& other);
    H261VideoMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// H262VideoMode
//

class H262VideoMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H262VideoMode(const void* info) : Inherited(info) {}
  public:
    H262VideoMode() : Inherited(&theInfo) {}
    H262VideoMode(const H262VideoMode & other) : Inherited(other)
    {}
    H262VideoMode& operator = (const H262VideoMode& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_videoBitRate,
      e_vbvBufferSize,
      e_samplesPerLine,
      e_linesPerFrame,
      e_framesPerSecond,
      e_luminanceSampleRate
    };

    class profileAndLevel {
      public:
        typedef H262VideoMode_profileAndLevel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileAndLevel
    profileAndLevel::const_reference get_profileAndLevel () const;
    profileAndLevel::reference ref_profileAndLevel ();
    profileAndLevel::reference set_profileAndLevel ();
    profileAndLevel::reference set_profileAndLevel (profileAndLevel::const_reference value);
    class videoBitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 1073741823>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoBitRate
    videoBitRate::const_reference get_videoBitRate () const;
    videoBitRate::reference ref_videoBitRate ();
    videoBitRate::reference set_videoBitRate ();
    videoBitRate::reference set_videoBitRate (videoBitRate::value_type::int_type value);
    void omit_videoBitRate ();
    bool videoBitRate_isPresent () const;
    class vbvBufferSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 262143>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class vbvBufferSize
    vbvBufferSize::const_reference get_vbvBufferSize () const;
    vbvBufferSize::reference ref_vbvBufferSize ();
    vbvBufferSize::reference set_vbvBufferSize ();
    vbvBufferSize::reference set_vbvBufferSize (vbvBufferSize::value_type::int_type value);
    void omit_vbvBufferSize ();
    bool vbvBufferSize_isPresent () const;
    class samplesPerLine {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16383>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class samplesPerLine
    samplesPerLine::const_reference get_samplesPerLine () const;
    samplesPerLine::reference ref_samplesPerLine ();
    samplesPerLine::reference set_samplesPerLine ();
    samplesPerLine::reference set_samplesPerLine (samplesPerLine::value_type::int_type value);
    void omit_samplesPerLine ();
    bool samplesPerLine_isPresent () const;
    class linesPerFrame {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16383>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class linesPerFrame
    linesPerFrame::const_reference get_linesPerFrame () const;
    linesPerFrame::reference ref_linesPerFrame ();
    linesPerFrame::reference set_linesPerFrame ();
    linesPerFrame::reference set_linesPerFrame (linesPerFrame::value_type::int_type value);
    void omit_linesPerFrame ();
    bool linesPerFrame_isPresent () const;
    class framesPerSecond {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class framesPerSecond
    framesPerSecond::const_reference get_framesPerSecond () const;
    framesPerSecond::reference ref_framesPerSecond ();
    framesPerSecond::reference set_framesPerSecond ();
    framesPerSecond::reference set_framesPerSecond (framesPerSecond::value_type::int_type value);
    void omit_framesPerSecond ();
    bool framesPerSecond_isPresent () const;
    class luminanceSampleRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class luminanceSampleRate
    luminanceSampleRate::const_reference get_luminanceSampleRate () const;
    luminanceSampleRate::reference ref_luminanceSampleRate ();
    luminanceSampleRate::reference set_luminanceSampleRate ();
    luminanceSampleRate::reference set_luminanceSampleRate (luminanceSampleRate::value_type::int_type value);
    void omit_luminanceSampleRate ();
    bool luminanceSampleRate_isPresent () const;
    void swap(H262VideoMode& other);
    H262VideoMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// H263VideoMode
//

class H263VideoMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H263VideoMode(const void* info) : Inherited(info) {}
  public:
    H263VideoMode() : Inherited(&theInfo) {}
    H263VideoMode(const H263VideoMode & other) : Inherited(other)
    {}
    H263VideoMode& operator = (const H263VideoMode& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_errorCompensation,
      e_enhancementLayerInfo,
      e_h263Options
    };

    class resolution {
      public:
        typedef H263VideoMode_resolution value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resolution
    resolution::const_reference get_resolution () const;
    resolution::reference ref_resolution ();
    resolution::reference set_resolution ();
    resolution::reference set_resolution (resolution::const_reference value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 19200>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    class unrestrictedVector {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unrestrictedVector
    unrestrictedVector::const_reference get_unrestrictedVector () const;
    unrestrictedVector::reference ref_unrestrictedVector ();
    unrestrictedVector::reference set_unrestrictedVector ();
    unrestrictedVector::reference set_unrestrictedVector (bool value);
    class arithmeticCoding {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class arithmeticCoding
    arithmeticCoding::const_reference get_arithmeticCoding () const;
    arithmeticCoding::reference ref_arithmeticCoding ();
    arithmeticCoding::reference set_arithmeticCoding ();
    arithmeticCoding::reference set_arithmeticCoding (bool value);
    class advancedPrediction {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class advancedPrediction
    advancedPrediction::const_reference get_advancedPrediction () const;
    advancedPrediction::reference ref_advancedPrediction ();
    advancedPrediction::reference set_advancedPrediction ();
    advancedPrediction::reference set_advancedPrediction (bool value);
    class pbFrames {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pbFrames
    pbFrames::const_reference get_pbFrames () const;
    pbFrames::reference ref_pbFrames ();
    pbFrames::reference set_pbFrames ();
    pbFrames::reference set_pbFrames (bool value);
    class errorCompensation {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorCompensation
    errorCompensation::const_reference get_errorCompensation () const;
    errorCompensation::reference ref_errorCompensation ();
    errorCompensation::reference set_errorCompensation ();
    errorCompensation::reference set_errorCompensation (bool value);
    void omit_errorCompensation ();
    bool errorCompensation_isPresent () const;
    class enhancementLayerInfo {
      public:
        typedef EnhancementLayerInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enhancementLayerInfo
    enhancementLayerInfo::const_reference get_enhancementLayerInfo () const;
    enhancementLayerInfo::reference ref_enhancementLayerInfo ();
    enhancementLayerInfo::reference set_enhancementLayerInfo ();
    enhancementLayerInfo::reference set_enhancementLayerInfo (enhancementLayerInfo::const_reference value);
    void omit_enhancementLayerInfo ();
    bool enhancementLayerInfo_isPresent () const;
    class h263Options {
      public:
        typedef H263Options value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h263Options
    h263Options::const_reference get_h263Options () const;
    h263Options::reference ref_h263Options ();
    h263Options::reference set_h263Options ();
    h263Options::reference set_h263Options (h263Options::const_reference value);
    void omit_h263Options ();
    bool h263Options_isPresent () const;
    void swap(H263VideoMode& other);
    H263VideoMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[9];
    static int fieldIds[9];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[9];
#endif
};

//
// IS11172AudioMode
//

class IS11172AudioMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IS11172AudioMode(const void* info) : Inherited(info) {}
  public:
    IS11172AudioMode() : Inherited(&theInfo) {}
    IS11172AudioMode(const IS11172AudioMode & other) : Inherited(other)
    {}
    IS11172AudioMode& operator = (const IS11172AudioMode& other)
    { Inherited::operator = (other); return *this; } 
    class audioLayer {
      public:
        typedef IS11172AudioMode_audioLayer value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer
    audioLayer::const_reference get_audioLayer () const;
    audioLayer::reference ref_audioLayer ();
    audioLayer::reference set_audioLayer ();
    audioLayer::reference set_audioLayer (audioLayer::const_reference value);
    class audioSampling {
      public:
        typedef IS11172AudioMode_audioSampling value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling
    audioSampling::const_reference get_audioSampling () const;
    audioSampling::reference ref_audioSampling ();
    audioSampling::reference set_audioSampling ();
    audioSampling::reference set_audioSampling (audioSampling::const_reference value);
    class multichannelType {
      public:
        typedef IS11172AudioMode_multichannelType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multichannelType
    multichannelType::const_reference get_multichannelType () const;
    multichannelType::reference ref_multichannelType ();
    multichannelType::reference set_multichannelType ();
    multichannelType::reference set_multichannelType (multichannelType::const_reference value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 448>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    void swap(IS11172AudioMode& other);
    IS11172AudioMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// IS13818AudioMode
//

class IS13818AudioMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IS13818AudioMode(const void* info) : Inherited(info) {}
  public:
    IS13818AudioMode() : Inherited(&theInfo) {}
    IS13818AudioMode(const IS13818AudioMode & other) : Inherited(other)
    {}
    IS13818AudioMode& operator = (const IS13818AudioMode& other)
    { Inherited::operator = (other); return *this; } 
    class audioLayer {
      public:
        typedef IS13818AudioMode_audioLayer value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioLayer
    audioLayer::const_reference get_audioLayer () const;
    audioLayer::reference ref_audioLayer ();
    audioLayer::reference set_audioLayer ();
    audioLayer::reference set_audioLayer (audioLayer::const_reference value);
    class audioSampling {
      public:
        typedef IS13818AudioMode_audioSampling value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioSampling
    audioSampling::const_reference get_audioSampling () const;
    audioSampling::reference ref_audioSampling ();
    audioSampling::reference set_audioSampling ();
    audioSampling::reference set_audioSampling (audioSampling::const_reference value);
    class multichannelType {
      public:
        typedef IS13818AudioMode_multichannelType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multichannelType
    multichannelType::const_reference get_multichannelType () const;
    multichannelType::reference ref_multichannelType ();
    multichannelType::reference set_multichannelType ();
    multichannelType::reference set_multichannelType (multichannelType::const_reference value);
    class lowFrequencyEnhancement {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lowFrequencyEnhancement
    lowFrequencyEnhancement::const_reference get_lowFrequencyEnhancement () const;
    lowFrequencyEnhancement::reference ref_lowFrequencyEnhancement ();
    lowFrequencyEnhancement::reference set_lowFrequencyEnhancement ();
    lowFrequencyEnhancement::reference set_lowFrequencyEnhancement (bool value);
    class multilingual {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multilingual
    multilingual::const_reference get_multilingual () const;
    multilingual::reference ref_multilingual ();
    multilingual::reference set_multilingual ();
    multilingual::reference set_multilingual (bool value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 1130>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    void swap(IS13818AudioMode& other);
    IS13818AudioMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// G7231AnnexCMode
//

class G7231AnnexCMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    G7231AnnexCMode(const void* info) : Inherited(info) {}
  public:
    G7231AnnexCMode() : Inherited(&theInfo) {}
    G7231AnnexCMode(const G7231AnnexCMode & other) : Inherited(other)
    {}
    G7231AnnexCMode& operator = (const G7231AnnexCMode& other)
    { Inherited::operator = (other); return *this; } 
    class maxAl_sduAudioFrames {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 256>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxAl_sduAudioFrames
    maxAl_sduAudioFrames::const_reference get_maxAl_sduAudioFrames () const;
    maxAl_sduAudioFrames::reference ref_maxAl_sduAudioFrames ();
    maxAl_sduAudioFrames::reference set_maxAl_sduAudioFrames ();
    maxAl_sduAudioFrames::reference set_maxAl_sduAudioFrames (maxAl_sduAudioFrames::value_type::int_type value);
    class silenceSuppression {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class silenceSuppression
    silenceSuppression::const_reference get_silenceSuppression () const;
    silenceSuppression::reference ref_silenceSuppression ();
    silenceSuppression::reference set_silenceSuppression ();
    silenceSuppression::reference set_silenceSuppression (bool value);
    class g723AnnexCAudioMode {
      public:
        typedef G7231AnnexCMode_g723AnnexCAudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g723AnnexCAudioMode
    g723AnnexCAudioMode::const_reference get_g723AnnexCAudioMode () const;
    g723AnnexCAudioMode::reference ref_g723AnnexCAudioMode ();
    g723AnnexCAudioMode::reference set_g723AnnexCAudioMode ();
    g723AnnexCAudioMode::reference set_g723AnnexCAudioMode (g723AnnexCAudioMode::const_reference value);
    void swap(G7231AnnexCMode& other);
    G7231AnnexCMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RoundTripDelayRequest
//

class RoundTripDelayRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RoundTripDelayRequest(const void* info) : Inherited(info) {}
  public:
    RoundTripDelayRequest() : Inherited(&theInfo) {}
    RoundTripDelayRequest(const RoundTripDelayRequest & other) : Inherited(other)
    {}
    RoundTripDelayRequest& operator = (const RoundTripDelayRequest& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    void swap(RoundTripDelayRequest& other);
    RoundTripDelayRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// RoundTripDelayResponse
//

class RoundTripDelayResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RoundTripDelayResponse(const void* info) : Inherited(info) {}
  public:
    RoundTripDelayResponse() : Inherited(&theInfo) {}
    RoundTripDelayResponse(const RoundTripDelayResponse & other) : Inherited(other)
    {}
    RoundTripDelayResponse& operator = (const RoundTripDelayResponse& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    void swap(RoundTripDelayResponse& other);
    RoundTripDelayResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MaintenanceLoopRequest
//

class MaintenanceLoopRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MaintenanceLoopRequest(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopRequest() : Inherited(&theInfo) {}
    MaintenanceLoopRequest(const MaintenanceLoopRequest & other) : Inherited(other)
    {}
    MaintenanceLoopRequest& operator = (const MaintenanceLoopRequest& other)
    { Inherited::operator = (other); return *this; } 
    class type {
      public:
        typedef MaintenanceLoopRequest_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    void swap(MaintenanceLoopRequest& other);
    MaintenanceLoopRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MaintenanceLoopAck
//

class MaintenanceLoopAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MaintenanceLoopAck(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopAck() : Inherited(&theInfo) {}
    MaintenanceLoopAck(const MaintenanceLoopAck & other) : Inherited(other)
    {}
    MaintenanceLoopAck& operator = (const MaintenanceLoopAck& other)
    { Inherited::operator = (other); return *this; } 
    class type {
      public:
        typedef MaintenanceLoopAck_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    void swap(MaintenanceLoopAck& other);
    MaintenanceLoopAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// MaintenanceLoopReject
//

class MaintenanceLoopReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MaintenanceLoopReject(const void* info) : Inherited(info) {}
  public:
    MaintenanceLoopReject() : Inherited(&theInfo) {}
    MaintenanceLoopReject(const MaintenanceLoopReject & other) : Inherited(other)
    {}
    MaintenanceLoopReject& operator = (const MaintenanceLoopReject& other)
    { Inherited::operator = (other); return *this; } 
    class type {
      public:
        typedef MaintenanceLoopReject_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    class cause {
      public:
        typedef MaintenanceLoopReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(MaintenanceLoopReject& other);
    MaintenanceLoopReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CommunicationModeTableEntry
//

class CommunicationModeTableEntry : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CommunicationModeTableEntry(const void* info) : Inherited(info) {}
  public:
    CommunicationModeTableEntry() : Inherited(&theInfo) {}
    CommunicationModeTableEntry(const CommunicationModeTableEntry & other) : Inherited(other)
    {}
    CommunicationModeTableEntry& operator = (const CommunicationModeTableEntry& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_associatedSessionID,
      e_terminalLabel,
      e_mediaChannel,
      e_mediaGuaranteedDelivery,
      e_mediaControlChannel,
      e_mediaControlGuaranteedDelivery,
      e_redundancyEncoding,
      e_sessionDependency,
      e_destination
    };

    class nonStandard {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class sessionID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionID
    sessionID::const_reference get_sessionID () const;
    sessionID::reference ref_sessionID ();
    sessionID::reference set_sessionID ();
    sessionID::reference set_sessionID (sessionID::value_type::int_type value);
    class associatedSessionID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class associatedSessionID
    associatedSessionID::const_reference get_associatedSessionID () const;
    associatedSessionID::reference ref_associatedSessionID ();
    associatedSessionID::reference set_associatedSessionID ();
    associatedSessionID::reference set_associatedSessionID (associatedSessionID::value_type::int_type value);
    void omit_associatedSessionID ();
    bool associatedSessionID_isPresent () const;
    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    void omit_terminalLabel ();
    bool terminalLabel_isPresent () const;
    class sessionDescription {
      public:
        class value_type : public ASN1::BMPString
        {
            typedef ASN1::BMPString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (std::wstring& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const wchar_t* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionDescription
    sessionDescription::const_reference get_sessionDescription () const;
    sessionDescription::reference ref_sessionDescription ();
    sessionDescription::reference set_sessionDescription ();
    sessionDescription::reference set_sessionDescription (const std::wstring& value);
    class dataType {
      public:
        typedef CommunicationModeTableEntry_dataType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataType
    dataType::const_reference get_dataType () const;
    dataType::reference ref_dataType ();
    dataType::reference set_dataType ();
    dataType::reference set_dataType (dataType::const_reference value);
    class mediaChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaChannel
    mediaChannel::const_reference get_mediaChannel () const;
    mediaChannel::reference ref_mediaChannel ();
    mediaChannel::reference set_mediaChannel ();
    mediaChannel::reference set_mediaChannel (mediaChannel::const_reference value);
    void omit_mediaChannel ();
    bool mediaChannel_isPresent () const;
    class mediaGuaranteedDelivery {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaGuaranteedDelivery
    mediaGuaranteedDelivery::const_reference get_mediaGuaranteedDelivery () const;
    mediaGuaranteedDelivery::reference ref_mediaGuaranteedDelivery ();
    mediaGuaranteedDelivery::reference set_mediaGuaranteedDelivery ();
    mediaGuaranteedDelivery::reference set_mediaGuaranteedDelivery (bool value);
    void omit_mediaGuaranteedDelivery ();
    bool mediaGuaranteedDelivery_isPresent () const;
    class mediaControlChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaControlChannel
    mediaControlChannel::const_reference get_mediaControlChannel () const;
    mediaControlChannel::reference ref_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel (mediaControlChannel::const_reference value);
    void omit_mediaControlChannel ();
    bool mediaControlChannel_isPresent () const;
    class mediaControlGuaranteedDelivery {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaControlGuaranteedDelivery
    mediaControlGuaranteedDelivery::const_reference get_mediaControlGuaranteedDelivery () const;
    mediaControlGuaranteedDelivery::reference ref_mediaControlGuaranteedDelivery ();
    mediaControlGuaranteedDelivery::reference set_mediaControlGuaranteedDelivery ();
    mediaControlGuaranteedDelivery::reference set_mediaControlGuaranteedDelivery (bool value);
    void omit_mediaControlGuaranteedDelivery ();
    bool mediaControlGuaranteedDelivery_isPresent () const;
    class redundancyEncoding {
      public:
        typedef RedundancyEncoding value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncoding
    redundancyEncoding::const_reference get_redundancyEncoding () const;
    redundancyEncoding::reference ref_redundancyEncoding ();
    redundancyEncoding::reference set_redundancyEncoding ();
    redundancyEncoding::reference set_redundancyEncoding (redundancyEncoding::const_reference value);
    void omit_redundancyEncoding ();
    bool redundancyEncoding_isPresent () const;
    class sessionDependency {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionDependency
    sessionDependency::const_reference get_sessionDependency () const;
    sessionDependency::reference ref_sessionDependency ();
    sessionDependency::reference set_sessionDependency ();
    sessionDependency::reference set_sessionDependency (sessionDependency::value_type::int_type value);
    void omit_sessionDependency ();
    bool sessionDependency_isPresent () const;
    class destination {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destination
    destination::const_reference get_destination () const;
    destination::reference ref_destination ();
    destination::reference set_destination ();
    destination::reference set_destination (destination::const_reference value);
    void omit_destination ();
    bool destination_isPresent () const;
    void swap(CommunicationModeTableEntry& other);
    CommunicationModeTableEntry * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[13];
    static int fieldIds[13];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[13];
#endif
};

typedef ASN1::SEQUENCE_OF<Criteria,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 16> >  CertSelectionCriteria;

//
// RequestAllTerminalIDsResponse
//

class RequestAllTerminalIDsResponse : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestAllTerminalIDsResponse(const void* info) : Inherited(info) {}
  public:
    RequestAllTerminalIDsResponse() : Inherited(&theInfo) {}
    RequestAllTerminalIDsResponse(const RequestAllTerminalIDsResponse & other) : Inherited(other)
    {}
    RequestAllTerminalIDsResponse& operator = (const RequestAllTerminalIDsResponse& other)
    { Inherited::operator = (other); return *this; } 
    class terminalInformation {
      public:
        typedef ASN1::SEQUENCE_OF<TerminalInformation>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalInformation
    terminalInformation::const_reference get_terminalInformation () const;
    terminalInformation::reference ref_terminalInformation ();
    terminalInformation::reference set_terminalInformation ();
    terminalInformation::reference set_terminalInformation (terminalInformation::const_reference value);
    void swap(RequestAllTerminalIDsResponse& other);
    RequestAllTerminalIDsResponse * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// RemoteMCResponse
//

class RemoteMCResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RemoteMCResponse(const void* info) : Inherited(info) {}
  public:
    RemoteMCResponse() : Inherited(&theInfo) {}
    class accept {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class accept

    accept::reference select_accept (); 
    bool accept_isSelected() const;

    class reject {
      public:
        enum Id { id_ = 1 };
        typedef RemoteMCResponse_reject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reject

    reject::const_reference get_reject () const;
    reject::reference ref_reject (); 
    reject::reference select_reject (); 
    reject::reference select_reject (reject::const_reference value); 
    bool reject_isSelected() const;

    RemoteMCResponse(accept::Id id, accept::const_reference value);
    RemoteMCResponse(reject::Id id, reject::const_reference value);
    void swap(RemoteMCResponse & other);
    RemoteMCResponse(const RemoteMCResponse & other)
    : Inherited(other) {} 

    RemoteMCResponse & operator = (const RemoteMCResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RemoteMCResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MultilinkIndication
//

class MultilinkIndication : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkIndication(const void* info) : Inherited(info) {}
  public:
    MultilinkIndication() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class crcDesired {
      public:
        enum Id { id_ = 1 };
        typedef MultilinkIndication_crcDesired value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcDesired

    crcDesired::const_reference get_crcDesired () const;
    crcDesired::reference ref_crcDesired (); 
    crcDesired::reference select_crcDesired (); 
    crcDesired::reference select_crcDesired (crcDesired::const_reference value); 
    bool crcDesired_isSelected() const;

    class excessiveError {
      public:
        enum Id { id_ = 2 };
        typedef MultilinkIndication_excessiveError value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class excessiveError

    excessiveError::const_reference get_excessiveError () const;
    excessiveError::reference ref_excessiveError (); 
    excessiveError::reference select_excessiveError (); 
    excessiveError::reference select_excessiveError (excessiveError::const_reference value); 
    bool excessiveError_isSelected() const;

    MultilinkIndication(nonStandard::Id id, nonStandard::const_reference value);
    MultilinkIndication(crcDesired::Id id, crcDesired::const_reference value);
    MultilinkIndication(excessiveError::Id id, excessiveError::const_reference value);
    void swap(MultilinkIndication & other);
    MultilinkIndication(const MultilinkIndication & other)
    : Inherited(other) {} 

    MultilinkIndication & operator = (const MultilinkIndication & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkIndication * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// DialingInformationNumber
//

class DialingInformationNumber : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DialingInformationNumber(const void* info) : Inherited(info) {}
  public:
    DialingInformationNumber() : Inherited(&theInfo) {}
    DialingInformationNumber(const DialingInformationNumber & other) : Inherited(other)
    {}
    DialingInformationNumber& operator = (const DialingInformationNumber& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_subAddress
    };

    class networkAddress {
      public:
        class value_type : public ASN1::NumericString
        {
            typedef ASN1::NumericString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class networkAddress
    networkAddress::const_reference get_networkAddress () const;
    networkAddress::reference ref_networkAddress ();
    networkAddress::reference set_networkAddress ();
    networkAddress::reference set_networkAddress (const std::string& value);
    class subAddress {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class subAddress
    subAddress::const_reference get_subAddress () const;
    subAddress::reference ref_subAddress ();
    subAddress::reference set_subAddress ();
    subAddress::reference set_subAddress (const std::string& value);
    void omit_subAddress ();
    bool subAddress_isPresent () const;
    class networkType {
      public:
        typedef ASN1::SET_OF<DialingInformationNetworkType,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class networkType
    networkType::const_reference get_networkType () const;
    networkType::reference ref_networkType ();
    networkType::reference set_networkType ();
    networkType::reference set_networkType (networkType::const_reference value);
    void swap(DialingInformationNumber& other);
    DialingInformationNumber * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// LogicalChannelRateRequest
//

class LogicalChannelRateRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LogicalChannelRateRequest(const void* info) : Inherited(info) {}
  public:
    LogicalChannelRateRequest() : Inherited(&theInfo) {}
    LogicalChannelRateRequest(const LogicalChannelRateRequest & other) : Inherited(other)
    {}
    LogicalChannelRateRequest& operator = (const LogicalChannelRateRequest& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    class maximumBitRate {
      public:
        typedef MaximumBitRate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumBitRate
    maximumBitRate::const_reference get_maximumBitRate () const;
    maximumBitRate::reference ref_maximumBitRate ();
    maximumBitRate::reference set_maximumBitRate ();
    maximumBitRate::reference set_maximumBitRate (maximumBitRate::value_type::int_type value);
    void swap(LogicalChannelRateRequest& other);
    LogicalChannelRateRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// LogicalChannelRateAcknowledge
//

class LogicalChannelRateAcknowledge : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LogicalChannelRateAcknowledge(const void* info) : Inherited(info) {}
  public:
    LogicalChannelRateAcknowledge() : Inherited(&theInfo) {}
    LogicalChannelRateAcknowledge(const LogicalChannelRateAcknowledge & other) : Inherited(other)
    {}
    LogicalChannelRateAcknowledge& operator = (const LogicalChannelRateAcknowledge& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    class maximumBitRate {
      public:
        typedef MaximumBitRate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumBitRate
    maximumBitRate::const_reference get_maximumBitRate () const;
    maximumBitRate::reference ref_maximumBitRate ();
    maximumBitRate::reference set_maximumBitRate ();
    maximumBitRate::reference set_maximumBitRate (maximumBitRate::value_type::int_type value);
    void swap(LogicalChannelRateAcknowledge& other);
    LogicalChannelRateAcknowledge * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// LogicalChannelRateReject
//

class LogicalChannelRateReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LogicalChannelRateReject(const void* info) : Inherited(info) {}
  public:
    LogicalChannelRateReject() : Inherited(&theInfo) {}
    LogicalChannelRateReject(const LogicalChannelRateReject & other) : Inherited(other)
    {}
    LogicalChannelRateReject& operator = (const LogicalChannelRateReject& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_currentMaximumBitRate
    };

    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    class rejectReason {
      public:
        typedef LogicalChannelRateRejectReason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejectReason
    rejectReason::const_reference get_rejectReason () const;
    rejectReason::reference ref_rejectReason ();
    rejectReason::reference set_rejectReason ();
    rejectReason::reference set_rejectReason (rejectReason::const_reference value);
    class currentMaximumBitRate {
      public:
        typedef MaximumBitRate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class currentMaximumBitRate
    currentMaximumBitRate::const_reference get_currentMaximumBitRate () const;
    currentMaximumBitRate::reference ref_currentMaximumBitRate ();
    currentMaximumBitRate::reference set_currentMaximumBitRate ();
    currentMaximumBitRate::reference set_currentMaximumBitRate (currentMaximumBitRate::value_type::int_type value);
    void omit_currentMaximumBitRate ();
    bool currentMaximumBitRate_isPresent () const;
    void swap(LogicalChannelRateReject& other);
    LogicalChannelRateReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// SendTerminalCapabilitySet
//

class SendTerminalCapabilitySet : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    SendTerminalCapabilitySet(const void* info) : Inherited(info) {}
  public:
    SendTerminalCapabilitySet() : Inherited(&theInfo) {}
    class specificRequest {
      public:
        enum Id { id_ = 0 };
        typedef SendTerminalCapabilitySet_specificRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class specificRequest

    specificRequest::const_reference get_specificRequest () const;
    specificRequest::reference ref_specificRequest (); 
    specificRequest::reference select_specificRequest (); 
    specificRequest::reference select_specificRequest (specificRequest::const_reference value); 
    bool specificRequest_isSelected() const;

    class genericRequest {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericRequest

    genericRequest::reference select_genericRequest (); 
    bool genericRequest_isSelected() const;

    SendTerminalCapabilitySet(specificRequest::Id id, specificRequest::const_reference value);
    SendTerminalCapabilitySet(genericRequest::Id id, genericRequest::const_reference value);
    void swap(SendTerminalCapabilitySet & other);
    SendTerminalCapabilitySet(const SendTerminalCapabilitySet & other)
    : Inherited(other) {} 

    SendTerminalCapabilitySet & operator = (const SendTerminalCapabilitySet & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    SendTerminalCapabilitySet * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// EncryptionCommand
//

class EncryptionCommand : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EncryptionCommand(const void* info) : Inherited(info) {}
  public:
    EncryptionCommand() : Inherited(&theInfo) {}
    class encryptionSE {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionSE

    encryptionSE::const_reference get_encryptionSE () const;
    encryptionSE::reference ref_encryptionSE (); 
    encryptionSE::reference select_encryptionSE (); 
    encryptionSE::reference select_encryptionSE (const std::vector<char>& value); 
    bool encryptionSE_isSelected() const;

    class encryptionIVRequest {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionIVRequest

    encryptionIVRequest::reference select_encryptionIVRequest (); 
    bool encryptionIVRequest_isSelected() const;

    class encryptionAlgorithmID {
      public:
        enum Id { id_ = 2 };
        typedef EncryptionCommand_encryptionAlgorithmID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionAlgorithmID

    encryptionAlgorithmID::const_reference get_encryptionAlgorithmID () const;
    encryptionAlgorithmID::reference ref_encryptionAlgorithmID (); 
    encryptionAlgorithmID::reference select_encryptionAlgorithmID (); 
    encryptionAlgorithmID::reference select_encryptionAlgorithmID (encryptionAlgorithmID::const_reference value); 
    bool encryptionAlgorithmID_isSelected() const;

    EncryptionCommand(encryptionSE::Id id, const std::vector<char>& value);
    EncryptionCommand(encryptionIVRequest::Id id, encryptionIVRequest::const_reference value);
    EncryptionCommand(encryptionAlgorithmID::Id id, encryptionAlgorithmID::const_reference value);
    void swap(EncryptionCommand & other);
    EncryptionCommand(const EncryptionCommand & other)
    : Inherited(other) {} 

    EncryptionCommand & operator = (const EncryptionCommand & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EncryptionCommand * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// FlowControlCommand
//

class FlowControlCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    FlowControlCommand(const void* info) : Inherited(info) {}
  public:
    FlowControlCommand() : Inherited(&theInfo) {}
    FlowControlCommand(const FlowControlCommand & other) : Inherited(other)
    {}
    FlowControlCommand& operator = (const FlowControlCommand& other)
    { Inherited::operator = (other); return *this; } 
    class scope {
      public:
        typedef FlowControlCommand_scope value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class scope
    scope::const_reference get_scope () const;
    scope::reference ref_scope ();
    scope::reference set_scope ();
    scope::reference set_scope (scope::const_reference value);
    class restriction {
      public:
        typedef FlowControlCommand_restriction value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class restriction
    restriction::const_reference get_restriction () const;
    restriction::reference ref_restriction ();
    restriction::reference set_restriction ();
    restriction::reference set_restriction (restriction::const_reference value);
    void swap(FlowControlCommand& other);
    FlowControlCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// EndSessionCommand
//

class EndSessionCommand : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EndSessionCommand(const void* info) : Inherited(info) {}
  public:
    EndSessionCommand() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class disconnect {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class disconnect

    disconnect::reference select_disconnect (); 
    bool disconnect_isSelected() const;

    class gstnOptions {
      public:
        enum Id { id_ = 2 };
        typedef EndSessionCommand_gstnOptions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gstnOptions

    gstnOptions::const_reference get_gstnOptions () const;
    gstnOptions::reference ref_gstnOptions (); 
    gstnOptions::reference select_gstnOptions (); 
    gstnOptions::reference select_gstnOptions (gstnOptions::const_reference value); 
    bool gstnOptions_isSelected() const;

    class isdnOptions {
      public:
        enum Id { id_ = 3 };
        typedef EndSessionCommand_isdnOptions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class isdnOptions

    isdnOptions::const_reference get_isdnOptions () const;
    isdnOptions::reference ref_isdnOptions (); 
    isdnOptions::reference select_isdnOptions (); 
    isdnOptions::reference select_isdnOptions (isdnOptions::const_reference value); 
    bool isdnOptions_isSelected() const;

    EndSessionCommand(nonStandard::Id id, nonStandard::const_reference value);
    EndSessionCommand(disconnect::Id id, disconnect::const_reference value);
    EndSessionCommand(gstnOptions::Id id, gstnOptions::const_reference value);
    EndSessionCommand(isdnOptions::Id id, isdnOptions::const_reference value);
    void swap(EndSessionCommand & other);
    EndSessionCommand(const EndSessionCommand & other)
    : Inherited(other) {} 

    EndSessionCommand & operator = (const EndSessionCommand & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EndSessionCommand * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// ConferenceCommand
//

class ConferenceCommand : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceCommand(const void* info) : Inherited(info) {}
  public:
    ConferenceCommand() : Inherited(&theInfo) {}
    class broadcastMyLogicalChannel {
      public:
        enum Id { id_ = 0 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class broadcastMyLogicalChannel

    broadcastMyLogicalChannel::const_reference get_broadcastMyLogicalChannel () const;
    broadcastMyLogicalChannel::reference ref_broadcastMyLogicalChannel (); 
    broadcastMyLogicalChannel::reference select_broadcastMyLogicalChannel (); 
    broadcastMyLogicalChannel::reference select_broadcastMyLogicalChannel (broadcastMyLogicalChannel::value_type::int_type value); 
    bool broadcastMyLogicalChannel_isSelected() const;

    class cancelBroadcastMyLogicalChannel {
      public:
        enum Id { id_ = 1 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelBroadcastMyLogicalChannel

    cancelBroadcastMyLogicalChannel::const_reference get_cancelBroadcastMyLogicalChannel () const;
    cancelBroadcastMyLogicalChannel::reference ref_cancelBroadcastMyLogicalChannel (); 
    cancelBroadcastMyLogicalChannel::reference select_cancelBroadcastMyLogicalChannel (); 
    cancelBroadcastMyLogicalChannel::reference select_cancelBroadcastMyLogicalChannel (cancelBroadcastMyLogicalChannel::value_type::int_type value); 
    bool cancelBroadcastMyLogicalChannel_isSelected() const;

    class makeTerminalBroadcaster {
      public:
        enum Id { id_ = 2 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeTerminalBroadcaster

    makeTerminalBroadcaster::const_reference get_makeTerminalBroadcaster () const;
    makeTerminalBroadcaster::reference ref_makeTerminalBroadcaster (); 
    makeTerminalBroadcaster::reference select_makeTerminalBroadcaster (); 
    makeTerminalBroadcaster::reference select_makeTerminalBroadcaster (makeTerminalBroadcaster::const_reference value); 
    bool makeTerminalBroadcaster_isSelected() const;

    class cancelMakeTerminalBroadcaster {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMakeTerminalBroadcaster

    cancelMakeTerminalBroadcaster::reference select_cancelMakeTerminalBroadcaster (); 
    bool cancelMakeTerminalBroadcaster_isSelected() const;

    class sendThisSource {
      public:
        enum Id { id_ = 4 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendThisSource

    sendThisSource::const_reference get_sendThisSource () const;
    sendThisSource::reference ref_sendThisSource (); 
    sendThisSource::reference select_sendThisSource (); 
    sendThisSource::reference select_sendThisSource (sendThisSource::const_reference value); 
    bool sendThisSource_isSelected() const;

    class cancelSendThisSource {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelSendThisSource

    cancelSendThisSource::reference select_cancelSendThisSource (); 
    bool cancelSendThisSource_isSelected() const;

    class dropConference {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dropConference

    dropConference::reference select_dropConference (); 
    bool dropConference_isSelected() const;

    class substituteConferenceIDCommand {
      public:
        enum Id { id_ = 7 };
        typedef SubstituteConferenceIDCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class substituteConferenceIDCommand

    substituteConferenceIDCommand::const_reference get_substituteConferenceIDCommand () const;
    substituteConferenceIDCommand::reference ref_substituteConferenceIDCommand (); 
    substituteConferenceIDCommand::reference select_substituteConferenceIDCommand (); 
    substituteConferenceIDCommand::reference select_substituteConferenceIDCommand (substituteConferenceIDCommand::const_reference value); 
    bool substituteConferenceIDCommand_isSelected() const;

    ConferenceCommand(broadcastMyLogicalChannel::Id id, broadcastMyLogicalChannel::value_type::int_type value);
    ConferenceCommand(cancelBroadcastMyLogicalChannel::Id id, cancelBroadcastMyLogicalChannel::value_type::int_type value);
    ConferenceCommand(makeTerminalBroadcaster::Id id, makeTerminalBroadcaster::const_reference value);
    ConferenceCommand(cancelMakeTerminalBroadcaster::Id id, cancelMakeTerminalBroadcaster::const_reference value);
    ConferenceCommand(sendThisSource::Id id, sendThisSource::const_reference value);
    ConferenceCommand(cancelSendThisSource::Id id, cancelSendThisSource::const_reference value);
    ConferenceCommand(dropConference::Id id, dropConference::const_reference value);
    ConferenceCommand(substituteConferenceIDCommand::Id id, substituteConferenceIDCommand::const_reference value);
    void swap(ConferenceCommand & other);
    ConferenceCommand(const ConferenceCommand & other)
    : Inherited(other) {} 

    ConferenceCommand & operator = (const ConferenceCommand & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceCommand * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// H223MultiplexReconfiguration
//

class H223MultiplexReconfiguration : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223MultiplexReconfiguration(const void* info) : Inherited(info) {}
  public:
    H223MultiplexReconfiguration() : Inherited(&theInfo) {}
    class h223ModeChange {
      public:
        enum Id { id_ = 0 };
        typedef H223MultiplexReconfiguration_h223ModeChange value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223ModeChange

    h223ModeChange::const_reference get_h223ModeChange () const;
    h223ModeChange::reference ref_h223ModeChange (); 
    h223ModeChange::reference select_h223ModeChange (); 
    h223ModeChange::reference select_h223ModeChange (h223ModeChange::const_reference value); 
    bool h223ModeChange_isSelected() const;

    class h223AnnexADoubleFlag {
      public:
        enum Id { id_ = 1 };
        typedef H223MultiplexReconfiguration_h223AnnexADoubleFlag value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223AnnexADoubleFlag

    h223AnnexADoubleFlag::const_reference get_h223AnnexADoubleFlag () const;
    h223AnnexADoubleFlag::reference ref_h223AnnexADoubleFlag (); 
    h223AnnexADoubleFlag::reference select_h223AnnexADoubleFlag (); 
    h223AnnexADoubleFlag::reference select_h223AnnexADoubleFlag (h223AnnexADoubleFlag::const_reference value); 
    bool h223AnnexADoubleFlag_isSelected() const;

    H223MultiplexReconfiguration(h223ModeChange::Id id, h223ModeChange::const_reference value);
    H223MultiplexReconfiguration(h223AnnexADoubleFlag::Id id, h223AnnexADoubleFlag::const_reference value);
    void swap(H223MultiplexReconfiguration & other);
    H223MultiplexReconfiguration(const H223MultiplexReconfiguration & other)
    : Inherited(other) {} 

    H223MultiplexReconfiguration & operator = (const H223MultiplexReconfiguration & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223MultiplexReconfiguration * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MobileMultilinkReconfigurationCommand
//

class MobileMultilinkReconfigurationCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MobileMultilinkReconfigurationCommand(const void* info) : Inherited(info) {}
  public:
    MobileMultilinkReconfigurationCommand() : Inherited(&theInfo) {}
    MobileMultilinkReconfigurationCommand(const MobileMultilinkReconfigurationCommand & other) : Inherited(other)
    {}
    MobileMultilinkReconfigurationCommand& operator = (const MobileMultilinkReconfigurationCommand& other)
    { Inherited::operator = (other); return *this; } 
    class sampleSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sampleSize
    sampleSize::const_reference get_sampleSize () const;
    sampleSize::reference ref_sampleSize ();
    sampleSize::reference set_sampleSize ();
    sampleSize::reference set_sampleSize (sampleSize::value_type::int_type value);
    class samplesPerFrame {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class samplesPerFrame
    samplesPerFrame::const_reference get_samplesPerFrame () const;
    samplesPerFrame::reference ref_samplesPerFrame ();
    samplesPerFrame::reference set_samplesPerFrame ();
    samplesPerFrame::reference set_samplesPerFrame (samplesPerFrame::value_type::int_type value);
    class status {
      public:
        typedef MobileMultilinkReconfigurationCommand_status value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class status
    status::const_reference get_status () const;
    status::reference ref_status ();
    status::reference set_status ();
    status::reference set_status (status::const_reference value);
    void swap(MobileMultilinkReconfigurationCommand& other);
    MobileMultilinkReconfigurationCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// FunctionNotSupported
//

class FunctionNotSupported : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    FunctionNotSupported(const void* info) : Inherited(info) {}
  public:
    FunctionNotSupported() : Inherited(&theInfo) {}
    FunctionNotSupported(const FunctionNotSupported & other) : Inherited(other)
    {}
    FunctionNotSupported& operator = (const FunctionNotSupported& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_returnedFunction
    };

    class cause {
      public:
        typedef FunctionNotSupported_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    class returnedFunction {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class returnedFunction
    returnedFunction::const_reference get_returnedFunction () const;
    returnedFunction::reference ref_returnedFunction ();
    returnedFunction::reference set_returnedFunction ();
    returnedFunction::reference set_returnedFunction (const std::vector<char>& value);
    void omit_returnedFunction ();
    bool returnedFunction_isPresent () const;
    void swap(FunctionNotSupported& other);
    FunctionNotSupported * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ConferenceIndication
//

class ConferenceIndication : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceIndication(const void* info) : Inherited(info) {}
  public:
    ConferenceIndication() : Inherited(&theInfo) {}
    class sbeNumber {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 9>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sbeNumber

    sbeNumber::const_reference get_sbeNumber () const;
    sbeNumber::reference ref_sbeNumber (); 
    sbeNumber::reference select_sbeNumber (); 
    sbeNumber::reference select_sbeNumber (sbeNumber::value_type::int_type value); 
    bool sbeNumber_isSelected() const;

    class terminalNumberAssign {
      public:
        enum Id { id_ = 1 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalNumberAssign

    terminalNumberAssign::const_reference get_terminalNumberAssign () const;
    terminalNumberAssign::reference ref_terminalNumberAssign (); 
    terminalNumberAssign::reference select_terminalNumberAssign (); 
    terminalNumberAssign::reference select_terminalNumberAssign (terminalNumberAssign::const_reference value); 
    bool terminalNumberAssign_isSelected() const;

    class terminalJoinedConference {
      public:
        enum Id { id_ = 2 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalJoinedConference

    terminalJoinedConference::const_reference get_terminalJoinedConference () const;
    terminalJoinedConference::reference ref_terminalJoinedConference (); 
    terminalJoinedConference::reference select_terminalJoinedConference (); 
    terminalJoinedConference::reference select_terminalJoinedConference (terminalJoinedConference::const_reference value); 
    bool terminalJoinedConference_isSelected() const;

    class terminalLeftConference {
      public:
        enum Id { id_ = 3 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLeftConference

    terminalLeftConference::const_reference get_terminalLeftConference () const;
    terminalLeftConference::reference ref_terminalLeftConference (); 
    terminalLeftConference::reference select_terminalLeftConference (); 
    terminalLeftConference::reference select_terminalLeftConference (terminalLeftConference::const_reference value); 
    bool terminalLeftConference_isSelected() const;

    class seenByAtLeastOneOther {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class seenByAtLeastOneOther

    seenByAtLeastOneOther::reference select_seenByAtLeastOneOther (); 
    bool seenByAtLeastOneOther_isSelected() const;

    class cancelSeenByAtLeastOneOther {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelSeenByAtLeastOneOther

    cancelSeenByAtLeastOneOther::reference select_cancelSeenByAtLeastOneOther (); 
    bool cancelSeenByAtLeastOneOther_isSelected() const;

    class seenByAll {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class seenByAll

    seenByAll::reference select_seenByAll (); 
    bool seenByAll_isSelected() const;

    class cancelSeenByAll {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelSeenByAll

    cancelSeenByAll::reference select_cancelSeenByAll (); 
    bool cancelSeenByAll_isSelected() const;

    class terminalYouAreSeeing {
      public:
        enum Id { id_ = 8 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalYouAreSeeing

    terminalYouAreSeeing::const_reference get_terminalYouAreSeeing () const;
    terminalYouAreSeeing::reference ref_terminalYouAreSeeing (); 
    terminalYouAreSeeing::reference select_terminalYouAreSeeing (); 
    terminalYouAreSeeing::reference select_terminalYouAreSeeing (terminalYouAreSeeing::const_reference value); 
    bool terminalYouAreSeeing_isSelected() const;

    class requestForFloor {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestForFloor

    requestForFloor::reference select_requestForFloor (); 
    bool requestForFloor_isSelected() const;

    class withdrawChairToken {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class withdrawChairToken

    withdrawChairToken::reference select_withdrawChairToken (); 
    bool withdrawChairToken_isSelected() const;

    class floorRequested {
      public:
        enum Id { id_ = 11 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class floorRequested

    floorRequested::const_reference get_floorRequested () const;
    floorRequested::reference ref_floorRequested (); 
    floorRequested::reference select_floorRequested (); 
    floorRequested::reference select_floorRequested (floorRequested::const_reference value); 
    bool floorRequested_isSelected() const;

    class terminalYouAreSeeingInSubPictureNumber {
      public:
        enum Id { id_ = 12 };
        typedef TerminalYouAreSeeingInSubPictureNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalYouAreSeeingInSubPictureNumber

    terminalYouAreSeeingInSubPictureNumber::const_reference get_terminalYouAreSeeingInSubPictureNumber () const;
    terminalYouAreSeeingInSubPictureNumber::reference ref_terminalYouAreSeeingInSubPictureNumber (); 
    terminalYouAreSeeingInSubPictureNumber::reference select_terminalYouAreSeeingInSubPictureNumber (); 
    terminalYouAreSeeingInSubPictureNumber::reference select_terminalYouAreSeeingInSubPictureNumber (terminalYouAreSeeingInSubPictureNumber::const_reference value); 
    bool terminalYouAreSeeingInSubPictureNumber_isSelected() const;

    class videoIndicateCompose {
      public:
        enum Id { id_ = 13 };
        typedef VideoIndicateCompose value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoIndicateCompose

    videoIndicateCompose::const_reference get_videoIndicateCompose () const;
    videoIndicateCompose::reference ref_videoIndicateCompose (); 
    videoIndicateCompose::reference select_videoIndicateCompose (); 
    videoIndicateCompose::reference select_videoIndicateCompose (videoIndicateCompose::const_reference value); 
    bool videoIndicateCompose_isSelected() const;

    ConferenceIndication(sbeNumber::Id id, sbeNumber::value_type::int_type value);
    ConferenceIndication(terminalNumberAssign::Id id, terminalNumberAssign::const_reference value);
    ConferenceIndication(terminalJoinedConference::Id id, terminalJoinedConference::const_reference value);
    ConferenceIndication(terminalLeftConference::Id id, terminalLeftConference::const_reference value);
    ConferenceIndication(seenByAtLeastOneOther::Id id, seenByAtLeastOneOther::const_reference value);
    ConferenceIndication(cancelSeenByAtLeastOneOther::Id id, cancelSeenByAtLeastOneOther::const_reference value);
    ConferenceIndication(seenByAll::Id id, seenByAll::const_reference value);
    ConferenceIndication(cancelSeenByAll::Id id, cancelSeenByAll::const_reference value);
    ConferenceIndication(terminalYouAreSeeing::Id id, terminalYouAreSeeing::const_reference value);
    ConferenceIndication(requestForFloor::Id id, requestForFloor::const_reference value);
    ConferenceIndication(withdrawChairToken::Id id, withdrawChairToken::const_reference value);
    ConferenceIndication(floorRequested::Id id, floorRequested::const_reference value);
    ConferenceIndication(terminalYouAreSeeingInSubPictureNumber::Id id, terminalYouAreSeeingInSubPictureNumber::const_reference value);
    ConferenceIndication(videoIndicateCompose::Id id, videoIndicateCompose::const_reference value);
    void swap(ConferenceIndication & other);
    ConferenceIndication(const ConferenceIndication & other)
    : Inherited(other) {} 

    ConferenceIndication & operator = (const ConferenceIndication & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceIndication * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[14];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[14];
#endif
};

//
// JitterIndication
//

class JitterIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    JitterIndication(const void* info) : Inherited(info) {}
  public:
    JitterIndication() : Inherited(&theInfo) {}
    JitterIndication(const JitterIndication & other) : Inherited(other)
    {}
    JitterIndication& operator = (const JitterIndication& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_skippedFrameCount,
      e_additionalDecoderBuffer
    };

    class scope {
      public:
        typedef JitterIndication_scope value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class scope
    scope::const_reference get_scope () const;
    scope::reference ref_scope ();
    scope::reference set_scope ();
    scope::reference set_scope (scope::const_reference value);
    class estimatedReceivedJitterMantissa {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 3>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class estimatedReceivedJitterMantissa
    estimatedReceivedJitterMantissa::const_reference get_estimatedReceivedJitterMantissa () const;
    estimatedReceivedJitterMantissa::reference ref_estimatedReceivedJitterMantissa ();
    estimatedReceivedJitterMantissa::reference set_estimatedReceivedJitterMantissa ();
    estimatedReceivedJitterMantissa::reference set_estimatedReceivedJitterMantissa (estimatedReceivedJitterMantissa::value_type::int_type value);
    class estimatedReceivedJitterExponent {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 7>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class estimatedReceivedJitterExponent
    estimatedReceivedJitterExponent::const_reference get_estimatedReceivedJitterExponent () const;
    estimatedReceivedJitterExponent::reference ref_estimatedReceivedJitterExponent ();
    estimatedReceivedJitterExponent::reference set_estimatedReceivedJitterExponent ();
    estimatedReceivedJitterExponent::reference set_estimatedReceivedJitterExponent (estimatedReceivedJitterExponent::value_type::int_type value);
    class skippedFrameCount {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class skippedFrameCount
    skippedFrameCount::const_reference get_skippedFrameCount () const;
    skippedFrameCount::reference ref_skippedFrameCount ();
    skippedFrameCount::reference set_skippedFrameCount ();
    skippedFrameCount::reference set_skippedFrameCount (skippedFrameCount::value_type::int_type value);
    void omit_skippedFrameCount ();
    bool skippedFrameCount_isPresent () const;
    class additionalDecoderBuffer {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 262143>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class additionalDecoderBuffer
    additionalDecoderBuffer::const_reference get_additionalDecoderBuffer () const;
    additionalDecoderBuffer::reference ref_additionalDecoderBuffer ();
    additionalDecoderBuffer::reference set_additionalDecoderBuffer ();
    additionalDecoderBuffer::reference set_additionalDecoderBuffer (additionalDecoderBuffer::value_type::int_type value);
    void omit_additionalDecoderBuffer ();
    bool additionalDecoderBuffer_isPresent () const;
    void swap(JitterIndication& other);
    JitterIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// FlowControlIndication
//

class FlowControlIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    FlowControlIndication(const void* info) : Inherited(info) {}
  public:
    FlowControlIndication() : Inherited(&theInfo) {}
    FlowControlIndication(const FlowControlIndication & other) : Inherited(other)
    {}
    FlowControlIndication& operator = (const FlowControlIndication& other)
    { Inherited::operator = (other); return *this; } 
    class scope {
      public:
        typedef FlowControlIndication_scope value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class scope
    scope::const_reference get_scope () const;
    scope::reference ref_scope ();
    scope::reference set_scope ();
    scope::reference set_scope (scope::const_reference value);
    class restriction {
      public:
        typedef FlowControlIndication_restriction value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class restriction
    restriction::const_reference get_restriction () const;
    restriction::reference ref_restriction ();
    restriction::reference set_restriction ();
    restriction::reference set_restriction (restriction::const_reference value);
    void swap(FlowControlIndication& other);
    FlowControlIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TerminalCapabilitySetReject_cause
//

class TerminalCapabilitySetReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    TerminalCapabilitySetReject_cause(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySetReject_cause() : Inherited(&theInfo) {}
    class unspecified {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unspecified

    unspecified::reference select_unspecified (); 
    bool unspecified_isSelected() const;

    class undefinedTableEntryUsed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class undefinedTableEntryUsed

    undefinedTableEntryUsed::reference select_undefinedTableEntryUsed (); 
    bool undefinedTableEntryUsed_isSelected() const;

    class descriptorCapacityExceeded {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class descriptorCapacityExceeded

    descriptorCapacityExceeded::reference select_descriptorCapacityExceeded (); 
    bool descriptorCapacityExceeded_isSelected() const;

    class tableEntryCapacityExceeded {
      public:
        enum Id { id_ = 3 };
        typedef TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tableEntryCapacityExceeded

    tableEntryCapacityExceeded::const_reference get_tableEntryCapacityExceeded () const;
    tableEntryCapacityExceeded::reference ref_tableEntryCapacityExceeded (); 
    tableEntryCapacityExceeded::reference select_tableEntryCapacityExceeded (); 
    tableEntryCapacityExceeded::reference select_tableEntryCapacityExceeded (tableEntryCapacityExceeded::const_reference value); 
    bool tableEntryCapacityExceeded_isSelected() const;

    TerminalCapabilitySetReject_cause(unspecified::Id id, unspecified::const_reference value);
    TerminalCapabilitySetReject_cause(undefinedTableEntryUsed::Id id, undefinedTableEntryUsed::const_reference value);
    TerminalCapabilitySetReject_cause(descriptorCapacityExceeded::Id id, descriptorCapacityExceeded::const_reference value);
    TerminalCapabilitySetReject_cause(tableEntryCapacityExceeded::Id id, tableEntryCapacityExceeded::const_reference value);
    void swap(TerminalCapabilitySetReject_cause & other);
    TerminalCapabilitySetReject_cause(const TerminalCapabilitySetReject_cause & other)
    : Inherited(other) {} 

    TerminalCapabilitySetReject_cause & operator = (const TerminalCapabilitySetReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    TerminalCapabilitySetReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// H223ModeParameters_adaptationLayerType
//

class H223ModeParameters_adaptationLayerType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223ModeParameters_adaptationLayerType(const void* info) : Inherited(info) {}
  public:
    H223ModeParameters_adaptationLayerType() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class al1Framed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1Framed

    al1Framed::reference select_al1Framed (); 
    bool al1Framed_isSelected() const;

    class al1NotFramed {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1NotFramed

    al1NotFramed::reference select_al1NotFramed (); 
    bool al1NotFramed_isSelected() const;

    class al2WithoutSequenceNumbers {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2WithoutSequenceNumbers

    al2WithoutSequenceNumbers::reference select_al2WithoutSequenceNumbers (); 
    bool al2WithoutSequenceNumbers_isSelected() const;

    class al2WithSequenceNumbers {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2WithSequenceNumbers

    al2WithSequenceNumbers::reference select_al2WithSequenceNumbers (); 
    bool al2WithSequenceNumbers_isSelected() const;

    class al3 {
      public:
        enum Id { id_ = 5 };
        typedef H223ModeParameters_adaptationLayerType_al3 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al3

    al3::const_reference get_al3 () const;
    al3::reference ref_al3 (); 
    al3::reference select_al3 (); 
    al3::reference select_al3 (al3::const_reference value); 
    bool al3_isSelected() const;

    class al1M {
      public:
        enum Id { id_ = 6 };
        typedef H223AL1MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1M

    al1M::const_reference get_al1M () const;
    al1M::reference ref_al1M (); 
    al1M::reference select_al1M (); 
    al1M::reference select_al1M (al1M::const_reference value); 
    bool al1M_isSelected() const;

    class al2M {
      public:
        enum Id { id_ = 7 };
        typedef H223AL2MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2M

    al2M::const_reference get_al2M () const;
    al2M::reference ref_al2M (); 
    al2M::reference select_al2M (); 
    al2M::reference select_al2M (al2M::const_reference value); 
    bool al2M_isSelected() const;

    class al3M {
      public:
        enum Id { id_ = 8 };
        typedef H223AL3MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al3M

    al3M::const_reference get_al3M () const;
    al3M::reference ref_al3M (); 
    al3M::reference select_al3M (); 
    al3M::reference select_al3M (al3M::const_reference value); 
    bool al3M_isSelected() const;

    H223ModeParameters_adaptationLayerType(nonStandard::Id id, nonStandard::const_reference value);
    H223ModeParameters_adaptationLayerType(al1Framed::Id id, al1Framed::const_reference value);
    H223ModeParameters_adaptationLayerType(al1NotFramed::Id id, al1NotFramed::const_reference value);
    H223ModeParameters_adaptationLayerType(al2WithoutSequenceNumbers::Id id, al2WithoutSequenceNumbers::const_reference value);
    H223ModeParameters_adaptationLayerType(al2WithSequenceNumbers::Id id, al2WithSequenceNumbers::const_reference value);
    H223ModeParameters_adaptationLayerType(al3::Id id, al3::const_reference value);
    H223ModeParameters_adaptationLayerType(al1M::Id id, al1M::const_reference value);
    H223ModeParameters_adaptationLayerType(al2M::Id id, al2M::const_reference value);
    H223ModeParameters_adaptationLayerType(al3M::Id id, al3M::const_reference value);
    void swap(H223ModeParameters_adaptationLayerType & other);
    H223ModeParameters_adaptationLayerType(const H223ModeParameters_adaptationLayerType & other)
    : Inherited(other) {} 

    H223ModeParameters_adaptationLayerType & operator = (const H223ModeParameters_adaptationLayerType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223ModeParameters_adaptationLayerType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[9];
#endif
};

//
// DataMode_application
//

class DataMode_application : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DataMode_application(const void* info) : Inherited(info) {}
  public:
    DataMode_application() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class t120 {
      public:
        enum Id { id_ = 1 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t120

    t120::const_reference get_t120 () const;
    t120::reference ref_t120 (); 
    t120::reference select_t120 (); 
    t120::reference select_t120 (t120::const_reference value); 
    bool t120_isSelected() const;

    class dsm_cc {
      public:
        enum Id { id_ = 2 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dsm_cc

    dsm_cc::const_reference get_dsm_cc () const;
    dsm_cc::reference ref_dsm_cc (); 
    dsm_cc::reference select_dsm_cc (); 
    dsm_cc::reference select_dsm_cc (dsm_cc::const_reference value); 
    bool dsm_cc_isSelected() const;

    class userData {
      public:
        enum Id { id_ = 3 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class userData

    userData::const_reference get_userData () const;
    userData::reference ref_userData (); 
    userData::reference select_userData (); 
    userData::reference select_userData (userData::const_reference value); 
    bool userData_isSelected() const;

    class t84 {
      public:
        enum Id { id_ = 4 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t84

    t84::const_reference get_t84 () const;
    t84::reference ref_t84 (); 
    t84::reference select_t84 (); 
    t84::reference select_t84 (t84::const_reference value); 
    bool t84_isSelected() const;

    class t434 {
      public:
        enum Id { id_ = 5 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t434

    t434::const_reference get_t434 () const;
    t434::reference ref_t434 (); 
    t434::reference select_t434 (); 
    t434::reference select_t434 (t434::const_reference value); 
    bool t434_isSelected() const;

    class h224 {
      public:
        enum Id { id_ = 6 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h224

    h224::const_reference get_h224 () const;
    h224::reference ref_h224 (); 
    h224::reference select_h224 (); 
    h224::reference select_h224 (h224::const_reference value); 
    bool h224_isSelected() const;

    class nlpid {
      public:
        enum Id { id_ = 7 };
        typedef DataMode_application_nlpid value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nlpid

    nlpid::const_reference get_nlpid () const;
    nlpid::reference ref_nlpid (); 
    nlpid::reference select_nlpid (); 
    nlpid::reference select_nlpid (nlpid::const_reference value); 
    bool nlpid_isSelected() const;

    class dsvdControl {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dsvdControl

    dsvdControl::reference select_dsvdControl (); 
    bool dsvdControl_isSelected() const;

    class h222DataPartitioning {
      public:
        enum Id { id_ = 9 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h222DataPartitioning

    h222DataPartitioning::const_reference get_h222DataPartitioning () const;
    h222DataPartitioning::reference ref_h222DataPartitioning (); 
    h222DataPartitioning::reference select_h222DataPartitioning (); 
    h222DataPartitioning::reference select_h222DataPartitioning (h222DataPartitioning::const_reference value); 
    bool h222DataPartitioning_isSelected() const;

    class t30fax {
      public:
        enum Id { id_ = 10 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t30fax

    t30fax::const_reference get_t30fax () const;
    t30fax::reference ref_t30fax (); 
    t30fax::reference select_t30fax (); 
    t30fax::reference select_t30fax (t30fax::const_reference value); 
    bool t30fax_isSelected() const;

    class t140 {
      public:
        enum Id { id_ = 11 };
        typedef DataProtocolCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t140

    t140::const_reference get_t140 () const;
    t140::reference ref_t140 (); 
    t140::reference select_t140 (); 
    t140::reference select_t140 (t140::const_reference value); 
    bool t140_isSelected() const;

    class t38fax {
      public:
        enum Id { id_ = 12 };
        typedef DataMode_application_t38fax value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t38fax

    t38fax::const_reference get_t38fax () const;
    t38fax::reference ref_t38fax (); 
    t38fax::reference select_t38fax (); 
    t38fax::reference select_t38fax (t38fax::const_reference value); 
    bool t38fax_isSelected() const;

    class genericDataMode {
      public:
        enum Id { id_ = 13 };
        typedef GenericCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericDataMode

    genericDataMode::const_reference get_genericDataMode () const;
    genericDataMode::reference ref_genericDataMode (); 
    genericDataMode::reference select_genericDataMode (); 
    genericDataMode::reference select_genericDataMode (genericDataMode::const_reference value); 
    bool genericDataMode_isSelected() const;

    DataMode_application(nonStandard::Id id, nonStandard::const_reference value);
    DataMode_application(t120::Id id, t120::const_reference value);
    DataMode_application(dsm_cc::Id id, dsm_cc::const_reference value);
    DataMode_application(userData::Id id, userData::const_reference value);
    DataMode_application(t84::Id id, t84::const_reference value);
    DataMode_application(t434::Id id, t434::const_reference value);
    DataMode_application(h224::Id id, h224::const_reference value);
    DataMode_application(nlpid::Id id, nlpid::const_reference value);
    DataMode_application(dsvdControl::Id id, dsvdControl::const_reference value);
    DataMode_application(h222DataPartitioning::Id id, h222DataPartitioning::const_reference value);
    DataMode_application(t30fax::Id id, t30fax::const_reference value);
    DataMode_application(t140::Id id, t140::const_reference value);
    DataMode_application(t38fax::Id id, t38fax::const_reference value);
    DataMode_application(genericDataMode::Id id, genericDataMode::const_reference value);
    void swap(DataMode_application & other);
    DataMode_application(const DataMode_application & other)
    : Inherited(other) {} 

    DataMode_application & operator = (const DataMode_application & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DataMode_application * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[14];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[14];
#endif
};

//
// ConferenceRequest_requestTerminalCertificate
//

class ConferenceRequest_requestTerminalCertificate : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ConferenceRequest_requestTerminalCertificate(const void* info) : Inherited(info) {}
  public:
    ConferenceRequest_requestTerminalCertificate() : Inherited(&theInfo) {}
    ConferenceRequest_requestTerminalCertificate(const ConferenceRequest_requestTerminalCertificate & other) : Inherited(other)
    {}
    ConferenceRequest_requestTerminalCertificate& operator = (const ConferenceRequest_requestTerminalCertificate& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_terminalLabel,
      e_certSelectionCriteria,
      e_sRandom
    };

    class terminalLabel {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalLabel
    terminalLabel::const_reference get_terminalLabel () const;
    terminalLabel::reference ref_terminalLabel ();
    terminalLabel::reference set_terminalLabel ();
    terminalLabel::reference set_terminalLabel (terminalLabel::const_reference value);
    void omit_terminalLabel ();
    bool terminalLabel_isPresent () const;
    class certSelectionCriteria {
      public:
        typedef CertSelectionCriteria value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certSelectionCriteria
    certSelectionCriteria::const_reference get_certSelectionCriteria () const;
    certSelectionCriteria::reference ref_certSelectionCriteria ();
    certSelectionCriteria::reference set_certSelectionCriteria ();
    certSelectionCriteria::reference set_certSelectionCriteria (certSelectionCriteria::const_reference value);
    void omit_certSelectionCriteria ();
    bool certSelectionCriteria_isPresent () const;
    class sRandom {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sRandom
    sRandom::const_reference get_sRandom () const;
    sRandom::reference ref_sRandom ();
    sRandom::reference set_sRandom ();
    sRandom::reference set_sRandom (sRandom::value_type::int_type value);
    void omit_sRandom ();
    bool sRandom_isPresent () const;
    void swap(ConferenceRequest_requestTerminalCertificate& other);
    ConferenceRequest_requestTerminalCertificate * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MultilinkRequest_maximumHeaderInterval
//

class MultilinkRequest_maximumHeaderInterval : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkRequest_maximumHeaderInterval(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest_maximumHeaderInterval() : Inherited(&theInfo) {}
    MultilinkRequest_maximumHeaderInterval(const MultilinkRequest_maximumHeaderInterval & other) : Inherited(other)
    {}
    MultilinkRequest_maximumHeaderInterval& operator = (const MultilinkRequest_maximumHeaderInterval& other)
    { Inherited::operator = (other); return *this; } 
    class requestType {
      public:
        typedef MultilinkRequest_maximumHeaderInterval_requestType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestType
    requestType::const_reference get_requestType () const;
    requestType::reference ref_requestType ();
    requestType::reference set_requestType ();
    requestType::reference set_requestType (requestType::const_reference value);
    void swap(MultilinkRequest_maximumHeaderInterval& other);
    MultilinkRequest_maximumHeaderInterval * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// NewATMVCCommand_reverseParameters
//

class NewATMVCCommand_reverseParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NewATMVCCommand_reverseParameters(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_reverseParameters() : Inherited(&theInfo) {}
    NewATMVCCommand_reverseParameters(const NewATMVCCommand_reverseParameters & other) : Inherited(other)
    {}
    NewATMVCCommand_reverseParameters& operator = (const NewATMVCCommand_reverseParameters& other)
    { Inherited::operator = (other); return *this; } 
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    class bitRateLockedToPCRClock {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRateLockedToPCRClock
    bitRateLockedToPCRClock::const_reference get_bitRateLockedToPCRClock () const;
    bitRateLockedToPCRClock::reference ref_bitRateLockedToPCRClock ();
    bitRateLockedToPCRClock::reference set_bitRateLockedToPCRClock ();
    bitRateLockedToPCRClock::reference set_bitRateLockedToPCRClock (bool value);
    class bitRateLockedToNetworkClock {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRateLockedToNetworkClock
    bitRateLockedToNetworkClock::const_reference get_bitRateLockedToNetworkClock () const;
    bitRateLockedToNetworkClock::reference ref_bitRateLockedToNetworkClock ();
    bitRateLockedToNetworkClock::reference set_bitRateLockedToNetworkClock ();
    bitRateLockedToNetworkClock::reference set_bitRateLockedToNetworkClock (bool value);
    class multiplex {
      public:
        typedef NewATMVCCommand_reverseParameters_multiplex value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplex
    multiplex::const_reference get_multiplex () const;
    multiplex::reference ref_multiplex ();
    multiplex::reference set_multiplex ();
    multiplex::reference set_multiplex (multiplex::const_reference value);
    void swap(NewATMVCCommand_reverseParameters& other);
    NewATMVCCommand_reverseParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// MiscellaneousIndication_type
//

class MiscellaneousIndication_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MiscellaneousIndication_type(const void* info) : Inherited(info) {}
  public:
    MiscellaneousIndication_type() : Inherited(&theInfo) {}
    class logicalChannelActive {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelActive

    logicalChannelActive::reference select_logicalChannelActive (); 
    bool logicalChannelActive_isSelected() const;

    class logicalChannelInactive {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelInactive

    logicalChannelInactive::reference select_logicalChannelInactive (); 
    bool logicalChannelInactive_isSelected() const;

    class multipointConference {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipointConference

    multipointConference::reference select_multipointConference (); 
    bool multipointConference_isSelected() const;

    class cancelMultipointConference {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMultipointConference

    cancelMultipointConference::reference select_cancelMultipointConference (); 
    bool cancelMultipointConference_isSelected() const;

    class multipointZeroComm {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipointZeroComm

    multipointZeroComm::reference select_multipointZeroComm (); 
    bool multipointZeroComm_isSelected() const;

    class cancelMultipointZeroComm {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMultipointZeroComm

    cancelMultipointZeroComm::reference select_cancelMultipointZeroComm (); 
    bool cancelMultipointZeroComm_isSelected() const;

    class multipointSecondaryStatus {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipointSecondaryStatus

    multipointSecondaryStatus::reference select_multipointSecondaryStatus (); 
    bool multipointSecondaryStatus_isSelected() const;

    class cancelMultipointSecondaryStatus {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMultipointSecondaryStatus

    cancelMultipointSecondaryStatus::reference select_cancelMultipointSecondaryStatus (); 
    bool cancelMultipointSecondaryStatus_isSelected() const;

    class videoIndicateReadyToActivate {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoIndicateReadyToActivate

    videoIndicateReadyToActivate::reference select_videoIndicateReadyToActivate (); 
    bool videoIndicateReadyToActivate_isSelected() const;

    class videoTemporalSpatialTradeOff {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 31>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoTemporalSpatialTradeOff

    videoTemporalSpatialTradeOff::const_reference get_videoTemporalSpatialTradeOff () const;
    videoTemporalSpatialTradeOff::reference ref_videoTemporalSpatialTradeOff (); 
    videoTemporalSpatialTradeOff::reference select_videoTemporalSpatialTradeOff (); 
    videoTemporalSpatialTradeOff::reference select_videoTemporalSpatialTradeOff (videoTemporalSpatialTradeOff::value_type::int_type value); 
    bool videoTemporalSpatialTradeOff_isSelected() const;

    class videoNotDecodedMBs {
      public:
        enum Id { id_ = 10 };
        typedef MiscellaneousIndication_type_videoNotDecodedMBs value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoNotDecodedMBs

    videoNotDecodedMBs::const_reference get_videoNotDecodedMBs () const;
    videoNotDecodedMBs::reference ref_videoNotDecodedMBs (); 
    videoNotDecodedMBs::reference select_videoNotDecodedMBs (); 
    videoNotDecodedMBs::reference select_videoNotDecodedMBs (videoNotDecodedMBs::const_reference value); 
    bool videoNotDecodedMBs_isSelected() const;

    class transportCapability {
      public:
        enum Id { id_ = 11 };
        typedef TransportCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportCapability

    transportCapability::const_reference get_transportCapability () const;
    transportCapability::reference ref_transportCapability (); 
    transportCapability::reference select_transportCapability (); 
    transportCapability::reference select_transportCapability (transportCapability::const_reference value); 
    bool transportCapability_isSelected() const;

    MiscellaneousIndication_type(logicalChannelActive::Id id, logicalChannelActive::const_reference value);
    MiscellaneousIndication_type(logicalChannelInactive::Id id, logicalChannelInactive::const_reference value);
    MiscellaneousIndication_type(multipointConference::Id id, multipointConference::const_reference value);
    MiscellaneousIndication_type(cancelMultipointConference::Id id, cancelMultipointConference::const_reference value);
    MiscellaneousIndication_type(multipointZeroComm::Id id, multipointZeroComm::const_reference value);
    MiscellaneousIndication_type(cancelMultipointZeroComm::Id id, cancelMultipointZeroComm::const_reference value);
    MiscellaneousIndication_type(multipointSecondaryStatus::Id id, multipointSecondaryStatus::const_reference value);
    MiscellaneousIndication_type(cancelMultipointSecondaryStatus::Id id, cancelMultipointSecondaryStatus::const_reference value);
    MiscellaneousIndication_type(videoIndicateReadyToActivate::Id id, videoIndicateReadyToActivate::const_reference value);
    MiscellaneousIndication_type(videoTemporalSpatialTradeOff::Id id, videoTemporalSpatialTradeOff::value_type::int_type value);
    MiscellaneousIndication_type(videoNotDecodedMBs::Id id, videoNotDecodedMBs::const_reference value);
    MiscellaneousIndication_type(transportCapability::Id id, transportCapability::const_reference value);
    void swap(MiscellaneousIndication_type & other);
    MiscellaneousIndication_type(const MiscellaneousIndication_type & other)
    : Inherited(other) {} 

    MiscellaneousIndication_type & operator = (const MiscellaneousIndication_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MiscellaneousIndication_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[12];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[12];
#endif
};

//
// UserInputIndication_signal
//

class UserInputIndication_signal : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UserInputIndication_signal(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_signal() : Inherited(&theInfo) {}
    UserInputIndication_signal(const UserInputIndication_signal & other) : Inherited(other)
    {}
    UserInputIndication_signal& operator = (const UserInputIndication_signal& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_duration,
      e_rtp,
      e_rtpPayloadIndication
    };

    class signalType {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalType
    signalType::const_reference get_signalType () const;
    signalType::reference ref_signalType ();
    signalType::reference set_signalType ();
    signalType::reference set_signalType (const std::string& value);
    class duration {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class duration
    duration::const_reference get_duration () const;
    duration::reference ref_duration ();
    duration::reference set_duration ();
    duration::reference set_duration (duration::value_type::int_type value);
    void omit_duration ();
    bool duration_isPresent () const;
    class rtp {
      public:
        typedef UserInputIndication_signal_rtp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtp
    rtp::const_reference get_rtp () const;
    rtp::reference ref_rtp ();
    rtp::reference set_rtp ();
    rtp::reference set_rtp (rtp::const_reference value);
    void omit_rtp ();
    bool rtp_isPresent () const;
    class rtpPayloadIndication {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpPayloadIndication
    rtpPayloadIndication::reference set_rtpPayloadIndication ();
    void omit_rtpPayloadIndication ();
    bool rtpPayloadIndication_isPresent () const;
    void swap(UserInputIndication_signal& other);
    UserInputIndication_signal * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// UserInputIndication_signalUpdate
//

class UserInputIndication_signalUpdate : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    UserInputIndication_signalUpdate(const void* info) : Inherited(info) {}
  public:
    UserInputIndication_signalUpdate() : Inherited(&theInfo) {}
    UserInputIndication_signalUpdate(const UserInputIndication_signalUpdate & other) : Inherited(other)
    {}
    UserInputIndication_signalUpdate& operator = (const UserInputIndication_signalUpdate& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_rtp
    };

    class duration {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class duration
    duration::const_reference get_duration () const;
    duration::reference ref_duration ();
    duration::reference set_duration ();
    duration::reference set_duration (duration::value_type::int_type value);
    class rtp {
      public:
        typedef UserInputIndication_signalUpdate_rtp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtp
    rtp::const_reference get_rtp () const;
    rtp::reference ref_rtp ();
    rtp::reference set_rtp ();
    rtp::reference set_rtp (rtp::const_reference value);
    void omit_rtp ();
    bool rtp_isPresent () const;
    void swap(UserInputIndication_signalUpdate& other);
    UserInputIndication_signalUpdate * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MultilinkResponse_addConnection_responseCode
//

class MultilinkResponse_addConnection_responseCode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkResponse_addConnection_responseCode(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_addConnection_responseCode() : Inherited(&theInfo) {}
    class accepted {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class accepted

    accepted::reference select_accepted (); 
    bool accepted_isSelected() const;

    class rejected {
      public:
        enum Id { id_ = 1 };
        typedef MultilinkResponse_addConnection_responseCode_rejected value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rejected

    rejected::const_reference get_rejected () const;
    rejected::reference ref_rejected (); 
    rejected::reference select_rejected (); 
    rejected::reference select_rejected (rejected::const_reference value); 
    bool rejected_isSelected() const;

    MultilinkResponse_addConnection_responseCode(accepted::Id id, accepted::const_reference value);
    MultilinkResponse_addConnection_responseCode(rejected::Id id, rejected::const_reference value);
    void swap(MultilinkResponse_addConnection_responseCode & other);
    MultilinkResponse_addConnection_responseCode(const MultilinkResponse_addConnection_responseCode & other)
    : Inherited(other) {} 

    MultilinkResponse_addConnection_responseCode & operator = (const MultilinkResponse_addConnection_responseCode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkResponse_addConnection_responseCode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MiscellaneousCommand_type_progressiveRefinementStart
//

class MiscellaneousCommand_type_progressiveRefinementStart : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand_type_progressiveRefinementStart(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type_progressiveRefinementStart() : Inherited(&theInfo) {}
    MiscellaneousCommand_type_progressiveRefinementStart(const MiscellaneousCommand_type_progressiveRefinementStart & other) : Inherited(other)
    {}
    MiscellaneousCommand_type_progressiveRefinementStart& operator = (const MiscellaneousCommand_type_progressiveRefinementStart& other)
    { Inherited::operator = (other); return *this; } 
    class repeatCount {
      public:
        typedef MiscellaneousCommand_type_progressiveRefinementStart_repeatCount value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class repeatCount
    repeatCount::const_reference get_repeatCount () const;
    repeatCount::reference ref_repeatCount ();
    repeatCount::reference set_repeatCount ();
    repeatCount::reference set_repeatCount (repeatCount::const_reference value);
    void swap(MiscellaneousCommand_type_progressiveRefinementStart& other);
    MiscellaneousCommand_type_progressiveRefinementStart * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// NewATMVCCommand_aal_aal1
//

class NewATMVCCommand_aal_aal1 : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NewATMVCCommand_aal_aal1(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_aal_aal1() : Inherited(&theInfo) {}
    NewATMVCCommand_aal_aal1(const NewATMVCCommand_aal_aal1 & other) : Inherited(other)
    {}
    NewATMVCCommand_aal_aal1& operator = (const NewATMVCCommand_aal_aal1& other)
    { Inherited::operator = (other); return *this; } 
    class clockRecovery {
      public:
        typedef NewATMVCCommand_aal_aal1_clockRecovery value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class clockRecovery
    clockRecovery::const_reference get_clockRecovery () const;
    clockRecovery::reference ref_clockRecovery ();
    clockRecovery::reference set_clockRecovery ();
    clockRecovery::reference set_clockRecovery (clockRecovery::const_reference value);
    class errorCorrection {
      public:
        typedef NewATMVCCommand_aal_aal1_errorCorrection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorCorrection
    errorCorrection::const_reference get_errorCorrection () const;
    errorCorrection::reference ref_errorCorrection ();
    errorCorrection::reference set_errorCorrection ();
    errorCorrection::reference set_errorCorrection (errorCorrection::const_reference value);
    class structuredDataTransfer {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class structuredDataTransfer
    structuredDataTransfer::const_reference get_structuredDataTransfer () const;
    structuredDataTransfer::reference ref_structuredDataTransfer ();
    structuredDataTransfer::reference set_structuredDataTransfer ();
    structuredDataTransfer::reference set_structuredDataTransfer (bool value);
    class partiallyFilledCells {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class partiallyFilledCells
    partiallyFilledCells::const_reference get_partiallyFilledCells () const;
    partiallyFilledCells::reference ref_partiallyFilledCells ();
    partiallyFilledCells::reference set_partiallyFilledCells ();
    partiallyFilledCells::reference set_partiallyFilledCells (bool value);
    void swap(NewATMVCCommand_aal_aal1& other);
    NewATMVCCommand_aal_aal1 * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// TerminalCapabilitySetReject
//

class TerminalCapabilitySetReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalCapabilitySetReject(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySetReject() : Inherited(&theInfo) {}
    TerminalCapabilitySetReject(const TerminalCapabilitySetReject & other) : Inherited(other)
    {}
    TerminalCapabilitySetReject& operator = (const TerminalCapabilitySetReject& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class cause {
      public:
        typedef TerminalCapabilitySetReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(TerminalCapabilitySetReject& other);
    TerminalCapabilitySetReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H2250Capability
//

class H2250Capability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250Capability(const void* info) : Inherited(info) {}
  public:
    H2250Capability() : Inherited(&theInfo) {}
    H2250Capability(const H2250Capability & other) : Inherited(other)
    {}
    H2250Capability& operator = (const H2250Capability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_transportCapability,
      e_redundancyEncodingCapability,
      e_logicalChannelSwitchingCapability,
      e_t120DynamicPortCapability
    };

    class maximumAudioDelayJitter {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 1023>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumAudioDelayJitter
    maximumAudioDelayJitter::const_reference get_maximumAudioDelayJitter () const;
    maximumAudioDelayJitter::reference ref_maximumAudioDelayJitter ();
    maximumAudioDelayJitter::reference set_maximumAudioDelayJitter ();
    maximumAudioDelayJitter::reference set_maximumAudioDelayJitter (maximumAudioDelayJitter::value_type::int_type value);
    class receiveMultipointCapability {
      public:
        typedef MultipointCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class receiveMultipointCapability
    receiveMultipointCapability::const_reference get_receiveMultipointCapability () const;
    receiveMultipointCapability::reference ref_receiveMultipointCapability ();
    receiveMultipointCapability::reference set_receiveMultipointCapability ();
    receiveMultipointCapability::reference set_receiveMultipointCapability (receiveMultipointCapability::const_reference value);
    class transmitMultipointCapability {
      public:
        typedef MultipointCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transmitMultipointCapability
    transmitMultipointCapability::const_reference get_transmitMultipointCapability () const;
    transmitMultipointCapability::reference ref_transmitMultipointCapability ();
    transmitMultipointCapability::reference set_transmitMultipointCapability ();
    transmitMultipointCapability::reference set_transmitMultipointCapability (transmitMultipointCapability::const_reference value);
    class receiveAndTransmitMultipointCapability {
      public:
        typedef MultipointCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class receiveAndTransmitMultipointCapability
    receiveAndTransmitMultipointCapability::const_reference get_receiveAndTransmitMultipointCapability () const;
    receiveAndTransmitMultipointCapability::reference ref_receiveAndTransmitMultipointCapability ();
    receiveAndTransmitMultipointCapability::reference set_receiveAndTransmitMultipointCapability ();
    receiveAndTransmitMultipointCapability::reference set_receiveAndTransmitMultipointCapability (receiveAndTransmitMultipointCapability::const_reference value);
    class mcCapability {
      public:
        typedef H2250Capability_mcCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mcCapability
    mcCapability::const_reference get_mcCapability () const;
    mcCapability::reference ref_mcCapability ();
    mcCapability::reference set_mcCapability ();
    mcCapability::reference set_mcCapability (mcCapability::const_reference value);
    class rtcpVideoControlCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtcpVideoControlCapability
    rtcpVideoControlCapability::const_reference get_rtcpVideoControlCapability () const;
    rtcpVideoControlCapability::reference ref_rtcpVideoControlCapability ();
    rtcpVideoControlCapability::reference set_rtcpVideoControlCapability ();
    rtcpVideoControlCapability::reference set_rtcpVideoControlCapability (bool value);
    class mediaPacketizationCapability {
      public:
        typedef MediaPacketizationCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaPacketizationCapability
    mediaPacketizationCapability::const_reference get_mediaPacketizationCapability () const;
    mediaPacketizationCapability::reference ref_mediaPacketizationCapability ();
    mediaPacketizationCapability::reference set_mediaPacketizationCapability ();
    mediaPacketizationCapability::reference set_mediaPacketizationCapability (mediaPacketizationCapability::const_reference value);
    class transportCapability {
      public:
        typedef TransportCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportCapability
    transportCapability::const_reference get_transportCapability () const;
    transportCapability::reference ref_transportCapability ();
    transportCapability::reference set_transportCapability ();
    transportCapability::reference set_transportCapability (transportCapability::const_reference value);
    void omit_transportCapability ();
    bool transportCapability_isPresent () const;
    class redundancyEncodingCapability {
      public:
        typedef ASN1::SEQUENCE_OF<RedundancyEncodingCapability,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncodingCapability
    redundancyEncodingCapability::const_reference get_redundancyEncodingCapability () const;
    redundancyEncodingCapability::reference ref_redundancyEncodingCapability ();
    redundancyEncodingCapability::reference set_redundancyEncodingCapability ();
    redundancyEncodingCapability::reference set_redundancyEncodingCapability (redundancyEncodingCapability::const_reference value);
    void omit_redundancyEncodingCapability ();
    bool redundancyEncodingCapability_isPresent () const;
    class logicalChannelSwitchingCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelSwitchingCapability
    logicalChannelSwitchingCapability::const_reference get_logicalChannelSwitchingCapability () const;
    logicalChannelSwitchingCapability::reference ref_logicalChannelSwitchingCapability ();
    logicalChannelSwitchingCapability::reference set_logicalChannelSwitchingCapability ();
    logicalChannelSwitchingCapability::reference set_logicalChannelSwitchingCapability (bool value);
    void omit_logicalChannelSwitchingCapability ();
    bool logicalChannelSwitchingCapability_isPresent () const;
    class t120DynamicPortCapability {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t120DynamicPortCapability
    t120DynamicPortCapability::const_reference get_t120DynamicPortCapability () const;
    t120DynamicPortCapability::reference ref_t120DynamicPortCapability ();
    t120DynamicPortCapability::reference set_t120DynamicPortCapability ();
    t120DynamicPortCapability::reference set_t120DynamicPortCapability (bool value);
    void omit_t120DynamicPortCapability ();
    bool t120DynamicPortCapability_isPresent () const;
    void swap(H2250Capability& other);
    H2250Capability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// H223ModeParameters
//

class H223ModeParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223ModeParameters(const void* info) : Inherited(info) {}
  public:
    H223ModeParameters() : Inherited(&theInfo) {}
    H223ModeParameters(const H223ModeParameters & other) : Inherited(other)
    {}
    H223ModeParameters& operator = (const H223ModeParameters& other)
    { Inherited::operator = (other); return *this; } 
    class adaptationLayerType {
      public:
        typedef H223ModeParameters_adaptationLayerType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class adaptationLayerType
    adaptationLayerType::const_reference get_adaptationLayerType () const;
    adaptationLayerType::reference ref_adaptationLayerType ();
    adaptationLayerType::reference set_adaptationLayerType ();
    adaptationLayerType::reference set_adaptationLayerType (adaptationLayerType::const_reference value);
    class segmentableFlag {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class segmentableFlag
    segmentableFlag::const_reference get_segmentableFlag () const;
    segmentableFlag::reference ref_segmentableFlag ();
    segmentableFlag::reference set_segmentableFlag ();
    segmentableFlag::reference set_segmentableFlag (bool value);
    void swap(H223ModeParameters& other);
    H223ModeParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// VideoMode
//

class VideoMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    VideoMode(const void* info) : Inherited(info) {}
  public:
    VideoMode() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class h261VideoMode {
      public:
        enum Id { id_ = 1 };
        typedef H261VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h261VideoMode

    h261VideoMode::const_reference get_h261VideoMode () const;
    h261VideoMode::reference ref_h261VideoMode (); 
    h261VideoMode::reference select_h261VideoMode (); 
    h261VideoMode::reference select_h261VideoMode (h261VideoMode::const_reference value); 
    bool h261VideoMode_isSelected() const;

    class h262VideoMode {
      public:
        enum Id { id_ = 2 };
        typedef H262VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h262VideoMode

    h262VideoMode::const_reference get_h262VideoMode () const;
    h262VideoMode::reference ref_h262VideoMode (); 
    h262VideoMode::reference select_h262VideoMode (); 
    h262VideoMode::reference select_h262VideoMode (h262VideoMode::const_reference value); 
    bool h262VideoMode_isSelected() const;

    class h263VideoMode {
      public:
        enum Id { id_ = 3 };
        typedef H263VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h263VideoMode

    h263VideoMode::const_reference get_h263VideoMode () const;
    h263VideoMode::reference ref_h263VideoMode (); 
    h263VideoMode::reference select_h263VideoMode (); 
    h263VideoMode::reference select_h263VideoMode (h263VideoMode::const_reference value); 
    bool h263VideoMode_isSelected() const;

    class is11172VideoMode {
      public:
        enum Id { id_ = 4 };
        typedef IS11172VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class is11172VideoMode

    is11172VideoMode::const_reference get_is11172VideoMode () const;
    is11172VideoMode::reference ref_is11172VideoMode (); 
    is11172VideoMode::reference select_is11172VideoMode (); 
    is11172VideoMode::reference select_is11172VideoMode (is11172VideoMode::const_reference value); 
    bool is11172VideoMode_isSelected() const;

    class genericVideoMode {
      public:
        enum Id { id_ = 5 };
        typedef GenericCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericVideoMode

    genericVideoMode::const_reference get_genericVideoMode () const;
    genericVideoMode::reference ref_genericVideoMode (); 
    genericVideoMode::reference select_genericVideoMode (); 
    genericVideoMode::reference select_genericVideoMode (genericVideoMode::const_reference value); 
    bool genericVideoMode_isSelected() const;

    VideoMode(nonStandard::Id id, nonStandard::const_reference value);
    VideoMode(h261VideoMode::Id id, h261VideoMode::const_reference value);
    VideoMode(h262VideoMode::Id id, h262VideoMode::const_reference value);
    VideoMode(h263VideoMode::Id id, h263VideoMode::const_reference value);
    VideoMode(is11172VideoMode::Id id, is11172VideoMode::const_reference value);
    VideoMode(genericVideoMode::Id id, genericVideoMode::const_reference value);
    void swap(VideoMode & other);
    VideoMode(const VideoMode & other)
    : Inherited(other) {} 

    VideoMode & operator = (const VideoMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    VideoMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// AudioMode
//

class AudioMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AudioMode(const void* info) : Inherited(info) {}
  public:
    AudioMode() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class g711Alaw64k {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g711Alaw64k

    g711Alaw64k::reference select_g711Alaw64k (); 
    bool g711Alaw64k_isSelected() const;

    class g711Alaw56k {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g711Alaw56k

    g711Alaw56k::reference select_g711Alaw56k (); 
    bool g711Alaw56k_isSelected() const;

    class g711Ulaw64k {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g711Ulaw64k

    g711Ulaw64k::reference select_g711Ulaw64k (); 
    bool g711Ulaw64k_isSelected() const;

    class g711Ulaw56k {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g711Ulaw56k

    g711Ulaw56k::reference select_g711Ulaw56k (); 
    bool g711Ulaw56k_isSelected() const;

    class g722_64k {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g722_64k

    g722_64k::reference select_g722_64k (); 
    bool g722_64k_isSelected() const;

    class g722_56k {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g722_56k

    g722_56k::reference select_g722_56k (); 
    bool g722_56k_isSelected() const;

    class g722_48k {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g722_48k

    g722_48k::reference select_g722_48k (); 
    bool g722_48k_isSelected() const;

    class g728 {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g728

    g728::reference select_g728 (); 
    bool g728_isSelected() const;

    class g729 {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g729

    g729::reference select_g729 (); 
    bool g729_isSelected() const;

    class g729AnnexA {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g729AnnexA

    g729AnnexA::reference select_g729AnnexA (); 
    bool g729AnnexA_isSelected() const;

    class g7231 {
      public:
        enum Id { id_ = 11 };
        typedef AudioMode_g7231 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g7231

    g7231::const_reference get_g7231 () const;
    g7231::reference ref_g7231 (); 
    g7231::reference select_g7231 (); 
    g7231::reference select_g7231 (g7231::const_reference value); 
    bool g7231_isSelected() const;

    class is11172AudioMode {
      public:
        enum Id { id_ = 12 };
        typedef IS11172AudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class is11172AudioMode

    is11172AudioMode::const_reference get_is11172AudioMode () const;
    is11172AudioMode::reference ref_is11172AudioMode (); 
    is11172AudioMode::reference select_is11172AudioMode (); 
    is11172AudioMode::reference select_is11172AudioMode (is11172AudioMode::const_reference value); 
    bool is11172AudioMode_isSelected() const;

    class is13818AudioMode {
      public:
        enum Id { id_ = 13 };
        typedef IS13818AudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class is13818AudioMode

    is13818AudioMode::const_reference get_is13818AudioMode () const;
    is13818AudioMode::reference ref_is13818AudioMode (); 
    is13818AudioMode::reference select_is13818AudioMode (); 
    is13818AudioMode::reference select_is13818AudioMode (is13818AudioMode::const_reference value); 
    bool is13818AudioMode_isSelected() const;

    class g729wAnnexB {
      public:
        enum Id { id_ = 14 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 256>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g729wAnnexB

    g729wAnnexB::const_reference get_g729wAnnexB () const;
    g729wAnnexB::reference ref_g729wAnnexB (); 
    g729wAnnexB::reference select_g729wAnnexB (); 
    g729wAnnexB::reference select_g729wAnnexB (g729wAnnexB::value_type::int_type value); 
    bool g729wAnnexB_isSelected() const;

    class g729AnnexAwAnnexB {
      public:
        enum Id { id_ = 15 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 256>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g729AnnexAwAnnexB

    g729AnnexAwAnnexB::const_reference get_g729AnnexAwAnnexB () const;
    g729AnnexAwAnnexB::reference ref_g729AnnexAwAnnexB (); 
    g729AnnexAwAnnexB::reference select_g729AnnexAwAnnexB (); 
    g729AnnexAwAnnexB::reference select_g729AnnexAwAnnexB (g729AnnexAwAnnexB::value_type::int_type value); 
    bool g729AnnexAwAnnexB_isSelected() const;

    class g7231AnnexCMode {
      public:
        enum Id { id_ = 16 };
        typedef G7231AnnexCMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g7231AnnexCMode

    g7231AnnexCMode::const_reference get_g7231AnnexCMode () const;
    g7231AnnexCMode::reference ref_g7231AnnexCMode (); 
    g7231AnnexCMode::reference select_g7231AnnexCMode (); 
    g7231AnnexCMode::reference select_g7231AnnexCMode (g7231AnnexCMode::const_reference value); 
    bool g7231AnnexCMode_isSelected() const;

    class gsmFullRate {
      public:
        enum Id { id_ = 17 };
        typedef GSMAudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gsmFullRate

    gsmFullRate::const_reference get_gsmFullRate () const;
    gsmFullRate::reference ref_gsmFullRate (); 
    gsmFullRate::reference select_gsmFullRate (); 
    gsmFullRate::reference select_gsmFullRate (gsmFullRate::const_reference value); 
    bool gsmFullRate_isSelected() const;

    class gsmHalfRate {
      public:
        enum Id { id_ = 18 };
        typedef GSMAudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gsmHalfRate

    gsmHalfRate::const_reference get_gsmHalfRate () const;
    gsmHalfRate::reference ref_gsmHalfRate (); 
    gsmHalfRate::reference select_gsmHalfRate (); 
    gsmHalfRate::reference select_gsmHalfRate (gsmHalfRate::const_reference value); 
    bool gsmHalfRate_isSelected() const;

    class gsmEnhancedFullRate {
      public:
        enum Id { id_ = 19 };
        typedef GSMAudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class gsmEnhancedFullRate

    gsmEnhancedFullRate::const_reference get_gsmEnhancedFullRate () const;
    gsmEnhancedFullRate::reference ref_gsmEnhancedFullRate (); 
    gsmEnhancedFullRate::reference select_gsmEnhancedFullRate (); 
    gsmEnhancedFullRate::reference select_gsmEnhancedFullRate (gsmEnhancedFullRate::const_reference value); 
    bool gsmEnhancedFullRate_isSelected() const;

    class genericAudioMode {
      public:
        enum Id { id_ = 20 };
        typedef GenericCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericAudioMode

    genericAudioMode::const_reference get_genericAudioMode () const;
    genericAudioMode::reference ref_genericAudioMode (); 
    genericAudioMode::reference select_genericAudioMode (); 
    genericAudioMode::reference select_genericAudioMode (genericAudioMode::const_reference value); 
    bool genericAudioMode_isSelected() const;

    class g729Extensions {
      public:
        enum Id { id_ = 21 };
        typedef G729Extensions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class g729Extensions

    g729Extensions::const_reference get_g729Extensions () const;
    g729Extensions::reference ref_g729Extensions (); 
    g729Extensions::reference select_g729Extensions (); 
    g729Extensions::reference select_g729Extensions (g729Extensions::const_reference value); 
    bool g729Extensions_isSelected() const;

    AudioMode(nonStandard::Id id, nonStandard::const_reference value);
    AudioMode(g711Alaw64k::Id id, g711Alaw64k::const_reference value);
    AudioMode(g711Alaw56k::Id id, g711Alaw56k::const_reference value);
    AudioMode(g711Ulaw64k::Id id, g711Ulaw64k::const_reference value);
    AudioMode(g711Ulaw56k::Id id, g711Ulaw56k::const_reference value);
    AudioMode(g722_64k::Id id, g722_64k::const_reference value);
    AudioMode(g722_56k::Id id, g722_56k::const_reference value);
    AudioMode(g722_48k::Id id, g722_48k::const_reference value);
    AudioMode(g728::Id id, g728::const_reference value);
    AudioMode(g729::Id id, g729::const_reference value);
    AudioMode(g729AnnexA::Id id, g729AnnexA::const_reference value);
    AudioMode(g7231::Id id, g7231::const_reference value);
    AudioMode(is11172AudioMode::Id id, is11172AudioMode::const_reference value);
    AudioMode(is13818AudioMode::Id id, is13818AudioMode::const_reference value);
    AudioMode(g729wAnnexB::Id id, g729wAnnexB::value_type::int_type value);
    AudioMode(g729AnnexAwAnnexB::Id id, g729AnnexAwAnnexB::value_type::int_type value);
    AudioMode(g7231AnnexCMode::Id id, g7231AnnexCMode::const_reference value);
    AudioMode(gsmFullRate::Id id, gsmFullRate::const_reference value);
    AudioMode(gsmHalfRate::Id id, gsmHalfRate::const_reference value);
    AudioMode(gsmEnhancedFullRate::Id id, gsmEnhancedFullRate::const_reference value);
    AudioMode(genericAudioMode::Id id, genericAudioMode::const_reference value);
    AudioMode(g729Extensions::Id id, g729Extensions::const_reference value);
    void swap(AudioMode & other);
    AudioMode(const AudioMode & other)
    : Inherited(other) {} 

    AudioMode & operator = (const AudioMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AudioMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[22];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[22];
#endif
};

//
// DataMode
//

class DataMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DataMode(const void* info) : Inherited(info) {}
  public:
    DataMode() : Inherited(&theInfo) {}
    DataMode(const DataMode & other) : Inherited(other)
    {}
    DataMode& operator = (const DataMode& other)
    { Inherited::operator = (other); return *this; } 
    class application {
      public:
        typedef DataMode_application value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class application
    application::const_reference get_application () const;
    application::reference ref_application ();
    application::reference set_application ();
    application::reference set_application (application::const_reference value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    void swap(DataMode& other);
    DataMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CommunicationModeCommand
//

class CommunicationModeCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CommunicationModeCommand(const void* info) : Inherited(info) {}
  public:
    CommunicationModeCommand() : Inherited(&theInfo) {}
    CommunicationModeCommand(const CommunicationModeCommand & other) : Inherited(other)
    {}
    CommunicationModeCommand& operator = (const CommunicationModeCommand& other)
    { Inherited::operator = (other); return *this; } 
    class communicationModeTable {
      public:
        typedef ASN1::SET_OF<CommunicationModeTableEntry,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class communicationModeTable
    communicationModeTable::const_reference get_communicationModeTable () const;
    communicationModeTable::reference ref_communicationModeTable ();
    communicationModeTable::reference set_communicationModeTable ();
    communicationModeTable::reference set_communicationModeTable (communicationModeTable::const_reference value);
    void swap(CommunicationModeCommand& other);
    CommunicationModeCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CommunicationModeResponse
//

class CommunicationModeResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CommunicationModeResponse(const void* info) : Inherited(info) {}
  public:
    CommunicationModeResponse() : Inherited(&theInfo) {}
    class communicationModeTable {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::SET_OF<CommunicationModeTableEntry,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class communicationModeTable

    communicationModeTable::const_reference get_communicationModeTable () const;
    communicationModeTable::reference ref_communicationModeTable (); 
    communicationModeTable::reference select_communicationModeTable (); 
    communicationModeTable::reference select_communicationModeTable (communicationModeTable::const_reference value); 
    bool communicationModeTable_isSelected() const;

    CommunicationModeResponse(communicationModeTable::Id id, communicationModeTable::const_reference value);
    void swap(CommunicationModeResponse & other);
    CommunicationModeResponse(const CommunicationModeResponse & other)
    : Inherited(other) {} 

    CommunicationModeResponse & operator = (const CommunicationModeResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CommunicationModeResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[1];
#endif
};

//
// ConferenceRequest
//

class ConferenceRequest : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceRequest(const void* info) : Inherited(info) {}
  public:
    ConferenceRequest() : Inherited(&theInfo) {}
    class terminalListRequest {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalListRequest

    terminalListRequest::reference select_terminalListRequest (); 
    bool terminalListRequest_isSelected() const;

    class makeMeChair {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeMeChair

    makeMeChair::reference select_makeMeChair (); 
    bool makeMeChair_isSelected() const;

    class cancelMakeMeChair {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMakeMeChair

    cancelMakeMeChair::reference select_cancelMakeMeChair (); 
    bool cancelMakeMeChair_isSelected() const;

    class dropTerminal {
      public:
        enum Id { id_ = 3 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dropTerminal

    dropTerminal::const_reference get_dropTerminal () const;
    dropTerminal::reference ref_dropTerminal (); 
    dropTerminal::reference select_dropTerminal (); 
    dropTerminal::reference select_dropTerminal (dropTerminal::const_reference value); 
    bool dropTerminal_isSelected() const;

    class requestTerminalID {
      public:
        enum Id { id_ = 4 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestTerminalID

    requestTerminalID::const_reference get_requestTerminalID () const;
    requestTerminalID::reference ref_requestTerminalID (); 
    requestTerminalID::reference select_requestTerminalID (); 
    requestTerminalID::reference select_requestTerminalID (requestTerminalID::const_reference value); 
    bool requestTerminalID_isSelected() const;

    class enterH243Password {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enterH243Password

    enterH243Password::reference select_enterH243Password (); 
    bool enterH243Password_isSelected() const;

    class enterH243TerminalID {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enterH243TerminalID

    enterH243TerminalID::reference select_enterH243TerminalID (); 
    bool enterH243TerminalID_isSelected() const;

    class enterH243ConferenceID {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enterH243ConferenceID

    enterH243ConferenceID::reference select_enterH243ConferenceID (); 
    bool enterH243ConferenceID_isSelected() const;

    class enterExtensionAddress {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class enterExtensionAddress

    enterExtensionAddress::reference select_enterExtensionAddress (); 
    bool enterExtensionAddress_isSelected() const;

    class requestChairTokenOwner {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestChairTokenOwner

    requestChairTokenOwner::reference select_requestChairTokenOwner (); 
    bool requestChairTokenOwner_isSelected() const;

    class requestTerminalCertificate {
      public:
        enum Id { id_ = 10 };
        typedef ConferenceRequest_requestTerminalCertificate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestTerminalCertificate

    requestTerminalCertificate::const_reference get_requestTerminalCertificate () const;
    requestTerminalCertificate::reference ref_requestTerminalCertificate (); 
    requestTerminalCertificate::reference select_requestTerminalCertificate (); 
    requestTerminalCertificate::reference select_requestTerminalCertificate (requestTerminalCertificate::const_reference value); 
    bool requestTerminalCertificate_isSelected() const;

    class broadcastMyLogicalChannel {
      public:
        enum Id { id_ = 11 };
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class broadcastMyLogicalChannel

    broadcastMyLogicalChannel::const_reference get_broadcastMyLogicalChannel () const;
    broadcastMyLogicalChannel::reference ref_broadcastMyLogicalChannel (); 
    broadcastMyLogicalChannel::reference select_broadcastMyLogicalChannel (); 
    broadcastMyLogicalChannel::reference select_broadcastMyLogicalChannel (broadcastMyLogicalChannel::value_type::int_type value); 
    bool broadcastMyLogicalChannel_isSelected() const;

    class makeTerminalBroadcaster {
      public:
        enum Id { id_ = 12 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeTerminalBroadcaster

    makeTerminalBroadcaster::const_reference get_makeTerminalBroadcaster () const;
    makeTerminalBroadcaster::reference ref_makeTerminalBroadcaster (); 
    makeTerminalBroadcaster::reference select_makeTerminalBroadcaster (); 
    makeTerminalBroadcaster::reference select_makeTerminalBroadcaster (makeTerminalBroadcaster::const_reference value); 
    bool makeTerminalBroadcaster_isSelected() const;

    class sendThisSource {
      public:
        enum Id { id_ = 13 };
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendThisSource

    sendThisSource::const_reference get_sendThisSource () const;
    sendThisSource::reference ref_sendThisSource (); 
    sendThisSource::reference select_sendThisSource (); 
    sendThisSource::reference select_sendThisSource (sendThisSource::const_reference value); 
    bool sendThisSource_isSelected() const;

    class requestAllTerminalIDs {
      public:
        enum Id { id_ = 14 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestAllTerminalIDs

    requestAllTerminalIDs::reference select_requestAllTerminalIDs (); 
    bool requestAllTerminalIDs_isSelected() const;

    class remoteMCRequest {
      public:
        enum Id { id_ = 15 };
        typedef RemoteMCRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteMCRequest

    remoteMCRequest::const_reference get_remoteMCRequest () const;
    remoteMCRequest::reference ref_remoteMCRequest (); 
    remoteMCRequest::reference select_remoteMCRequest (); 
    remoteMCRequest::reference select_remoteMCRequest (remoteMCRequest::const_reference value); 
    bool remoteMCRequest_isSelected() const;

    ConferenceRequest(terminalListRequest::Id id, terminalListRequest::const_reference value);
    ConferenceRequest(makeMeChair::Id id, makeMeChair::const_reference value);
    ConferenceRequest(cancelMakeMeChair::Id id, cancelMakeMeChair::const_reference value);
    ConferenceRequest(dropTerminal::Id id, dropTerminal::const_reference value);
    ConferenceRequest(requestTerminalID::Id id, requestTerminalID::const_reference value);
    ConferenceRequest(enterH243Password::Id id, enterH243Password::const_reference value);
    ConferenceRequest(enterH243TerminalID::Id id, enterH243TerminalID::const_reference value);
    ConferenceRequest(enterH243ConferenceID::Id id, enterH243ConferenceID::const_reference value);
    ConferenceRequest(enterExtensionAddress::Id id, enterExtensionAddress::const_reference value);
    ConferenceRequest(requestChairTokenOwner::Id id, requestChairTokenOwner::const_reference value);
    ConferenceRequest(requestTerminalCertificate::Id id, requestTerminalCertificate::const_reference value);
    ConferenceRequest(broadcastMyLogicalChannel::Id id, broadcastMyLogicalChannel::value_type::int_type value);
    ConferenceRequest(makeTerminalBroadcaster::Id id, makeTerminalBroadcaster::const_reference value);
    ConferenceRequest(sendThisSource::Id id, sendThisSource::const_reference value);
    ConferenceRequest(requestAllTerminalIDs::Id id, requestAllTerminalIDs::const_reference value);
    ConferenceRequest(remoteMCRequest::Id id, remoteMCRequest::const_reference value);
    void swap(ConferenceRequest & other);
    ConferenceRequest(const ConferenceRequest & other)
    : Inherited(other) {} 

    ConferenceRequest & operator = (const ConferenceRequest & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceRequest * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[16];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[16];
#endif
};

//
// ConferenceResponse
//

class ConferenceResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ConferenceResponse(const void* info) : Inherited(info) {}
  public:
    ConferenceResponse() : Inherited(&theInfo) {}
    class mCTerminalIDResponse {
      public:
        enum Id { id_ = 0 };
        typedef ConferenceResponse_mCTerminalIDResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mCTerminalIDResponse

    mCTerminalIDResponse::const_reference get_mCTerminalIDResponse () const;
    mCTerminalIDResponse::reference ref_mCTerminalIDResponse (); 
    mCTerminalIDResponse::reference select_mCTerminalIDResponse (); 
    mCTerminalIDResponse::reference select_mCTerminalIDResponse (mCTerminalIDResponse::const_reference value); 
    bool mCTerminalIDResponse_isSelected() const;

    class terminalIDResponse {
      public:
        enum Id { id_ = 1 };
        typedef ConferenceResponse_terminalIDResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalIDResponse

    terminalIDResponse::const_reference get_terminalIDResponse () const;
    terminalIDResponse::reference ref_terminalIDResponse (); 
    terminalIDResponse::reference select_terminalIDResponse (); 
    terminalIDResponse::reference select_terminalIDResponse (terminalIDResponse::const_reference value); 
    bool terminalIDResponse_isSelected() const;

    class conferenceIDResponse {
      public:
        enum Id { id_ = 2 };
        typedef ConferenceResponse_conferenceIDResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceIDResponse

    conferenceIDResponse::const_reference get_conferenceIDResponse () const;
    conferenceIDResponse::reference ref_conferenceIDResponse (); 
    conferenceIDResponse::reference select_conferenceIDResponse (); 
    conferenceIDResponse::reference select_conferenceIDResponse (conferenceIDResponse::const_reference value); 
    bool conferenceIDResponse_isSelected() const;

    class passwordResponse {
      public:
        enum Id { id_ = 3 };
        typedef ConferenceResponse_passwordResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class passwordResponse

    passwordResponse::const_reference get_passwordResponse () const;
    passwordResponse::reference ref_passwordResponse (); 
    passwordResponse::reference select_passwordResponse (); 
    passwordResponse::reference select_passwordResponse (passwordResponse::const_reference value); 
    bool passwordResponse_isSelected() const;

    class terminalListResponse {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::SET_OF<TerminalLabel,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalListResponse

    terminalListResponse::const_reference get_terminalListResponse () const;
    terminalListResponse::reference ref_terminalListResponse (); 
    terminalListResponse::reference select_terminalListResponse (); 
    terminalListResponse::reference select_terminalListResponse (terminalListResponse::const_reference value); 
    bool terminalListResponse_isSelected() const;

    class videoCommandReject {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoCommandReject

    videoCommandReject::reference select_videoCommandReject (); 
    bool videoCommandReject_isSelected() const;

    class terminalDropReject {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalDropReject

    terminalDropReject::reference select_terminalDropReject (); 
    bool terminalDropReject_isSelected() const;

    class makeMeChairResponse {
      public:
        enum Id { id_ = 7 };
        typedef ConferenceResponse_makeMeChairResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeMeChairResponse

    makeMeChairResponse::const_reference get_makeMeChairResponse () const;
    makeMeChairResponse::reference ref_makeMeChairResponse (); 
    makeMeChairResponse::reference select_makeMeChairResponse (); 
    makeMeChairResponse::reference select_makeMeChairResponse (makeMeChairResponse::const_reference value); 
    bool makeMeChairResponse_isSelected() const;

    class extensionAddressResponse {
      public:
        enum Id { id_ = 8 };
        typedef ConferenceResponse_extensionAddressResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionAddressResponse

    extensionAddressResponse::const_reference get_extensionAddressResponse () const;
    extensionAddressResponse::reference ref_extensionAddressResponse (); 
    extensionAddressResponse::reference select_extensionAddressResponse (); 
    extensionAddressResponse::reference select_extensionAddressResponse (extensionAddressResponse::const_reference value); 
    bool extensionAddressResponse_isSelected() const;

    class chairTokenOwnerResponse {
      public:
        enum Id { id_ = 9 };
        typedef ConferenceResponse_chairTokenOwnerResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class chairTokenOwnerResponse

    chairTokenOwnerResponse::const_reference get_chairTokenOwnerResponse () const;
    chairTokenOwnerResponse::reference ref_chairTokenOwnerResponse (); 
    chairTokenOwnerResponse::reference select_chairTokenOwnerResponse (); 
    chairTokenOwnerResponse::reference select_chairTokenOwnerResponse (chairTokenOwnerResponse::const_reference value); 
    bool chairTokenOwnerResponse_isSelected() const;

    class terminalCertificateResponse {
      public:
        enum Id { id_ = 10 };
        typedef ConferenceResponse_terminalCertificateResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCertificateResponse

    terminalCertificateResponse::const_reference get_terminalCertificateResponse () const;
    terminalCertificateResponse::reference ref_terminalCertificateResponse (); 
    terminalCertificateResponse::reference select_terminalCertificateResponse (); 
    terminalCertificateResponse::reference select_terminalCertificateResponse (terminalCertificateResponse::const_reference value); 
    bool terminalCertificateResponse_isSelected() const;

    class broadcastMyLogicalChannelResponse {
      public:
        enum Id { id_ = 11 };
        typedef ConferenceResponse_broadcastMyLogicalChannelResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class broadcastMyLogicalChannelResponse

    broadcastMyLogicalChannelResponse::const_reference get_broadcastMyLogicalChannelResponse () const;
    broadcastMyLogicalChannelResponse::reference ref_broadcastMyLogicalChannelResponse (); 
    broadcastMyLogicalChannelResponse::reference select_broadcastMyLogicalChannelResponse (); 
    broadcastMyLogicalChannelResponse::reference select_broadcastMyLogicalChannelResponse (broadcastMyLogicalChannelResponse::const_reference value); 
    bool broadcastMyLogicalChannelResponse_isSelected() const;

    class makeTerminalBroadcasterResponse {
      public:
        enum Id { id_ = 12 };
        typedef ConferenceResponse_makeTerminalBroadcasterResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class makeTerminalBroadcasterResponse

    makeTerminalBroadcasterResponse::const_reference get_makeTerminalBroadcasterResponse () const;
    makeTerminalBroadcasterResponse::reference ref_makeTerminalBroadcasterResponse (); 
    makeTerminalBroadcasterResponse::reference select_makeTerminalBroadcasterResponse (); 
    makeTerminalBroadcasterResponse::reference select_makeTerminalBroadcasterResponse (makeTerminalBroadcasterResponse::const_reference value); 
    bool makeTerminalBroadcasterResponse_isSelected() const;

    class sendThisSourceResponse {
      public:
        enum Id { id_ = 13 };
        typedef ConferenceResponse_sendThisSourceResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendThisSourceResponse

    sendThisSourceResponse::const_reference get_sendThisSourceResponse () const;
    sendThisSourceResponse::reference ref_sendThisSourceResponse (); 
    sendThisSourceResponse::reference select_sendThisSourceResponse (); 
    sendThisSourceResponse::reference select_sendThisSourceResponse (sendThisSourceResponse::const_reference value); 
    bool sendThisSourceResponse_isSelected() const;

    class requestAllTerminalIDsResponse {
      public:
        enum Id { id_ = 14 };
        typedef RequestAllTerminalIDsResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestAllTerminalIDsResponse

    requestAllTerminalIDsResponse::const_reference get_requestAllTerminalIDsResponse () const;
    requestAllTerminalIDsResponse::reference ref_requestAllTerminalIDsResponse (); 
    requestAllTerminalIDsResponse::reference select_requestAllTerminalIDsResponse (); 
    requestAllTerminalIDsResponse::reference select_requestAllTerminalIDsResponse (requestAllTerminalIDsResponse::const_reference value); 
    bool requestAllTerminalIDsResponse_isSelected() const;

    class remoteMCResponse {
      public:
        enum Id { id_ = 15 };
        typedef RemoteMCResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteMCResponse

    remoteMCResponse::const_reference get_remoteMCResponse () const;
    remoteMCResponse::reference ref_remoteMCResponse (); 
    remoteMCResponse::reference select_remoteMCResponse (); 
    remoteMCResponse::reference select_remoteMCResponse (remoteMCResponse::const_reference value); 
    bool remoteMCResponse_isSelected() const;

    ConferenceResponse(mCTerminalIDResponse::Id id, mCTerminalIDResponse::const_reference value);
    ConferenceResponse(terminalIDResponse::Id id, terminalIDResponse::const_reference value);
    ConferenceResponse(conferenceIDResponse::Id id, conferenceIDResponse::const_reference value);
    ConferenceResponse(passwordResponse::Id id, passwordResponse::const_reference value);
    ConferenceResponse(terminalListResponse::Id id, terminalListResponse::const_reference value);
    ConferenceResponse(videoCommandReject::Id id, videoCommandReject::const_reference value);
    ConferenceResponse(terminalDropReject::Id id, terminalDropReject::const_reference value);
    ConferenceResponse(makeMeChairResponse::Id id, makeMeChairResponse::const_reference value);
    ConferenceResponse(extensionAddressResponse::Id id, extensionAddressResponse::const_reference value);
    ConferenceResponse(chairTokenOwnerResponse::Id id, chairTokenOwnerResponse::const_reference value);
    ConferenceResponse(terminalCertificateResponse::Id id, terminalCertificateResponse::const_reference value);
    ConferenceResponse(broadcastMyLogicalChannelResponse::Id id, broadcastMyLogicalChannelResponse::const_reference value);
    ConferenceResponse(makeTerminalBroadcasterResponse::Id id, makeTerminalBroadcasterResponse::const_reference value);
    ConferenceResponse(sendThisSourceResponse::Id id, sendThisSourceResponse::const_reference value);
    ConferenceResponse(requestAllTerminalIDsResponse::Id id, requestAllTerminalIDsResponse::const_reference value);
    ConferenceResponse(remoteMCResponse::Id id, remoteMCResponse::const_reference value);
    void swap(ConferenceResponse & other);
    ConferenceResponse(const ConferenceResponse & other)
    : Inherited(other) {} 

    ConferenceResponse & operator = (const ConferenceResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ConferenceResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[16];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[16];
#endif
};

//
// DialingInformation
//

class DialingInformation : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DialingInformation(const void* info) : Inherited(info) {}
  public:
    DialingInformation() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class differential {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::SET_OF<DialingInformationNumber,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class differential

    differential::const_reference get_differential () const;
    differential::reference ref_differential (); 
    differential::reference select_differential (); 
    differential::reference select_differential (differential::const_reference value); 
    bool differential_isSelected() const;

    class infoNotAvailable {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infoNotAvailable

    infoNotAvailable::const_reference get_infoNotAvailable () const;
    infoNotAvailable::reference ref_infoNotAvailable (); 
    infoNotAvailable::reference select_infoNotAvailable (); 
    infoNotAvailable::reference select_infoNotAvailable (infoNotAvailable::value_type::int_type value); 
    bool infoNotAvailable_isSelected() const;

    DialingInformation(nonStandard::Id id, nonStandard::const_reference value);
    DialingInformation(differential::Id id, differential::const_reference value);
    DialingInformation(infoNotAvailable::Id id, infoNotAvailable::value_type::int_type value);
    void swap(DialingInformation & other);
    DialingInformation(const DialingInformation & other)
    : Inherited(other) {} 

    DialingInformation & operator = (const DialingInformation & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DialingInformation * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// MiscellaneousIndication
//

class MiscellaneousIndication : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousIndication(const void* info) : Inherited(info) {}
  public:
    MiscellaneousIndication() : Inherited(&theInfo) {}
    MiscellaneousIndication(const MiscellaneousIndication & other) : Inherited(other)
    {}
    MiscellaneousIndication& operator = (const MiscellaneousIndication& other)
    { Inherited::operator = (other); return *this; } 
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    class type {
      public:
        typedef MiscellaneousIndication_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    void swap(MiscellaneousIndication& other);
    MiscellaneousIndication * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// UserInputIndication
//

class UserInputIndication : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    UserInputIndication(const void* info) : Inherited(info) {}
  public:
    UserInputIndication() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class alphanumeric {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::GeneralString value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alphanumeric

    alphanumeric::const_reference get_alphanumeric () const;
    alphanumeric::reference ref_alphanumeric (); 
    alphanumeric::reference select_alphanumeric (); 
    alphanumeric::reference select_alphanumeric (const std::string& value); 
    bool alphanumeric_isSelected() const;

    class userInputSupportIndication {
      public:
        enum Id { id_ = 2 };
        typedef UserInputIndication_userInputSupportIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class userInputSupportIndication

    userInputSupportIndication::const_reference get_userInputSupportIndication () const;
    userInputSupportIndication::reference ref_userInputSupportIndication (); 
    userInputSupportIndication::reference select_userInputSupportIndication (); 
    userInputSupportIndication::reference select_userInputSupportIndication (userInputSupportIndication::const_reference value); 
    bool userInputSupportIndication_isSelected() const;

    class signal {
      public:
        enum Id { id_ = 3 };
        typedef UserInputIndication_signal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signal

    signal::const_reference get_signal () const;
    signal::reference ref_signal (); 
    signal::reference select_signal (); 
    signal::reference select_signal (signal::const_reference value); 
    bool signal_isSelected() const;

    class signalUpdate {
      public:
        enum Id { id_ = 4 };
        typedef UserInputIndication_signalUpdate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalUpdate

    signalUpdate::const_reference get_signalUpdate () const;
    signalUpdate::reference ref_signalUpdate (); 
    signalUpdate::reference select_signalUpdate (); 
    signalUpdate::reference select_signalUpdate (signalUpdate::const_reference value); 
    bool signalUpdate_isSelected() const;

    class extendedAlphanumeric {
      public:
        enum Id { id_ = 5 };
        typedef UserInputIndication_extendedAlphanumeric value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extendedAlphanumeric

    extendedAlphanumeric::const_reference get_extendedAlphanumeric () const;
    extendedAlphanumeric::reference ref_extendedAlphanumeric (); 
    extendedAlphanumeric::reference select_extendedAlphanumeric (); 
    extendedAlphanumeric::reference select_extendedAlphanumeric (extendedAlphanumeric::const_reference value); 
    bool extendedAlphanumeric_isSelected() const;

    UserInputIndication(nonStandard::Id id, nonStandard::const_reference value);
    UserInputIndication(alphanumeric::Id id, const std::string& value);
    UserInputIndication(userInputSupportIndication::Id id, userInputSupportIndication::const_reference value);
    UserInputIndication(signal::Id id, signal::const_reference value);
    UserInputIndication(signalUpdate::Id id, signalUpdate::const_reference value);
    UserInputIndication(extendedAlphanumeric::Id id, extendedAlphanumeric::const_reference value);
    void swap(UserInputIndication & other);
    UserInputIndication(const UserInputIndication & other)
    : Inherited(other) {} 

    UserInputIndication & operator = (const UserInputIndication & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    UserInputIndication * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// H235Mode_mediaMode
//

class H235Mode_mediaMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H235Mode_mediaMode(const void* info) : Inherited(info) {}
  public:
    H235Mode_mediaMode() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class videoMode {
      public:
        enum Id { id_ = 1 };
        typedef VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoMode

    videoMode::const_reference get_videoMode () const;
    videoMode::reference ref_videoMode (); 
    videoMode::reference select_videoMode (); 
    videoMode::reference select_videoMode (videoMode::const_reference value); 
    bool videoMode_isSelected() const;

    class audioMode {
      public:
        enum Id { id_ = 2 };
        typedef AudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioMode

    audioMode::const_reference get_audioMode () const;
    audioMode::reference ref_audioMode (); 
    audioMode::reference select_audioMode (); 
    audioMode::reference select_audioMode (audioMode::const_reference value); 
    bool audioMode_isSelected() const;

    class dataMode {
      public:
        enum Id { id_ = 3 };
        typedef DataMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataMode

    dataMode::const_reference get_dataMode () const;
    dataMode::reference ref_dataMode (); 
    dataMode::reference select_dataMode (); 
    dataMode::reference select_dataMode (dataMode::const_reference value); 
    bool dataMode_isSelected() const;

    H235Mode_mediaMode(nonStandard::Id id, nonStandard::const_reference value);
    H235Mode_mediaMode(videoMode::Id id, videoMode::const_reference value);
    H235Mode_mediaMode(audioMode::Id id, audioMode::const_reference value);
    H235Mode_mediaMode(dataMode::Id id, dataMode::const_reference value);
    void swap(H235Mode_mediaMode & other);
    H235Mode_mediaMode(const H235Mode_mediaMode & other)
    : Inherited(other) {} 

    H235Mode_mediaMode & operator = (const H235Mode_mediaMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H235Mode_mediaMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// RedundancyEncodingMode_secondaryEncoding
//

class RedundancyEncodingMode_secondaryEncoding : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RedundancyEncodingMode_secondaryEncoding(const void* info) : Inherited(info) {}
  public:
    RedundancyEncodingMode_secondaryEncoding() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class audioData {
      public:
        enum Id { id_ = 1 };
        typedef AudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioData

    audioData::const_reference get_audioData () const;
    audioData::reference ref_audioData (); 
    audioData::reference select_audioData (); 
    audioData::reference select_audioData (audioData::const_reference value); 
    bool audioData_isSelected() const;

    RedundancyEncodingMode_secondaryEncoding(nonStandard::Id id, nonStandard::const_reference value);
    RedundancyEncodingMode_secondaryEncoding(audioData::Id id, audioData::const_reference value);
    void swap(RedundancyEncodingMode_secondaryEncoding & other);
    RedundancyEncodingMode_secondaryEncoding(const RedundancyEncodingMode_secondaryEncoding & other)
    : Inherited(other) {} 

    RedundancyEncodingMode_secondaryEncoding & operator = (const RedundancyEncodingMode_secondaryEncoding & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RedundancyEncodingMode_secondaryEncoding * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MultilinkRequest_addConnection
//

class MultilinkRequest_addConnection : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkRequest_addConnection(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest_addConnection() : Inherited(&theInfo) {}
    MultilinkRequest_addConnection(const MultilinkRequest_addConnection & other) : Inherited(other)
    {}
    MultilinkRequest_addConnection& operator = (const MultilinkRequest_addConnection& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class dialingInformation {
      public:
        typedef DialingInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dialingInformation
    dialingInformation::const_reference get_dialingInformation () const;
    dialingInformation::reference ref_dialingInformation ();
    dialingInformation::reference set_dialingInformation ();
    dialingInformation::reference set_dialingInformation (dialingInformation::const_reference value);
    void swap(MultilinkRequest_addConnection& other);
    MultilinkRequest_addConnection * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MultilinkResponse_callInformation
//

class MultilinkResponse_callInformation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkResponse_callInformation(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_callInformation() : Inherited(&theInfo) {}
    MultilinkResponse_callInformation(const MultilinkResponse_callInformation & other) : Inherited(other)
    {}
    MultilinkResponse_callInformation& operator = (const MultilinkResponse_callInformation& other)
    { Inherited::operator = (other); return *this; } 
    class dialingInformation {
      public:
        typedef DialingInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dialingInformation
    dialingInformation::const_reference get_dialingInformation () const;
    dialingInformation::reference ref_dialingInformation ();
    dialingInformation::reference set_dialingInformation ();
    dialingInformation::reference set_dialingInformation (dialingInformation::const_reference value);
    class callAssociationNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callAssociationNumber
    callAssociationNumber::const_reference get_callAssociationNumber () const;
    callAssociationNumber::reference ref_callAssociationNumber ();
    callAssociationNumber::reference set_callAssociationNumber ();
    callAssociationNumber::reference set_callAssociationNumber (callAssociationNumber::value_type::int_type value);
    void swap(MultilinkResponse_callInformation& other);
    MultilinkResponse_callInformation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MultilinkResponse_addConnection
//

class MultilinkResponse_addConnection : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultilinkResponse_addConnection(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse_addConnection() : Inherited(&theInfo) {}
    MultilinkResponse_addConnection(const MultilinkResponse_addConnection & other) : Inherited(other)
    {}
    MultilinkResponse_addConnection& operator = (const MultilinkResponse_addConnection& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class responseCode {
      public:
        typedef MultilinkResponse_addConnection_responseCode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class responseCode
    responseCode::const_reference get_responseCode () const;
    responseCode::reference ref_responseCode ();
    responseCode::reference set_responseCode ();
    responseCode::reference set_responseCode (responseCode::const_reference value);
    void swap(MultilinkResponse_addConnection& other);
    MultilinkResponse_addConnection * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MiscellaneousCommand_type
//

class MiscellaneousCommand_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MiscellaneousCommand_type(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand_type() : Inherited(&theInfo) {}
    class equaliseDelay {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class equaliseDelay

    equaliseDelay::reference select_equaliseDelay (); 
    bool equaliseDelay_isSelected() const;

    class zeroDelay {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class zeroDelay

    zeroDelay::reference select_zeroDelay (); 
    bool zeroDelay_isSelected() const;

    class multipointModeCommand {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multipointModeCommand

    multipointModeCommand::reference select_multipointModeCommand (); 
    bool multipointModeCommand_isSelected() const;

    class cancelMultipointModeCommand {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cancelMultipointModeCommand

    cancelMultipointModeCommand::reference select_cancelMultipointModeCommand (); 
    bool cancelMultipointModeCommand_isSelected() const;

    class videoFreezePicture {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoFreezePicture

    videoFreezePicture::reference select_videoFreezePicture (); 
    bool videoFreezePicture_isSelected() const;

    class videoFastUpdatePicture {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoFastUpdatePicture

    videoFastUpdatePicture::reference select_videoFastUpdatePicture (); 
    bool videoFastUpdatePicture_isSelected() const;

    class videoFastUpdateGOB {
      public:
        enum Id { id_ = 6 };
        typedef MiscellaneousCommand_type_videoFastUpdateGOB value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoFastUpdateGOB

    videoFastUpdateGOB::const_reference get_videoFastUpdateGOB () const;
    videoFastUpdateGOB::reference ref_videoFastUpdateGOB (); 
    videoFastUpdateGOB::reference select_videoFastUpdateGOB (); 
    videoFastUpdateGOB::reference select_videoFastUpdateGOB (videoFastUpdateGOB::const_reference value); 
    bool videoFastUpdateGOB_isSelected() const;

    class videoTemporalSpatialTradeOff {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 31>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoTemporalSpatialTradeOff

    videoTemporalSpatialTradeOff::const_reference get_videoTemporalSpatialTradeOff () const;
    videoTemporalSpatialTradeOff::reference ref_videoTemporalSpatialTradeOff (); 
    videoTemporalSpatialTradeOff::reference select_videoTemporalSpatialTradeOff (); 
    videoTemporalSpatialTradeOff::reference select_videoTemporalSpatialTradeOff (videoTemporalSpatialTradeOff::value_type::int_type value); 
    bool videoTemporalSpatialTradeOff_isSelected() const;

    class videoSendSyncEveryGOB {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoSendSyncEveryGOB

    videoSendSyncEveryGOB::reference select_videoSendSyncEveryGOB (); 
    bool videoSendSyncEveryGOB_isSelected() const;

    class videoSendSyncEveryGOBCancel {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoSendSyncEveryGOBCancel

    videoSendSyncEveryGOBCancel::reference select_videoSendSyncEveryGOBCancel (); 
    bool videoSendSyncEveryGOBCancel_isSelected() const;

    class videoFastUpdateMB {
      public:
        enum Id { id_ = 10 };
        typedef MiscellaneousCommand_type_videoFastUpdateMB value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoFastUpdateMB

    videoFastUpdateMB::const_reference get_videoFastUpdateMB () const;
    videoFastUpdateMB::reference ref_videoFastUpdateMB (); 
    videoFastUpdateMB::reference select_videoFastUpdateMB (); 
    videoFastUpdateMB::reference select_videoFastUpdateMB (videoFastUpdateMB::const_reference value); 
    bool videoFastUpdateMB_isSelected() const;

    class maxH223MUXPDUsize {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxH223MUXPDUsize

    maxH223MUXPDUsize::const_reference get_maxH223MUXPDUsize () const;
    maxH223MUXPDUsize::reference ref_maxH223MUXPDUsize (); 
    maxH223MUXPDUsize::reference select_maxH223MUXPDUsize (); 
    maxH223MUXPDUsize::reference select_maxH223MUXPDUsize (maxH223MUXPDUsize::value_type::int_type value); 
    bool maxH223MUXPDUsize_isSelected() const;

    class encryptionUpdate {
      public:
        enum Id { id_ = 12 };
        typedef EncryptionSync value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionUpdate

    encryptionUpdate::const_reference get_encryptionUpdate () const;
    encryptionUpdate::reference ref_encryptionUpdate (); 
    encryptionUpdate::reference select_encryptionUpdate (); 
    encryptionUpdate::reference select_encryptionUpdate (encryptionUpdate::const_reference value); 
    bool encryptionUpdate_isSelected() const;

    class encryptionUpdateRequest {
      public:
        enum Id { id_ = 13 };
        typedef EncryptionUpdateRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionUpdateRequest

    encryptionUpdateRequest::const_reference get_encryptionUpdateRequest () const;
    encryptionUpdateRequest::reference ref_encryptionUpdateRequest (); 
    encryptionUpdateRequest::reference select_encryptionUpdateRequest (); 
    encryptionUpdateRequest::reference select_encryptionUpdateRequest (encryptionUpdateRequest::const_reference value); 
    bool encryptionUpdateRequest_isSelected() const;

    class switchReceiveMediaOff {
      public:
        enum Id { id_ = 14 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class switchReceiveMediaOff

    switchReceiveMediaOff::reference select_switchReceiveMediaOff (); 
    bool switchReceiveMediaOff_isSelected() const;

    class switchReceiveMediaOn {
      public:
        enum Id { id_ = 15 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class switchReceiveMediaOn

    switchReceiveMediaOn::reference select_switchReceiveMediaOn (); 
    bool switchReceiveMediaOn_isSelected() const;

    class progressiveRefinementStart {
      public:
        enum Id { id_ = 16 };
        typedef MiscellaneousCommand_type_progressiveRefinementStart value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class progressiveRefinementStart

    progressiveRefinementStart::const_reference get_progressiveRefinementStart () const;
    progressiveRefinementStart::reference ref_progressiveRefinementStart (); 
    progressiveRefinementStart::reference select_progressiveRefinementStart (); 
    progressiveRefinementStart::reference select_progressiveRefinementStart (progressiveRefinementStart::const_reference value); 
    bool progressiveRefinementStart_isSelected() const;

    class progressiveRefinementAbortOne {
      public:
        enum Id { id_ = 17 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class progressiveRefinementAbortOne

    progressiveRefinementAbortOne::reference select_progressiveRefinementAbortOne (); 
    bool progressiveRefinementAbortOne_isSelected() const;

    class progressiveRefinementAbortContinuous {
      public:
        enum Id { id_ = 18 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class progressiveRefinementAbortContinuous

    progressiveRefinementAbortContinuous::reference select_progressiveRefinementAbortContinuous (); 
    bool progressiveRefinementAbortContinuous_isSelected() const;

    class videoBadMBs {
      public:
        enum Id { id_ = 19 };
        typedef MiscellaneousCommand_type_videoBadMBs value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoBadMBs

    videoBadMBs::const_reference get_videoBadMBs () const;
    videoBadMBs::reference ref_videoBadMBs (); 
    videoBadMBs::reference select_videoBadMBs (); 
    videoBadMBs::reference select_videoBadMBs (videoBadMBs::const_reference value); 
    bool videoBadMBs_isSelected() const;

    class lostPicture {
      public:
        enum Id { id_ = 20 };
        typedef ASN1::SEQUENCE_OF<PictureReference>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lostPicture

    lostPicture::const_reference get_lostPicture () const;
    lostPicture::reference ref_lostPicture (); 
    lostPicture::reference select_lostPicture (); 
    lostPicture::reference select_lostPicture (lostPicture::const_reference value); 
    bool lostPicture_isSelected() const;

    class lostPartialPicture {
      public:
        enum Id { id_ = 21 };
        typedef MiscellaneousCommand_type_lostPartialPicture value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lostPartialPicture

    lostPartialPicture::const_reference get_lostPartialPicture () const;
    lostPartialPicture::reference ref_lostPartialPicture (); 
    lostPartialPicture::reference select_lostPartialPicture (); 
    lostPartialPicture::reference select_lostPartialPicture (lostPartialPicture::const_reference value); 
    bool lostPartialPicture_isSelected() const;

    class recoveryReferencePicture {
      public:
        enum Id { id_ = 22 };
        typedef ASN1::SEQUENCE_OF<PictureReference>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class recoveryReferencePicture

    recoveryReferencePicture::const_reference get_recoveryReferencePicture () const;
    recoveryReferencePicture::reference ref_recoveryReferencePicture (); 
    recoveryReferencePicture::reference select_recoveryReferencePicture (); 
    recoveryReferencePicture::reference select_recoveryReferencePicture (recoveryReferencePicture::const_reference value); 
    bool recoveryReferencePicture_isSelected() const;

    MiscellaneousCommand_type(equaliseDelay::Id id, equaliseDelay::const_reference value);
    MiscellaneousCommand_type(zeroDelay::Id id, zeroDelay::const_reference value);
    MiscellaneousCommand_type(multipointModeCommand::Id id, multipointModeCommand::const_reference value);
    MiscellaneousCommand_type(cancelMultipointModeCommand::Id id, cancelMultipointModeCommand::const_reference value);
    MiscellaneousCommand_type(videoFreezePicture::Id id, videoFreezePicture::const_reference value);
    MiscellaneousCommand_type(videoFastUpdatePicture::Id id, videoFastUpdatePicture::const_reference value);
    MiscellaneousCommand_type(videoFastUpdateGOB::Id id, videoFastUpdateGOB::const_reference value);
    MiscellaneousCommand_type(videoTemporalSpatialTradeOff::Id id, videoTemporalSpatialTradeOff::value_type::int_type value);
    MiscellaneousCommand_type(videoSendSyncEveryGOB::Id id, videoSendSyncEveryGOB::const_reference value);
    MiscellaneousCommand_type(videoSendSyncEveryGOBCancel::Id id, videoSendSyncEveryGOBCancel::const_reference value);
    MiscellaneousCommand_type(videoFastUpdateMB::Id id, videoFastUpdateMB::const_reference value);
    MiscellaneousCommand_type(maxH223MUXPDUsize::Id id, maxH223MUXPDUsize::value_type::int_type value);
    MiscellaneousCommand_type(encryptionUpdate::Id id, encryptionUpdate::const_reference value);
    MiscellaneousCommand_type(encryptionUpdateRequest::Id id, encryptionUpdateRequest::const_reference value);
    MiscellaneousCommand_type(switchReceiveMediaOff::Id id, switchReceiveMediaOff::const_reference value);
    MiscellaneousCommand_type(switchReceiveMediaOn::Id id, switchReceiveMediaOn::const_reference value);
    MiscellaneousCommand_type(progressiveRefinementStart::Id id, progressiveRefinementStart::const_reference value);
    MiscellaneousCommand_type(progressiveRefinementAbortOne::Id id, progressiveRefinementAbortOne::const_reference value);
    MiscellaneousCommand_type(progressiveRefinementAbortContinuous::Id id, progressiveRefinementAbortContinuous::const_reference value);
    MiscellaneousCommand_type(videoBadMBs::Id id, videoBadMBs::const_reference value);
    MiscellaneousCommand_type(lostPicture::Id id, lostPicture::const_reference value);
    MiscellaneousCommand_type(lostPartialPicture::Id id, lostPartialPicture::const_reference value);
    MiscellaneousCommand_type(recoveryReferencePicture::Id id, recoveryReferencePicture::const_reference value);
    void swap(MiscellaneousCommand_type & other);
    MiscellaneousCommand_type(const MiscellaneousCommand_type & other)
    : Inherited(other) {} 

    MiscellaneousCommand_type & operator = (const MiscellaneousCommand_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MiscellaneousCommand_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[23];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[23];
#endif
};

//
// NewATMVCCommand_aal
//

class NewATMVCCommand_aal : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NewATMVCCommand_aal(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand_aal() : Inherited(&theInfo) {}
    class aal1 {
      public:
        enum Id { id_ = 0 };
        typedef NewATMVCCommand_aal_aal1 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aal1

    aal1::const_reference get_aal1 () const;
    aal1::reference ref_aal1 (); 
    aal1::reference select_aal1 (); 
    aal1::reference select_aal1 (aal1::const_reference value); 
    bool aal1_isSelected() const;

    class aal5 {
      public:
        enum Id { id_ = 1 };
        typedef NewATMVCCommand_aal_aal5 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aal5

    aal5::const_reference get_aal5 () const;
    aal5::reference ref_aal5 (); 
    aal5::reference select_aal5 (); 
    aal5::reference select_aal5 (aal5::const_reference value); 
    bool aal5_isSelected() const;

    NewATMVCCommand_aal(aal1::Id id, aal1::const_reference value);
    NewATMVCCommand_aal(aal5::Id id, aal5::const_reference value);
    void swap(NewATMVCCommand_aal & other);
    NewATMVCCommand_aal(const NewATMVCCommand_aal & other)
    : Inherited(other) {} 

    NewATMVCCommand_aal & operator = (const NewATMVCCommand_aal & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NewATMVCCommand_aal * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MultiplexCapability
//

class MultiplexCapability : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultiplexCapability(const void* info) : Inherited(info) {}
  public:
    MultiplexCapability() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class h222Capability {
      public:
        enum Id { id_ = 1 };
        typedef H222Capability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h222Capability

    h222Capability::const_reference get_h222Capability () const;
    h222Capability::reference ref_h222Capability (); 
    h222Capability::reference select_h222Capability (); 
    h222Capability::reference select_h222Capability (h222Capability::const_reference value); 
    bool h222Capability_isSelected() const;

    class h223Capability {
      public:
        enum Id { id_ = 2 };
        typedef H223Capability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223Capability

    h223Capability::const_reference get_h223Capability () const;
    h223Capability::reference ref_h223Capability (); 
    h223Capability::reference select_h223Capability (); 
    h223Capability::reference select_h223Capability (h223Capability::const_reference value); 
    bool h223Capability_isSelected() const;

    class v76Capability {
      public:
        enum Id { id_ = 3 };
        typedef V76Capability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v76Capability

    v76Capability::const_reference get_v76Capability () const;
    v76Capability::reference ref_v76Capability (); 
    v76Capability::reference select_v76Capability (); 
    v76Capability::reference select_v76Capability (v76Capability::const_reference value); 
    bool v76Capability_isSelected() const;

    class h2250Capability {
      public:
        enum Id { id_ = 4 };
        typedef H2250Capability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250Capability

    h2250Capability::const_reference get_h2250Capability () const;
    h2250Capability::reference ref_h2250Capability (); 
    h2250Capability::reference select_h2250Capability (); 
    h2250Capability::reference select_h2250Capability (h2250Capability::const_reference value); 
    bool h2250Capability_isSelected() const;

    class genericMultiplexCapability {
      public:
        enum Id { id_ = 5 };
        typedef GenericCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericMultiplexCapability

    genericMultiplexCapability::const_reference get_genericMultiplexCapability () const;
    genericMultiplexCapability::reference ref_genericMultiplexCapability (); 
    genericMultiplexCapability::reference select_genericMultiplexCapability (); 
    genericMultiplexCapability::reference select_genericMultiplexCapability (genericMultiplexCapability::const_reference value); 
    bool genericMultiplexCapability_isSelected() const;

    MultiplexCapability(nonStandard::Id id, nonStandard::const_reference value);
    MultiplexCapability(h222Capability::Id id, h222Capability::const_reference value);
    MultiplexCapability(h223Capability::Id id, h223Capability::const_reference value);
    MultiplexCapability(v76Capability::Id id, v76Capability::const_reference value);
    MultiplexCapability(h2250Capability::Id id, h2250Capability::const_reference value);
    MultiplexCapability(genericMultiplexCapability::Id id, genericMultiplexCapability::const_reference value);
    void swap(MultiplexCapability & other);
    MultiplexCapability(const MultiplexCapability & other)
    : Inherited(other) {} 

    MultiplexCapability & operator = (const MultiplexCapability & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultiplexCapability * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// H235Mode
//

class H235Mode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H235Mode(const void* info) : Inherited(info) {}
  public:
    H235Mode() : Inherited(&theInfo) {}
    H235Mode(const H235Mode & other) : Inherited(other)
    {}
    H235Mode& operator = (const H235Mode& other)
    { Inherited::operator = (other); return *this; } 
    class encryptionAuthenticationAndIntegrity {
      public:
        typedef EncryptionAuthenticationAndIntegrity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionAuthenticationAndIntegrity
    encryptionAuthenticationAndIntegrity::const_reference get_encryptionAuthenticationAndIntegrity () const;
    encryptionAuthenticationAndIntegrity::reference ref_encryptionAuthenticationAndIntegrity ();
    encryptionAuthenticationAndIntegrity::reference set_encryptionAuthenticationAndIntegrity ();
    encryptionAuthenticationAndIntegrity::reference set_encryptionAuthenticationAndIntegrity (encryptionAuthenticationAndIntegrity::const_reference value);
    class mediaMode {
      public:
        typedef H235Mode_mediaMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaMode
    mediaMode::const_reference get_mediaMode () const;
    mediaMode::reference ref_mediaMode ();
    mediaMode::reference set_mediaMode ();
    mediaMode::reference set_mediaMode (mediaMode::const_reference value);
    void swap(H235Mode& other);
    H235Mode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RedundancyEncodingMode
//

class RedundancyEncodingMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RedundancyEncodingMode(const void* info) : Inherited(info) {}
  public:
    RedundancyEncodingMode() : Inherited(&theInfo) {}
    RedundancyEncodingMode(const RedundancyEncodingMode & other) : Inherited(other)
    {}
    RedundancyEncodingMode& operator = (const RedundancyEncodingMode& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_secondaryEncoding
    };

    class redundancyEncodingMethod {
      public:
        typedef RedundancyEncodingMethod value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncodingMethod
    redundancyEncodingMethod::const_reference get_redundancyEncodingMethod () const;
    redundancyEncodingMethod::reference ref_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod (redundancyEncodingMethod::const_reference value);
    class secondaryEncoding {
      public:
        typedef RedundancyEncodingMode_secondaryEncoding value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secondaryEncoding
    secondaryEncoding::const_reference get_secondaryEncoding () const;
    secondaryEncoding::reference ref_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding (secondaryEncoding::const_reference value);
    void omit_secondaryEncoding ();
    bool secondaryEncoding_isPresent () const;
    void swap(RedundancyEncodingMode& other);
    RedundancyEncodingMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MultilinkRequest
//

class MultilinkRequest : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkRequest(const void* info) : Inherited(info) {}
  public:
    MultilinkRequest() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class callInformation {
      public:
        enum Id { id_ = 1 };
        typedef MultilinkRequest_callInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callInformation

    callInformation::const_reference get_callInformation () const;
    callInformation::reference ref_callInformation (); 
    callInformation::reference select_callInformation (); 
    callInformation::reference select_callInformation (callInformation::const_reference value); 
    bool callInformation_isSelected() const;

    class addConnection {
      public:
        enum Id { id_ = 2 };
        typedef MultilinkRequest_addConnection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class addConnection

    addConnection::const_reference get_addConnection () const;
    addConnection::reference ref_addConnection (); 
    addConnection::reference select_addConnection (); 
    addConnection::reference select_addConnection (addConnection::const_reference value); 
    bool addConnection_isSelected() const;

    class removeConnection {
      public:
        enum Id { id_ = 3 };
        typedef MultilinkRequest_removeConnection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class removeConnection

    removeConnection::const_reference get_removeConnection () const;
    removeConnection::reference ref_removeConnection (); 
    removeConnection::reference select_removeConnection (); 
    removeConnection::reference select_removeConnection (removeConnection::const_reference value); 
    bool removeConnection_isSelected() const;

    class maximumHeaderInterval {
      public:
        enum Id { id_ = 4 };
        typedef MultilinkRequest_maximumHeaderInterval value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumHeaderInterval

    maximumHeaderInterval::const_reference get_maximumHeaderInterval () const;
    maximumHeaderInterval::reference ref_maximumHeaderInterval (); 
    maximumHeaderInterval::reference select_maximumHeaderInterval (); 
    maximumHeaderInterval::reference select_maximumHeaderInterval (maximumHeaderInterval::const_reference value); 
    bool maximumHeaderInterval_isSelected() const;

    MultilinkRequest(nonStandard::Id id, nonStandard::const_reference value);
    MultilinkRequest(callInformation::Id id, callInformation::const_reference value);
    MultilinkRequest(addConnection::Id id, addConnection::const_reference value);
    MultilinkRequest(removeConnection::Id id, removeConnection::const_reference value);
    MultilinkRequest(maximumHeaderInterval::Id id, maximumHeaderInterval::const_reference value);
    void swap(MultilinkRequest & other);
    MultilinkRequest(const MultilinkRequest & other)
    : Inherited(other) {} 

    MultilinkRequest & operator = (const MultilinkRequest & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkRequest * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// MultilinkResponse
//

class MultilinkResponse : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultilinkResponse(const void* info) : Inherited(info) {}
  public:
    MultilinkResponse() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class callInformation {
      public:
        enum Id { id_ = 1 };
        typedef MultilinkResponse_callInformation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callInformation

    callInformation::const_reference get_callInformation () const;
    callInformation::reference ref_callInformation (); 
    callInformation::reference select_callInformation (); 
    callInformation::reference select_callInformation (callInformation::const_reference value); 
    bool callInformation_isSelected() const;

    class addConnection {
      public:
        enum Id { id_ = 2 };
        typedef MultilinkResponse_addConnection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class addConnection

    addConnection::const_reference get_addConnection () const;
    addConnection::reference ref_addConnection (); 
    addConnection::reference select_addConnection (); 
    addConnection::reference select_addConnection (addConnection::const_reference value); 
    bool addConnection_isSelected() const;

    class removeConnection {
      public:
        enum Id { id_ = 3 };
        typedef MultilinkResponse_removeConnection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class removeConnection

    removeConnection::const_reference get_removeConnection () const;
    removeConnection::reference ref_removeConnection (); 
    removeConnection::reference select_removeConnection (); 
    removeConnection::reference select_removeConnection (removeConnection::const_reference value); 
    bool removeConnection_isSelected() const;

    class maximumHeaderInterval {
      public:
        enum Id { id_ = 4 };
        typedef MultilinkResponse_maximumHeaderInterval value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maximumHeaderInterval

    maximumHeaderInterval::const_reference get_maximumHeaderInterval () const;
    maximumHeaderInterval::reference ref_maximumHeaderInterval (); 
    maximumHeaderInterval::reference select_maximumHeaderInterval (); 
    maximumHeaderInterval::reference select_maximumHeaderInterval (maximumHeaderInterval::const_reference value); 
    bool maximumHeaderInterval_isSelected() const;

    MultilinkResponse(nonStandard::Id id, nonStandard::const_reference value);
    MultilinkResponse(callInformation::Id id, callInformation::const_reference value);
    MultilinkResponse(addConnection::Id id, addConnection::const_reference value);
    MultilinkResponse(removeConnection::Id id, removeConnection::const_reference value);
    MultilinkResponse(maximumHeaderInterval::Id id, maximumHeaderInterval::const_reference value);
    void swap(MultilinkResponse & other);
    MultilinkResponse(const MultilinkResponse & other)
    : Inherited(other) {} 

    MultilinkResponse & operator = (const MultilinkResponse & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultilinkResponse * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// MiscellaneousCommand
//

class MiscellaneousCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MiscellaneousCommand(const void* info) : Inherited(info) {}
  public:
    MiscellaneousCommand() : Inherited(&theInfo) {}
    MiscellaneousCommand(const MiscellaneousCommand & other) : Inherited(other)
    {}
    MiscellaneousCommand& operator = (const MiscellaneousCommand& other)
    { Inherited::operator = (other); return *this; } 
    class logicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelNumber
    logicalChannelNumber::const_reference get_logicalChannelNumber () const;
    logicalChannelNumber::reference ref_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber ();
    logicalChannelNumber::reference set_logicalChannelNumber (logicalChannelNumber::value_type::int_type value);
    class type {
      public:
        typedef MiscellaneousCommand_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    void swap(MiscellaneousCommand& other);
    MiscellaneousCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// NewATMVCCommand
//

class NewATMVCCommand : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NewATMVCCommand(const void* info) : Inherited(info) {}
  public:
    NewATMVCCommand() : Inherited(&theInfo) {}
    NewATMVCCommand(const NewATMVCCommand & other) : Inherited(other)
    {}
    NewATMVCCommand& operator = (const NewATMVCCommand& other)
    { Inherited::operator = (other); return *this; } 
    class resourceID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceID
    resourceID::const_reference get_resourceID () const;
    resourceID::reference ref_resourceID ();
    resourceID::reference set_resourceID ();
    resourceID::reference set_resourceID (resourceID::value_type::int_type value);
    class bitRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRate
    bitRate::const_reference get_bitRate () const;
    bitRate::reference ref_bitRate ();
    bitRate::reference set_bitRate ();
    bitRate::reference set_bitRate (bitRate::value_type::int_type value);
    class bitRateLockedToPCRClock {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRateLockedToPCRClock
    bitRateLockedToPCRClock::const_reference get_bitRateLockedToPCRClock () const;
    bitRateLockedToPCRClock::reference ref_bitRateLockedToPCRClock ();
    bitRateLockedToPCRClock::reference set_bitRateLockedToPCRClock ();
    bitRateLockedToPCRClock::reference set_bitRateLockedToPCRClock (bool value);
    class bitRateLockedToNetworkClock {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bitRateLockedToNetworkClock
    bitRateLockedToNetworkClock::const_reference get_bitRateLockedToNetworkClock () const;
    bitRateLockedToNetworkClock::reference ref_bitRateLockedToNetworkClock ();
    bitRateLockedToNetworkClock::reference set_bitRateLockedToNetworkClock ();
    bitRateLockedToNetworkClock::reference set_bitRateLockedToNetworkClock (bool value);
    class aal {
      public:
        typedef NewATMVCCommand_aal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class aal
    aal::const_reference get_aal () const;
    aal::reference ref_aal ();
    aal::reference set_aal ();
    aal::reference set_aal (aal::const_reference value);
    class multiplex {
      public:
        typedef NewATMVCCommand_multiplex value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplex
    multiplex::const_reference get_multiplex () const;
    multiplex::reference ref_multiplex ();
    multiplex::reference set_multiplex ();
    multiplex::reference set_multiplex (multiplex::const_reference value);
    class reverseParameters {
      public:
        typedef NewATMVCCommand_reverseParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reverseParameters
    reverseParameters::const_reference get_reverseParameters () const;
    reverseParameters::reference ref_reverseParameters ();
    reverseParameters::reference set_reverseParameters ();
    reverseParameters::reference set_reverseParameters (reverseParameters::const_reference value);
    void swap(NewATMVCCommand& other);
    NewATMVCCommand * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// ModeElement_type
//

class ModeElement_type : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ModeElement_type(const void* info) : Inherited(info) {}
  public:
    ModeElement_type() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class videoMode {
      public:
        enum Id { id_ = 1 };
        typedef VideoMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoMode

    videoMode::const_reference get_videoMode () const;
    videoMode::reference ref_videoMode (); 
    videoMode::reference select_videoMode (); 
    videoMode::reference select_videoMode (videoMode::const_reference value); 
    bool videoMode_isSelected() const;

    class audioMode {
      public:
        enum Id { id_ = 2 };
        typedef AudioMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioMode

    audioMode::const_reference get_audioMode () const;
    audioMode::reference ref_audioMode (); 
    audioMode::reference select_audioMode (); 
    audioMode::reference select_audioMode (audioMode::const_reference value); 
    bool audioMode_isSelected() const;

    class dataMode {
      public:
        enum Id { id_ = 3 };
        typedef DataMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataMode

    dataMode::const_reference get_dataMode () const;
    dataMode::reference ref_dataMode (); 
    dataMode::reference select_dataMode (); 
    dataMode::reference select_dataMode (dataMode::const_reference value); 
    bool dataMode_isSelected() const;

    class encryptionMode {
      public:
        enum Id { id_ = 4 };
        typedef EncryptionMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionMode

    encryptionMode::const_reference get_encryptionMode () const;
    encryptionMode::reference ref_encryptionMode (); 
    encryptionMode::reference select_encryptionMode (); 
    encryptionMode::reference select_encryptionMode (encryptionMode::const_reference value); 
    bool encryptionMode_isSelected() const;

    class h235Mode {
      public:
        enum Id { id_ = 5 };
        typedef H235Mode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h235Mode

    h235Mode::const_reference get_h235Mode () const;
    h235Mode::reference ref_h235Mode (); 
    h235Mode::reference select_h235Mode (); 
    h235Mode::reference select_h235Mode (h235Mode::const_reference value); 
    bool h235Mode_isSelected() const;

    class multiplexedStreamMode {
      public:
        enum Id { id_ = 6 };
        typedef MultiplexedStreamParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexedStreamMode

    multiplexedStreamMode::const_reference get_multiplexedStreamMode () const;
    multiplexedStreamMode::reference ref_multiplexedStreamMode (); 
    multiplexedStreamMode::reference select_multiplexedStreamMode (); 
    multiplexedStreamMode::reference select_multiplexedStreamMode (multiplexedStreamMode::const_reference value); 
    bool multiplexedStreamMode_isSelected() const;

    ModeElement_type(nonStandard::Id id, nonStandard::const_reference value);
    ModeElement_type(videoMode::Id id, videoMode::const_reference value);
    ModeElement_type(audioMode::Id id, audioMode::const_reference value);
    ModeElement_type(dataMode::Id id, dataMode::const_reference value);
    ModeElement_type(encryptionMode::Id id, encryptionMode::const_reference value);
    ModeElement_type(h235Mode::Id id, h235Mode::const_reference value);
    ModeElement_type(multiplexedStreamMode::Id id, multiplexedStreamMode::const_reference value);
    void swap(ModeElement_type & other);
    ModeElement_type(const ModeElement_type & other)
    : Inherited(other) {} 

    ModeElement_type & operator = (const ModeElement_type & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ModeElement_type * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[7];
#endif
};

//
// ResponseMessage
//

class ResponseMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ResponseMessage(const void* info) : Inherited(info) {}
  public:
    ResponseMessage() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class masterSlaveDeterminationAck {
      public:
        enum Id { id_ = 1 };
        typedef MasterSlaveDeterminationAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterSlaveDeterminationAck

    masterSlaveDeterminationAck::const_reference get_masterSlaveDeterminationAck () const;
    masterSlaveDeterminationAck::reference ref_masterSlaveDeterminationAck (); 
    masterSlaveDeterminationAck::reference select_masterSlaveDeterminationAck (); 
    masterSlaveDeterminationAck::reference select_masterSlaveDeterminationAck (masterSlaveDeterminationAck::const_reference value); 
    bool masterSlaveDeterminationAck_isSelected() const;

    class masterSlaveDeterminationReject {
      public:
        enum Id { id_ = 2 };
        typedef MasterSlaveDeterminationReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterSlaveDeterminationReject

    masterSlaveDeterminationReject::const_reference get_masterSlaveDeterminationReject () const;
    masterSlaveDeterminationReject::reference ref_masterSlaveDeterminationReject (); 
    masterSlaveDeterminationReject::reference select_masterSlaveDeterminationReject (); 
    masterSlaveDeterminationReject::reference select_masterSlaveDeterminationReject (masterSlaveDeterminationReject::const_reference value); 
    bool masterSlaveDeterminationReject_isSelected() const;

    class terminalCapabilitySetAck {
      public:
        enum Id { id_ = 3 };
        typedef TerminalCapabilitySetAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCapabilitySetAck

    terminalCapabilitySetAck::const_reference get_terminalCapabilitySetAck () const;
    terminalCapabilitySetAck::reference ref_terminalCapabilitySetAck (); 
    terminalCapabilitySetAck::reference select_terminalCapabilitySetAck (); 
    terminalCapabilitySetAck::reference select_terminalCapabilitySetAck (terminalCapabilitySetAck::const_reference value); 
    bool terminalCapabilitySetAck_isSelected() const;

    class terminalCapabilitySetReject {
      public:
        enum Id { id_ = 4 };
        typedef TerminalCapabilitySetReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCapabilitySetReject

    terminalCapabilitySetReject::const_reference get_terminalCapabilitySetReject () const;
    terminalCapabilitySetReject::reference ref_terminalCapabilitySetReject (); 
    terminalCapabilitySetReject::reference select_terminalCapabilitySetReject (); 
    terminalCapabilitySetReject::reference select_terminalCapabilitySetReject (terminalCapabilitySetReject::const_reference value); 
    bool terminalCapabilitySetReject_isSelected() const;

    class openLogicalChannelAck {
      public:
        enum Id { id_ = 5 };
        typedef OpenLogicalChannelAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class openLogicalChannelAck

    openLogicalChannelAck::const_reference get_openLogicalChannelAck () const;
    openLogicalChannelAck::reference ref_openLogicalChannelAck (); 
    openLogicalChannelAck::reference select_openLogicalChannelAck (); 
    openLogicalChannelAck::reference select_openLogicalChannelAck (openLogicalChannelAck::const_reference value); 
    bool openLogicalChannelAck_isSelected() const;

    class openLogicalChannelReject {
      public:
        enum Id { id_ = 6 };
        typedef OpenLogicalChannelReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class openLogicalChannelReject

    openLogicalChannelReject::const_reference get_openLogicalChannelReject () const;
    openLogicalChannelReject::reference ref_openLogicalChannelReject (); 
    openLogicalChannelReject::reference select_openLogicalChannelReject (); 
    openLogicalChannelReject::reference select_openLogicalChannelReject (openLogicalChannelReject::const_reference value); 
    bool openLogicalChannelReject_isSelected() const;

    class closeLogicalChannelAck {
      public:
        enum Id { id_ = 7 };
        typedef CloseLogicalChannelAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class closeLogicalChannelAck

    closeLogicalChannelAck::const_reference get_closeLogicalChannelAck () const;
    closeLogicalChannelAck::reference ref_closeLogicalChannelAck (); 
    closeLogicalChannelAck::reference select_closeLogicalChannelAck (); 
    closeLogicalChannelAck::reference select_closeLogicalChannelAck (closeLogicalChannelAck::const_reference value); 
    bool closeLogicalChannelAck_isSelected() const;

    class requestChannelCloseAck {
      public:
        enum Id { id_ = 8 };
        typedef RequestChannelCloseAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestChannelCloseAck

    requestChannelCloseAck::const_reference get_requestChannelCloseAck () const;
    requestChannelCloseAck::reference ref_requestChannelCloseAck (); 
    requestChannelCloseAck::reference select_requestChannelCloseAck (); 
    requestChannelCloseAck::reference select_requestChannelCloseAck (requestChannelCloseAck::const_reference value); 
    bool requestChannelCloseAck_isSelected() const;

    class requestChannelCloseReject {
      public:
        enum Id { id_ = 9 };
        typedef RequestChannelCloseReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestChannelCloseReject

    requestChannelCloseReject::const_reference get_requestChannelCloseReject () const;
    requestChannelCloseReject::reference ref_requestChannelCloseReject (); 
    requestChannelCloseReject::reference select_requestChannelCloseReject (); 
    requestChannelCloseReject::reference select_requestChannelCloseReject (requestChannelCloseReject::const_reference value); 
    bool requestChannelCloseReject_isSelected() const;

    class requestModeAck {
      public:
        enum Id { id_ = 14 };
        typedef RequestModeAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestModeAck

    requestModeAck::const_reference get_requestModeAck () const;
    requestModeAck::reference ref_requestModeAck (); 
    requestModeAck::reference select_requestModeAck (); 
    requestModeAck::reference select_requestModeAck (requestModeAck::const_reference value); 
    bool requestModeAck_isSelected() const;

    class requestModeReject {
      public:
        enum Id { id_ = 15 };
        typedef RequestModeReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestModeReject

    requestModeReject::const_reference get_requestModeReject () const;
    requestModeReject::reference ref_requestModeReject (); 
    requestModeReject::reference select_requestModeReject (); 
    requestModeReject::reference select_requestModeReject (requestModeReject::const_reference value); 
    bool requestModeReject_isSelected() const;

    class roundTripDelayResponse {
      public:
        enum Id { id_ = 16 };
        typedef RoundTripDelayResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class roundTripDelayResponse

    roundTripDelayResponse::const_reference get_roundTripDelayResponse () const;
    roundTripDelayResponse::reference ref_roundTripDelayResponse (); 
    roundTripDelayResponse::reference select_roundTripDelayResponse (); 
    roundTripDelayResponse::reference select_roundTripDelayResponse (roundTripDelayResponse::const_reference value); 
    bool roundTripDelayResponse_isSelected() const;

    class maintenanceLoopAck {
      public:
        enum Id { id_ = 17 };
        typedef MaintenanceLoopAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintenanceLoopAck

    maintenanceLoopAck::const_reference get_maintenanceLoopAck () const;
    maintenanceLoopAck::reference ref_maintenanceLoopAck (); 
    maintenanceLoopAck::reference select_maintenanceLoopAck (); 
    maintenanceLoopAck::reference select_maintenanceLoopAck (maintenanceLoopAck::const_reference value); 
    bool maintenanceLoopAck_isSelected() const;

    class maintenanceLoopReject {
      public:
        enum Id { id_ = 18 };
        typedef MaintenanceLoopReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintenanceLoopReject

    maintenanceLoopReject::const_reference get_maintenanceLoopReject () const;
    maintenanceLoopReject::reference ref_maintenanceLoopReject (); 
    maintenanceLoopReject::reference select_maintenanceLoopReject (); 
    maintenanceLoopReject::reference select_maintenanceLoopReject (maintenanceLoopReject::const_reference value); 
    bool maintenanceLoopReject_isSelected() const;

    class communicationModeResponse {
      public:
        enum Id { id_ = 19 };
        typedef CommunicationModeResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class communicationModeResponse

    communicationModeResponse::const_reference get_communicationModeResponse () const;
    communicationModeResponse::reference ref_communicationModeResponse (); 
    communicationModeResponse::reference select_communicationModeResponse (); 
    communicationModeResponse::reference select_communicationModeResponse (communicationModeResponse::const_reference value); 
    bool communicationModeResponse_isSelected() const;

    class conferenceResponse {
      public:
        enum Id { id_ = 20 };
        typedef ConferenceResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceResponse

    conferenceResponse::const_reference get_conferenceResponse () const;
    conferenceResponse::reference ref_conferenceResponse (); 
    conferenceResponse::reference select_conferenceResponse (); 
    conferenceResponse::reference select_conferenceResponse (conferenceResponse::const_reference value); 
    bool conferenceResponse_isSelected() const;

    class multilinkResponse {
      public:
        enum Id { id_ = 21 };
        typedef MultilinkResponse value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multilinkResponse

    multilinkResponse::const_reference get_multilinkResponse () const;
    multilinkResponse::reference ref_multilinkResponse (); 
    multilinkResponse::reference select_multilinkResponse (); 
    multilinkResponse::reference select_multilinkResponse (multilinkResponse::const_reference value); 
    bool multilinkResponse_isSelected() const;

    class logicalChannelRateAcknowledge {
      public:
        enum Id { id_ = 22 };
        typedef LogicalChannelRateAcknowledge value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelRateAcknowledge

    logicalChannelRateAcknowledge::const_reference get_logicalChannelRateAcknowledge () const;
    logicalChannelRateAcknowledge::reference ref_logicalChannelRateAcknowledge (); 
    logicalChannelRateAcknowledge::reference select_logicalChannelRateAcknowledge (); 
    logicalChannelRateAcknowledge::reference select_logicalChannelRateAcknowledge (logicalChannelRateAcknowledge::const_reference value); 
    bool logicalChannelRateAcknowledge_isSelected() const;

    class logicalChannelRateReject {
      public:
        enum Id { id_ = 23 };
        typedef LogicalChannelRateReject value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelRateReject

    logicalChannelRateReject::const_reference get_logicalChannelRateReject () const;
    logicalChannelRateReject::reference ref_logicalChannelRateReject (); 
    logicalChannelRateReject::reference select_logicalChannelRateReject (); 
    logicalChannelRateReject::reference select_logicalChannelRateReject (logicalChannelRateReject::const_reference value); 
    bool logicalChannelRateReject_isSelected() const;

    ResponseMessage(nonStandard::Id id, nonStandard::const_reference value);
    ResponseMessage(masterSlaveDeterminationAck::Id id, masterSlaveDeterminationAck::const_reference value);
    ResponseMessage(masterSlaveDeterminationReject::Id id, masterSlaveDeterminationReject::const_reference value);
    ResponseMessage(terminalCapabilitySetAck::Id id, terminalCapabilitySetAck::const_reference value);
    ResponseMessage(terminalCapabilitySetReject::Id id, terminalCapabilitySetReject::const_reference value);
    ResponseMessage(openLogicalChannelAck::Id id, openLogicalChannelAck::const_reference value);
    ResponseMessage(openLogicalChannelReject::Id id, openLogicalChannelReject::const_reference value);
    ResponseMessage(closeLogicalChannelAck::Id id, closeLogicalChannelAck::const_reference value);
    ResponseMessage(requestChannelCloseAck::Id id, requestChannelCloseAck::const_reference value);
    ResponseMessage(requestChannelCloseReject::Id id, requestChannelCloseReject::const_reference value);
    ResponseMessage(requestModeAck::Id id, requestModeAck::const_reference value);
    ResponseMessage(requestModeReject::Id id, requestModeReject::const_reference value);
    ResponseMessage(roundTripDelayResponse::Id id, roundTripDelayResponse::const_reference value);
    ResponseMessage(maintenanceLoopAck::Id id, maintenanceLoopAck::const_reference value);
    ResponseMessage(maintenanceLoopReject::Id id, maintenanceLoopReject::const_reference value);
    ResponseMessage(communicationModeResponse::Id id, communicationModeResponse::const_reference value);
    ResponseMessage(conferenceResponse::Id id, conferenceResponse::const_reference value);
    ResponseMessage(multilinkResponse::Id id, multilinkResponse::const_reference value);
    ResponseMessage(logicalChannelRateAcknowledge::Id id, logicalChannelRateAcknowledge::const_reference value);
    ResponseMessage(logicalChannelRateReject::Id id, logicalChannelRateReject::const_reference value);
    void swap(ResponseMessage & other);
    ResponseMessage(const ResponseMessage & other)
    : Inherited(other) {} 

    ResponseMessage & operator = (const ResponseMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ResponseMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[24];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[24];
#endif
};

//
// CommandMessage
//

class CommandMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CommandMessage(const void* info) : Inherited(info) {}
  public:
    CommandMessage() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class maintenanceLoopOffCommand {
      public:
        enum Id { id_ = 1 };
        typedef MaintenanceLoopOffCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintenanceLoopOffCommand

    maintenanceLoopOffCommand::const_reference get_maintenanceLoopOffCommand () const;
    maintenanceLoopOffCommand::reference ref_maintenanceLoopOffCommand (); 
    maintenanceLoopOffCommand::reference select_maintenanceLoopOffCommand (); 
    maintenanceLoopOffCommand::reference select_maintenanceLoopOffCommand (maintenanceLoopOffCommand::const_reference value); 
    bool maintenanceLoopOffCommand_isSelected() const;

    class sendTerminalCapabilitySet {
      public:
        enum Id { id_ = 2 };
        typedef SendTerminalCapabilitySet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendTerminalCapabilitySet

    sendTerminalCapabilitySet::const_reference get_sendTerminalCapabilitySet () const;
    sendTerminalCapabilitySet::reference ref_sendTerminalCapabilitySet (); 
    sendTerminalCapabilitySet::reference select_sendTerminalCapabilitySet (); 
    sendTerminalCapabilitySet::reference select_sendTerminalCapabilitySet (sendTerminalCapabilitySet::const_reference value); 
    bool sendTerminalCapabilitySet_isSelected() const;

    class encryptionCommand {
      public:
        enum Id { id_ = 3 };
        typedef EncryptionCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionCommand

    encryptionCommand::const_reference get_encryptionCommand () const;
    encryptionCommand::reference ref_encryptionCommand (); 
    encryptionCommand::reference select_encryptionCommand (); 
    encryptionCommand::reference select_encryptionCommand (encryptionCommand::const_reference value); 
    bool encryptionCommand_isSelected() const;

    class flowControlCommand {
      public:
        enum Id { id_ = 4 };
        typedef FlowControlCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class flowControlCommand

    flowControlCommand::const_reference get_flowControlCommand () const;
    flowControlCommand::reference ref_flowControlCommand (); 
    flowControlCommand::reference select_flowControlCommand (); 
    flowControlCommand::reference select_flowControlCommand (flowControlCommand::const_reference value); 
    bool flowControlCommand_isSelected() const;

    class endSessionCommand {
      public:
        enum Id { id_ = 5 };
        typedef EndSessionCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endSessionCommand

    endSessionCommand::const_reference get_endSessionCommand () const;
    endSessionCommand::reference ref_endSessionCommand (); 
    endSessionCommand::reference select_endSessionCommand (); 
    endSessionCommand::reference select_endSessionCommand (endSessionCommand::const_reference value); 
    bool endSessionCommand_isSelected() const;

    class miscellaneousCommand {
      public:
        enum Id { id_ = 6 };
        typedef MiscellaneousCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class miscellaneousCommand

    miscellaneousCommand::const_reference get_miscellaneousCommand () const;
    miscellaneousCommand::reference ref_miscellaneousCommand (); 
    miscellaneousCommand::reference select_miscellaneousCommand (); 
    miscellaneousCommand::reference select_miscellaneousCommand (miscellaneousCommand::const_reference value); 
    bool miscellaneousCommand_isSelected() const;

    class communicationModeCommand {
      public:
        enum Id { id_ = 7 };
        typedef CommunicationModeCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class communicationModeCommand

    communicationModeCommand::const_reference get_communicationModeCommand () const;
    communicationModeCommand::reference ref_communicationModeCommand (); 
    communicationModeCommand::reference select_communicationModeCommand (); 
    communicationModeCommand::reference select_communicationModeCommand (communicationModeCommand::const_reference value); 
    bool communicationModeCommand_isSelected() const;

    class conferenceCommand {
      public:
        enum Id { id_ = 8 };
        typedef ConferenceCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceCommand

    conferenceCommand::const_reference get_conferenceCommand () const;
    conferenceCommand::reference ref_conferenceCommand (); 
    conferenceCommand::reference select_conferenceCommand (); 
    conferenceCommand::reference select_conferenceCommand (conferenceCommand::const_reference value); 
    bool conferenceCommand_isSelected() const;

    class h223MultiplexReconfiguration {
      public:
        enum Id { id_ = 9 };
        typedef H223MultiplexReconfiguration value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223MultiplexReconfiguration

    h223MultiplexReconfiguration::const_reference get_h223MultiplexReconfiguration () const;
    h223MultiplexReconfiguration::reference ref_h223MultiplexReconfiguration (); 
    h223MultiplexReconfiguration::reference select_h223MultiplexReconfiguration (); 
    h223MultiplexReconfiguration::reference select_h223MultiplexReconfiguration (h223MultiplexReconfiguration::const_reference value); 
    bool h223MultiplexReconfiguration_isSelected() const;

    class newATMVCCommand {
      public:
        enum Id { id_ = 10 };
        typedef NewATMVCCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class newATMVCCommand

    newATMVCCommand::const_reference get_newATMVCCommand () const;
    newATMVCCommand::reference ref_newATMVCCommand (); 
    newATMVCCommand::reference select_newATMVCCommand (); 
    newATMVCCommand::reference select_newATMVCCommand (newATMVCCommand::const_reference value); 
    bool newATMVCCommand_isSelected() const;

    class mobileMultilinkReconfigurationCommand {
      public:
        enum Id { id_ = 11 };
        typedef MobileMultilinkReconfigurationCommand value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mobileMultilinkReconfigurationCommand

    mobileMultilinkReconfigurationCommand::const_reference get_mobileMultilinkReconfigurationCommand () const;
    mobileMultilinkReconfigurationCommand::reference ref_mobileMultilinkReconfigurationCommand (); 
    mobileMultilinkReconfigurationCommand::reference select_mobileMultilinkReconfigurationCommand (); 
    mobileMultilinkReconfigurationCommand::reference select_mobileMultilinkReconfigurationCommand (mobileMultilinkReconfigurationCommand::const_reference value); 
    bool mobileMultilinkReconfigurationCommand_isSelected() const;

    CommandMessage(nonStandard::Id id, nonStandard::const_reference value);
    CommandMessage(maintenanceLoopOffCommand::Id id, maintenanceLoopOffCommand::const_reference value);
    CommandMessage(sendTerminalCapabilitySet::Id id, sendTerminalCapabilitySet::const_reference value);
    CommandMessage(encryptionCommand::Id id, encryptionCommand::const_reference value);
    CommandMessage(flowControlCommand::Id id, flowControlCommand::const_reference value);
    CommandMessage(endSessionCommand::Id id, endSessionCommand::const_reference value);
    CommandMessage(miscellaneousCommand::Id id, miscellaneousCommand::const_reference value);
    CommandMessage(communicationModeCommand::Id id, communicationModeCommand::const_reference value);
    CommandMessage(conferenceCommand::Id id, conferenceCommand::const_reference value);
    CommandMessage(h223MultiplexReconfiguration::Id id, h223MultiplexReconfiguration::const_reference value);
    CommandMessage(newATMVCCommand::Id id, newATMVCCommand::const_reference value);
    CommandMessage(mobileMultilinkReconfigurationCommand::Id id, mobileMultilinkReconfigurationCommand::const_reference value);
    void swap(CommandMessage & other);
    CommandMessage(const CommandMessage & other)
    : Inherited(other) {} 

    CommandMessage & operator = (const CommandMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CommandMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[12];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[12];
#endif
};

//
// TerminalCapabilitySet
//

class TerminalCapabilitySet : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalCapabilitySet(const void* info) : Inherited(info) {}
  public:
    TerminalCapabilitySet() : Inherited(&theInfo) {}
    TerminalCapabilitySet(const TerminalCapabilitySet & other) : Inherited(other)
    {}
    TerminalCapabilitySet& operator = (const TerminalCapabilitySet& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_multiplexCapability,
      e_capabilityTable,
      e_capabilityDescriptors
    };

    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class protocolIdentifier {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class protocolIdentifier
    protocolIdentifier::const_reference get_protocolIdentifier () const;
    protocolIdentifier::reference ref_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier ();
    protocolIdentifier::reference set_protocolIdentifier (protocolIdentifier::const_reference value);
    class multiplexCapability {
      public:
        typedef MultiplexCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexCapability
    multiplexCapability::const_reference get_multiplexCapability () const;
    multiplexCapability::reference ref_multiplexCapability ();
    multiplexCapability::reference set_multiplexCapability ();
    multiplexCapability::reference set_multiplexCapability (multiplexCapability::const_reference value);
    void omit_multiplexCapability ();
    bool multiplexCapability_isPresent () const;
    class capabilityTable {
      public:
        typedef ASN1::SET_OF<CapabilityTableEntry,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capabilityTable
    capabilityTable::const_reference get_capabilityTable () const;
    capabilityTable::reference ref_capabilityTable ();
    capabilityTable::reference set_capabilityTable ();
    capabilityTable::reference set_capabilityTable (capabilityTable::const_reference value);
    void omit_capabilityTable ();
    bool capabilityTable_isPresent () const;
    class capabilityDescriptors {
      public:
        typedef ASN1::SET_OF<CapabilityDescriptor,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class capabilityDescriptors
    capabilityDescriptors::const_reference get_capabilityDescriptors () const;
    capabilityDescriptors::reference ref_capabilityDescriptors ();
    capabilityDescriptors::reference set_capabilityDescriptors ();
    capabilityDescriptors::reference set_capabilityDescriptors (capabilityDescriptors::const_reference value);
    void omit_capabilityDescriptors ();
    bool capabilityDescriptors_isPresent () const;
    void swap(TerminalCapabilitySet& other);
    TerminalCapabilitySet * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// H2250ModeParameters
//

class H2250ModeParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250ModeParameters(const void* info) : Inherited(info) {}
  public:
    H2250ModeParameters() : Inherited(&theInfo) {}
    H2250ModeParameters(const H2250ModeParameters & other) : Inherited(other)
    {}
    H2250ModeParameters& operator = (const H2250ModeParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_redundancyEncodingMode
    };

    class redundancyEncodingMode {
      public:
        typedef RedundancyEncodingMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncodingMode
    redundancyEncodingMode::const_reference get_redundancyEncodingMode () const;
    redundancyEncodingMode::reference ref_redundancyEncodingMode ();
    redundancyEncodingMode::reference set_redundancyEncodingMode ();
    redundancyEncodingMode::reference set_redundancyEncodingMode (redundancyEncodingMode::const_reference value);
    void omit_redundancyEncodingMode ();
    bool redundancyEncodingMode_isPresent () const;
    void swap(H2250ModeParameters& other);
    H2250ModeParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// ModeElement
//

class ModeElement : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ModeElement(const void* info) : Inherited(info) {}
  public:
    ModeElement() : Inherited(&theInfo) {}
    ModeElement(const ModeElement & other) : Inherited(other)
    {}
    ModeElement& operator = (const ModeElement& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_h223ModeParameters,
      e_v76ModeParameters,
      e_h2250ModeParameters,
      e_genericModeParameters,
      e_multiplexedStreamModeParameters
    };

    class type {
      public:
        typedef ModeElement_type value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    class h223ModeParameters {
      public:
        typedef H223ModeParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223ModeParameters
    h223ModeParameters::const_reference get_h223ModeParameters () const;
    h223ModeParameters::reference ref_h223ModeParameters ();
    h223ModeParameters::reference set_h223ModeParameters ();
    h223ModeParameters::reference set_h223ModeParameters (h223ModeParameters::const_reference value);
    void omit_h223ModeParameters ();
    bool h223ModeParameters_isPresent () const;
    class v76ModeParameters {
      public:
        typedef V76ModeParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v76ModeParameters
    v76ModeParameters::const_reference get_v76ModeParameters () const;
    v76ModeParameters::reference ref_v76ModeParameters ();
    v76ModeParameters::reference set_v76ModeParameters ();
    v76ModeParameters::reference set_v76ModeParameters (v76ModeParameters::const_reference value);
    void omit_v76ModeParameters ();
    bool v76ModeParameters_isPresent () const;
    class h2250ModeParameters {
      public:
        typedef H2250ModeParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250ModeParameters
    h2250ModeParameters::const_reference get_h2250ModeParameters () const;
    h2250ModeParameters::reference ref_h2250ModeParameters ();
    h2250ModeParameters::reference set_h2250ModeParameters ();
    h2250ModeParameters::reference set_h2250ModeParameters (h2250ModeParameters::const_reference value);
    void omit_h2250ModeParameters ();
    bool h2250ModeParameters_isPresent () const;
    class genericModeParameters {
      public:
        typedef GenericCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class genericModeParameters
    genericModeParameters::const_reference get_genericModeParameters () const;
    genericModeParameters::reference ref_genericModeParameters ();
    genericModeParameters::reference set_genericModeParameters ();
    genericModeParameters::reference set_genericModeParameters (genericModeParameters::const_reference value);
    void omit_genericModeParameters ();
    bool genericModeParameters_isPresent () const;
    class multiplexedStreamModeParameters {
      public:
        typedef MultiplexedStreamModeParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexedStreamModeParameters
    multiplexedStreamModeParameters::const_reference get_multiplexedStreamModeParameters () const;
    multiplexedStreamModeParameters::reference ref_multiplexedStreamModeParameters ();
    multiplexedStreamModeParameters::reference set_multiplexedStreamModeParameters ();
    multiplexedStreamModeParameters::reference set_multiplexedStreamModeParameters (multiplexedStreamModeParameters::const_reference value);
    void omit_multiplexedStreamModeParameters ();
    bool multiplexedStreamModeParameters_isPresent () const;
    void swap(ModeElement& other);
    ModeElement * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

typedef ASN1::SET_OF<ModeElement,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  ModeDescription;

//
// RequestMode
//

class RequestMode : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestMode(const void* info) : Inherited(info) {}
  public:
    RequestMode() : Inherited(&theInfo) {}
    RequestMode(const RequestMode & other) : Inherited(other)
    {}
    RequestMode& operator = (const RequestMode& other)
    { Inherited::operator = (other); return *this; } 
    class sequenceNumber {
      public:
        typedef SequenceNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sequenceNumber
    sequenceNumber::const_reference get_sequenceNumber () const;
    sequenceNumber::reference ref_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber ();
    sequenceNumber::reference set_sequenceNumber (sequenceNumber::value_type::int_type value);
    class requestedModes {
      public:
        typedef ASN1::SEQUENCE_OF<ModeDescription,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestedModes
    requestedModes::const_reference get_requestedModes () const;
    requestedModes::reference ref_requestedModes ();
    requestedModes::reference set_requestedModes ();
    requestedModes::reference set_requestedModes (requestedModes::const_reference value);
    void swap(RequestMode& other);
    RequestMode * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RequestMessage
//

class RequestMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RequestMessage(const void* info) : Inherited(info) {}
  public:
    RequestMessage() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class masterSlaveDetermination {
      public:
        enum Id { id_ = 1 };
        typedef MasterSlaveDetermination value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterSlaveDetermination

    masterSlaveDetermination::const_reference get_masterSlaveDetermination () const;
    masterSlaveDetermination::reference ref_masterSlaveDetermination (); 
    masterSlaveDetermination::reference select_masterSlaveDetermination (); 
    masterSlaveDetermination::reference select_masterSlaveDetermination (masterSlaveDetermination::const_reference value); 
    bool masterSlaveDetermination_isSelected() const;

    class terminalCapabilitySet {
      public:
        enum Id { id_ = 2 };
        typedef TerminalCapabilitySet value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCapabilitySet

    terminalCapabilitySet::const_reference get_terminalCapabilitySet () const;
    terminalCapabilitySet::reference ref_terminalCapabilitySet (); 
    terminalCapabilitySet::reference select_terminalCapabilitySet (); 
    terminalCapabilitySet::reference select_terminalCapabilitySet (terminalCapabilitySet::const_reference value); 
    bool terminalCapabilitySet_isSelected() const;

    class openLogicalChannel {
      public:
        enum Id { id_ = 3 };
        typedef OpenLogicalChannel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class openLogicalChannel

    openLogicalChannel::const_reference get_openLogicalChannel () const;
    openLogicalChannel::reference ref_openLogicalChannel (); 
    openLogicalChannel::reference select_openLogicalChannel (); 
    openLogicalChannel::reference select_openLogicalChannel (openLogicalChannel::const_reference value); 
    bool openLogicalChannel_isSelected() const;

    class closeLogicalChannel {
      public:
        enum Id { id_ = 4 };
        typedef CloseLogicalChannel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class closeLogicalChannel

    closeLogicalChannel::const_reference get_closeLogicalChannel () const;
    closeLogicalChannel::reference ref_closeLogicalChannel (); 
    closeLogicalChannel::reference select_closeLogicalChannel (); 
    closeLogicalChannel::reference select_closeLogicalChannel (closeLogicalChannel::const_reference value); 
    bool closeLogicalChannel_isSelected() const;

    class requestChannelClose {
      public:
        enum Id { id_ = 5 };
        typedef RequestChannelClose value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestChannelClose

    requestChannelClose::const_reference get_requestChannelClose () const;
    requestChannelClose::reference ref_requestChannelClose (); 
    requestChannelClose::reference select_requestChannelClose (); 
    requestChannelClose::reference select_requestChannelClose (requestChannelClose::const_reference value); 
    bool requestChannelClose_isSelected() const;

    class requestMode {
      public:
        enum Id { id_ = 8 };
        typedef RequestMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestMode

    requestMode::const_reference get_requestMode () const;
    requestMode::reference ref_requestMode (); 
    requestMode::reference select_requestMode (); 
    requestMode::reference select_requestMode (requestMode::const_reference value); 
    bool requestMode_isSelected() const;

    class roundTripDelayRequest {
      public:
        enum Id { id_ = 9 };
        typedef RoundTripDelayRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class roundTripDelayRequest

    roundTripDelayRequest::const_reference get_roundTripDelayRequest () const;
    roundTripDelayRequest::reference ref_roundTripDelayRequest (); 
    roundTripDelayRequest::reference select_roundTripDelayRequest (); 
    roundTripDelayRequest::reference select_roundTripDelayRequest (roundTripDelayRequest::const_reference value); 
    bool roundTripDelayRequest_isSelected() const;

    class maintenanceLoopRequest {
      public:
        enum Id { id_ = 10 };
        typedef MaintenanceLoopRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maintenanceLoopRequest

    maintenanceLoopRequest::const_reference get_maintenanceLoopRequest () const;
    maintenanceLoopRequest::reference ref_maintenanceLoopRequest (); 
    maintenanceLoopRequest::reference select_maintenanceLoopRequest (); 
    maintenanceLoopRequest::reference select_maintenanceLoopRequest (maintenanceLoopRequest::const_reference value); 
    bool maintenanceLoopRequest_isSelected() const;

    class communicationModeRequest {
      public:
        enum Id { id_ = 11 };
        typedef CommunicationModeRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class communicationModeRequest

    communicationModeRequest::const_reference get_communicationModeRequest () const;
    communicationModeRequest::reference ref_communicationModeRequest (); 
    communicationModeRequest::reference select_communicationModeRequest (); 
    communicationModeRequest::reference select_communicationModeRequest (communicationModeRequest::const_reference value); 
    bool communicationModeRequest_isSelected() const;

    class conferenceRequest {
      public:
        enum Id { id_ = 12 };
        typedef ConferenceRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceRequest

    conferenceRequest::const_reference get_conferenceRequest () const;
    conferenceRequest::reference ref_conferenceRequest (); 
    conferenceRequest::reference select_conferenceRequest (); 
    conferenceRequest::reference select_conferenceRequest (conferenceRequest::const_reference value); 
    bool conferenceRequest_isSelected() const;

    class multilinkRequest {
      public:
        enum Id { id_ = 13 };
        typedef MultilinkRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multilinkRequest

    multilinkRequest::const_reference get_multilinkRequest () const;
    multilinkRequest::reference ref_multilinkRequest (); 
    multilinkRequest::reference select_multilinkRequest (); 
    multilinkRequest::reference select_multilinkRequest (multilinkRequest::const_reference value); 
    bool multilinkRequest_isSelected() const;

    class logicalChannelRateRequest {
      public:
        enum Id { id_ = 14 };
        typedef LogicalChannelRateRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelRateRequest

    logicalChannelRateRequest::const_reference get_logicalChannelRateRequest () const;
    logicalChannelRateRequest::reference ref_logicalChannelRateRequest (); 
    logicalChannelRateRequest::reference select_logicalChannelRateRequest (); 
    logicalChannelRateRequest::reference select_logicalChannelRateRequest (logicalChannelRateRequest::const_reference value); 
    bool logicalChannelRateRequest_isSelected() const;

    RequestMessage(nonStandard::Id id, nonStandard::const_reference value);
    RequestMessage(masterSlaveDetermination::Id id, masterSlaveDetermination::const_reference value);
    RequestMessage(terminalCapabilitySet::Id id, terminalCapabilitySet::const_reference value);
    RequestMessage(openLogicalChannel::Id id, openLogicalChannel::const_reference value);
    RequestMessage(closeLogicalChannel::Id id, closeLogicalChannel::const_reference value);
    RequestMessage(requestChannelClose::Id id, requestChannelClose::const_reference value);
    RequestMessage(requestMode::Id id, requestMode::const_reference value);
    RequestMessage(roundTripDelayRequest::Id id, roundTripDelayRequest::const_reference value);
    RequestMessage(maintenanceLoopRequest::Id id, maintenanceLoopRequest::const_reference value);
    RequestMessage(communicationModeRequest::Id id, communicationModeRequest::const_reference value);
    RequestMessage(conferenceRequest::Id id, conferenceRequest::const_reference value);
    RequestMessage(multilinkRequest::Id id, multilinkRequest::const_reference value);
    RequestMessage(logicalChannelRateRequest::Id id, logicalChannelRateRequest::const_reference value);
    void swap(RequestMessage & other);
    RequestMessage(const RequestMessage & other)
    : Inherited(other) {} 

    RequestMessage & operator = (const RequestMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RequestMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[15];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[15];
#endif
};

//
// FunctionNotUnderstood
//

class FunctionNotUnderstood : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    FunctionNotUnderstood(const void* info) : Inherited(info) {}
  public:
    FunctionNotUnderstood() : Inherited(&theInfo) {}
    class request {
      public:
        enum Id { id_ = 0 };
        typedef RequestMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class request

    request::const_reference get_request () const;
    request::reference ref_request (); 
    request::reference select_request (); 
    request::reference select_request (request::const_reference value); 
    bool request_isSelected() const;

    class response {
      public:
        enum Id { id_ = 1 };
        typedef ResponseMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class response

    response::const_reference get_response () const;
    response::reference ref_response (); 
    response::reference select_response (); 
    response::reference select_response (response::const_reference value); 
    bool response_isSelected() const;

    class command {
      public:
        enum Id { id_ = 2 };
        typedef CommandMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class command

    command::const_reference get_command () const;
    command::reference ref_command (); 
    command::reference select_command (); 
    command::reference select_command (command::const_reference value); 
    bool command_isSelected() const;

    FunctionNotUnderstood(request::Id id, request::const_reference value);
    FunctionNotUnderstood(response::Id id, response::const_reference value);
    FunctionNotUnderstood(command::Id id, command::const_reference value);
    void swap(FunctionNotUnderstood & other);
    FunctionNotUnderstood(const FunctionNotUnderstood & other)
    : Inherited(other) {} 

    FunctionNotUnderstood & operator = (const FunctionNotUnderstood & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    FunctionNotUnderstood * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// IndicationMessage
//

class IndicationMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IndicationMessage(const void* info) : Inherited(info) {}
  public:
    IndicationMessage() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class functionNotUnderstood {
      public:
        enum Id { id_ = 1 };
        typedef FunctionNotUnderstood value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class functionNotUnderstood

    functionNotUnderstood::const_reference get_functionNotUnderstood () const;
    functionNotUnderstood::reference ref_functionNotUnderstood (); 
    functionNotUnderstood::reference select_functionNotUnderstood (); 
    functionNotUnderstood::reference select_functionNotUnderstood (functionNotUnderstood::const_reference value); 
    bool functionNotUnderstood_isSelected() const;

    class masterSlaveDeterminationRelease {
      public:
        enum Id { id_ = 2 };
        typedef MasterSlaveDeterminationRelease value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterSlaveDeterminationRelease

    masterSlaveDeterminationRelease::const_reference get_masterSlaveDeterminationRelease () const;
    masterSlaveDeterminationRelease::reference ref_masterSlaveDeterminationRelease (); 
    masterSlaveDeterminationRelease::reference select_masterSlaveDeterminationRelease (); 
    masterSlaveDeterminationRelease::reference select_masterSlaveDeterminationRelease (masterSlaveDeterminationRelease::const_reference value); 
    bool masterSlaveDeterminationRelease_isSelected() const;

    class terminalCapabilitySetRelease {
      public:
        enum Id { id_ = 3 };
        typedef TerminalCapabilitySetRelease value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalCapabilitySetRelease

    terminalCapabilitySetRelease::const_reference get_terminalCapabilitySetRelease () const;
    terminalCapabilitySetRelease::reference ref_terminalCapabilitySetRelease (); 
    terminalCapabilitySetRelease::reference select_terminalCapabilitySetRelease (); 
    terminalCapabilitySetRelease::reference select_terminalCapabilitySetRelease (terminalCapabilitySetRelease::const_reference value); 
    bool terminalCapabilitySetRelease_isSelected() const;

    class openLogicalChannelConfirm {
      public:
        enum Id { id_ = 4 };
        typedef OpenLogicalChannelConfirm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class openLogicalChannelConfirm

    openLogicalChannelConfirm::const_reference get_openLogicalChannelConfirm () const;
    openLogicalChannelConfirm::reference ref_openLogicalChannelConfirm (); 
    openLogicalChannelConfirm::reference select_openLogicalChannelConfirm (); 
    openLogicalChannelConfirm::reference select_openLogicalChannelConfirm (openLogicalChannelConfirm::const_reference value); 
    bool openLogicalChannelConfirm_isSelected() const;

    class requestChannelCloseRelease {
      public:
        enum Id { id_ = 5 };
        typedef RequestChannelCloseRelease value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestChannelCloseRelease

    requestChannelCloseRelease::const_reference get_requestChannelCloseRelease () const;
    requestChannelCloseRelease::reference ref_requestChannelCloseRelease (); 
    requestChannelCloseRelease::reference select_requestChannelCloseRelease (); 
    requestChannelCloseRelease::reference select_requestChannelCloseRelease (requestChannelCloseRelease::const_reference value); 
    bool requestChannelCloseRelease_isSelected() const;

    class requestModeRelease {
      public:
        enum Id { id_ = 8 };
        typedef RequestModeRelease value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestModeRelease

    requestModeRelease::const_reference get_requestModeRelease () const;
    requestModeRelease::reference ref_requestModeRelease (); 
    requestModeRelease::reference select_requestModeRelease (); 
    requestModeRelease::reference select_requestModeRelease (requestModeRelease::const_reference value); 
    bool requestModeRelease_isSelected() const;

    class miscellaneousIndication {
      public:
        enum Id { id_ = 9 };
        typedef MiscellaneousIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class miscellaneousIndication

    miscellaneousIndication::const_reference get_miscellaneousIndication () const;
    miscellaneousIndication::reference ref_miscellaneousIndication (); 
    miscellaneousIndication::reference select_miscellaneousIndication (); 
    miscellaneousIndication::reference select_miscellaneousIndication (miscellaneousIndication::const_reference value); 
    bool miscellaneousIndication_isSelected() const;

    class jitterIndication {
      public:
        enum Id { id_ = 10 };
        typedef JitterIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class jitterIndication

    jitterIndication::const_reference get_jitterIndication () const;
    jitterIndication::reference ref_jitterIndication (); 
    jitterIndication::reference select_jitterIndication (); 
    jitterIndication::reference select_jitterIndication (jitterIndication::const_reference value); 
    bool jitterIndication_isSelected() const;

    class userInput {
      public:
        enum Id { id_ = 13 };
        typedef UserInputIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class userInput

    userInput::const_reference get_userInput () const;
    userInput::reference ref_userInput (); 
    userInput::reference select_userInput (); 
    userInput::reference select_userInput (userInput::const_reference value); 
    bool userInput_isSelected() const;

    class h2250MaximumSkewIndication {
      public:
        enum Id { id_ = 14 };
        typedef H2250MaximumSkewIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250MaximumSkewIndication

    h2250MaximumSkewIndication::const_reference get_h2250MaximumSkewIndication () const;
    h2250MaximumSkewIndication::reference ref_h2250MaximumSkewIndication (); 
    h2250MaximumSkewIndication::reference select_h2250MaximumSkewIndication (); 
    h2250MaximumSkewIndication::reference select_h2250MaximumSkewIndication (h2250MaximumSkewIndication::const_reference value); 
    bool h2250MaximumSkewIndication_isSelected() const;

    class mcLocationIndication {
      public:
        enum Id { id_ = 15 };
        typedef MCLocationIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mcLocationIndication

    mcLocationIndication::const_reference get_mcLocationIndication () const;
    mcLocationIndication::reference ref_mcLocationIndication (); 
    mcLocationIndication::reference select_mcLocationIndication (); 
    mcLocationIndication::reference select_mcLocationIndication (mcLocationIndication::const_reference value); 
    bool mcLocationIndication_isSelected() const;

    class conferenceIndication {
      public:
        enum Id { id_ = 16 };
        typedef ConferenceIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class conferenceIndication

    conferenceIndication::const_reference get_conferenceIndication () const;
    conferenceIndication::reference ref_conferenceIndication (); 
    conferenceIndication::reference select_conferenceIndication (); 
    conferenceIndication::reference select_conferenceIndication (conferenceIndication::const_reference value); 
    bool conferenceIndication_isSelected() const;

    class vendorIdentification {
      public:
        enum Id { id_ = 17 };
        typedef VendorIdentification value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class vendorIdentification

    vendorIdentification::const_reference get_vendorIdentification () const;
    vendorIdentification::reference ref_vendorIdentification (); 
    vendorIdentification::reference select_vendorIdentification (); 
    vendorIdentification::reference select_vendorIdentification (vendorIdentification::const_reference value); 
    bool vendorIdentification_isSelected() const;

    class functionNotSupported {
      public:
        enum Id { id_ = 18 };
        typedef FunctionNotSupported value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class functionNotSupported

    functionNotSupported::const_reference get_functionNotSupported () const;
    functionNotSupported::reference ref_functionNotSupported (); 
    functionNotSupported::reference select_functionNotSupported (); 
    functionNotSupported::reference select_functionNotSupported (functionNotSupported::const_reference value); 
    bool functionNotSupported_isSelected() const;

    class multilinkIndication {
      public:
        enum Id { id_ = 19 };
        typedef MultilinkIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multilinkIndication

    multilinkIndication::const_reference get_multilinkIndication () const;
    multilinkIndication::reference ref_multilinkIndication (); 
    multilinkIndication::reference select_multilinkIndication (); 
    multilinkIndication::reference select_multilinkIndication (multilinkIndication::const_reference value); 
    bool multilinkIndication_isSelected() const;

    class logicalChannelRateRelease {
      public:
        enum Id { id_ = 20 };
        typedef LogicalChannelRateRelease value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class logicalChannelRateRelease

    logicalChannelRateRelease::const_reference get_logicalChannelRateRelease () const;
    logicalChannelRateRelease::reference ref_logicalChannelRateRelease (); 
    logicalChannelRateRelease::reference select_logicalChannelRateRelease (); 
    logicalChannelRateRelease::reference select_logicalChannelRateRelease (logicalChannelRateRelease::const_reference value); 
    bool logicalChannelRateRelease_isSelected() const;

    class flowControlIndication {
      public:
        enum Id { id_ = 21 };
        typedef FlowControlIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class flowControlIndication

    flowControlIndication::const_reference get_flowControlIndication () const;
    flowControlIndication::reference ref_flowControlIndication (); 
    flowControlIndication::reference select_flowControlIndication (); 
    flowControlIndication::reference select_flowControlIndication (flowControlIndication::const_reference value); 
    bool flowControlIndication_isSelected() const;

    class mobileMultilinkReconfigurationIndication {
      public:
        enum Id { id_ = 22 };
        typedef MobileMultilinkReconfigurationIndication value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mobileMultilinkReconfigurationIndication

    mobileMultilinkReconfigurationIndication::const_reference get_mobileMultilinkReconfigurationIndication () const;
    mobileMultilinkReconfigurationIndication::reference ref_mobileMultilinkReconfigurationIndication (); 
    mobileMultilinkReconfigurationIndication::reference select_mobileMultilinkReconfigurationIndication (); 
    mobileMultilinkReconfigurationIndication::reference select_mobileMultilinkReconfigurationIndication (mobileMultilinkReconfigurationIndication::const_reference value); 
    bool mobileMultilinkReconfigurationIndication_isSelected() const;

    IndicationMessage(nonStandard::Id id, nonStandard::const_reference value);
    IndicationMessage(functionNotUnderstood::Id id, functionNotUnderstood::const_reference value);
    IndicationMessage(masterSlaveDeterminationRelease::Id id, masterSlaveDeterminationRelease::const_reference value);
    IndicationMessage(terminalCapabilitySetRelease::Id id, terminalCapabilitySetRelease::const_reference value);
    IndicationMessage(openLogicalChannelConfirm::Id id, openLogicalChannelConfirm::const_reference value);
    IndicationMessage(requestChannelCloseRelease::Id id, requestChannelCloseRelease::const_reference value);
    IndicationMessage(requestModeRelease::Id id, requestModeRelease::const_reference value);
    IndicationMessage(miscellaneousIndication::Id id, miscellaneousIndication::const_reference value);
    IndicationMessage(jitterIndication::Id id, jitterIndication::const_reference value);
    IndicationMessage(userInput::Id id, userInput::const_reference value);
    IndicationMessage(h2250MaximumSkewIndication::Id id, h2250MaximumSkewIndication::const_reference value);
    IndicationMessage(mcLocationIndication::Id id, mcLocationIndication::const_reference value);
    IndicationMessage(conferenceIndication::Id id, conferenceIndication::const_reference value);
    IndicationMessage(vendorIdentification::Id id, vendorIdentification::const_reference value);
    IndicationMessage(functionNotSupported::Id id, functionNotSupported::const_reference value);
    IndicationMessage(multilinkIndication::Id id, multilinkIndication::const_reference value);
    IndicationMessage(logicalChannelRateRelease::Id id, logicalChannelRateRelease::const_reference value);
    IndicationMessage(flowControlIndication::Id id, flowControlIndication::const_reference value);
    IndicationMessage(mobileMultilinkReconfigurationIndication::Id id, mobileMultilinkReconfigurationIndication::const_reference value);
    void swap(IndicationMessage & other);
    IndicationMessage(const IndicationMessage & other)
    : Inherited(other) {} 

    IndicationMessage & operator = (const IndicationMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IndicationMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[23];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[23];
#endif
};

//
// MultimediaSystemControlMessage
//

class MultimediaSystemControlMessage : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MultimediaSystemControlMessage(const void* info) : Inherited(info) {}
  public:
    MultimediaSystemControlMessage() : Inherited(&theInfo) {}
    class request {
      public:
        enum Id { id_ = 0 };
        typedef RequestMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class request

    request::const_reference get_request () const;
    request::reference ref_request (); 
    request::reference select_request (); 
    request::reference select_request (request::const_reference value); 
    bool request_isSelected() const;

    class response {
      public:
        enum Id { id_ = 1 };
        typedef ResponseMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class response

    response::const_reference get_response () const;
    response::reference ref_response (); 
    response::reference select_response (); 
    response::reference select_response (response::const_reference value); 
    bool response_isSelected() const;

    class command {
      public:
        enum Id { id_ = 2 };
        typedef CommandMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class command

    command::const_reference get_command () const;
    command::reference ref_command (); 
    command::reference select_command (); 
    command::reference select_command (command::const_reference value); 
    bool command_isSelected() const;

    class indication {
      public:
        enum Id { id_ = 3 };
        typedef IndicationMessage value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class indication

    indication::const_reference get_indication () const;
    indication::reference ref_indication (); 
    indication::reference select_indication (); 
    indication::reference select_indication (indication::const_reference value); 
    bool indication_isSelected() const;

    MultimediaSystemControlMessage(request::Id id, request::const_reference value);
    MultimediaSystemControlMessage(response::Id id, response::const_reference value);
    MultimediaSystemControlMessage(command::Id id, command::const_reference value);
    MultimediaSystemControlMessage(indication::Id id, indication::const_reference value);
    void swap(MultimediaSystemControlMessage & other);
    MultimediaSystemControlMessage(const MultimediaSystemControlMessage & other)
    : Inherited(other) {} 

    MultimediaSystemControlMessage & operator = (const MultimediaSystemControlMessage & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MultimediaSystemControlMessage * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

#include "multimedia_system_control.inl"
} // namespace MULTIMEDIA_SYSTEM_CONTROL

#endif // __MULTIMEDIA_SYSTEM_CONTROL_H


// End of multimedia_system_control.h
