//
// remote_operations_information_objects.h
//
// Code automatically generated by asnparser.
//

#ifndef __REMOTE_OPERATIONS_INFORMATION_OBJECTS_H
#define __REMOTE_OPERATIONS_INFORMATION_OBJECTS_H

#include <asn1.h>

namespace Remote_Operations_Information_Objects {

//
// Code
//

class Code : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Code(const void* info) : Inherited(info) {}
  public:
    Code() : Inherited(&theInfo) {}
    class local {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::INTEGER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class local

    local::const_reference get_local () const;
    local::reference ref_local (); 
    local::reference select_local (); 
    local::reference select_local (local::value_type::int_type value); 
    bool local_isSelected() const;

    class global {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class global

    global::const_reference get_global () const;
    global::reference ref_global (); 
    global::reference select_global (); 
    global::reference select_global (global::const_reference value); 
    bool global_isSelected() const;

    Code(local::Id id, local::value_type::int_type value);
    Code(global::Id id, global::const_reference value);
    void swap(Code & other);
    Code(const Code & other)
    : Inherited(other) {} 

    Code & operator = (const Code & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Code * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
    static unsigned selectionTags[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::PartiallyConstrained, 0, INT_MAX>  Priority;


//
// OPERATION
//

#undef ERROR
class ERROR;

class OPERATION
{
  public:
    typedef Code key_type;
    class info_type
    {
      public:
        info_type();
        ASN1::AbstractData* get_ArgumentType() const { return m_ArgumentType ? ASN1::AbstractData::create(m_ArgumentType) : NULL; }
        ASN1::AbstractData* get_ResultType() const { return m_ResultType ? ASN1::AbstractData::create(m_ResultType) : NULL; }
        const ERROR* get_Errors() const { return m_Errors; }
        const OPERATION* get_Linked() const { return m_Linked; }
      protected:
        const void* m_ArgumentType;
        const void* m_ResultType;
        const ERROR* m_Errors;
        const OPERATION* m_Linked;
    };

    typedef const info_type* mapped_type;

    class value_type : public std::pair<key_type, mapped_type>
    {
        typedef std::pair<key_type, mapped_type> Inherited;
      public:
        value_type(const key_type& key, mapped_type mt) : Inherited(key,mt) {}
        ASN1::AbstractData* get_ArgumentType() const { return second->get_ArgumentType(); }
        ASN1::AbstractData* get_ResultType() const { return second->get_ResultType(); }
        const ERROR* get_Errors() const { return second->get_Errors(); }
        const OPERATION* get_Linked() const { return second->get_Linked(); }
    };

    typedef value_type& reference;
    typedef const value_type& const_reference;
    typedef value_type* pointer;
    typedef const value_type* const_pointer;
    typedef Loki::AssocVector<key_type, mapped_type> map_type;

  private:
    typedef boost::iterator<std::bidirectional_iterator_tag, value_type> my_iterator_traits;
    typedef boost::iterator<std::bidirectional_iterator_tag, const value_type> my_const_iterator_traits;
  public:
    class iterator : public my_iterator_traits
    {
      public:
        iterator() {}
        iterator(map_type::iterator i) : itsIter(i) {}
        map_type::iterator base() const {return itsIter;}
        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}
        iterator& operator++()          {++itsIter; return *this;}
        iterator& operator--()          {--itsIter; return *this;}
        iterator operator++(int)        {iterator t(*this); ++itsIter; return t;}
        iterator operator--(int)        {iterator t(*this); --itsIter; return t;}

        bool operator==(const iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::iterator itsIter;
    };
    class const_iterator : public my_const_iterator_traits
    {
      public:
        const_iterator() {}
        const_iterator(OPERATION::iterator i) : itsIter(i.base()) {}
        const_iterator(map_type::const_iterator i) : itsIter(i) {}
        map_type::const_iterator base() const {return itsIter;}

        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}

        const_iterator& operator++()          {++itsIter; return *this;}
        const_iterator& operator--()          {--itsIter; return *this;}
        const_iterator operator++(int)        {const_iterator t(*this); ++itsIter; return t;}
        const_iterator operator--(int)        {const_iterator t(*this); --itsIter; return t;}

        bool operator==(const const_iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const const_iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::const_iterator itsIter;
    };

#if defined(BOOST_NO_STD_ITERATOR) || defined (BOOST_MSVC_STD_ITERATOR)
    typedef std::reverse_bidirectional_iterator<iterator, value_type> reverse_iterator;
    typedef std::reverse_bidirectional_iterator<const_iterator, const value_type> const_reverse_iterator;
#else
    typedef std::reverse_iterator<iterator> reverse_iterator;
    typedef std::reverse_iterator<const_iterator> const_reverse_iterator;
#endif

    typedef map_type::key_compare key_compare;
    typedef map_type::difference_type difference_type;
    typedef map_type::size_type size_type;

    OPERATION(){}
    template <class InputIterator>
            OPERATION(InputIterator first, InputIterator last)
        : rep(first, last) {}
    OPERATION(const OPERATION& other)
        : rep(other.rep) {}

        OPERATION& operator = (const OPERATION& other)
    { OPERATION tmp(other); swap(tmp);  return *this; }

    // iterators
    iterator begin() { return iterator(rep.begin());}
    const_iterator begin() const { return const_iterator(rep.begin());}
    iterator end() { return iterator(rep.end()); }
    const_iterator end() const { return const_iterator(rep.end()); }

    reverse_iterator rbegin() { return reverse_iterator(end());}
    const_reverse_iterator rbegin() const { return const_reverse_iterator(end());}
    reverse_iterator rend() { return reverse_iterator(begin()); }
    const_reverse_iterator rend() const { return const_reverse_iterator(begin()); }
    // capacity
    bool empty() const { return rep.empty(); }
    size_type size() const { return rep.size(); }
    // modifiers
    std::pair<iterator, bool> insert(const value_type& x)
    { 
        std::pair<map_type::iterator, bool> r = rep.insert(x); 
        return std::pair<iterator, bool>(r.first, r.second);
    }
    iterator insert(iterator position, const value_type& x)
    { return iterator(rep.insert(position.base(), x)); }
    void insert(const_iterator first, const_iterator last)
    { rep.insert(first.base(), last.base()); }
    void erase(iterator position) { rep.erase(position.base()); }
    void erase(const key_type& key) { rep.erase(key); }
    void erase(iterator first, iterator last) { rep.erase(first.base(), last.base()); }
    void swap(OPERATION& other) { rep.swap(other.rep); }
    void clear() { rep.clear(); }
    key_compare key_comp() const { return rep.key_comp(); }
    // operations
    iterator find(const key_type& key) { return iterator(rep.find(key)); }
    const_iterator find(const key_type& key) const { return const_iterator(rep.find(key)); }
    size_type count(const key_type& key) const { return rep.count(key); }
  private:
    map_type rep;
};

//
// ERROR
//

class ERROR
{
  public:
    typedef Code key_type;
    class info_type
    {
      public:
        info_type();
        ASN1::AbstractData* get_ParameterType() const { return m_ParameterType ? ASN1::AbstractData::create(m_ParameterType) : NULL; }
      protected:
        const void* m_ParameterType;
    };

    typedef const info_type* mapped_type;

    class value_type : public std::pair<key_type, mapped_type>
    {
        typedef std::pair<key_type, mapped_type> Inherited;
      public:
        value_type(const key_type& key, mapped_type mt) : Inherited(key,mt) {}
        ASN1::AbstractData* get_ParameterType() const { return second->get_ParameterType(); }
    };

    typedef value_type& reference;
    typedef const value_type& const_reference;
    typedef value_type* pointer;
    typedef const value_type* const_pointer;
    typedef Loki::AssocVector<key_type, mapped_type> map_type;

  private:
    typedef boost::iterator<std::bidirectional_iterator_tag, value_type> my_iterator_traits;
    typedef boost::iterator<std::bidirectional_iterator_tag, const value_type> my_const_iterator_traits;
  public:
    class iterator : public my_iterator_traits
    {
      public:
        iterator() {}
        iterator(map_type::iterator i) : itsIter(i) {}
        map_type::iterator base() const {return itsIter;}
        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}
        iterator& operator++()          {++itsIter; return *this;}
        iterator& operator--()          {--itsIter; return *this;}
        iterator operator++(int)        {iterator t(*this); ++itsIter; return t;}
        iterator operator--(int)        {iterator t(*this); --itsIter; return t;}

        bool operator==(const iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::iterator itsIter;
    };
    class const_iterator : public my_const_iterator_traits
    {
      public:
        const_iterator() {}
        const_iterator(ERROR::iterator i) : itsIter(i.base()) {}
        const_iterator(map_type::const_iterator i) : itsIter(i) {}
        map_type::const_iterator base() const {return itsIter;}

        reference operator*() const {return *static_cast<pointer>(&*itsIter);}
        pointer operator->() const {return static_cast<pointer>(&*itsIter);}

        const_iterator& operator++()          {++itsIter; return *this;}
        const_iterator& operator--()          {--itsIter; return *this;}
        const_iterator operator++(int)        {const_iterator t(*this); ++itsIter; return t;}
        const_iterator operator--(int)        {const_iterator t(*this); --itsIter; return t;}

        bool operator==(const const_iterator& r) const    {return itsIter == r.itsIter;}
        bool operator!=(const const_iterator& r) const    {return itsIter != r.itsIter;}
      private:
        map_type::const_iterator itsIter;
    };

#if defined(BOOST_NO_STD_ITERATOR) || defined (BOOST_MSVC_STD_ITERATOR)
    typedef std::reverse_bidirectional_iterator<iterator, value_type> reverse_iterator;
    typedef std::reverse_bidirectional_iterator<const_iterator, const value_type> const_reverse_iterator;
#else
    typedef std::reverse_iterator<iterator> reverse_iterator;
    typedef std::reverse_iterator<const_iterator> const_reverse_iterator;
#endif

    typedef map_type::key_compare key_compare;
    typedef map_type::difference_type difference_type;
    typedef map_type::size_type size_type;

    ERROR(){}
    template <class InputIterator>
            ERROR(InputIterator first, InputIterator last)
        : rep(first, last) {}
    ERROR(const ERROR& other)
        : rep(other.rep) {}

        ERROR& operator = (const ERROR& other)
    { ERROR tmp(other); swap(tmp);  return *this; }

    // iterators
    iterator begin() { return iterator(rep.begin());}
    const_iterator begin() const { return const_iterator(rep.begin());}
    iterator end() { return iterator(rep.end()); }
    const_iterator end() const { return const_iterator(rep.end()); }

    reverse_iterator rbegin() { return reverse_iterator(end());}
    const_reverse_iterator rbegin() const { return const_reverse_iterator(end());}
    reverse_iterator rend() { return reverse_iterator(begin()); }
    const_reverse_iterator rend() const { return const_reverse_iterator(begin()); }
    // capacity
    bool empty() const { return rep.empty(); }
    size_type size() const { return rep.size(); }
    // modifiers
    std::pair<iterator, bool> insert(const value_type& x)
    { 
        std::pair<map_type::iterator, bool> r = rep.insert(x); 
        return std::pair<iterator, bool>(r.first, r.second);
    }
    iterator insert(iterator position, const value_type& x)
    { return iterator(rep.insert(position.base(), x)); }
    void insert(const_iterator first, const_iterator last)
    { rep.insert(first.base(), last.base()); }
    void erase(iterator position) { rep.erase(position.base()); }
    void erase(const key_type& key) { rep.erase(key); }
    void erase(iterator first, iterator last) { rep.erase(first.base(), last.base()); }
    void swap(ERROR& other) { rep.swap(other.rep); }
    void clear() { rep.clear(); }
    key_compare key_comp() const { return rep.key_comp(); }
    // operations
    iterator find(const key_type& key) { return iterator(rep.find(key)); }
    const_iterator find(const key_type& key) const { return const_iterator(rep.find(key)); }
    size_type count(const key_type& key) const { return rep.count(key); }
  private:
    map_type rep;
};
#include "remote_operations_information_objects.inl"
} // namespace Remote_Operations_Information_Objects

#endif // __REMOTE_OPERATIONS_INFORMATION_OBJECTS_H


// End of remote_operations_information_objects.h
