/*
  This file is a part of Qosmos ixEngine.

   Copyright  Qosmos 2021 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Qosmos ixEngine header */
#include <qmdpi.h>
/* Bundle header */
#include <qmdpi_bundle_api.h>

#include "customize.h"

/*
 * flags for custom configuration
 */
#undef DI_TCP_REASS_ENABLE
#undef DI_BASIC_DPI_ENABLE
#undef DI_OFFLOADING_TUNNELING_ENABLE

/*
 * flags for tunes
 */
#undef DI_BITTORENT_MAXIMUM_TRACKER_PEERS_COUNT_SET

/*
 * flags for attributes
 */
#undef DI_HOOK_HTTP_SERVER_ENABLE

extern char config_line[CONFIG_STR_SIZE];

/* add param to config line */
void di_config_line_add(char *config_line, const char *param, uint64_t value)
{
    int ret;
    char param_string[CONFIG_STR_SIZE];
    ret = snprintf(param_string, sizeof(param_string), "%s=%lu;", param, value);

    if (ret < 0 || ret >= 128) {
        fprintf(stderr,
                "error buffer for DPI configuration\n");
        exit(1);
    }

    strncat(config_line, param_string, CONFIG_STR_SIZE - strlen(param_string) - 1);
    return;
}

/*
 * custom configuration
 */
int
di_custom_engine_configuration(void)
{
    int ret = 0;

#ifdef DI_TCP_REASS_ENABLE
    di_config_line_add(config_line, "fm_tcp_reass_enable", 1);
    printf("TCP reassembly is enabled\n");
#endif

#ifdef DI_BASIC_DPI_ENABLE
    di_config_line_add(config_line, "basic_dpi_enable", 1);
    printf("Basic DPI is enabled\n");
#endif

#ifdef DI_OFFLOADING_TUNNELING_ENABLE
    di_config_line_add(config_line, "offloading_tunneling", 1);
    printf("Tunneling offloading is enabled\n");
#endif

    return ret;
}

/*
 * custom tunes
 */
int
di_custom_tune_configuration(void)
{
#ifdef DI_BITTORENT_MAXIMUM_TRACKER_PEERS_COUNT_SET
    if (qmdpi_tune_value_set(bundle, "bittorrent", "maximum_tracker_peers_count",
                             1000) < 0) {
        ctb_fprintf(stderr, "Cannot set tune\n");
        return -1;
    }
#endif

    return 0;
}

/*
 * custom attributes
 */
int di_custom_attribute_configuration(void)
{
#ifdef DI_HOOK_HTTP_SERVER_ENABLE
    if (qmdpi_bundle_attr_register(bundle, "http", "server") < 0) {
        ctb_fprintf(stderr, "Cannot register attribute\n");
        return -1;
    }
#endif

    return 0;
}
