/*
  This file is a part of Qosmos ixEngine.

   Copyright  Qosmos 2015 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#include <inttypes.h>
#include <stdio.h>

/**
 * DPI includes
 */
#include <qmdpi.h>
/*
 * flags for custom configuration
 */
#undef PI_TCP_REASS_ENABLE
#undef PI_BASIC_DPI_ENABLE

/*
 * flags for qmbundle custom proto-tunes
 */
#undef PI_BITTORENT_MAXIMUM_TRACKER_PEERS_COUNT_SET

/*
 * flags for hook customization
 */
#undef PI_HOOK_HTTP_SERVER_ENABLE


extern void pi_config_line_add(char *config_line, const char *param,
                               uint64_t value);
extern char config_line[512];

/*
* custom configuration
*/
int
pi_custom_engine_configuration(void)
{
    int ret = 0;

#ifdef PI_TCP_REASS_ENABLE
    pi_config_line_add(config_line, "fm_tcp_reass_enable", 1);
    printf("TCP reassembly is enabled\n");
#endif

#ifdef PI_BASIC_DPI_ENABLE
    pi_config_line_add(config_line, "basic_dpi_enable", 1);
    printf("Basic DPI is enabled\n");
#endif

    return ret;
}

/*
 * custom tunes
 */
int
pi_custom_tune_configuration(void)
{
#ifdef PI_BITTORENT_MAXIMUM_TRACKER_PEERS_COUNT_SET
    if (qmdpi_tune_value_set(bundle, "bittorrent", "maximum_tracker_peers_count",
                             1000) < 0) {
        fprintf(stderr, "Cannot set tune\n");
        return -1;
    }
#endif

    return 0;
}

/*
 * custom attributes
 */
int pi_custom_attribute_configuration(void)
{
#ifdef PI_HOOK_HTTP_SERVER_ENABLE
    if (qmdpi_bundle_attr_register(bundle, "http", "server") < 0) {
        fprintf(stderr, "Cannot register attribute\n");
        return -1;
    }
#endif

    return 0;
}
