/*
  This file is a part of Qosmos ixEngine.

   Copyright  Qosmos 2022 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#ifndef __included_dpi_h__
#define __included_dpi_h__

#include <vnet/vnet.h>
#include <vnet/ip/ip.h>
#include <vnet/ethernet/ethernet.h>

#include <vppinfra/hash.h>
#include <vppinfra/error.h>

#define MAX_NB_WORKERS 48

#define dpi_print(handle, ...) vlib_cli_output (handle, __VA_ARGS__)

typedef enum {
    DPI_NEXT_ETHERNET_INPUT,
    DPI_N_NEXT,
} dpi_next_t;

typedef struct {
    /* Enable logging */
    int         log_enable;

    /* IxE elements */
    struct qmdpi_engine *engine;
    struct qmdpi_bundle *bundle;
    struct qmdpi_worker *workers_table[MAX_NB_WORKERS];

    /* convenience */
    vlib_main_t *vlib_main;
    vnet_main_t *vnet_main;
    ethernet_main_t *ethernet_main;

    /* dpi node index */
    u32 dpi_index;

    /* next-node of flowtable node, NOT pm node id */
    u32 next_node_index;

    /* clock rate */
    f64 clocks_per_second;
} dpi_main_t;

extern dpi_main_t dpi_main;
extern vlib_node_registration_t dpi_node;

#endif /* __included_dpi_h__ */

/*
 * fd.io coding-style-patch-verification: ON
 *
 * Local Variables:
 * eval: (c-set-style "gnu")
 * End:
 */

