/*
  This file is a part of Qosmos ixEngine.

   Copyright  Qosmos 2022 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#ifndef __flowdata_h__
#define __flowdata_h__

#include <vnet/vnet.h>

/*
 * keep this under 6x4 Bytes so that it may fit into unused opaques' field.
 */
typedef union {
    struct {
        u64 structure_addr;
        u64 classified : 1;
        u64 offloaded : 1;
        u64 block     : 1;

        union {
            void *dpi_flow;
            u8 opaque[8];
        };
    } __attribute__((packed)) data;

    u32 flow_data[6];
} flow_data_t;

/* signatures */
struct ipv6_addrs {
    u16     src_offset;  /* Holding the 16 bytes of ipv6 address would make */
    u16     dst_offset;  /* too large a structure to be stored in the opaque */
} __attribute__((packed));


struct ipv4_addrs {
    ip4_address_t src;
    ip4_address_t dst;
} __attribute__((packed));

typedef struct {
    void *ft_flow;
    u8  is_reverse: 1;
    u8  is_ipv6: 1;
    u8  ip_protocol;
    u16 data_offset;
    union {
        struct ipv6_addrs   ipv6;
        struct ipv4_addrs   ipv4;
    };
    u16 src_port;
    u16 dst_port;
    const void *l4hdr;
} __attribute__((packed)) sig_info_t ;

static_always_inline u8 *
vnet_plugin_buffer(vlib_buffer_t *b)
{
    return (u8 *) & (vnet_buffer(b)->unused);
}

static_always_inline u8 *
vnet_plugin_buffer2(vlib_buffer_t *b)
{
    return (u8 *) & (vnet_buffer2(b)->unused);
}

#endif  /* __flowdata_h__ */
