/*
  This file is a part of Qosmos ixEngine.

   Copyright  Qosmos 2022 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#include <flowtable/flowtable.h>

#include <vppinfra/byte_order.h>
#include <vlibapi/api.h>
#include <vlibmemory/api.h>
#include <vlibapi/api_helper_macros.h>

#define vl_msg_id(n, h) n,
typedef enum {
#include <flowtable/flowtable.api.h>
    /* We'll want to know how many messages IDs we need... */
    VL_MSG_FIRST_AVAILABLE,
} vl_msg_id_t;
#undef vl_msg_id


/* define message structures */
#define vl_typedefs
#include <flowtable/flowtable.api.h>
#undef vl_typedefs

/* define generated endian-swappers */
#define vl_endianfun
#include <flowtable/flowtable.api.h>
#undef vl_endianfun

#define vl_msg_name_crc_list
#include <flowtable/flowtable.api.h>
#undef vl_msg_name_crc_list

static void
setup_message_id_table(flowtable_main_t *ftm, api_main_t *am)
{
#define _(id, n, crc) \
    vl_msg_api_add_msg_name_crc(am, # n "_" # crc, id + ftm->msg_id_base);
    foreach_vl_msg_name_crc_flowtable;
#undef _
}

#define vl_print(handle, ...) vlib_cli_output(handle, __VA_ARGS__)

/* Get the API version number */
#define vl_api_version(n, v) static u32 api_version = (v);
#include <flowtable/flowtable.api.h>
#undef vl_api_version

/* Macro to finish up custom dump fns */
#define FINISH                                  \
    vec_add1(s, 0);                            \
    vl_print(handle, (char *)s);               \
    vec_free(s);                               \
    return handle;


static void
vl_api_flowtable_conf_t_handler(vl_api_flowtable_conf_t *mp)
{
    flowtable_main_t *ftm = &flowtable_main;
    vl_api_flowtable_conf_reply_t *rmp;
    int rv = 0;

    if (mp->next_node_index != ~0) {
        ftm->next_node_index = clib_net_to_host_u32(mp->next_node_index);
    }

    if (mp->sw_if_index != ~0)
        rv = flowtable_enable_disable(ftm, clib_net_to_host_u32(mp->sw_if_index),
                                      mp->enable_disable);

    REPLY_MACRO(VL_API_FLOWTABLE_CONF_REPLY);
}

static void *
vl_api_flowtable_conf_t_print(vl_api_flowtable_conf_t *mp, void *handle)
{
    u8 *s;
    s = format(0, "SCRIPT: flowtable_conf ");

    s = format(s, "%u ", mp->sw_if_index);
    s = format(s, "%u ", mp->enable_disable);
    s = format(s, "%u ", mp->next_node_index);

    FINISH;
}

/* List of message types that this plugin understands */
#define foreach_flowtable_plugin_api_msg    \
    _(FLOWTABLE_CONF, flowtable_conf)       \
     

static clib_error_t *
flowtable_api_init(vlib_main_t *vm)
{
    flowtable_main_t *ftm = &flowtable_main;
    u8 *name = format(0, "flowtable_%08x%c", api_version, 0);
    ftm->msg_id_base = vl_msg_api_get_msg_ids
                       ((char *) name, VL_MSG_FIRST_AVAILABLE);

#define _(N, n)                                                  \
    vl_msg_api_set_handlers((VL_API_ ## N + ftm->msg_id_base),    \
                            # n,                                  \
                            vl_api_ ## n ## _t_handler,              \
                            vl_noop_handler,                     \
                            vl_api_ ## n ## _t_endian,               \
                            vl_api_ ## n ## _t_print,                \
                            sizeof(vl_api_ ## n ## _t), 1);
    foreach_flowtable_plugin_api_msg;
#undef _

    /* Add our API messages to the global name_crc hash table */
    api_main_t *api_main = vlibapi_get_main();
    setup_message_id_table(ftm, api_main);

    return 0;
}

VLIB_INIT_FUNCTION(flowtable_api_init);
