# Flowtable plugin for VPP

## Overview

This plugin uses ixEngine flow-level API to construct a stateful flow management
functionality in a VPP node.

## Objective
Provides a flowtable node to do flow classification, and associate a flow context.
Once a new flow is created, its packets are sent to the DPI plugin to classify the
flow.

Compared to the classifier, it stores a flow context, which changes the following:
1) A flow context (which can be updated with external information)
2) It can offload
3) Flows have a lifetime

## Current status
a) Default behavior is to connect transparently to given interface.
b) Can offload sessions
c) Only support IP packets
d) If the maximum number of flows is reached, the flowtable will increase the
   FLOW_ALLOCATION ERROR counter

## CLI
Configuration of input interfaces and/or next node (default ethernet-input)

    flowtable add [interface <Interface>] [next-node <Node>]
    flowtable delete interface <Interface>

Enable or disable the DPI (enabled by default)

    flowtable dpi [enable|disable]

Enable or disable the log (disabled by default)

    flowtable log [enable|disable]

Enable or disable the statistics (disabled by default)

    flowtable stats [enable|disable]

Show the statistics

    flowtable show-stats

Show plugin information

    flowtable info

The traffic from the given interface is redirected to the flowtable using vnet_hw_interface_rx_redirect_to_node()

## API
Used ~0 (or 0xff for u8) to leave configuration parameter unchanged.

flowtable configuration

    flowtable_conf(sw_if_index, next_node_index, enable_disable)
