#error "This header should not be used. It is provided for documentation only."
/*
  This file is a part of Qosmos ixEngine.

  Copyright  Qosmos 2000-2019 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

/**
 * @file dpi_alloc.h
 * This header contains the prototypes of functions hat users can override
 * in order to use their own **Allocators**, it is **not** meant to be included.
 * @attention
 * Please consult the Developer's Manual for instructions on overriding allocators.
 * @note This file is not meant to be included.
 *
 * @image html overriding_mem_alloc.svg "Conceptual diagram of Memory Allocation choices."
*/

/**
 * Memory pools initialization.
 * @attention
 * - If overridden without calling @a qm_malloc_init_default(),
 *   then memory pools management gets bypassed.
 * - If overridden for memory tracking purposes, it must call
 *   internal initialization with @a qm_malloc_init_default()
 *
 * @return 0 on success, negative value otherwise.
 *
 */
int qm_malloc_init(void);

/**
 * Memory pools cleanup.
 * @attention
 * - If overridden without calling @a qm_malloc_cleanup_default(),
 *   then memory pools management gets bypassed.
 * - If overridden for memory tracking purposes, it must call
 *   internal initialization with @a qm_malloc_cleanup_default().
 *
 */
void qm_malloc_cleanup(void);

/**
 * ixEngine-level memory allocation.
 *
 * @attention If overridden for memory tracking purposes,
 * it must call internal allocation with @a qm_malloc_default().
 *
 * @param nr: number of element to allocate
 * @param size: size of one element
 * @param ctx: memory context
 * @param sid: structure context
 * @return The allocated memory pointer on success, NULL otherwise.
 */
void *qm_malloc(uint32_t nr, uint32_t size, unsigned int ctx,
        unsigned int sid);

/**
 * ixEngine-level memory release.
 *
 * @note If overridden for memory tracking purposes,
 * it must call internal allocation with @a qm_free_default().
 *
 * @param ptr: Memory chunk to free
 * @param ctx: memory context
 * @param sid: structure context
 */
void qm_free(void *ptr, unsigned int ctx, unsigned int sid);

/**
 * ixEngine-level memory reallocation.
 *
 * @attention If overridden for memory tracking purposes,
 * it must call internal allocation with @a qm_realloc_default().
 *
 * @param ptr: Memory chunk to realloc
 * @param nr: New number of element to allocate
 * @param size: New size of element
 * @param ctx: memory context
 * @param sid: structure context
 *
 * @return The allocated memory pointer on success, NULL otherwise.
 */
void *qm_realloc(void *ptr, uint32_t nr, uint32_t size, unsigned int ctx,
        unsigned int sid);

/**
 * String duplication.
 *
 * @param str: pointer to string
 * @param ctx: memory context
 *
 * @return The allocated string pointer on success, NULL otherwise.
 */
char *qm_strdup(char const *str, unsigned int ctx);

/**
 * System-level memory allocation.
 *
 * @param size: Memory size to be allocated
 * @return The allocated memory pointer on success, NULL otherwise.
 */
void* qm_sys_malloc(size_t size);

/**
 * System-level memory release.
 *
 * @param ptr: Memory chunk to free
 *
 */
void qm_sys_free(void *ptr);

/**
 * System-level memory reallocation.
 *
 * @param ptr: Memory chunk to realloc
 * @param size: New size of element
 * @return The allocated memory pointer on success, NULL otherwise.
 */
void* qm_sys_realloc(void *ptr, size_t size);
