#error "This header should not be used. It is provided for documentation only."
/*
  This file is a part of Qosmos ixEngine.

  Copyright  Qosmos 2000-2019 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/
/**
 * @file attr_push.h
 * This header contains the prototypes of functions
 * that users can override,
 * it is not meant to be included.
 * @attention
 * Overriding qmdpi_attr_push() makes the attributes no longer
 * accessible through their standard getter functions:
 *     - qmdpi_result_attr_getnext()
 *     - qmdpi_result_attr_getnext_with_index()
 * @note This file is not meant to be included.
 */

/**
 * Prototype for qmdpi_attr_push.
 * @attention overriding qmdpi_attr_push() makes the attributes no longer accessible
 * through their standard getter functions:
 *     - qmdpi_result_attr_getnext()
 *     - qmdpi_result_attr_getnext_with_index()
 *
 * @param       worker pointer to worker
 * @param       flow pointer to the flow
 * @param       proto_id protocol identifier for that attribute
 * @param       path_index index of the protocol in the classification path
 * @param       attr_id attribute identifier
 * @param       attr_data attribute value
 * @param       attr_len attribute value length
 * @param       attr_data_type attribute data type:
 *              - 0 : attr data is available on the PDU.
 *              - other values : attr data is computed and held by the ixEngine.
 * @param       attr_flags attribute flags
 *
 * @return always 0 (other values are reserved for future use)
 */

int qmdpi_attr_push(struct qmdpi_worker *worker,
                    struct qmdpi_flow *flow,
                    int proto_id,
                    int path_index,
                    int attr_id,
                    void const *attr_data,
                    int attr_len,
                    ctb_uint8 attr_data_type,
                    int attr_flags);

