/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2016 - All rights reserved
*/
#include <stdio.h>
#include <stdlib.h>
#include <qmdpi.h>

#include "tune.h"
#include "pcap_analyzer_getter.h"

int pa_tune_apply(struct tune_store const *ts)
{
    char *layer;
    char *tunable;
    int val;
    unsigned int i;
    int ret = 0;

    struct tune const *t;

    for (i = 0; i < ts->nb; ++i) {

        t       = TUNE_STORE_GET(ts, i);
        layer   = TUNE_LAYER(t);
        tunable = TUNE_ATTR(t);
        val  = TUNE_VAL(t);

        ret = qmdpi_bundle_tune_set(pcap_analyzer_bundle_get(), layer, tunable, val);
        if (ret < 0) {
            fprintf(stderr, "Cannot set proto tune `%s' for protocol `%s': %s\n",
                    layer, tunable, qmdpi_error_get_string(pcap_analyzer_bundle_get(), ret));

            return -1;
        }
    }

    return 0;
}
