/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2016 - All rights reserved
*/
#ifndef __TUNE__
#define __TUNE__

/**
 * Structure that define a protocol's tune
 */
struct tune {
    /**
     * Protocol layer name
     */
    char *layer;
    /**
     * Protocol's tune name
     */
    char *attr;

    /**
     * Protocol's tune value
     */
    int val;
};

#define TUNE_SET_LAYER(t, l) ((t)->layer = l)
#define TUNE_SET_ATTR(t, a) ((t)->attr = a)
#define TUNE_SET_VAL(t, v) ((t)->val = v)
#define TUNE_SET(t, l, a, v) do {                                       \
        TUNE_SET_LAYER(t, l);                                           \
        TUNE_SET_ATTR(t, a);                                            \
        TUNE_SET_VAL(t, v);                                             \
    } while(0);
#define TUNE_LAYER(t) ((t)->layer)
#define TUNE_ATTR(t) ((t)->attr)
#define TUNE_VAL(t) ((t)->val)


#define MAX_TUNE   64

/**
 * Structure to keeps a list of protocols' tunes
 */
struct tune_store {
    /**
     * List of proto tune
     */
    struct tune tune[MAX_TUNE];
    /**
     * Number of tune in the list
     */
    size_t nb;
};

#define TUNE_STORE_INIT(ts) ((ts)->nb = 0)
#define TUNE_STORE_ADD(ts, l, a, v) do {                                \
        if((ts)->nb == MAX_TUNE) {                                      \
            fprintf(stderr,                                             \
                    "Max tune reached; cannot add %s:%s=%d", l, a, v);  \
        } else {                                                        \
            TUNE_SET(&((ts)->tune[(ts)->nb]), l, a, v);                 \
            ++(ts)->nb;                                                 \
        }                                                               \
    } while(0);
#define TUNE_STORE_GET(ts, i) (&(ts)->tune[i])

int pa_tune_apply(struct tune_store const *ts);

#endif
