/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2017 - All rights reserved
*/
#ifndef __EXCLUSION__
#define __EXCLUSION__

#include <stdint.h>

#define EXCL_MAX_CNT 1024
#define EXCL_PATTERN_SZ 64

/**
 * Attribute value exclusion pattern item.
 */
typedef struct attribute_excl {
    char pattern[EXCL_PATTERN_SZ];
    int  pattern_len;
    int  proto_id;
    int  attr_id;
} attribute_excl_t;

/**
 * Attribute value exclusion patterns list.
 */
struct attribute_excl_list {
    attribute_excl_t excl[EXCL_MAX_CNT];
    int              excl_len;
};

/**
 * Initialize exclusion patterns list from configuration file.
 */
void excls_setup(void);
void excls_setup_line(char *line, int line_count);

/**
 * Test a <proto_id>:<attr_id> attribute <value> against
 * the exclusion patterns list.
 *
 * Returns: 1 if the attribute is excluded (match),
 *          0 if it is not (no match).
 */
int excls_attribute_is_excluded(int proto_id, int attr_id,
                                const uint8_t *value, unsigned int value_len);

#endif
