#ifndef __PACKET_HELPER_H__
#define __PACKET_HELPER_H__

#include <stdint.h>

#define QM_ETHERTYPE_IP    0x0800
#define QM_ETHERTYPE_ETH1Q 0x8100
#define QM_ETHERTYPE_IP6   0x86dd

/**
 * MAC (ethernet) address.
 */
#pragma pack(1)
struct qm_mac_addr {
    uint8_t addr[6]; /**< Ethernet address on 6 bytes. */
};
#pragma pack()

#pragma pack(1)
struct qm_eth_hdr {
    struct qm_mac_addr dest;
    struct qm_mac_addr src;
    uint16_t h_proto;
};
#pragma pack()

#pragma pack(1)
struct qm_eth1q_hdr {
    uint16_t        tci;
    uint16_t        h_proto;
};
#pragma pack()

#pragma pack(1)
struct qm_ip_hdr {
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
    uint8_t    ihl: 4,
               version: 4;
#else
#if __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
    uint8_t    version: 4,
               ihl: 4;
#else
#error    "Please fix LITTLE/BIG_ENDIAN define"
#endif
#endif
    uint8_t    tos;
    uint16_t   tot_len;
    uint16_t   id;
    uint16_t   frag_off;
    uint8_t    ttl;
    uint8_t    protocol;
    uint16_t   check;
    uint32_t   saddr;
    uint32_t   daddr;
};
#pragma pack()

#pragma pack(1)
struct qm_ip6_addr {
    uint8_t addr[16];
};
#pragma pack()

#pragma pack(1)
struct qm_ip6_hdr {
    uint32_t   vcf;
    uint16_t   payload_len;
    uint8_t    nexthdr;
    uint8_t    hop_limit;
    struct qm_ip6_addr saddr;
    struct qm_ip6_addr daddr;
};
#pragma pack()

#pragma pack(1)
struct qm_tcp_hdr {
    uint16_t    source;
    uint16_t    dest;
    uint32_t    seq;
    uint32_t    ack_seq;
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
    uint16_t
    res1: 4,
          doff: 4,
          fin: 1,
          syn: 1,
          rst: 1,
          psh: 1,
          ack: 1,
          urg: 1,
          ece: 1,
          cwr: 1;
#else
#if __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
    uint16_t
    doff: 4,
          res1: 4,
          cwr: 1,
          ece: 1,
          urg: 1,
          ack: 1,
          psh: 1,
          rst: 1,
          syn: 1,
          fin: 1;
#else
#error    "Please fix LITTLE/BIG_ENDIAN define"
#endif
#endif
    uint16_t    window;
    uint16_t    check;
    uint16_t    urg_ptr;
};
#pragma pack()

#pragma pack(1)
struct qm_udp_hdr {
    uint16_t    source;
    uint16_t    dest;
    uint16_t    len;
    uint16_t    check;
};
#pragma pack()

#endif /* __PACKET_HELPER_H__ */
