/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2017 - All rights reserved
*/
#ifndef __PARSE_OPTIONS__
#define __PARSE_OPTIONS__

#include <stdint.h>

#include "logs.h"
#include "hooks.h"

#define CONFIG_FILE_NAME "pcap_logger.cfg"
#define FILENAME_LEN 1024

/**
 * Structure that keeps globals options
 */
struct opt {
    char log_filename[FILENAME_LEN];
    char conf_filename[FILENAME_LEN];
    struct hook_store hs;
    uint32_t maxcnx;
    uint8_t live_capture: 1;
};

#define OPT_INIT(o) do {                         \
        (o)->maxcnx = 200000;                    \
        (o)->live_capture = 0;                   \
        HOOK_STORE_INIT(&(o)->hs);               \
        strcpy((o)->log_filename, LOG_FILENAME); \
    } while(0)

#define OPT_MCNX(o)                 ((o)->maxcnx)
#define OPT_HOOK_STORE(o)           ((o)->hs)
#define OPT_MCNX(o)                 ((o)->maxcnx)
#define OPT_LIVE_CAPTURE(o)         ((o)->live_capture)
#define OPT_SET_MCNX(o, m)          ((o)->maxcnx = m)
#define OPT_LOG_FILENAME(o)         ((o)->log_filename)
#define OPT_CONFIG_FILENAME(o)      ((o)->conf_filename)

int parse_param(int argc, char *argv[], struct opt *opt);

#endif
