/*
  The oSIP library implements the Session Initiation Protocol (SIP -rfc3261-)
  Copyright (C) 2001,2002,2003,2004,2005,2006,2007 Aymeric MOIZARD jack@atosc.org
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef _OSIP_HEADERS_H_
#define _OSIP_HEADERS_H_

#include "osip_port.h"
#include "osip_const.h"
#include "osip_uri.h"

#include "headers/osip_header.h"
#include "headers/osip_accept.h"
#include "headers/osip_accept_encoding.h"
#include "headers/osip_accept_language.h"
#include "headers/osip_alert_info.h"
#include "headers/osip_allow.h"
#include "headers/osip_authentication_info.h"
#include "headers/osip_authorization.h"
#include "headers/osip_call_id.h"
#include "headers/osip_call_info.h"
#include "headers/osip_contact.h"
#include "headers/osip_content_disposition.h"
#include "headers/osip_content_encoding.h"
#include "headers/osip_content_length.h"
#include "headers/osip_content_type.h"
#include "headers/osip_cseq.h"
#include "headers/osip_error_info.h"
#include "headers/osip_from.h"
#include "headers/osip_mime_version.h"
#include "headers/osip_proxy_authenticate.h"
#include "headers/osip_proxy_authentication_info.h"
#include "headers/osip_proxy_authorization.h"
#include "headers/osip_record_route.h"
#include "headers/osip_route.h"
#include "headers/osip_to.h"
#include "headers/osip_via.h"
#include "headers/osip_www_authenticate.h"

/**
 * @file osip_headers.h
 * @brief oSIP osip_headers definition.
 */

/**
 * @defgroup oSIP_HEADERS oSIP headers definitions
 * @ingroup osip2_parser
 * @{
 */

/** @} */

#endif
