#ifndef decoder_h
#define decoder_h "$Id $"

/*
*****************************************************************************
*                         INCLUDE FILES
*****************************************************************************
*/
#include "typedef.h"

/* frame size in serial bitstream file (frame type + serial stream + flags) */
#define MAX_SERIAL_SIZE 244
#define SERIAL_FRAMESIZE (1+MAX_SERIAL_SIZE+5)

enum SESSION_MODE{
	BW_EFFICIENT_MODE = 0,
	OCTET_ALIGNED_MODE
};

typedef struct{
	Word16 isLastFrame;
	Word16 frameType;
	Word16 frameQuality;
}TOC;


typedef struct{
	Word8   octetAlign;	
	Word8   hasCRCList;
	Word8   nChannels;
	Word32  interleaving;
}SessionInfo;

void apiAmrNBDecode (const char* buf, unsigned short bufLen, unsigned shift, Word16* decodedData, unsigned short frameType, unsigned short frameQuality, void *destate);
int   AmrNBDecoderInit(void **destate);
void  AmrNBDecoderExit(void **destate);

#endif
